/****************************************************************************/
/*-COPYRIGHT:                                                               */
/*                                                                          */
/*            Copyright 1991 by Charles E. Voss                             */
/*            Copyright 1992 by Charles E. Voss                             */
/*            Copyright 1993 by Charles E. Voss                             */
/*                                                                          */
/*                     All rights reserved                                  */
/*                                                                          */
/* Developed by:      Charles E. Voss                                       */
/*                    8314 Lichen Lane                                      */
/*                    Spring, Texas 77379                                   */
/*                    (713) 370 6268                                        */
/*                                                                          */
/*-REVISED: Jan 1991 by C. E. Voss - Break the file given as the first      */
/*                                   command line parameter into multiple   */
/*                                   files whose extensions are .LST        */
/*                                   and whose filename is sequential       */
/*                                   incrementation of two characters       */
/*                                   concatenated with the input filename.  */
/*                                   This program is intended to be used    */
/*                                   to break the file lists from Cloud9    */
/*                                   BBS into multiple files.               */
/*                                                                          */
/*-Revised: August 26, 1993  - The header lines in the input file changed.  */
/*          Charles E. Voss                                                 */
/*-Revised: August 26, 1993  - Added options and second spec field.         */
/*          Charles E. Voss                                                 */
/*                                                                          */
/****************************************************************************/

/****************************/
/*-INCLUDE:                 */
/****************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>

long atol();

/****************************/
/*-Local functions:         */
/****************************/

void  errorexit(int  errorcode);
void  usage(int  uerr);
void  getargs(int  argc,char  * *argv);

#define BOOL  int
#define true  1
#define false 0

#define stringlength    100   /* size of char-arrays for strings             */

/*---------------------------------------------------------------------------*/

enum  useagecodetype
{
    ign,                                /* ignore cause, print'Usage:..'     */
    lngpth,                             /* pathname too long                 */
    onearg,                             /* only one argument allowed         */
    noarg,                              /* argument expected                 */
    bdopt                               /* invalid option letter supplied    */
} useagecodetype;

enum errorcodetype
{
    filop,                              /* cannot access file                */
    filcr                               /* cannot create file                */
} errorcodetype;

/*---------------------------------------------------------------------------*/

FILE *INPfile;
FILE *OUTfile;

char INPfilename[stringlength+1];
char OUTfilename[stringlength+1];
char BreakCloud9[] = "BrkCld9 Version 2R1";

int OUTfilenameLength;
long int INPlinecount;
long int OUTlinecount;
long int TotalOutLines = 0;
int LinesPerPage = 58;

BOOL RemoveBlankLines = false;
BOOL PutFormFeeds = false;
BOOL IncludeC9Headers = false;
BOOL DeleteCommentLines = false;

/*--------------------------------------------------------------------------*/

void errorexit(errorcode)
enum errorcodetype errorcode;
{
    switch (errorcode)
    {
        case filop:
            fprintf(stderr,"Cannot open inputfile: %s\n", INPfilename);
            break;
        case filcr:
            fprintf(stderr,"Cannot create outfile: %s\n", OUTfilename);
            break;
        default:
            fprintf(stderr,"Unknown error code.\n");
            break;
    }

    (void) unlink(OUTfilename);

    exit(-1);
}

/*---------------------------------------------------------------------------*/

void usage(uerr)
enum  useagecodetype uerr;
{
    if (uerr != ign)
    {
        switch (uerr)
        {
            case ign:
                fprintf(stderr,"Gee this is copyrighted...\n");
                break;
            case onearg:
                fprintf(stderr,"Only one command line parameter allowed\n");
                break;
            case noarg:
                fprintf(stderr,"Command line parameters expected\n");
                break;
            case lngpth:
                fprintf(stderr,"path arg too long\n");
                break;
            case bdopt:
                fprintf(stderr,"bad option\n");
                break;
            default:
                break;
        }
    }

    fprintf(stderr,"Usage: brkcld9 [options] LSTfile OutFileBaseName\n");
    fprintf(stderr,"Options are:\n");
    fprintf(stderr,"  -b       Remove extra comment lines.\n");
    fprintf(stderr,"  -f       Insert formfeed characters periodically.\n");
    fprintf(stderr,"  -h       Include the C9 header in the output.\n");
    fprintf(stderr,"  -pn      Set the page size to n lines.\n");
    fprintf(stderr,"  -r       Remove lines that are completely blank.\n");
    exit(1);
}

/*---------------------------------------------------------------------------*/

void getargs(argc, argv)
int argc;
char **argv;
{
BOOL INPfilenamefound;
char *str;
char *opts;
BOOL nextarg;

    if (argc < 3)
        usage(ign);

    INPfilenamefound = false;

    while (argc-- > 1)
    {
        ++argv;
        if (**argv == '-')
        {
           for (opts=(*argv)+1, nextarg=false; *opts!='\0' && !nextarg; opts++)
           {
               switch (*opts)
               {
                    case 'r':
                    case 'R':
                        RemoveBlankLines = true;
                        break;

                    case 'f':
                    case 'F':
                        PutFormFeeds = true;
                        break;

                    case 'h':
                    case 'H':
                        IncludeC9Headers = true;
                        break;

                    case 'b':
                    case 'B':
                        DeleteCommentLines = true;
                        break;

                    case 'p':
                    case 'P':
                        if (*(opts+1) != '\0')
                            opts++;
                        else if (argc > 1)
                        {
                            argc--;
                            argv++;
                            opts = *argv;
                        }
                        else
                            usage(noarg);

                        LinesPerPage = atoi(opts);
                        fprintf(stdout,"Lines Per Page is %i\n",LinesPerPage);
                        nextarg = true;
                        break;

                    default:
                        usage(bdopt);
               }
           }
        }
        else
        {
            if (INPfilenamefound)
            {
                if (strlen(*argv) > stringlength)
                    usage(lngpth);
                strcpy(OUTfilename, *argv);
                OUTfilenameLength = strlen(OUTfilename);
            }
            else
            {
                if (strlen(*argv) > stringlength)
                    usage(lngpth);
                strcpy(INPfilename, *argv);
                INPfilenamefound = true;
            }
        }
    }

    if (! INPfilenamefound)
        usage(noarg);
}

    
 /***************************************************************************
 *
 *     M A I N
 *
 ***************************************************************************/

char INPUT_line[200];
char HDGimageMain[] = "Main Board:";
char HDGimageAdult[] = "ADULT:";
char BlankLine[] ="\n";
char CommentLine[] = "                                 ";
BOOL OUTfile_open = false;
char FILnumber[3];
char FILzero[] = "0";
int i;
int j;
int FILNumber = 1;
int Line_Space_Count;
int main(argc, argv)
int argc;
char **argv;
{
    fprintf(stdout,"%s\n",BreakCloud9);
    getargs(argc, argv);                  /* read the command line arguments */

    fprintf(stdout,"Inputfile is %s\n", INPfilename);

    INPlinecount = 0;

    INPfile = fopen(INPfilename, "rt");
    if (INPfile == NULL)
        errorexit(filop);                 /* can't open input listing file   */
/*                                                                           */
/*   Get the first line of the input file, and then loop until EOF           */
/*                                                                           */
    fgets(INPUT_line, 200 , INPfile);
    while (! feof(INPfile))
    {
        INPlinecount++;
/*                                                                           */
/*   If we have been told to remove blank lines, see if the current line is  */
/*     one and if it is, ignore it.                                          */
/*                                                                           */
        if (RemoveBlankLines)
        {
            i = strcmp(INPUT_line, BlankLine);
            if (!i)
                goto SkipBlank;
        }
/*                                                                           */
/*   If we have been told to extra comment lines, see if the current line is */
/*     one and if it is, ignore it.                                          */
/*                                                                           */
        if (DeleteCommentLines)
        {
            i = strncmp(INPUT_line, CommentLine, 33);
            if (!i)
                goto SkipBlank;
        }
/*                                                                           */
/*   Check for the two types of heading images.                              */
/*                                                                           */
        i = strncmp(INPUT_line, HDGimageMain, 11);
        j = strncmp(INPUT_line, HDGimageAdult, 6);
        if (!i || !j)                          /* It is a heading image             */
        {
/*                                                                           */
/*   If the output file is open, put out FF (if appropriate) and close it.   */
/*     Tell the user the count of lines put to the output file.              */
/*                                                                           */
            if (OUTfile_open)
            {
                if (PutFormFeeds)
                    fputs("", OUTfile);
                fclose(OUTfile);
                fprintf(stdout,"Outputfile: %s Contains %li Lines\n",
                        OUTfilename, OUTlinecount);
                OUTfile_open = false;
                TotalOutLines += OUTlinecount;
            }
/*                                                                           */
/*   Develop the new output filename from the base and the next number.      */
/*                                                                           */
            OUTfilename[OUTfilenameLength] = '\0';
            strcat(OUTfilename, ".");
            itoa(FILNumber,FILnumber,10);
            if (FILNumber < 10)
                strcat(OUTfilename, FILzero);
            if (FILNumber < 100)
                strcat(OUTfilename, FILzero);
            FILNumber += 1;
            strcat(OUTfilename, FILnumber);
/*                                                                           */
/*   Open the new output file for writing.  If it cannot be opened, tell the */
/*     user and quit.                                                        */
/*                                                                           */
            OUTfile = fopen(OUTfilename, "wt");
            if (OUTfile == NULL)
                errorexit(filcr);                 /* can't create outfile    */
/*                                                                           */
/*   Tell the user what the new output filename is.                          */
/*                                                                           */
            fprintf(stdout,"Outputfile is now %s\n", OUTfilename);
/*                                                                           */
/*   Put out the current line and the next one without any check on them.    */
/*                                                                           */
            OUTlinecount = 2;
            Line_Space_Count = 2;
            OUTfile_open = true;
            fputs(INPUT_line, OUTfile);
            fgets(INPUT_line, 200 , INPfile);
            fputs(INPUT_line, OUTfile);
/*                                                                           */
/*   If the user wants the C9 headers in the output, just skip the code      */
/*     which bypasses them.                                                  */
/*                                                                           */
            if (!IncludeC9Headers)
            {
                for (i = 0 ; i < 7 ; i++)
                {
                    fgets(INPUT_line, 200 , INPfile);
                    INPlinecount++;
                }
            }
        }
        else
/*                                                                           */
/*   Not a recognized header, just put the line to the output file.          */
/*                                                                           */
        if (OUTfile_open)
        {
            OUTlinecount++;
            fputs(INPUT_line, OUTfile);
            Line_Space_Count++;
            if (Line_Space_Count >= LinesPerPage && PutFormFeeds)
            {
                fputs("", OUTfile);
                Line_Space_Count = 0;
            }
        }
SkipBlank:
        fgets(INPUT_line, 200 , INPfile);
        ;
    }

/*                                                                           */
/*   All done, close the current output file and tell the user the count.    */
/*                                                                           */
    if (OUTfile_open)
        {
            if (PutFormFeeds)
               fputs("", OUTfile);
            fclose(OUTfile);
            fprintf(stdout,"Outputfile: %s Contains %li Lines\n",
                    OUTfilename, OUTlinecount);
            TotalOutLines += OUTlinecount;
        }
/*                                                                           */
/*   Tell the user the count of lines in the input file and the total in     */
/*     the output files.                                                     */
/*                                                                           */
    fprintf(stdout,"Inputfile: %s Contains %li Lines \n",
            INPfilename, INPlinecount);
    fprintf(stdout,"Total Lines Output to the Output Files: %li\n",
            TotalOutLines);

}
