Program Maximus_File_Manager;

Uses
  AdoptIns, Compress, CopyMove, Crt, Debit, Display, Dos, Edit, General, Help,
  MaxAreas, Memory, MfmCopy, MfmDefs, MfmStr, PushPop, Quit, RenFind, SaveKill,
  Screen, Setup, Sort, ViewFile;
{========================================================================}
Var
  Mmc : Char;
Begin
  Altered := False; BeginSort := NIL; EndSort := NIL; TabOk := True;
  Base153 := Base153A + Base153B + Base153C; OldArea := $FFFF;
  Fsplit(Fexpand(ParamStr(0)),MfmExeDir,N,E);
  ParseCommandLine; BuildSkipList; ParseConfigFile;
  NumberOfEntries := 0; BuildList;
  StringToFind := '';
  If NumberOfEntries = 0 Then
  Begin
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write('This area contains no files!');
    Repeat
      Result := SelectArea(AreaPath,FileAreaPath,FilesBbsPath,OldArea);
      If Result In [252..255] Then
      Begin
        If Result = 255 Then
        Begin
          WriteLn('"'+AreaPath+'" not found.');
          Halt(Result);
        End;
        If Result = 254 Then
        Begin
          WriteLn('Could not open "'+AreaPath+'".');
          Halt(Result);
        End;
        QuitMfm;
      End;
      NumberOfEntries := 0; BuildList;
      If NumberOfEntries = 0 Then
      Begin
        AnsiGotoXY(25,1); AnsiClearToEOL;
        Write('This area contains no files!');
      End;
    Until NumberOfEntries > 0;
  End;
  If NumberOfEntries > 0 Then
  Begin
    Row := 1; CurrentEntry := FirstEntry; TopEntry := FirstEntry; DisplayScreen;
    Repeat
      Gcx := UpCase(FileAreaPath[1]);
      AnsiGotoXY(24,1);
      NewTextColor(Black); NewTextBackground(Cyan);
      FreeSpace := DiskFree(Ord(Gcx)-64) Div 1024;
      AnsiClearToEol;
      Write(' Number of files = '+MyStr(NumberOfFiles,3)
            +'   Size of files = '+Bytes(SizeOfFiles Div 1024)
            +'   Free space = '+Bytes(FreeSpace)
            +'   ? = Help');
      NewTextColor(White); NewTextBackground(Black);
      If Not (Mmc In [':',';','[',']','{','}']) Then
      Begin
        AnsiGotoXY(25,1);
        AnsiClearToEol;
        Write(FileAreaPath);
      End;
      AnsiGotoXY(24,80);
      Gbx := GetInput;
      Mmc := Upcase(Chr(Gbx));
      If Gbx = 0 Then
      Begin
        Gbx := GetInput;
        Case Gbx Of
          31 : Begin         { ALT-S }
                 ShellToDos;
                 Mmc := ^@;
               End;
          33 : Begin         { ALT-F }
                 MfmViewFile(CompressedFileViewer,CurrentEntry^.FileName);
                 Mmc := ^@;
               End;
          38 : Begin         { ALT-L }
                 MfmViewFile(DefaultViewer,CurrentEntry^.FileName);
                 Mmc := ^@;
               End;
          44 : Begin         { ALT-Z }
                 MfmViewFile(PictureFileViewer,CurrentEntry^.FileName);
                 Mmc := ^@;
               End;
          47 : Begin         { ALT-V }
                 CallFileViewer;
                 Mmc := ^@;
               End;
          72 : Mmc := '8';
          80 : Mmc := '2';
          73 : Mmc := '9';
          81 : Mmc := '3';
          71 : Mmc := '7';
          79 : Mmc := '1';
        End;
      End;
      Case Mmc Of
        ^A  : AdoptAllOrphans;
        ^B  : FindString('B');
        ^D  : FindString('D');
        ^F  : FindString('F');
        ^P  : RemotePage;
        ^R  : RemoveUpLdCredit;
        ^Q  : Begin
                If Altered Then SaveList;
                Halt(0);
              End;
        ^X  : Begin
                If CurrentEntry^.PrevEntry <> NIL Then
                  Begin
                    CurrentEntry^.Description := CurrentEntry^.PrevEntry^.Description;
                    NextPrintEntry := CurrentEntry;
                    DisplayRecord(Row);
                    DisplayCurrentLocation;
                  End;
              End;
        ' ' : Begin
                CurrentEntry^.Tagged := (Not CurrentEntry^.Tagged);
                LineDown;
                If CurrentEntry^.NextEntry = NIL Then DisplayCurrentLocation;
              End;
        '8' : LineUp;
        '2' : LineDown;
        '9' : PageUp;
        '3' : PageDown;
        '7' : TopOfList;
        '1' : BottomOfList;
        '#' : MassMove;
        '$' : MassCopy;
        'A' : AdoptAbandon(1);
        'C' : CopyFile;
        'D' : ChangeFileDate;
        'E' : EditDescription;
        'F' : Begin
                BeginSort := CurrentEntry;
                DisplayScreen;
              End;
        'I' : InsertBlank('B');
        'J' : InsertBlank('A');
        'K' : PushRecord(KillEntry);
        'L' : Begin
                EndSort := CurrentEntry;
                DisplayScreen;
              End;
        'M' : MoveFile;
        'N' : Begin
                If Altered Then
                Begin
                  SaveList;
                  Altered := False;
                End;
                BeginSort := NIL; EndSort := NIL;
                Repeat
                  Result := SelectArea(AreaPath,FileAreaPath,FilesBbsPath,OldArea);
                  If Result = 253 Then QuitMfm;
                  NumberOfEntries := 0; BuildList;
                  If NumberOfEntries = 0 Then
                  Begin
                    AnsiGotoXY(25,1); AnsiClearToEOL;
                    Write('This area contains no files!');
                  End;
                Until NumberOfEntries > 0;
                Row := 1;
                CurrentEntry := FirstEntry;
                TopEntry := FirstEntry;
                DisplayScreen;
              End;
        'Q' : QuitMfm;
        'R' : RenameFile;
        'S' : GenSort;
        'U' : PopRecord(KillEntry,'B');
        'W' : SaveList;
        'Z' : DirOfArchive(FileAreaPath+CurrentEntry^.FileName);
        '<' : PushRecord(StackEntry);
        '>' : PopRecord(StackEntry,'A');
        ',' : PushRecord(StackEntry);
        '.' : PopRecord(StackEntry,'B');
        '[' : StackPrev(StackEntry);
        ']' : StackNext(StackEntry);
        ';' : ShowStack(StackEntry);
        '{' : StackPrev(KillEntry);
        '}' : StackNext(KillEntry);
        ':' : ShowStack(KillEntry);
        '!' : ReDrawScreen;
        '?' : ListHelp;
      End;
    Until Mmc = #255;
  End;
End.
{========================================================================}
