Unit Sort;
{========================================================================}
Interface
  Uses
    Dos;
  Function FileExtName(InFileName : PathStr) : ExtStr;
  Procedure GenSort;
{========================================================================}
Implementation
  Uses
    Display, MfmDefs, Screen;
{========================================================================}
Function FileExtName(InFileName : PathStr) : ExtStr;
  Begin
    FSplit(InFileName,D,N,E);
    E := Copy(E+'   ',1,3);
    FileExtName := E+N;
  End;
{========================================================================}
Procedure GenSort;
  Var
    Gsb : Byte;
    Gsc, Gsco, Gscd : Char;
    Gss : String;
    TempSort : ListPtr;
    Exchange : Boolean;
    {========================}
    Function SortCompare : Boolean;
      Var
        TempBoolean : Boolean;
      Begin
        TempBoolean := False;
        Case Gsco Of
          'N' : Begin
                  If Gscd = 'A' Then
                  Begin
                    If NextPrintEntry^.FileName > NextPrintEntry^.NextEntry^.FileName Then TempBoolean := True;
                  End
                  Else
                  Begin
                    If NextPrintEntry^.FileName < NextPrintEntry^.NextEntry^.FileName Then TempBoolean := True;
                  End;
                End;
          'E' : Begin
                  If Gscd = 'A' Then
                  Begin
                    If FileExtName(NextPrintEntry^.FileName) > FileExtName(NextPrintEntry^.NextEntry^.FileName) Then
                     TempBoolean := True;
                  End
                  Else
                  Begin
                    If FileExtName(NextPrintEntry^.FileName) < FileExtName(NextPrintEntry^.NextEntry^.FileName) Then
                     TempBoolean := True;
                  End;
                End;
          'S' : Begin
                  If Gscd = 'A' Then
                  Begin
                    If NextPrintEntry^.FileSize > NextPrintEntry^.NextEntry^.FileSize Then TempBoolean := True;
                  End
                  Else
                  Begin
                    If NextPrintEntry^.FileSize < NextPrintEntry^.NextEntry^.FileSize Then TempBoolean := True;
                  End;
                End;
          'T' : Begin
                  If Gscd = 'A' Then
                  Begin
                    If NextPrintEntry^.FileDate > NextPrintEntry^.NextEntry^.FileDate Then TempBoolean := True;
                  End
                  Else
                  Begin
                    If NextPrintEntry^.FileDate < NextPrintEntry^.NextEntry^.FileDate Then TempBoolean := True;
                  End;
                End;
          'D' : Begin
                  If Gscd = 'A' Then
                  Begin
                    If NextPrintEntry^.Description > NextPrintEntry^.NextEntry^.Description Then TempBoolean := True;
                  End
                  Else
                  Begin
                    If NextPrintEntry^.Description < NextPrintEntry^.NextEntry^.Description Then TempBoolean := True;
                  End;
                End;
        End;
        SortCompare := TempBoolean;
      End;
    {========================}
  Begin
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write('Sort by (N)ame, (E)xt, (S)ize, (T)ime & Date or (D)escription: ');
    Repeat
      Gsco := UpCase(Char(GetInput));
    Until Pos(Gsco,'NESTDQ') > 0;
    If Gsco = 'Q' Then Exit;
    Case Gsco Of
      'N' : Gss := 'Sort by Name, ';
      'E' : Gss := 'Sort by Ext, ';
      'S' : Gss := 'Sort by Size, ';
      'T' : Gss := 'Sort by Time & Date, ';
      'D' : Gss := 'Sort by Description, ';
    End;
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write(Gss+'(A)sending or (D)esending: ');
    Repeat
      Gscd := UpCase(Char(GetInput));
    Until Pos(Gscd,'ADQ') > 0;
    If Gscd = 'Q' Then Exit;
    Case Gscd Of
      'A' : Gss := Gss+'Assending, ';
      'D' : Gss := Gss+'Desending, ';
    End;
    AnsiGotoXY(25,1); AnsiClearToEOL;
    Write(Gss+'(G)o or (Q)uit: ');
    Repeat
      Gsc := UpCase(Char(GetInput));
    Until Pos(Gsc,'GQ') > 0;
    If Gsc = 'Q' Then Exit;
    If (BeginSort <> NIL) And (EndSort <> NIL) And (BeginSort <> EndSort) Then
    Begin
      Altered := True;
      If MaxAvail > SizeOf(ListRecord) Then
      Begin
        New(TempSort);
        NextPrintEntry := BeginSort;
        While (NextPrintEntry <> EndSort) And (NextPrintEntry <> NIL) Do
        Begin
          NextPrintEntry := NextPrintEntry^.PrevEntry;
          If NextPrintEntry = EndSort Then
          Begin
            EndSort := BeginSort;
            BeginSort := NextPrintEntry;
          End;
        End;
        Repeat
          Exchange := False;
          NextPrintEntry := BeginSort;
          While NextPrintEntry <> EndSort Do
          Begin
            If SortCompare Then
            Begin
              TempSort^.TypeOfRecord := NextPrintEntry^.TypeOfRecord;
              TempSort^.FileName := NextPrintEntry^.FileName;
              TempSort^.FileSize := NextPrintEntry^.FileSize;
              TempSort^.FileDate := NextPrintEntry^.FileDate;
              TempSort^.Description := NextPrintEntry^.Description;
              NextPrintEntry^.TypeOfRecord := NextPrintEntry^.NextEntry^.TypeOfRecord;
              NextPrintEntry^.FileName := NextPrintEntry^.NextEntry^.FileName;
              NextPrintEntry^.FileSize := NextPrintEntry^.NextEntry^.FileSize;
              NextPrintEntry^.FileDate := NextPrintEntry^.NextEntry^.FileDate;
              NextPrintEntry^.Description := NextPrintEntry^.NextEntry^.Description;
              NextPrintEntry^.NextEntry^.TypeOfRecord := TempSort^.TypeOfRecord;
              NextPrintEntry^.NextEntry^.FileName := TempSort^.FileName;
              NextPrintEntry^.NextEntry^.FileSize := TempSort^.FileSize;
              NextPrintEntry^.NextEntry^.FileDate := TempSort^.FileDate;
              NextPrintEntry^.NextEntry^.Description := TempSort^.Description;
              Exchange := True;
            End;
            NextPrintEntry := NextPrintEntry^.NextEntry;
          End;
        Until (Not Exchange);
        DisplayScreen;
        Dispose(TempSort);
      End;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
