Unit ViewFile;
{========================================================================}
Interface
  Uses
    MfmDefs;
  Procedure MfmViewFile(Viewer, FileToBeViewed : S12);
  Procedure CallFileViewer;
  Procedure ShellToDos;
{========================================================================}
Implementation
  Uses
    Display, Dos, Memory, Screen, Setup;
{========================================================================}
Procedure MfmViewFile(Viewer, FileToBeViewed : S12);
  Var
    PathToUtility : PathStr;
    CmdLineParms : String;
  Begin
    If ReDirectTo = Console Then
    Begin
      If CurrentEntry^.TypeOfRecord In [FileRecord,Orphan] Then
      Begin
        AnsiClearScreen;
        Write('Loading File Viewer...');
        SetMemTop(HeapPtr);
        SwapVectors;
        CmdLineParms := '';
        If Pos(' ',Viewer) > 0 Then
        Begin
          CmdLineParms := Copy(Viewer,Pos(' ',Viewer)+1,255);
          Viewer := Copy(Viewer,1,Pos(' ',Viewer)-1);
        End;
        PathToUtility := FSearch(Viewer,GetEnv('PATH'));
        Exec(PathToUtility,FileAreaPath+FileToBeViewed+CmdLineParms);
        SwapVectors;
        SetMemTop(HeapEnd);
        SetupScreen; DisplayScreen;
      End;
    End;
  End;
{========================================================================}
Procedure CallFileViewer;
  Begin
    If ReDirectTo = Console Then
    Begin
      If CurrentEntry^.TypeOfRecord In [FileRecord,Orphan] Then
      Begin
        FSplit(CurrentEntry^.FileName,ViewDir,ViewName,ViewExt);
        ViewExt := Copy(ViewExt,2,3);
        If (Pos(ViewExt,CompressedFileExt+PictureFileExt) Mod 3) = 1 Then
        Begin
          If (Pos(ViewExt,CompressedFileExt) Mod 3) = 1 Then
          Begin
            MfmViewFile(CompressedFileViewer,CurrentEntry^.FileName);
          End
          Else
          Begin
            MfmViewFile(PictureFileViewer,CurrentEntry^.FileName);
          End;
        End
        Else
        Begin
          MfmViewFile(DefaultViewer,CurrentEntry^.FileName);
        End;
      End;
    End;
  End;
{========================================================================}
Procedure ShellToDos;
  Var
    ReturnCode : Integer;
  Begin
    AnsiClearScreen;
    SetMemTop(HeapPtr);
    WriteLn('Type EXIT to return...');
    SwapVectors;
    Exec(GetEnv('COMSPEC'), '');
    SwapVectors;
    SetMemTop(HeapEnd);
    SetupScreen; DisplayScreen;
  End;
{========================================================================}
Begin
End.
{========================================================================}
