/* REXX exec to make the Workplace Shell objects for GBM */
/* Assumes GBM installed in d:\GBM directory, and on PATH */

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

If Pos('\GBM',Translate(Value('PATH',,'OS2ENVIRONMENT'))) > 0 Then Do
  drive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\GBM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)
  Say "Found "drive"\GBM on the path"
  fullpath = drive||'\GBM'
End
Else Do
  Say "Please type full path to where GBM installed (eg: D:\GBM)"
  Parse Upper Pull fullpath
End

rc = SysFileTree(fullpath, 'file', 'D')
If file.0 <> 0 Then Do
  assoc = '*.BMP,*.VGA,*.BGA,*.RLE,*.DIB,*.RL4,*.RL8,*.GIF,*.PCX,*.TIF,*.TGA,*.VST,*.AFI,*.IFF,*.LBM,*.VID,*.PGM,*.PPM,*.KPS,*.IAX,*.XBM,*.SPR'
  Call SysCreateObject 'WPProgram','GbmV','<WP_DESKTOP>','EXENAME='||fullpath||'\GBMV.EXE;PROGTYPE=PM;PARAMETERS=-e %*;STARTUPDIR='||fullpath||';ASSOCFILTER='||assoc,'R'
  Call SysCreateObject 'WPProgram','GbmV2','<WP_DESKTOP>','EXENAME='||fullpath||'\GBMV2.EXE;PROGTYPE=PM;PARAMETERS=%*;STARTUPDIR='||fullpath||';ASSOCFILTER='||assoc,'R'
  Say "Workplace Shell Objects for GbmV and GbmV2 created on the desktop."
  Say "I recommend you now remove the *.BMP/Bitmap associations from Iconedit in the"
  Say "Productivity Folder and also from the ICONEDIT.EXE program."
End
Else Do
  Say "The directory " fullpath " does not exist"
End

Return 0
