
#include "Objects.ch"
#include "Fastgt.ch"

*----------------------------------------------------*
*  Clase WGTCTRL - Aministrador de ventanas en 3D    *
*                  estilo Windows.                   *
*----------------------------------------------------*
CLASS WGTCtrl

      DATA aTWND  , nInd   , cNombVen
      DATA aTLSIzq, aTCSIzq, aTLIdch , aTCIdch,  oWND
      DATA aTLSIzqf,aTCSIzqf,aTLIdchf, aTCIdchf, aTITWNDf
      DATA aTITWND ,nind1  , nind2   , aTPSave , aTPSavef
      DATA aTWNDsel,nMaxHor ,nMaxVer , aTWNDself

      METHOD Ini(nVesaMode) CONSTRUCTOR
      METHOD AddWnd(p1,p2,p3,p4,p5,p6,p7,p8)
      METHOD BMenuWnd(aMenu)
      METHOD CloseWnd(nInd)
      METHOD MouseCtrl()
      METHOD KeybCtrl(nKey)
      METHOD ActiveWnd(nInd)
      METHOD Fin()
      METHOD Ver()

ENDCLASS

*--------------------------------------------------------------------------*

METHOD Ver() CLASS WGTCrtl

*       RestScreen(::aTLSizq[1],::aTCSIzq[1],::aTLIdch[1],::aTCIdch[1],::aTPSave[1])
       ::nind1=1
       Do While ::nind1<len(::aTWND)-1
*          @ ::nind1,1 say  alltrim(str(::aTLSIzq[::nind1]))+"-"+alltrim(str(::aTCSIzq[::nind1]))+"-"+alltrim(str(::aTLIdch[::nind1]))+"-"+alltrim(str(::aTCIdch[::nind1]))+"-"+::aTITWND[::nind1]+"-"+::aTPSave[::nind1]
          @ ::nind1,1 say  ::aTWNDsel[::nind1]

          ::nind1=::nind1+1
       enddo
       inkey(0)

return

*--------------------------------------------------------------------------*

METHOD Ini(nVesaMode) CLASS WGTCtrl

       If nVesaMode=0
          ::nMaxHor=600
	  ::nMaxVer=400
       EndIf
       If nVesaMode=1
          ::nMaxHor=640
	  ::nMaxVer=480
       EndIf
       If nVesaMode=2
          ::nMaxHor=800
	  ::nMaxVer=600
       EndIf
       If nVesaMode=3
          ::nMaxHor=1024
	  ::nMaxVer=768
       EndIf
       ::oWND     = ""
       ::aTWND    = {,}
       ::aTLSIzq  = {,}
       ::aTCSIzq  = {,}
       ::aTLIdch  = {,}
       ::aTCIdch  = {,}
       ::aTITWND  = {,}
       ::aTPSave  = {,}
       ::aTWNDsel = {,}
       ::aTLSIzqf = 0
       ::aTCSIzqf = 0
       ::aTLIdchf = 0
       ::aTCIdchf = 0
       ::aTITWNDf = ""
       ::aTPSavef = ""
       ::atwndself= ""
       ::nInd     = 0
       ::nInd1    = 0
       ::nInd2    = 0

RETURN

*--------------------------------------------------------------------------*

METHOD AddWnd (p1,p2,p3,p4,p5,p6,p7,p8) CLASS WGTCtrl

   MouseCursor( .F. )

   AaDD(::aTPSave,0)
   Ains(::aTPSAVE,1) ; ::aTPSave[1]:=SaveScreen(p1,p2,p3,p4)
   oWND:=WinGt():Create( p1, p2, p3, p4, p5, p6, p7, p8 )
   oWND:WGT_Show()
   oWND:WGT_Limits(::nMaxVer,::nMaxHor)
   Aadd(::aTWND,"")
   Ains(::aTWND,1) ; ::aTWND[1]:=oWND
   AaDD(::aTLSIzq,0)
   Ains(::aTLSIzq,1) ; ::aTLSIzq[1]:=p1
   AaDD(::aTCSIzq,0)
   Ains(::aTCSIzq,1) ; ::aTCSIzq[1]:=p2
   AaDD(::aTLIdch,0)
   Ains(::aTLIdch,1) ; ::aTLIdch[1]:=p3
   AaDD(::aTCIdch,0)
   Ains(::aTCIdch,1) ; ::aTCIdch[1]:=p4
   AaDD(::aTITWND,0)
   Ains(::aTITWND,1) ; ::aTITWND[1]:=p5
   AaDD(::aTWNDsel,0)
   Ains(::aTWNDsel,1) ; ::aTWNDsel[1]:=.T.
   if p8=.F.
      ::aTWNDsel[1]:=.F.
   Endif
   MouseCursor( .T. )

return

*--------------------------------------------------------------------------*

METHOD BMenuWnd (aMenu) CLASS WGTCtrl

       MouseCursor( .F. )
       ::aTWND[1]:WGT_BMenu(aMenu)
       MouseCursor( .T. )

return

*--------------------------------------------------------------------------*

METHOD CloseWnd (nInd) CLASS WGTCtrl

       MouseCursor( .F. )

        RestScreen(::aTLSizq[nInd],::aTCSIzq[nInd],::aTLIdch[nInd],::aTCIdch[nInd],::aTPSave[nInd],)

       MouseCursor( .T. )
return

*--------------------------------------------------------------------------*

METHOD MouseCtrl () CLASS WGTCtrl

       MouseCursor( .F. )
       ::nInd=1
       Do While ::nInd<Len(::aTWND)-1
	  if MouseArea(::aTLSIzq[::nInd]*16,::aTCSIzq[::nInd]*8,::aTLIdch[::nInd]*16+15,::aTCIdch[::nInd]*8+7)
             exit
	  endif
	  ::nInd=::nInd+1
       EndDo
       If ::nInd>1 .and. ::nInd<len(::aTWND)-1 .and. ::aTWNDsel[::nInd]
          ::ActiveWnd(::nInd)
       EndIf
       IF ::nInd=1
          ::aTWND[1]:WGT_LMouse(.T.)
          ::aTWND[1]:WGT_RBMenu()
          ::aTWND[1]:WGT_LMouse(.F.)
       EndIf

       MouseCursor( .T. )
RETURN

*--------------------------------------------------------------------------*

METHOD KeybCtrl (nKey) CLASS WGTCtrl

       MouseCursor( .F. )

       ::aTWND[1]:WGT_Keyboard(nKey)

       MouseCursor( .T. )
RETURN

*--------------------------------------------------------------------------*

METHOD ActiveWnd(nInd) CLASS WGTCtrl

       ::nInd1=1

       Do While ::nInd1<=nInd
          ::CloseWnd(::nInd1)
	  ::aTPSave[::nInd1]=""
	  ::nInd1:=::nInd1+1
       EndDo

       ::oWND=::aTWND[nInd]
       ::aTLSIzqf= ::aTLSIzq[nInd]
       ::aTCSIzqf= ::aTCSIzq[nInd]
       ::aTLIdchf= ::aTLIdch[nInd]
       ::aTCIdchf= ::aTCIdch[nInd]
       ::aTITWNDf= ::aTITWND[nInd]
       ::aTPSavef= ::aTPSave[nInd]
       ::atwndself= ::aTWNDsel[nInd]
       Adel(::aTWND,nInd)
       Ains(::aTWND,1)
       Adel(::aTLSizq,nInd)
       Ains(::aTLSIzq,1)
       Adel(::aTCSIzq,nInd)
       Ains(::aTCSIzq,1)
       Adel(::aTLIdch,nInd)
       Ains(::aTLIdch,1)
       Adel(::aTCIdch,nInd)
       Ains(::aTCIdch,1)
       Adel(::aTITWND,nInd)
       Ains(::aTITWND,1)
       Adel(::aTPSave,nInd)
       Ains(::aTPSave,1)
       Adel(::aTWNDsel,nInd)
       Ains(::aTWNDsel,1)
       ::aTWND[1]=::oWND
       ::aTLSIzq[1]=::aTLSIzqf
       ::aTCSIzq[1]=::aTCSIzqf
       ::aTLIdch[1]=::aTLIdchf
       ::aTCIdch[1]=::aTCIdchf
       ::aTITWND[1]=::aTITWNDf
       ::aTPSave[1]=::aTPSavef
       ::aTWNDsel[1]=::atwndself

       MouseCursor( .F. )

       ::nInd1=nInd

       Do While ::nInd1>0
          ::aTPSave[::nInd1]:=SaveScreen(::aTLSizq[::nInd1],::aTCSIzq[::nInd1],::aTLIdch[::nInd1],::aTCIdch[::nInd1])
          ::aTWND[::nInd1]:WGT_Refres()
	  ::nInd1=::nInd1-1
       EndDo

       MouseCursor( .T. )


RETURN

*--------------------------------------------------------------------------*

METHOD Fin() CLASS WGTCtrl

       ::nInd=1

       Do While ::nInd<Len(::aTWND)-1

          DestScreen(::aTPSave[::nInd])
	  ::nInd=::nInd+1

       EndDo

RETURN


*----------------------------------------------------*
*  Clase WinGT - Crea ventanas en 3D estilo Windows  *
*----------------------------------------------------*
CLASS WinGT

   DATA   nLSizq,   nCSizq,    nLIdch,    nCIdch
   DATA   nGLSizq,  nGCSizq,   nGLIdch,   nGCIdch
   DATA   cColor,   cTitulo,   pAnterior, cStatus
   DATA   cColorA,  nCentre,   aBMenu,    nOpera1
   DATA   nOpera2,  nLenMenu,  nIndMenu,  nI
   DATA   nPiOpMenu,aSubBMenu, aWords  ,  lSize
   DATA   nI1      ,nI2      , nI3     ,  nItems   , nMaxLen
   DATA   nPLSizq  ,nPCSizq  , nPLIdch  , nPCIdch
   DATA   nPLSizqC ,nPCSizqC , nPLIdchC , nPCIdchC
   DATA   pPersiana,nMaxHor  , nMaxVer  , lItemAct
   DATA   nKey     ,aAlts    , lBMenu   , lSBMenu
   DATA   nIndM    ,nIndSM   , lMouse

   METHOD Create( nLSizq, nCSizq, nLIdch, nCIdch, cTitulo, cColor, lSize ) CONSTRUCTOR
   METHOD WGT_Limits(nMaxVer,nMaxHor)
   METHOD WGT_Show()
   METHOD WGT_BMenu(aMenu)
   METHOD WGT_BSMenu(nItem)
   METHOD WGT_BRSMenu(nItem)
   METHOD WGT_ItemOff()
   METHOD WGT_RBMenu()
   METHOD WGT_ShwMen()
   METHOD WGT_Keyboard(nKey)
   METHOD WGT_Alt(nkey)
   METHOD WGT_IniAlt()
   METHOD WGT_Refres()
   METHOD WGT_LMouse(lMouse)
  
ENDCLASS

*--------------------------------------------------------------------------*

METHOD Create( nLSizq, nCSizq, nLIdch, nCIdch, cTitulo, cColor, lSize ) CLASS WinGT

   ::nLSizq    = nLSizq
   ::nCSizq    = nCSizq
   ::nLIdch    = nLIdch
   ::nCIdch    = nCIdch
   ::nGLSizq   = ::nLSizq * 16
   ::nGCSizq   = ::nCSizq * 8
   ::nGLIdch   = ::nLIdch * 16+15
   ::nGCIdch   = ::nCIdch * 8 +7
   ::cTitulo   = cTitulo
   ::nOpera1   = 0
   ::nOpera2   = 0
   ::nCentre   = 0
   ::cColor    = cColor
   ::cColorA   = ""
   ::pAnterior = ""
   ::pPersiana = ""
   ::cStatus   = "N"
   ::lSize     = .T.
   ::lItemAct  = .F.
   ::lBMenu    = .F.
   ::lSBMenu   = .F.
   ::lMouse    = .F.
   if lSize=.F.
      ::lSize=.F.
   EndIF
   ::aBMenu    = ""
   ::aAlts     = ""
   ::nLenMenu  = 0
   ::nMaxLen   = 0
   ::nIndMenu  = 0
   ::nI        = 0
   ::nI1       = 0
   ::nI2       = 0
   ::nI3       = 0
   ::nIndM     = 0
   ::nIndSM    = 0
   ::nItems    = 0
   ::nPiOpMenu = 0
   ::nPLSizq   = 0
   ::nPCSizq   = 0
   ::nPLIdch   = 0
   ::nPCIdch   = 0
   ::nPLSizqC  = 0
   ::nPCSizqC  = 0
   ::nPLIdchC  = 0
   ::nPCIdchC  = 0
   ::aWords    = ""
   ::nKey      =0
   if ::nLSizq=0 .and. ::nCSizq=0 .and. ::nLIdch=MaxRow() .and. ::nCIdch=MaxCol()
      ::cStatus="M"
   endif
   ::WGT_IniAlt()

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_IniAlt() CLASS WinGT //Inicializa la tabla de Teclas con Alt

       ::aAlts=Array(26,2)
       ::aAlts[1,1]=272; ::aAlts[1,2]="Q"
       ::aAlts[2,1]=273; ::aAlts[2,2]="W"
       ::aAlts[3,1]=274; ::aAlts[3,2]="E"
       ::aAlts[4,1]=275; ::aAlts[4,2]="R"
       ::aAlts[5,1]=276; ::aAlts[5,2]="T"
       ::aAlts[6,1]=277; ::aAlts[6,2]="Y"
       ::aAlts[7,1]=278; ::aAlts[7,2]="U"
       ::aAlts[8,1]=279; ::aAlts[8,2]="I"
       ::aAlts[9,1]=280; ::aAlts[9,2]="O"
      ::aAlts[10,1]=281;::aAlts[10,2]="P"
      ::aAlts[11,1]=286;::aAlts[11,2]="A"
      ::aAlts[12,1]=287;::aAlts[12,2]="S"
      ::aAlts[13,1]=288;::aAlts[13,2]="D"
      ::aAlts[14,1]=289;::aAlts[14,2]="F"
      ::aAlts[15,1]=290;::aAlts[15,2]="G"
      ::aAlts[16,1]=291;::aAlts[16,2]="H"
      ::aAlts[17,1]=292;::aAlts[17,2]="J"
      ::aAlts[18,1]=293;::aAlts[18,2]="K"
      ::aAlts[19,1]=294;::aAlts[19,2]="L"
      ::aAlts[20,1]=300;::aAlts[20,2]="Z"
      ::aAlts[21,1]=301;::aAlts[21,2]="X"
      ::aAlts[22,1]=302;::aAlts[22,2]="C"
      ::aAlts[23,1]=303;::aAlts[23,2]="V"
      ::aAlts[24,1]=304;::aAlts[24,2]="B"
      ::aAlts[25,1]=305;::aAlts[25,2]="N"
      ::aAlts[26,1]=306;::aAlts[26,2]="M"

RETURN
*--------------------------------------------------------------------------*

METHOD WGT_Show() CLASS WinGT //Muestra la Ventana

       ::cColorA=SetColor()
   
       SetColor(::cColor)
       Scroll( ::nLSizq, ::nCSizq, ::nLIdch, ::nCIdch )

       VesaLine( ::nGLSizq+3, ::nGCSizq+3, ::nGLSizq+3, ::nGCIdch-3,  0 )
       VesaLine( ::nGLIdch-3, ::nGCSizq+3, ::nGLIdch-3, ::nGCIdch-3,  0 )
       VesaLine( ::nGLSizq+3, ::nGCSizq+3, ::nGLIdch-3, ::nGCSizq+3,  0 )
       VesaLine( ::nGLSizq+3, ::nGCIdch-3, ::nGLIdch-3, ::nGCIdch-3,  0 )

       VesaLine( ::nGLSizq+2, ::nGCSizq+2, ::nGLSizq+2, ::nGCIdch-2, 07 )
       VesaLine( ::nGLIdch-2, ::nGCSizq+2, ::nGLIdch-2, ::nGCIdch-2, 07 )
       VesaLine( ::nGLSizq+2, ::nGCSizq+2, ::nGLIdch-2, ::nGCSizq+2, 07 )
       VesaLine( ::nGLSizq+2, ::nGCIdch-2, ::nGLIdch-2, ::nGCIdch-2, 07 )

       VesaLine( ::nGLSizq+1, ::nGCSizq+1, ::nGLSizq+1, ::nGCIdch-1, 07 )
       VesaLine( ::nGLIdch-1, ::nGCSizq+1, ::nGLIdch-1, ::nGCIdch-1, 07 )
       VesaLine( ::nGLSizq+1, ::nGCSizq+1, ::nGLIdch-1, ::nGCSizq+1, 07 )
       VesaLine( ::nGLSizq+1, ::nGCIdch-1, ::nGLIdch-1, ::nGCIdch-1, 07 )

       VesaLine( ::nGLSizq  , ::nGCSizq  , ::nGLSizq  , ::nGCIdch,  0 )
       VesaLine( ::nGLIdch  , ::nGCSizq  , ::nGLIdch  , ::nGCIdch,  0 )
       VesaLine( ::nGLSizq  , ::nGCSizq  , ::nGLIdch  , ::nGCSizq,  0 )
       VesaLine( ::nGLSizq  , ::nGCIdch  , ::nGLIdch  , ::nGCIdch,  0 )

       VesaSetArea(::nGlSizq+4,::nGCSizq+23,::nGLSizq+18,::nGCIdch-4, 1)

       VesaSetArea(::nGlSizq+4,::nGCSizq+4 ,::nGLSizq+18,::nGCSizq+22,15)
       VesaLine(::nGlSizq+4,::nGCSizq+22,::nGLSizq+18,::nGCSizq+22,0)
       VesaBox(::nGLSizq+9,::nGCSizq+7,::nGLSizq+12,::nGCSizq+18,8)
       VesaLine(::nGLSizq+13,::nGCSizq+8,::nGLSizq+13,::nGCSizq+19,0)
       VesaLine(::nGLSizq+10,::nGCSizq+19,::nGLSizq+13,::nGCSizq+19,0)


       IF ::lSize

          VesaSetArea(::nGlSizq+4,::nGCIdch-36,::nGLsizq+18,::nGCIdch-4,7)
          VesaLine(::nGlSizq+5 ,::nGCIdch-36,::nGLSizq+18,::nGCIdch-36,0)
          VesaLine(::nGlSizq+4 ,::nGCIdch-35,::nGLSizq+4 ,::nGCIdch-5,15)
          VesaLine(::nGlSizq+18,::nGCIdch-35,::nGLSizq+18,::nGCIdch-4, 0)
          VesaLine(::nGlSizq+5 ,::nGCIdch-35,::nGLSizq+18,::nGCIdch-35,15)
          VesaLine(::nGlSizq+5 ,::nGCIdch-20,::nGLSizq+18,::nGCIdch-20, 0)
          VesaLine(::nGlSizq+5 ,::nGCIdch-18,::nGLSizq+18,::nGCIdch-18,15)
          VesaLine(::nGlSizq+5 ,::nGCIdch- 4,::nGLSizq+18,::nGCIdch- 4, 0)

          VesaLine(::nGlSizq+14,::nGCIdch-28,::nGLSizq+14,::nGCIdch-28,0)
          VesaLine(::nGlSizq+13,::nGCIdch-29,::nGLSizq+13,::nGCIdch-27,0)
          VesaLine(::nGlSizq+12,::nGCIdch-30,::nGLSizq+12,::nGCIdch-26,0)
          VesaLine(::nGlSizq+11,::nGCIdch-31,::nGLSizq+11,::nGCIdch-25,0)

          If ::cStatus="N"

             VesaLine(::nGlSizq+12,::nGCIdch-14,::nGLSizq+12,::nGCIdch-08,0)
             VesaLine(::nGlSizq+11,::nGCIdch-13,::nGLSizq+11,::nGCIdch-09,0)
             VesaLine(::nGlSizq+10,::nGCIdch-12,::nGLSizq+10,::nGCIdch-10,0)
             VesaLine(::nGlSizq+09,::nGCIdch-11,::nGLSizq+09,::nGCIdch-11,0)

           EndIf


           If ::cStatus="M"
          
              VesaLine(::nGlSizq+07,::nGCIdch-11,::nGLSizq+07,::nGCIdch-11,0)
              VesaLine(::nGlSizq+08,::nGCIdch-12,::nGLSizq+08,::nGCIdch-10,0)
              VesaLine(::nGlSizq+09,::nGCIdch-13,::nGLSizq+09,::nGCIdch-09,0)
              VesaLine(::nGlSizq+10,::nGCIdch-14,::nGLSizq+10,::nGCIdch-08,0)
          
              VesaLine(::nGlSizq+16,::nGCIdch-11,::nGLSizq+16,::nGCIdch-11,0)
              VesaLine(::nGlSizq+15,::nGCIdch-12,::nGLSizq+15,::nGCIdch-10,0)
              VesaLine(::nGlSizq+14,::nGCIdch-13,::nGLSizq+14,::nGCIdch-09,0)
              VesaLine(::nGlSizq+13,::nGCIdch-14,::nGLSizq+13,::nGCIdch-08,0)

           EndIf

           VesaLine(::nGlSizq+4 ,::nGCIdch-19,::nGLSizq+18,::nGCIdch-19,0)

       EndIF
       VesaLine(::nGlSizq+19,::nGCSizq+4,::nGLSizq+19,::nGCIdch-4,0)

       ::nOpera1=::nGCIdch-36
       ::nOpera2=::nGCSizq+23

       ::nCentre=(::nOpera1-::nOpera2)/2 - ((Len(::cTitulo) / 2) * 8)
       VesaWriteAt(::nGLSizq+8,::nGCSizq+19+::nCentre,::cTitulo,15,1,FONT_SMALL)

       SetColor(::cColorA)

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_Limits(nMaxVer,nMaxHor) CLASS WinGT //Recoge los Limites de la pantalla en Pixels

       ::nMaxVer=nMaxVer
       ::nMaxHor=nMaxHor

RETURN
*--------------------------------------------------------------------------*

METHOD WGT_lMouse(lMouse) CLASS WinGT //Informa a la ventana que se ha activado el raton o no

       ::lMouse=lMouse

RETURN
*--------------------------------------------------------------------------*

METHOD WGT_ItemOff() CLASS WinGT //Apaga La Subopcion que se encuentre encendida en la pesina actual

       ::nI3=1
       Do While ::nI3<=::nLenMenu
          if ::aBMenu[::nI3,9]="*" .and. Empty(::aBMenu[::nI3,1])
             VesaWriteAt(::aBMenu[::nI3,5]+1,::aBMenu[::nI3,6],::aBMenu[::nI3,11],0,15,FONT_BIG)
             VesaLine(::aBMenu[::nI3,5]+14,::aBMenu[::nI3,6]+((Val(::aBMenu[::nI3,4])-1)*8),::aBMenu[::nI3,5]+14,::aBMenu[::nI3,6]+((Val(::aBMenu[::nI3,4]))*8)-2,0)
             ::aBMenu[::nI3,9]=""
             exit
	  EndIf
	  ::nI3=::nI3+1
       EndDo

RETURN
*--------------------------------------------------------------------------*

METHOD WGT_RBMenu() CLASS WinGT //Chequea la Barra de Menu con el Raton

       If Empty(::aBMenu)
          return
       endif
       ::nLenMenu=Len(::aBMenu)

       ::nI2=1
       Do While ::nI2<=::nLenMenu
          if !Empty(::aBMenu[::nI2,1]) .and. ::aBMenu[::nI2,9]="*"
	     ::lItemAct=.T.
	  EndIf
          if !Empty(::aBMenu[::nI2,1]) .and. ::aBMenu[::nI2,9]!="*"
	     ::lItemAct=.F.
	  EndIf
          if MouseArea(::aBMenu[::nI2,5],::aBMenu[::nI2,6],::aBMenu[::nI2,7],::aBMenu[::nI2,8]) .and. Empty(::aBMenu[::nI2,1]) .and. ::lItemAct .and. ::lMouse
	     ::WGT_ItemOff()
             VesaWriteAt(::aBMenu[::nI2,5]+1,::aBMenu[::nI2,6],::aBMenu[::nI2,11],15,1,FONT_BIG)
             VesaLine(::aBMenu[::nI2,5]+14,::aBMenu[::nI2,6]+((Val(::aBMenu[::nI2,4])-1)*8),::aBMenu[::nI2,5]+14,::aBMenu[::nI2,6]+((Val(::aBMenu[::nI2,4]))*8)-2,15)
             ::aBMenu[::nI2,9]="*"
	     eval(::aBMenu[::nI2,10])
	     exit
	  EndIf
          if Chr(::nKey)=::aBMenu[::nI2,3] .and. Empty(::aBMenu[::nI2,1]) .and. ::lItemAct
	     ::WGT_ItemOff()
             VesaWriteAt(::aBMenu[::nI2,5]+1,::aBMenu[::nI2,6],::aBMenu[::nI2,11],15,1,FONT_BIG)
             VesaLine(::aBMenu[::nI2,5]+14,::aBMenu[::nI2,6]+((Val(::aBMenu[::nI2,4])-1)*8),::aBMenu[::nI2,5]+14,::aBMenu[::nI2,6]+((Val(::aBMenu[::nI2,4]))*8)-2,15)
	     ::lSBMenu=.T.
	     ::nIndSM=::nI2
             ::aBMenu[::nI2,9]="*"
	     exit
	  Else
	     ::lSBMenu=.F.
	  EndIf
	  ::nI2=::nI2+1
       EndDo

       If !::lSBMenu
       ::nI1=1
       Do While ::nI1<=::nLenMenu
          if ::aBMenu[::nI1,9]="*"
	     ::WGT_BRSMenu(::nI1)
             VesaWriteAt(::aBMenu[::nI1,5],::aBMenu[::nI1,6],::aBMenu[::nI1,1],0,15,FONT_BIG)
             VesaLine(::aBMenu[::nI1,5]+13,::aBMenu[::nI1,6]+((Val(::aBMenu[::nI1,4]))*8),::aBMenu[::nI1,5]+13,::aBMenu[::nI1,6]+((Val(::aBMenu[::nI1,4])+1)*8)-2,0)
             ::aBMenu[::nI1,9]=""
	     ::lBMenu=.F.
	     exit
	  EndIf
	     ::nI1=::nI1+1
       EndDo
       ::nI=1
       Do While ::nI<=::nLenMenu
          if MouseArea(::aBMenu[::nI,5],::aBMenu[::nI,6],::aBMenu[::nI,7],::aBMenu[::nI,8]) .and. ::nI<>::nI1 .and. !Empty(::aBMenu[::nI,1]) .and. ::lMouse
             VesaWriteAt(::aBMenu[::nI,5],::aBMenu[::nI,6],::aBMenu[::nI,1],15,1,FONT_BIG)
             VesaLine(::aBMenu[::nI,5]+13,::aBMenu[::nI,6]+((Val(::aBMenu[::nI,4]))*8),::aBMenu[::nI,5]+13,::aBMenu[::nI,6]+((Val(::aBMenu[::nI,4])+1)*8)-2,15)
             ::aBMenu[::nI,9]="*"
	     ::lBMenu=.T.
	     ::nIndM=::nI
	     ::WGT_BSMenu(::nI)
	     exit
	  EndIf
          if Chr(::nKey)=::aBMenu[::nI,3] .and. ::nI<>::nI1 .and. !Empty(::aBMenu[::nI,1])
             VesaWriteAt(::aBMenu[::nI,5],::aBMenu[::nI,6],::aBMenu[::nI,1],15,1,FONT_BIG)
             VesaLine(::aBMenu[::nI,5]+13,::aBMenu[::nI,6]+((Val(::aBMenu[::nI,4]))*8),::aBMenu[::nI,5]+13,::aBMenu[::nI,6]+((Val(::aBMenu[::nI,4])+1)*8)-2,15)
             ::aBMenu[::nI,9]="*"
	     ::lBMenu=.T.
	     ::nIndM=::nI
	     ::WGT_BSMenu(::nIndM)
	     exit
	  EndIf
	  ::nI=::nI+1
       EndDo
       EndIf

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_BRSMenu(nItem) CLASS WinGT //Elimina la persiana de la opcion de Menu

       ::nI2=nItem+1
       Do While ::nI2<=::nLenMenu
	  if !Empty(::aBMenu[::nI2,1])
	     exit
	  EndIf
          ::aBMenu[::nI2,9]=""
	  ::nI2=::nI2+1
       EndDo

       RestScreen(::nPLSizqC,::nPCSizqC,::nPLIdchC,::nPCIdchC,::pPersiana)

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_BSMenu(nItem) CLASS WinGT //Crea la persiana de la opcion de Menu

       ::nI2=nItem+1
       ::nItems=0
       ::nMaxlen=0

       Do While ::nI2<=::nLenMenu
	  if !Empty(::aBMenu[::nI2,1])
	     exit
	  EndIf
	  ::nItems=::nItems+1
          if Len(::aBMenu[::nI2,2])>::nMaxLen
             ::nMaxlen=Len(::aBMenu[::nI2,2])
	  EndIf
	  ::nI2=::nI2+1
       EndDo

       If (::nMaxLen*8)+::aBMenu[::nI,6] > ::nMaxHor
	  ::nPCSizq=::nMaxHor-((::nMaxlen-1)*8)
          ::nPLSizq=::aBMenu[::nI,5]
       Else
          ::nPCSizq=::aBMenu[::nI,6]
	  ::nPLSizq=::aBMenu[::nI,7]
       EndIf

       If (::nItems*16)+::aBMenu[::nI,7] > ::nMaxVer
          ::nPCIdch=::nPCSizq+((::nMaxlen+1)*8)
	  ::nPLIdch=::nPCSizq
          ::nPCSIzq=::nPCSizq
	  ::nPLSizq=::nPLIdch-((::nItems+1)*16)
       Else
          ::nPLIdch=::nPLSizq+((::nItems)*16)+1
	  ::nPCIdch=::nPCSizq+((::nMaxlen+1)*8)+1
       EndIf

       If ::nItems > 0
           ::nPLSizqC=Int(::nPLSizq/16)
	   ::nPCSizqC=Int(::nPCSizq/8)
	   ::nPLIdchC=Int(::nPLIdch/16)
	   ::nPCIdchC=Int(::nPCIdch/8)
           ::pPersiana=SaveScreen(::nPLSizqC,::nPCSizqC,::nPLIdchC,::nPCIdchC)
           VesaBox(::nPLSizq,::nPCSizq,::nPLIdch,::nPCIdch,0)
	   VesaSetArea(::nPLSizq+1,::nPCSizq+1,::nPLIdch-1,::nPCIdch-1,15)
       Else
           RETURN
       EndIf

       ::nI2=nItem+1
       ::nItems=0

       Do While ::nI2<=::nLenMenu
	  if !Empty(::aBMenu[::nI2,1])
	     exit
	  EndIf
          ::nItems=::nItems+1
          ::aBMenu[::nI2,11]=::aBMenu[::nI2,2]+space(::nMaxlen-Len(::aBMenu[::nI2,2])+1)
          ::aBMenu[::nI2,5]=(::nPLSizq)+((::nItems-1)*16)
	  ::aBMenu[::nI2,6]=::nPCSIzq+1
	  ::aBMenu[::nI2,7]=::aBMenu[::nI2,5]+16
	  ::aBMenu[::nI2,8]=::aBMenu[::nI2,6]+(Len(::aBMenu[::nI2,11])*8)
          If ::nItems = 1
             ::nIndSM=::nI2
	     ::lSBMenu=.T.
             VesaWriteAt(::aBMenu[::nI2,5]+1,::aBMenu[::nI2,6],::aBMenu[::nI2,11],15,1,FONT_BIG)
             VesaLine(::nPLSizq+(::nItems*16)-2,(::nPCSizq+1)+((Val(::aBMenu[::nI2,4])-1)*8),::nPLSizq+(::nItems*16)-2,(::nPCSizq+1)+(Val(::aBMenu[::nI2,4])*8)-2,15)
	     ::aBMenu[::nI2,9]="*"
	  Else
             VesaWriteAt(::aBMenu[::nI2,5]+1,::aBMenu[::nI2,6],::aBMenu[::nI2,11],0,15,FONT_BIG)
             VesaLine(::nPLSizq+(::nItems*16)-2,(::nPCSizq+1)+((Val(::aBMenu[::nI2,4])-1)*8),::nPLSizq+(::nItems*16)-2,(::nPCSizq+1)+(Val(::aBMenu[::nI2,4])*8)-2,0)
          EndIf
          ::nI2=::nI2+1
       EndDo


RETURN

*--------------------------------------------------------------------------*

METHOD WGT_BMenu(aMenu) CLASS WinGT //Crea la Barra de Menu

       If Empty(aMenu)
          return
       endif

       ::nLenMenu=Len(aMenu)
       ::aBMenu=Array(::nLenMenu,15)
       ::nI=1
       ::nPiOpMenu=22

       Do While ::nI<=::nLenMenu
          
	  If !Empty(aMenu[::nI,1])

             ::aBMenu[::nI,1]=aMenu[::nI,1]
             ::aBMenu[::nI,1]=StrTran(::aBMenu[::nI,1],"[")
             ::aBMenu[::nI,1]=StrTran(::aBMenu[::nI,1],"]")
	     ::aBMenu[::nI,1]=" "+::aBMenu[::nI,1]+" "
             ::aBMenu[::nI,4]=Str(At("]",aMenu[::nI,1]))
             ::aBMenu[::nI,4]=Str(Val(::aBMenu[::nI,4])-2)
             ::aBMenu[::nI,3]=SubStr(aMenu[::nI,1],Val(::aBMenu[::nI,4])+1,1)
             ::aBMenu[::nI,10]=aMenu[::nI,3]
             ::aBMenu[::nI,5]=::nGLSIzq+20
	     ::aBMenu[::nI,6]=::nGCSizq+::nPiOpMenu
             ::aBMenu[::nI,7]=::aBMenu[::nI,5]+16
	     ::aBMenu[::nI,8]=::aBMenu[::nI,6]+(Len(::aBMenu[::nI,1])*8)
             ::nPiOpMenu=::nPiOpMenu+((Len(::aBMenu[::nI,1]))*8)

           EndIF

	  If !Empty(aMenu[::nI,2])

             ::aBMenu[::nI,2]="  "+aMenu[::nI,2]+" "
             ::aBMenu[::nI,4]=Str(At("]",::aBMenu[::nI,2]))
             ::aBMenu[::nI,4]=Str(Val(::aBMenu[::nI,4])-2)
             ::aBMenu[::nI,2]=StrTran(::aBMenu[::nI,2],"[")
             ::aBMenu[::nI,2]=StrTran(::aBMenu[::nI,2],"]")
             ::aBMenu[::nI,3]=SubStr(::aBMenu[::nI,2],Val(::aBMenu[::nI,4]),1)
             ::aBMenu[::nI,10]=aMenu[::nI,3]

           EndIF

           ::nI=::nI+1

       EndDo

       ::WGT_ShwMen()
       ::nI=0

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_ShwMen() CLASS WinGT //Muestra la Barra de Menu

       VesaSetArea(::nGlSizq+20,::nGCSizq+4 ,::nGLSizq+35,::nGCIdch-4,15)
       VesaLine(::nGlSizq+36,::nGCSizq+4,::nGLSizq+36,::nGCIdch-4,0)

       ::nI=1
       ::nPiOpMenu=22

       Do While ::nI<=::nLenMenu
          
	  If !Empty(::aBMenu[::nI,1])

             VesaWriteAt(::nGLSizq+20,::nGCSizq+::nPiOpMenu,::aBMenu[::nI,1],0,15,FONT_BIG)
             VesaLine(::nGLSizq+33,::nGCSizq+::nPiOpMenu+((Val(::aBMenu[::nI,4]))*8),::nGLSizq+33,::nGCSizq+::nPiOpMenu+((Val(::aBMenu[::nI,4])+1)*8)-2,0)
      
             ::nPiOpMenu=::nPiOpMenu+((Len(::aBMenu[::nI,1]))*8)

           EndIF

           ::nI=::nI+1

       EndDo

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_Keyboard(nKey) CLASS WinGT //Chequea el Teclado

    ::nKey=nKey

    if nKey>271 .and. nkey<307
       ::WGT_Alt(nkey)
       ::WGT_RBMenu()
    endif

    
    if ::nKey=19 .or. ::nKey=4 
       if ::lBMenu
          ::lSBMenu=.F.
          Do While .T.
             If ::nKey=19
	        If ::nIndM=1
	           ::nIndM=::nLenMenu
                Else
                   ::nIndM=::nIndM-1
	        Endif
	     EndIf
             If ::nKey=4
                If ::nIndM=::nLenMenu
	           ::nIndM=1
                Else
	           ::nIndM=::nIndM+1
	        Endif
             Endif
             if !Empty(::aBMenu[::nIndM,1])
	        ::nKey=Asc(::aBMenu[::nIndM,3])
	         ::WGT_RBMenu()
	         exit
	      EndIf
	EndDo
       EndIf
     EndIf

    if ::nKey=5 .or. ::nKey=24 
       if ::lBMenu
          Do While .T.
             If ::nKey=5
	        If ::nIndSM-1=::nIndM
		   Do While Empty(::aBMenu[::nIndSM,1]) 
		      If ::nIndSM=::nLenMenu
		         Exit
		      Endif
                      ::nIndSM=::nIndSM+1
                   EndDo
                Else
                   ::nIndSM=::nIndSM-1
	        Endif
	     EndIf
             If ::nKey=24
	        If ::nIndSM=::nLenMenu
		   ::nIndSM=::nIndM
		EndIf
	        If ::nIndSM<::nLenMenu
                   ::nIndSM=::nIndSM+1
                   If !Empty(::aBMenu[::nIndSM,1])
		      ::nIndSM=::nIndM+1
                   EndIf
                Endif
	     EndIf
             if Empty(::aBMenu[::nIndSM,1])
	        ::nKey=Asc(::aBMenu[::nIndSM,3])
	        ::WGT_RBMenu()
	        exit
	     EndIf
	EndDo
       EndIf
     EndIf

     If ::nKey=13 .and. ::lSBMenu
        ::lSBMenu=.F.
	     eval(::aBMenu[::nIndSM,10])
        ::WGT_RBMenu()
     EndIF

     If ::nKey=27 .and. ::lSBMenu
        ::lSBMenu=.F.
        RestScreen(::nPLSizqC,::nPCSizqC,::nPLIdchC,::nPCIdchC,::pPersiana)
        ::WGT_RBMenu()

     EndIF


RETURN

*--------------------------------------------------------------------------*

METHOD WGT_Alt(nKey) CLASS WinGT //Chequea que tecla ha sido pulsada con Alt

    ::nI=1
    Do While ::nI<26
       if nkey=::aAlts[::nI,1]
	  ::nKey=ASC(::aAlts[::nI,2])
          exit
       EndIf
       ::nI=::nI+1
    EndDo

RETURN

*--------------------------------------------------------------------------*

METHOD WGT_Refres() CLASS WinGT //Redibuja la ventana con su contenido

       ::WGT_Show()
       If !Empty(::aBMenu)
          ::WGT_ShwMen()
       EndIf

RETURN





