/*
  CLASSLCK.C - Copyright (c) 1993 James M. Finnegan, All Rights Reserved
*/
#include <windows.h>
#include "prochook.h"
#include "goodies.h"

// Global stuff
HANDLE      hInst;
NPHOOKCHILD npHookChild;
          
// This structure array associates the possible values of the nIndex
// parameter of SetClassWord() to a string.
struct ClassItems
{
    int  nIndex;
    char szText[20];
}CI[]=
{

    GCW_HBRBACKGROUND  ,"Background",
    GCW_HCURSOR        ,"Cursor",
    GCW_HICON          ,"Icon",
    GCW_HMODULE        ,"Module",
    GCW_CBWNDEXTRA     ,"WndExtra",
    GCW_CBCLSEXTRA     ,"ClassExtra",
    GCL_WNDPROC        ,"WndProc",
    GCW_STYLE          ,"Style",
    NULL               ,""
};    

// Declarations
long WINAPI WndProc        (HWND, UINT, WPARAM, LPARAM);
WORD WINAPI NewSetClassWord(HWND, int, WORD);


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
           int nCmdShow)
{
    static char szAppName[]="ClassLock";
    HWND        hwnd;
    MSG         msg;
    WNDCLASS    wndclass;

    
    // Allow only one instance of this app
    if(hPrevInstance != NULL) 
    {
        // terminate this instance
        BringWindowToTop(FindWindow(szAppName,szAppName));
        return(0);
    }
    
    if(!hPrevInstance)
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = WndProc;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = 0;
        wndclass.hInstance     = hInstance;
        wndclass.hIcon         = LoadIcon(hInstance,szAppName);
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = COLOR_WINDOW + 1;
        wndclass.lpszMenuName  = NULL;
        wndclass.lpszClassName = szAppName;

        if(!RegisterClass(&wndclass))
            return -1;
    }

    // Make hInstance global
    hInst=hInstance;

    hwnd=CreateWindow(szAppName,szAppName,
                         WS_OVERLAPPED | WS_VISIBLE |
                         WS_CAPTION | WS_SYSMENU,
                         CW_USEDEFAULT, 
                         SW_SHOWMINNOACTIVE,
                         CW_USEDEFAULT, CW_USEDEFAULT,
                         NULL, NULL, hInstance, NULL);
    // Remove SW_SHOWMINNIACTIVE and replace it with SW_HIDE,  
    // to remove it from view (from the desktop as well as the Task
    // Mananger).

    if(hwnd == NULL)
        return(0);

    while(GetMessage(&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return(msg.wParam);
}


long WINAPI WndProc(HWND hWnd,UINT wMessage,WPARAM wParam,LPARAM lParam)
{
    FARPROC lpfnNewSC;  // Pointer for MakeProcInstance()

        
    switch(wMessage)
    {
        case WM_CREATE:
            // Set up the hook for our NewSetClassWord()
            lpfnNewSC=MakeProcInstance((FARPROC)NewSetClassWord,hInst);
            npHookChild=SetProcAddress((FARPROC)SetClassWord,lpfnNewSC,FALSE);
            break;
            
        case WM_QUERYOPEN:
            // This app only runs as an icon, so fail this request.
            break;
            
        case WM_DESTROY:
            // Permanently delete the hook to NewSetClassWord()
            SetProcRelease(npHookChild);
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(hWnd, wMessage, wParam, lParam);
            break;
    }
    return 0L;
}


// This is called only when SetClassWord is called by an applicaiton! 
WORD WINAPI NewSetClassWord(HWND hWnd, int nIndex, WORD wNewWord)
{
    WORD           i;
    static char    szMessage[200];
    static char    szClassName[20];
    static HMODULE hUserMod=NULL;

    
    // Grab the handle to USER.EXE
    if(hUserMod==NULL)
    {    
        hUserMod=GetTaskHandle("USER");
    }
    
    // If the class owner is USER...
    if(hUserMod == GetClassWord(hWnd,GCW_HMODULE))   
    {
        // Find the text of nIndex
        for(i=0;i<8;i++)
        {
            if(nIndex == CI[i].nIndex)
                break;
        }
                
        // Get the text name for this class
        GetClassName(hWnd,szClassName,19);
        
        // Form the text for the message box
        wsprintf(szMessage,"%s is attempting to modify class %s with a new %s.\nThis class is owned by %s and it should be static.\nDo you wish to permit modification to the class?",
                                GetTaskName(GetCurrentTask()),
                                (LPSTR)szClassName,
                                (LPSTR)CI[i].szText,
                                GetModuleName(GetClassWord(hWnd,GCW_HMODULE)));
                                    
        // If the user selects "no", send a failure return
        // code (0) to the calling application.
        if((MessageBox(NULL,szMessage,"ClassLock Warning",
                                         MB_SYSTEMMODAL | MB_ICONHAND |
                                         MB_DEFBUTTON2 | MB_YESNO)) == IDNO)
            return 0;
    }                        

    // Unhook us!
    ProcUnhook(npHookChild);
    // Reissue the call to SetClassWord()
    i=SetClassWord(hWnd,nIndex,wNewWord);
    // Rehook us!
    ProcHook(npHookChild);
   
    return i;
}     
