/*
  GPA.C - Copyright (c) 1993 James M. Finnegan, All Rights Reserved
*/
#include <windows.h>
#include "gpa.h"
#include "prochook.h"
#include "goodies.h"

// Global stuff
HANDLE hInst;
HWND   ghWnd;
// Magic cookie for GetProcAddress hook
NPHOOKCHILD npHookChild;


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
           int nCmdShow)
{
    static char szAppName[]="gpa";
    HWND        hWnd;
    MSG         msg;
    WNDCLASS    wndclass;

    
    hInst=hInstance;
    
    if(!hPrevInstance)
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = WndProc;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = DLGWINDOWEXTRA;
        wndclass.hInstance     = hInstance;
        wndclass.hIcon         = LoadIcon(hInstance,szAppName);
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = COLOR_WINDOW + 1;
        wndclass.lpszMenuName  = NULL;
        wndclass.lpszClassName = szAppName;

        if(!RegisterClass(&wndclass))
            return -1;
    }

    if((hWnd=CreateDialog(hInstance,szAppName,0,NULL)) == NULL)
        return -1;

    // Make HWND global
    ghWnd=hWnd;
    
    ShowWindow(hWnd,nCmdShow);

    while(GetMessage(&msg,NULL,0,0))
    {
        if((!IsWindow(hWnd)) ||
           (!IsDialogMessage(hWnd,&msg)))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return msg.wParam;
}


long WINAPI WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    FARPROC lpfnNewGetPA;  // Pointer for MakeProcInstance()
    int iTabStop[4];       // Tabs for the list box
                            
                            
    switch(message)
    {
        case WM_CREATE:
            //Center the window on the screen
            CenterWindow(hWnd);
            
            // Set up the hook to our new function
            lpfnNewGetPA=MakeProcInstance((FARPROC)NewGetProcAddress,hInst);
            npHookChild=SetProcAddress((FARPROC)GetProcAddress,lpfnNewGetPA,FALSE);
            
            // Post a message to set the tabs in the list box
            PostMessage(hWnd,WM_SETLBTABS,0,0L);
            break;
        
        case WM_SETLBTABS:
            iTabStop[0]=28;
            iTabStop[1]=83;
            iTabStop[2]=127;
            iTabStop[3]=146;
            SendDlgItemMessage(hWnd,IDL_MAINBOX,LB_SETTABSTOPS,4,(LONG)(LPINT)iTabStop);

            SetFocus(GetDlgItem(hWnd,IDB_CLEAR));
            break;
            
        // Processing for the listbox buttons...
        case WM_COMMAND:
            switch(wParam)
            {
                case IDB_CLEAR:
                    SendDlgItemMessage(hWnd,IDL_MAINBOX,LB_RESETCONTENT,0,0L);
                    break;

                case IDB_EXIT:
                    PostMessage(hWnd,WM_CLOSE,0,0L);
                    break;
            }
            break;
            
        case WM_DESTROY:
            // Delete the reference to the hook
            SetProcRelease(npHookChild);
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
            break;
    }
    return 0L;
}
            
/* 
 All the stuff below is called only when GetProcAddress() is called from
 another application! 
*/

FARPROC __export WINAPI NewGetProcAddress(HINSTANCE hInst,LPCSTR lpszExp)
{
    FARPROC     i;
    static char szItem[100];
    static char szResult[5];
    HTASK       wCurTask;
    HMODULE     wModHandle=NULL;
    
    
    // Unhook our reference
    ProcUnhook(npHookChild);
    // Reissue the call to GetProcAddress 
    i=GetProcAddress(hInst,lpszExp);
    // Rehook our reference
    ProcHook(npHookChild);

    // Get the caller's task handle
    wCurTask=GetCurrentTask();
    
    // Get the module handle of the referenced library.
    // Quasi-documented... pass hInst instead of a string as a parameter!
    if(hInst != NULL)
        wModHandle=GetModuleHandle((LPCSTR)hInst);

    // Assign some readable text to the result of the call to GetProcAddress
    if(i == NULL)
        lstrcpy(szResult,"Fail");
    else
        lstrcpy(szResult,"OK");
   
    // If the caller passed in an ordinal instead of a string, print the
    // ordinal and search for the string in the EXE header 
    if(HIWORD(lpszExp) == 0)
    {    
        wsprintf(szItem,"%s\t%-8.8s\t%-8.8s\t(%03d)\t%s",(LPSTR)szResult,
                                                         GetTaskName(wCurTask),
                                                         GetModuleName(wModHandle),
                                                         LOWORD(lpszExp),
                                                         GetNameFromOrd(wModHandle,(WORD)LOWORD(lpszExp)));
    }
    // The caller used the "straight and narrow".  Just print the 
    // parameters and the result.
    else
    {    
        wsprintf(szItem,"%s\t%-8.8s\t%-8.8s\t\t%s",(LPSTR)szResult,
                                                   GetTaskName(wCurTask),
                                                   GetModuleName(wModHandle),
                                                   lpszExp);
    }
   
    // Put the string in the listbox.
    SendDlgItemMessage(ghWnd,IDL_MAINBOX,LB_ADDSTRING,0,(LONG)(LPSTR)szItem);
      
    // Return the value returned from the call to GetProcAddress to
    // make us look transparent!
    return i;
}     

