/*
  HOOKTOOL.C - Copyright (c) 1993 James M. Finnegan, All Rights Reserved
*/
#include <windows.h>
#include <toolhelp.h>
#include <dos.h>
#include "hooktool.h"
#include "prochook.h"
#include "goodies.h"
  

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
           int nCmdShow)
{
    static char szAppName[]="HookTool";
    HWND        hwnd;
    MSG         msg;
    WNDCLASS    wndclass;


    if(!hPrevInstance)
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = WndProc;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = DLGWINDOWEXTRA;
        wndclass.hInstance     = hInstance;
        wndclass.hIcon         = LoadIcon(hInstance,szAppName);
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = COLOR_WINDOW + 1;
        wndclass.lpszMenuName  = NULL;
        wndclass.lpszClassName = szAppName;

        if(!RegisterClass(&wndclass))
            return -1;
    }

    if((hwnd=CreateDialog(hInstance,szAppName,0,NULL)) == NULL)
        return -1;

    ShowWindow(hwnd,nCmdShow);

    while(GetMessage(&msg,NULL,0,0))
    {
        if((!IsWindow(hwnd)) ||
           (!IsDialogMessage(hwnd,&msg)))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return msg.wParam;
}


long WINAPI WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch(message)
    {
        case WM_CREATE:
            //Center the window on the screen
            CenterWindow(hWnd);

             // Post messages to set focus and refresh the list box
            PostMessage(hWnd,WM_SFOCUS,0,0L);
            PostMessage(hWnd,WM_COMMAND,IDB_REFRESH,0L);
            break;
        
        case WM_SFOCUS:    
            SetFocus(GetDlgItem(hWnd,IDB_REFRESH));
            break;
        
        // Processing for the listbox buttons...
        case WM_COMMAND:
            switch(wParam)
            {
                // Reset the listboxes and walk the master list
                case IDB_REFRESH:
                    SendDlgItemMessage(hWnd,IDL_LIST1,LB_RESETCONTENT,0,0L);
                    SendDlgItemMessage(hWnd,IDL_LIST2,LB_RESETCONTENT,0,0L);
                    EnableWindow(GetDlgItem(hWnd,IDB_DELETE),FALSE);
                    WalkMaster(hWnd);
                    break;
                                
                // Delete the currently selected child record
                case IDB_DELETE:
                    if(MessageBox(hWnd,"Delete. Are you sure?","HookTool",
                          MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2) == IDYES)
                    {
                        DeleteChild(hWnd);
                        PostMessage(hWnd,WM_COMMAND,IDB_REFRESH,0L);
                    }                    
                    break;
                    
                case IDB_EXIT:
                    PostMessage(hWnd,WM_CLOSE,0,0L);
                    break;
                    
                case IDL_LIST1:
                    switch(HIWORD(lParam))
                    {
                        // Reset and populate the second listobx if a 
                        // new master record is selected in the first
                        // listbox
                        case LBN_SELCHANGE:
                            SendDlgItemMessage(hWnd,IDL_LIST2,LB_RESETCONTENT,0,0L);
                            EnableWindow(GetDlgItem(hWnd, IDB_DELETE),FALSE);
                            WalkChild(hWnd);
                            break;
                    }
                    break;

                case IDL_LIST2:
                   // Set the status of the delete button based on whether
                   // there is a selection in the second listbox
                   if(SendDlgItemMessage(hWnd,IDL_LIST1,LB_GETCURSEL,0,0L)
                                                                  != LB_ERR)
                   {    
                       EnableWindow(GetDlgItem(hWnd,IDB_DELETE),TRUE);
                   }
                   else
                   { 
                       EnableWindow(GetDlgItem(hWnd,IDB_DELETE),FALSE);
                   }
                   break;    
            }
            break;
            
        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
            break;
    }
    return 0L;
}


VOID WalkMaster(HWND hWnd)
{
    char         szText[50];
    GLOBALENTRY  ge;
    HOOKMASTER   HookMast;
    NPHOOKMASTER npHookMast;
    WORD         wIndex;
   
   
    // Get the first master record
    if((npHookMast=GetFirstHMaster(&HookMast)) == NULL)
        return;
  
    for(;;)
    {
        // Get the owner of the hook
        ge.dwSize=sizeof(GLOBALENTRY);
        GlobalEntryHandle(&ge,FP_SEG(HookMast.lpfnHookedFunction));

        wsprintf(szText,"%s.%s",(LPSTR)GetModuleName(ge.hOwner),
                                       GetNameFromOrd(ge.hOwner,
                                       GetOrdFromAddr(ge.hOwner,HookMast.lpfnHookedFunction)));

        // Print the string showing the owner and export in the listbox
        if((wIndex=(WORD)SendDlgItemMessage(hWnd,IDL_LIST1,LB_ADDSTRING,0,
                                             (LONG)(LPSTR)szText)) != LB_ERR)
        {
            // Associate the master pointer with the string
            SendDlgItemMessage(hWnd,IDL_LIST1,LB_SETITEMDATA,wIndex,
                                                    MAKELONG(npHookMast,0));
        }
       
        // Get the next master record and loop
        if((npHookMast=GetNextHMaster(&HookMast)) == NULL)
            break;
    }
}     


VOID WalkChild(HWND hWnd)
{
    char         szText[50];
    GLOBALENTRY  ge;
    NPHOOKMASTER npHookMast;
    HOOKCHILD    HookChild;
    NPHOOKCHILD  npHookChild;
    WORD         wIndex;
                 
                 
    // Get the current master selection
    if((wIndex=(WORD)SendDlgItemMessage(hWnd,IDL_LIST1,LB_GETCURSEL,0,0L)) == LB_ERR)
        return;
        
    // Get the pointer to the master
    npHookMast=(NPHOOKMASTER)SendDlgItemMessage(hWnd,IDL_LIST1,
                                                   LB_GETITEMDATA,wIndex,0L);
   
    // Get the first child record of the current master
    if((npHookChild=GetFirstHChild((LPHOOKMASTER)MK_FP(0,npHookMast),&HookChild)) == NULL)
    {
        // If the child record is not valid, print "Invalid"
        SendDlgItemMessage(hWnd,IDL_LIST2,LB_ADDSTRING,0,(LONG)(LPSTR)"Invalid");
        return;
    }    

    for(;;)
    {
        // Get the owner of the hook
        ge.dwSize=sizeof(GLOBALENTRY);
        GlobalEntryHandle(&ge,FP_SEG(HookChild.lpfnNewFunc));
    
        wsprintf(szText,"%s",(LPSTR)GetModuleName(ge.hOwner));

        // Print the owner in the listbox
        if((wIndex=(WORD)SendDlgItemMessage(hWnd,IDL_LIST2,LB_ADDSTRING,0,
                                             (LONG)(LPSTR)szText)) != LB_ERR)
        {
            // Associate the child pointer with the string
            SendDlgItemMessage(hWnd,IDL_LIST2,LB_SETITEMDATA,wIndex,
                                                   MAKELONG(npHookChild,0));
        }

        // Get the next child record and loop
        if((npHookChild=GetNextHChild(&HookChild)) == NULL)
            break;
    }
}


VOID DeleteChild(HWND hWnd)
{   
    WORD        wIndex;
    NPHOOKCHILD npHookChild;
                 
                 
    // Get the current child selection
    if((wIndex=(WORD)SendDlgItemMessage(hWnd,IDL_LIST2,LB_GETCURSEL,0,0L))
                                                                  !=LB_ERR)
    {
        // Get the pointer to the child record
        npHookChild=(NPHOOKCHILD)SendDlgItemMessage(hWnd,IDL_LIST2,
                                                   LB_GETITEMDATA,wIndex,0L);
        // Delete it!
        SetProcRelease(npHookChild);
    }
}
