/*
  LAZYAPP.C - Copyright (c) 1993 James M. Finnegan, All Rights Reserved
*/
#include <windows.h>

LONG WINAPI DlgProc(HWND,WORD,WORD,LONG);   // Dialog Message Procedure

int iShow;                         // Variable to make iCmdShow global
HANDLE hInst;                      // Variable to make hInstance global

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                                        LPSTR lpszCmdLine, int nCmdShow)
{
    int     iRet;          // Dialog Box return value
    FARPROC lpfnDlgProc;   // Variable for MakeProcInstance


    iShow=nCmdShow;        // Make 'em global
    hInst=hInstance;

    lpfnDlgProc=MakeProcInstance((FARPROC)DlgProc,hInstance);
    iRet=DialogBox(hInstance,"LAZYAPP",0,lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);

    return iRet;
}


LONG WINAPI DlgProc(HWND hWndDlg, WORD Message, WORD wParam, LONG lParam)
{
    PAINTSTRUCT  ps;
    HDC          hDC;
    static HICON hIcon;
    
    
    switch(Message)
    {
        case WM_INITDIALOG:
            hIcon=LoadIcon(hInst,"LAZYAPP");
            ShowWindow(hWndDlg,iShow);  // In case someone is starting us
                                        // in a minimized state...
            break;

        // Give Windows our Icon handle so it can draw a mono cursor
        // if the minimized window is being moved. We only get this
        // message if there is no Icon associated with this class!
        case WM_QUERYDRAGICON:
            return hIcon;
            break;
                                                         
        // since there is no associated icon with the dialog class, we
        // must do our own icon drawing...
        case WM_PAINT:
            if(IsIconic(hWndDlg))
            {
                hDC=BeginPaint(hWndDlg, &ps);

                if(hDC)
                {
                    // Paint the desktop window background (for
                    // transparent icons)
                    DefWindowProc(hWndDlg,WM_ICONERASEBKGND,(WORD)ps.hdc,0L);
                    // Draw the icon on top of it
                    DrawIcon(hDC,0,0,hIcon);
                }
                EndPaint(hWndDlg, &ps);
                return(TRUE);
            }
            return(FALSE);
            break;

        case WM_ERASEBKGND:
            if(IsIconic(hWndDlg))
                return(TRUE);    // Don't erase when iconized
            else
                return(FALSE);
            break;

        case WM_CLOSE:
            PostMessage(hWndDlg,WM_COMMAND,IDCANCEL,0L);
            break;

        case WM_COMMAND:
            switch(wParam)
            {
                case IDCANCEL:
                    EndDialog(hWndDlg,FALSE);
                    break;
            }
            break;

        default:
            return FALSE;
    }
    return TRUE;
}
