/*
  SCW.C - Copyright (c) 1993 James M. Finnegan, All Rights Reserved
*/
#include <windows.h>
#include "scw.h"
#include "prochook.h"
#include "goodies.h"

// Global stuff
HANDLE hInst;
HWND   ghWnd;
// Magic cookie for SetClassWord hook
NPHOOKCHILD npHookChild;

// This structure array associates the possible values of the nIndex
// parameter of SetClassWord() to a string.
struct ClassItems
{
    int  nIndex;
    char szText[20];
}CI[]=
{

    GCW_HBRBACKGROUND  ,"Background",
    GCW_HCURSOR        ,"Cursor",
    GCW_HICON          ,"Icon",
    GCW_HMODULE        ,"Module",
    GCW_CBWNDEXTRA     ,"WndExtra",
    GCW_CBCLSEXTRA     ,"ClassExtra",
    GCL_WNDPROC        ,"WndProc",
    GCW_STYLE          ,"Style",
    NULL               ,""
};    


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
           int nCmdShow)
{
    static char szAppName[]="scw";
    HWND        hwnd;
    MSG         msg;
    WNDCLASS    wndclass;

    
    hInst=hInstance;
    
    if(!hPrevInstance)
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = WndProc;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = DLGWINDOWEXTRA;
        wndclass.hInstance     = hInstance;
        wndclass.hIcon         = LoadIcon(hInstance,szAppName);
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = COLOR_WINDOW + 1;
        wndclass.lpszMenuName  = NULL;
        wndclass.lpszClassName = szAppName;

        if(!RegisterClass(&wndclass))
            return -1;
    }

    if((hwnd=CreateDialog(hInstance,szAppName,0,NULL)) == NULL)
        return -1;

    // Make HWND global
    ghWnd=hwnd;  
    
    ShowWindow(hwnd,nCmdShow);

    while(GetMessage(&msg,NULL,0,0))
    {
        if((!IsWindow(hwnd)) ||
           (!IsDialogMessage(hwnd,&msg)))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return msg.wParam;
}


long WINAPI WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    FARPROC lpfnNewSetClass; // Pointer for MakeProcInstance()
    int     iTabStop[3];     // Tabs for the list box

        
    switch(message)
    {
        case WM_CREATE:
            //Center the window on the screen
            CenterWindow(hWnd);
            
            // Set up the hook to our new function
            lpfnNewSetClass=MakeProcInstance((FARPROC)NewSetClassWord,hInst);
            npHookChild=SetProcAddress((FARPROC)SetClassWord,lpfnNewSetClass,FALSE);

            // Post a message to set the tabs in the list box
            PostMessage(hWnd,WM_SETLBTABS,0,0L);
            break;
        
        case WM_SETLBTABS:
            iTabStop[0]=58;
            iTabStop[1]=122;
            iTabStop[2]=187;
            SendDlgItemMessage(hWnd,IDL_MAINBOX,LB_SETTABSTOPS,3,(LONG)(LPINT)iTabStop);
            
            SetFocus(GetDlgItem(hWnd,IDB_CLEAR));
            break;
            
        // Processing for the listbox buttons...
        case WM_COMMAND:
            switch(wParam)
            {
                case IDB_CLEAR:
                    SendDlgItemMessage(hWnd,IDL_MAINBOX,LB_RESETCONTENT,0,0L);
                    break;

                case IDB_EXIT:
                    PostMessage(hWnd,WM_CLOSE,0,0L);
                    break;
            }
            break;
            
        case WM_DESTROY:
            // Delete the reference to the hook
            SetProcRelease(npHookChild);
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
            break;
    }
    return 0L;
}

/* 
 All the stuff below is called only when SetClassWord() is called from
 another application! 
*/

WORD WINAPI NewSetClassWord(HWND hWnd, int nIndex, WORD wNewWord)
{
   WORD        i;
   static char szLBText[50];
   static char szClassName[20];
   
   // Find the text of nIndex
   for(i=0;i<8;i++)
   {
       if(nIndex == CI[i].nIndex)
           break;
   }
   
   // Get the text name for this class
   GetClassName(hWnd,szClassName,19);

   // Create the string for the listbox
   wsprintf(szLBText,"%s\t%s\t%s\t%s",GetTaskName(GetCurrentTask()),
                                      GetModuleName(GetClassWord(hWnd,GCW_HMODULE)),
                                      (LPSTR)szClassName,(LPSTR)CI[i].szText);
   
   SendDlgItemMessage(ghWnd,IDL_MAINBOX,LB_ADDSTRING,0,(LONG)(LPSTR)szLBText);

    // Unhook us!
   ProcUnhook(npHookChild);
    // Reissue the call to SetClassWord()
   i=SetClassWord(hWnd,nIndex,wNewWord);
    // Rehook us!
   ProcHook(npHookChild);
   
   return i;
}     
