#include <windows.h>
#define IDM_START   100
#define IDM_STOP    101

HWND HMainWnd = 0;          // Window handle of main window
UINT HTimer = 0;            // Handle for timer
BOOL bSecondLoop = 0;       // Should we be in second PeekMessage() loop?

//
// Indicate on the status bar which loop we're in (primary or
// secondary).  Only update the text if the state changes.
//
void FAR PASCAL IdleAction( int nId )
{
    static int lastTime = 0;
    
    if ( nId == lastTime )
        return;
    lastTime = nId;
    
    SetWindowText(HMainWnd, (nId==1) ? "Main Loop" : "Secondary loop");
}

//
// Secondary PeekMessage() loop entered when a WM_TIMER message goes off
//
void FAR PASCAL SecondaryLoop( void )
{
    MSG msg;
    
    while( bSecondLoop )
    {
        while( PeekMessage(&msg,NULL,NULL,NULL,PM_REMOVE) )
        {
            if( msg.message == WM_QUIT )
            {
                PostQuitMessage( msg.wParam );
                bSecondLoop = 0;
                return;
            }
            
            TranslateMessage(&msg);
            DispatchMessage(&msg);
      
            if( !bSecondLoop )
                break;
        }  
        IdleAction( 2 );    // Indicate which loop we're in
    }
}

//
// The program's main window procedure.
//
LRESULT CALLBACK _export LoopWndProc(
    HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam )
{
    switch ( wMessage )
    {
        case WM_COMMAND:
            switch( wParam )
            {
                case IDM_START:
                    HTimer = SetTimer( hWnd, 1, 5000, 0 );  // 5 seconds
                    bSecondLoop = 0;
                    break;

                case IDM_STOP:
                    if( HTimer )    // Stop the timer and 2nd loop
                    {
                        KillTimer( hWnd, HTimer );
                        HTimer = bSecondLoop = 0;
                    }
                    break;
            }
            break;

        case WM_TIMER:              // Alternate between modes.  Five
            if( !bSecondLoop )      // seconds in the primary loop,
            {                       // Followed by five seconds in the
                bSecondLoop = 1;    // secondary loop.
                SecondaryLoop();
            }
            else
                bSecondLoop = 0;
            break;

        case WM_CLOSE:
            if( HTimer )
                KillTimer( hWnd, HTimer );
            PostQuitMessage( 0 );
            break;
    }
    
    return( DefWindowProc( hWnd, wMessage, wParam, lParam ) );
}

int PASCAL WinMain(
    HANDLE hInstance, HANDLE hPrev, LPSTR lpCmdLine, int nCmdShow )
{
    WNDCLASS wndClass;
    MSG msg;

    //
    // Generic code for registering a window class.
    //
    wndClass.style = CS_HREDRAW | CS_VREDRAW;
    wndClass.lpfnWndProc = (WNDPROC)LoopWndProc;
    wndClass.cbWndExtra = wndClass.cbClsExtra = 0;
    wndClass.hInstance = hInstance;
    wndClass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
    wndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    wndClass.lpszMenuName = (LPSTR)"LoopMenu";
    wndClass.lpszClassName = (LPSTR)"LoopWndClass";

    if ( !RegisterClass( &wndClass ) )
        return 0;

    //
    // Create a standard overlapped window with a scroll bar
    //
    HMainWnd = CreateWindow("LoopWndClass",
                            "Message Looping",
                            (DWORD)(WS_OVERLAPPEDWINDOW|WS_VSCROLL),
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            0, 0, hInstance, 0 );
    if( !HMainWnd )
        return 0;

    ShowWindow( HMainWnd, nCmdShow );
    UpdateWindow( HMainWnd );

    //
    // The primary PeekMessage() loop.
    //
    while ( TRUE )
    {
        if ( PeekMessage(&msg, 0, 0, 0, PM_REMOVE) )
        {
            if ( msg.message == WM_QUIT )
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else                    // No message waiting.
            IdleAction( 1 );    // Indicate that we're in primary loop
    }
    
    return msg.wParam;
}
