{
                              Naplps Interpreter
                      Copyright (C) 1991-92 by John Beck
                           See Licensing Agreement.

NAPFLAGS - Contains the compiler directives (CD's) for the different
           unit versions of naplps to generate.

}

(*
    Definition Expainations -

          FINAL  - enable this directive on when compiling the final
                   version of your program.  This will increase the code
                   speed and reduce the size of the program.

          NAP286 - Turns on 80286 code generation.

          NAP486 - Turns on 80286 and coporcessor code generation.
*)


{ *** Definition Area *** }

{ $ DEFINE FINAL }
{ $ DEFINE NAP286}
{ $ DEFINE NAP486}

{ *** Set Default Directive States *** }

{ CD  :   Function              : Comments           }

{$A+}   { Word Allign Data      : speeds up memory   }
{$B-}   { Complete Boolean Eval : speeds up code     }
{$D+}   { Debug Information     : for debugging      }
{$E+}   { 80x87 Emulation       : flexible code      }
{$F+}   { Force Far Calls       : recommended on     }
{$G-}   { 286 Code Generation   : speeds up code     }
{$I+}   { IO Checking           : recommended on     }
{$L+}   { Local Symbol Info     : for debugging      }
{$N-}   { Coprocessor           : speeds up code     }
{$O-}   { Overlays              : program optional   }
{$P+}   { Open Parameters       : flexible code      }
{$Q+}   { Overflow Checking     : for debugging      }
{$R+}   { Range Checking        : for debugging      }
{$S+}   { Stack Checking        : for debugging      }
{$T-}   { Pointer Checking      : program optional   }
{$V+}   { Strict Str Checking   : for debugging      }
{$X+}   { Extended Syntax       : recommened on      }
{$Y+}   { Symbol Reference Info : for debugging      }

{ *** Set Conditional Directives *** }

{$IFDEF NAP286}
   {$G+}            (* Set 80286 Code Generation On *)
{$ENDIF}

{$IFDEF NAP486}
   {$G+}            (* Set 80286 Code Generation On *)
   {$N+}            (* Set Coprocessor Code On      *)
{$ENDIF}

{$IFDEF FINAL}
   {$S-}            (* Set Stack Checking Off *)
   {$R-}            (* Set Range Checking Off *)
   {$L-}            (* Set Symbol Info Off    *)
   {$D-}            (* Set Debug Info Off     *)
   {$Q-}            (* Set Overflow Check Off *)
   {$Y-}            (* Set Symbol Ref. Off    *)
   {$V-}            (* Set Str Checking Off   *)
{$ENDIF}
