/* The following Microsoft C 7.0 program should be linked with the assembly
language library in Example 2.  Combine the library with XLIB.LIB using the
Microsoft Lib utility.  The C program first initializes XLIB.  Next, it
creates a float array.  A control block for SUMARRAY is then constructed
and the call to SUMARRAY is executed.  Finally, the condition code in the
control block is inspected and results are printed. */

#include <stdio.h>
#include <xlib.h>

extern long __far __pascal LINADR(void __far *ptr);
extern void __far __pascal SUMARRAY(void __far *ptr);

struct arraydata
{
  long condcode;
  long n;
  long address;
  float sum;
} ad;

float a[101];

main()
{
  int i;
  long temp;

  temp = INITXLIB();
  if (temp != 0)
  {
    printf("Initialization Error:  %lX\n",temp);
    return 0;
  }

  for(i = 0; i <= 100; i++)
    a[i] = i;

  ad.condcode = 0;
  ad.n = 50;
  ad.address = LINADR(a);

  SUMARRAY(&ad);
  if (ad.condcode != 0)
  {
    printf("Error:  %lX\n",ad.condcode);
    return 0;
  }
  printf("Sum:  %f\n",ad.sum);
}
