VERSION 2.00
Begin Form BMPView 
   Caption         =   "Bitmap Viewer 2.0"
   ClientHeight    =   600
   ClientLeft      =   3696
   ClientTop       =   2880
   ClientWidth     =   2040
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   7.8
   FontStrikethru  =   0   'False
   FontTransparent =   0   'False
   FontUnderline   =   0   'False
   Height          =   972
   Icon            =   BMPVIEW.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   3672
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   600
   ScaleWidth      =   2040
   Top             =   2532
   Width           =   2088
   Begin PictureBox Picture1 
      AutoSize        =   -1  'True
      ClipControls    =   0   'False
      Enabled         =   0   'False
      Height          =   36
      Left            =   0
      ScaleHeight     =   12
      ScaleWidth      =   24
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   48
   End
   Begin Image Image1 
      Height          =   612
      Left            =   0
      Stretch         =   -1  'True
      Top             =   0
      Width           =   2052
   End
End
Option Explicit

Sub Form_KeyDown (Keycode As Integer, Shift As Integer)

Dim ShiftDown, AltDown, CtrlDown, Txt, F12, F4

    Const KEY_F4 = &H73
    Const KEY_F12 = &H7B
    Const SHIFT_MASK = 1
    Const CTRL_MASK = 2
    Const ALT_MASK = 4
    
    ShiftDown = (Shift And SHIFT_MASK) > 0
    AltDown = (Shift And ALT_MASK) > 0
    CtrlDown = (Shift And CTRL_MASK) > 0
    F12 = (Keycode = KEY_F12)
    F4 = (Keycode = KEY_F4)
    
    If (ShiftDown And F12) Then
        WindowState = MINIMIZED
        'Picture = Image1.Picture
        'Form_Resize
    End If
    
    If (CtrlDown And F12) Then
        WindowState = normal
    End If
    
    If (AltDown And F12) Then
        WindowState = MAXIMIZED
    End If
    
    If (AltDown And F4) Then
        Form_Unload 0
    End If

End Sub

Sub Form_Load ()
    
    ReadINI

    Picture1.Top = 0
    Picture1.Left = 0
    Image1.Top = 0
    Image1.Left = 0
    Image1.Width = ScaleWidth
    Image1.Height = ScaleHeight

    Load OpenBitMap
    Load BmpABout


    If (BMPFileName <> "") Then
        ImageLoad
        Top = ViewTop
        Left = ViewLeft
        Height = ViewHeight
        ViewAllowResize = True
        Width = ViewWidth
    Else
        NotTopMost
        OpenBitMap.Show 1
    End If
    
    If (OpenBitMap.OnTop = True) Then
        Topmost
    Else
        NotTopMost
    End If

End Sub

Sub Form_Resize ()
    
    If (ScaleWidth > 1) And (ScaleHeight > 1) And (ViewAllowResize) Then
        If (OpenBitMap.Aspect = True) And (WindowState = normal) Then
            Width = (ScaleHeight * ViewAspect) + ViewBorder
        End If
        Image1.Width = ScaleWidth
        Image1.Height = ScaleHeight
    End If
    
End Sub

Sub Form_Unload (Cancel As Integer)
    
    BMPView.Image1.Picture = LoadPicture("")
    Unload OpenBitMap
    Unload BmpABout
    Unload BMPView
    End

End Sub

Sub Image1_DblClick ()
    
    NotTopMost

    OpenBitMap.Show 1
    
End Sub

Sub Image1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
        
    If (Button And 2) Then
        ViewAllowResize = False
        If (Caption = "") Then
            ViewCaption = True
            Caption = "Bitmap Viewer"
        Else
            ViewCaption = False
            Caption = ""
        End If
        ViewAllowResize = True
    Else
        PixStartX = (BMPView.Left) / TPRatio
        PixStartY = (BMPView.Top) / TPRatio
        PixOffsetX = Int(X / TPRatio)
        PixOffsetY = Int(Y / TPRatio)
        OkToMove = True
        GhostForm PixStartX, PixStartY, PixStartX + (BMPView.Width / TPRatio), PixStartY + (BMPView.Height / TPRatio)
    End If

End Sub

Sub Image1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    
    If Button = 1 And OkToMove = True Then
        OkToMove = False
        PixX = Int(X / TPRatio) - PixOffsetX
        PixY = Int(Y / TPRatio) - PixOffsetY
        GhostForm PixStartX, PixStartY, PixStartX + (BMPView.Width / TPRatio), PixStartY + (BMPView.Height / TPRatio)
        GhostForm PixStartX + PixX, PixStartY + PixY, PixStartX + PixX + (BMPView.Width / TPRatio), PixStartY + PixY + (BMPView.Height / TPRatio)
        PixOffsetX = Int(X / TPRatio)
        PixOffsetY = Int(Y / TPRatio)
        PixStartX = PixStartX + PixX
        PixStartY = PixStartY + PixY
        OkToMove = True
    End If

End Sub

Sub Image1_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    
    If Button = 1 And OkToMove = True Then
        GhostForm PixStartX, PixStartY, PixStartX + (BMPView.Width / TPRatio), PixStartY + (BMPView.Height / TPRatio)
        BMPView.Move (PixStartX) * TPRatio, (PixStartY) * TPRatio
    End If
    
End Sub

Sub ReadINI ()
    
    Dim INISection As String
    Dim NoTitle As String
    Dim SaveSet As String
    Dim Always As String
    Dim AspectRatio As String
    Dim INIChan As Integer
    Dim Tmp As Integer
    Dim LIN As String

    On Error GoTo NOINI
    INIChan% = 1
    BMPFileName = ""
    ViewCaption = True
    OpenBitMap.SaveSettings = False
    OpenBitMap.OnTop = False
    OpenBitMap.Aspect = False
    
    Open "C:\WINDOWS\BMPVIEW.INI" For Input As #INIChan%
    
    While (EOF(INIChan%) = 0)
        
        Line Input #INIChan%, LIN$
        If Trim$(LIN$) <> "" Then
            If (Left$(LIN$, 1) = "[") Then
                Tmp% = InStr(LIN$, "]")
                If (Tmp% > 2) Then
                    INISection = Mid$(LIN$, 2, Tmp% - 2)
                Else
                    INISection = Mid$(LIN$, 2)
                End If
            Else
                Select Case INISection
                    Case "Current Bitmap"
                        BMPFileName = LIN$
                    Case "Top"
                        ViewTop = Val(LIN$)
                    Case "Left"
                        ViewLeft = Val(LIN$)
                    Case "Height"
                        ViewHeight = Val(LIN$)
                    Case "Width"
                        ViewWidth = Val(LIN$)
                    Case "No Title"
                        NoTitle = LIN$
                    Case "Save Settings"
                        SaveSet = LIN$
                    Case "Always on top"
                        Always = LIN$
                    Case "Aspect Ratio"
                        AspectRatio = LIN$
                    Case Else
                End Select
            End If
        End If

    Wend
    Close #INIChan%
    If (NoTitle = "Yes") Then
        Caption = ""
        ViewCaption = False
    End If
    If (SaveSet = "Yes") Then
        OpenBitMap.SaveSettings = True
    End If
    If (Always = "Yes") Then
        OpenBitMap.OnTop = True
    End If
    If (AspectRatio = "Yes") Then
        OpenBitMap.Aspect = True
    End If
    
Exit Sub

NOINI:
        If (Err = 53) Then
            Exit Sub
        Else
            MsgBox "Fatal error" & Str$(Err) & " in BMPView"
        End If
        
        Form_Unload 0

        End

End Sub

