@echo off
echo off
if %1==Q goto MakeQB
if %1==P goto MakePDS
if %1==V goto MakeVB

:Intro
cls
echo BLDLIB creates a complete PBCLONE.LIB (and .QLB) for you. It needs
echo one parameter, to specify the target compiler:
echo   Q   for QuickBasic
echo   P   for PDS ("The BASIC Professional Development System")
echo   V   for Visual Basic for DOS
echo.
echo For this to work:
echo   1) BC.EXE, LINK.EXE, and LIB.EXE must be somewhere along your PATH
echo   2) The BC support libraries must be somewhere along your LIB
echo   3) The .BAS files from PBC23C.ZIP must be in the BAS subdir off
echo      the current path (for example, if you're now in C:\PBCLONE,
echo      the .BAS files should be in C:\PBCLONE\BAS).
echo.
echo The LibWiz utility, available separately, makes it easy to make
echo subset PBClone libraries and .QLBs. You can also follow the
echo instructions in PBCLONE.DOC to create libraries manually.
echo.
echo Example:
echo   BLDLIB Q
echo (this creates a PBCLONE.LIB for QuickBasic 4.x)
goto Done

:MakeQB
if not exist BAS\ALTKEY.BAS goto ErrNoBAS
cd bas
echo Compiling... this may take a while... hang on!
del *.obj >nul
for %x in (*.bas) do bc %x/o; >nul
del pbc$bas.lib >nul
if not exist ALTKEY.OBJ goto ErrNoOBJ
echo Creating PBC$BAS library. This *will* take a while. Patience!
for %x in (*.obj) do lib PBC$BAS+%x; >nul
if not exist PBC$BAS.LIB goto ErrNoTmpLIB
del *.obj >nul
cd ..
echo Creating final PBCLONE.LIB library. We're almost there...
del pbclone.lib >nul
lib pbclone.lib+pbc$main.lib+pbc$near.lib+bas\pbc$bas.lib; >nul
echo PBCLONE.LIB contains the complete PBClone link library.
echo Building .QLB library...
link pbclone.lib/q/se:2048,pbclone.qlb,nul,BQLB45; >nul
if not exist PBCLONE.QLB goto ErrNoQLB45
echo PBCLONE.QLB contains the complete PBClone quick library.
echo You're set to go!
goto Done

:MakePDS
if not exist BAS\ALTKEY.BAS goto ErrNoBAS
cd bas
echo Compiling... this may take a while... hang on!
del *.obj >nul
for %x in (*.bas) do bc %x/o; >nul
del pbc$bas.lib >nul
if not exist ALTKEY.OBJ goto ErrNoOBJ
echo Creating PBC$BAS library. This *will* take a while. Patience!
for %x in (*.obj) do lib PBC$BAS+%x; >nul
if not exist PBC$BAS.LIB goto ErrNoTmpLIB
del *.obj >nul
cd ..
echo Creating near string PBCLONE.LIB library. Nearly half done...
del pbclone.lib >nul
lib pbclone.lib+pbc$main.lib+pbc$near.lib+bas\pbc$bas.lib; >nul
echo PBCLONE.LIB contains the complete near string PBClone link library.
cd bas
echo Compiling again... this may take a while... hang on!
del *.obj >nul
for %x in (*.bas) do bc %x/o/fs; >nul
del pbc$bas.lib >nul
echo Creating PBC$BASF library. This *will* take a while. Patience!
for %x in (*.obj) do lib PBC$BASF+%x; >nul
del *.obj >nul
cd ..
echo Creating far string PBCLONEF.LIB library. Almost done...
del pbclonef.lib >nul
lib pbclonef.lib+pbc$main.lib+pbc$far.lib+bas\pbc$basf.lib; >nul
echo PBCLONEF.LIB contains the complete far string PBClone link library.
echo Building .QLB library...
link pbclonef.lib/q/se:2048,pbclonef.qlb,nul,QBXQLB; >nul
if not exist PBCLONEF.QLB goto ErrNoQLB
echo PBCLONEF.QLB contains the complete PBClone quick library.
echo You're set to go!
goto Done

:MakeVB
if not exist BAS\ALTKEY.BAS goto ErrNoBAS
cd bas
echo Compiling... this may take a while... hang on!
del *.obj >nul
for %x in (*.bas) do bc %x/o; >nul
del pbc$bas.lib >nul
if not exist ALTKEY.OBJ goto ErrNoOBJ
echo Creating PBC$BAS library. This *will* take a while. Patience!
for %x in (*.obj) do lib PBC$BAS+%x; >nul
if not exist PBC$BAS.LIB goto ErrNoTmpLIB
del *.obj >nul
cd ..
echo Creating final PBCLONE.LIB library. We're almost there...
del pbclone.lib >nul
lib pbclone.lib+pbc$main.lib+pbc$near.lib+bas\pbc$bas.lib; >nul
echo PBCLONE.LIB contains the complete PBClone link library.
echo Building .QLB library...
link pbclone.lib/q/se:2048,pbclone.qlb,nul,VBDOSQLB; >nul
if not exist PBCLONE.QLB goto ErrNoQLB
echo PBCLONE.QLB contains the complete PBClone quick library.
echo You're set to go!
goto Done

:ErrNoBAS
echo Didn't find the .BAS files. Looks like they aren't in the BAS
echo directory as required. Let's check the instructions again...
echo.
goto Intro

:ErrNoOBJ
echo The .OBJ files weren't created. Looks like BC.EXE wasn't in
echo the PATH as required. Let's check the instructions again...
echo.
cd ..
goto Intro

:ErrNoTmpLIB
echo The PBC$BAS.LIB library wasn't created. Looks like LIB.EXE
echo wasn't in the PATH as required. Let's check the instructions
echo again...
echo.
cd ..
goto Intro

:ErrNoQLB45
echo The PBCLONE.QLB quick library wasn't created. Either you have
echo an old version (or no version) of LINK.EXE in your PATH, or
echo you are using a version of QuickBasic before QB 4.5. In the
echo latter case, create the .QLB manually, as described in the
echo LIBRARY.TXT document. Otherwise, put the current LINK.EXE in
echo your PATH and try it again.
goto Done

:ErrNoQLB
echo The PBCLONE.QLB quick library wasn't created. Probably you have
echo an old version (or no version) of LINK.EXE in your PATH...
goto Done

:Done
