'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        PBClone  Copyright (c) 1990-1994  Thomas G. Hanlin III        |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE SUB CursorInfo (Visible%, StartLine%, EndLine%, MaxLine%)
   DECLARE SUB GetKbd (Ins%, Caps%, Num%, ScrollLock%)
   DECLARE SUB GetVidMode (BIOSMode%, ScreenWidth%, ActivePage%)
   DECLARE SUB SetKbd (BYVAL Ins%, BYVAL Caps%, BYVAL Num%, BYVAL ScrollLock%)
   DECLARE SUB TInstr (St$, BYVAL ChrType%, Place%)
   DECLARE SUB XQPrint (St$, BYVAL Row%, BYVAL Column%, BYVAL VAttr%, BYVAL Page%, BYVAL Fast%)

   DECLARE SUB GetSInput00 (FillCh%, ExitMode%, BadBeep%, FullBeep%, Fast%)
   DECLARE SUB GetSInput01 (CurPosn%, FullExit%)
   DECLARE SUB GetSInput02 (Capitalize%, TabExit%)

SUB SInput (St$, SLen%, ValidTypes%, MustFill%, VAttr%, ExitCode%)
   GetSInput00 FillCh%, ExitMode%, BadBeep%, FullBeep%, Fast%
   GetSInput01 CurPosn%, FullExit%
   GetSInput02 Capitalize%, TabExit%

   ExitCode% = 0

   MaxLen% = LEN(St$)
   St$ = LEFT$(St$, SLen%)
   IF CurPosn% = 0 OR CurPosn% > MaxLen% THEN
      CurPosn% = LEN(St$) + 1
   END IF

   Row% = CSRLIN
   Col% = POS(0)
   GetVidMode BIOSMode%, ScreenWidth%, Page%
   GetKbd Ins%, Caps%, Num%, ScrollLock%
   CursorInfo OldVisible%, OldStart%, OldEnd%, MaxEnd%
   CEnd% = MaxEnd%
   CStart% = MaxEnd% - 1 + Ins% * 2

   DO
      XQPrint St$, Row%, Col%, VAttr%, Page%, Fast%
      XQPrint STRING$(MaxLen% - LEN(St$), FillCh%), Row%, Col% + LEN(St$), VAttr%, Page%, Fast%
      LOCATE Row%, Col% + CurPosn% - 1, -(CurPosn% <= MaxLen%), CStart%, CEnd%
      DO
         ky$ = INKEY$
      LOOP UNTIL LEN(ky$)
      IF CtrlQ% THEN
         GOSUB ComboKeys
      ELSEIF LEN(ky$) = 2 THEN
         GOSUB ExtendedKeys
      ELSEIF ky$ < " " THEN
         GOSUB ControlKeys
      ELSE
         GOSUB NormalKeys
      END IF
   LOOP UNTIL ExitCode%

   XQPrint SPACE$(MaxLen% - LEN(St$)), Row%, Col% + LEN(St$), VAttr%, Page%, Fast%
   LOCATE Row%, Col%, OldVisible%, OldStart%, OldEnd%
   SLen% = LEN(St$)
   St$ = St$ + SPACE$(MaxLen% - SLen%)
   EXIT SUB

' ------------ subroutines ----------------------------------------------------

ControlKeys:
   SELECT CASE ASC(ky$)
      CASE 1   ' ctrl A
         IF CurPosn% <= MaxLen% THEN tmp% = CurPosn% ELSE tmp% = MaxLen%
         IF tmp% > 1 THEN
            DO
               tmp% = tmp% - 1
            LOOP UNTIL MID$(St$, tmp%, 1) <> " " OR tmp% = 1
         END IF
         DO UNTIL MID$(St$, tmp%, 1) = " " OR tmp% = 1
            tmp% = tmp% - 1
         LOOP
         IF MID$(St$, tmp%, 1) = " " THEN tmp% = tmp% + 1
         CurPosn% = tmp%
      CASE 3   ' ctrl C
         IF ExitMode% THEN ExitCode% = -81
      CASE 4   ' ctrl D
         IF CurPosn% <= MaxLen% THEN CurPosn% = CurPosn% + 1
      CASE 6   ' ctrl F
         IF CurPosn% <= MaxLen% THEN tmp% = CurPosn% ELSE tmp% = MaxLen%
         DO UNTIL MID$(St$, tmp%, 1) = " " OR tmp% >= LEN(St$)
            tmp% = tmp% + 1
         LOOP
         IF MID$(St$, tmp%, 1) <> " " AND tmp% < LEN(St$) THEN tmp% = tmp% + 1
         DO UNTIL MID$(St$, tmp%, 1) <> " "
            tmp% = tmp% + 1
         LOOP
         IF MID$(St$, tmp%, 1) = " " THEN tmp% = tmp% - 1
         CurPosn% = tmp%
      CASE 7   ' ctrl G
         IF CurPosn% <= LEN(St$) THEN
            St$ = LEFT$(St$, CurPosn% - 1) + MID$(St$, CurPosn% + 1)
         END IF
      CASE 8   ' ctrl H (backspace)
         IF CurPosn% > 1 THEN
            CurPosn% = CurPosn% - 1
            IF CurPosn% <= LEN(St$) THEN
               St$ = LEFT$(St$, CurPosn% - 1) + MID$(St$, CurPosn% + 1)
            END IF
         END IF
      CASE 9   ' ctrl I (tab)
         IF TabExit% AND NOT MustFill% THEN ExitCode% = 9
      CASE 13  ' ctrl M (return)
         IF MustFill% AND (LEN(St$) = MaxLen%) OR NOT MustFill% THEN ExitCode% = 13
      CASE 17  ' ctrl Q
         CtrlQ% = -1
      CASE 18  ' ctrl R
         IF ExitMode% THEN ExitCode% = -73
      CASE 19  ' ctrl S
         IF CurPosn% > 1 THEN CurPosn% = CurPosn% - 1
      CASE 20  ' ctrl T
         IF CurPosn% <= LEN(St$) THEN
            IF MID$(St$, CurPosn%, 1) = " " THEN
               DO WHILE MID$(St$, CurPosn%, 1) = " "
                  St$ = LEFT$(St$, CurPosn% - 1) + MID$(St$, CurPosn% + 1)
               LOOP
            ELSE
               DO UNTIL MID$(St$, CurPosn%, 1) = " " OR CurPosn% > LEN(St$)
                  St$ = LEFT$(St$, CurPosn% - 1) + MID$(St$, CurPosn% + 1)
               LOOP
            END IF
         END IF
      CASE 22  ' ctrl V
         GetKbd Ins%, Caps%, Num%, ScrollLock%
         Ins% = NOT Ins%
         SetKbd Ins%, Caps%, Num%, ScrollLock%
         CStart% = MaxEnd% - 1 + Ins% * 2
      CASE 27  ' ctrl [ (esc)
         IF NOT MustFill% THEN ExitCode% = 27
      CASE ELSE
   END SELECT
   RETURN

ComboKeys:
   CtrlQ% = 0
   SELECT CASE ASC(UCASE$(ky$))
      CASE 3, 67    ' ctrl C, C
         IF ExitMode% THEN ExitCode% = -118
      CASE 4, 68    ' ctrl D, D
         CurPosn% = LEN(St$) + 1
      CASE 18, 82   ' ctrl R, R
         IF ExitMode% THEN ExitCode% = -132
      CASE 19, 83   ' ctrl S, S
         CurPosn% = 1
      CASE 25, 89   ' ctrl Y, Y
         IF CurPosn% <= LEN(St$) THEN St$ = LEFT$(St$, CurPosn% - 1)
      CASE ELSE
   END SELECT
   RETURN

ExtendedKeys:
   CtrlQ% = 0
   SELECT CASE ASC(RIGHT$(ky$, 1))
      CASE 82   ' insert
         GetKbd Ins%, Caps%, Num%, ScrollLock%
         CStart% = MaxEnd% - 1 + Ins% * 2
      CASE 83   ' delete
         IF CurPosn% <= LEN(St$) THEN
            St$ = LEFT$(St$, CurPosn% - 1) + MID$(St$, CurPosn% + 1)
         END IF
      CASE 75   ' left arrow
         IF CurPosn% > 1 THEN CurPosn% = CurPosn% - 1
      CASE 77   ' right arrow
         IF CurPosn% <= MaxLen% THEN CurPosn% = CurPosn% + 1
      CASE 71   ' home
         CurPosn% = 1
      CASE 79   ' end
         CurPosn% = LEN(St$) + 1
      CASE 115  ' ctrl left arrow
         IF CurPosn% <= MaxLen% THEN tmp% = CurPosn% ELSE tmp% = MaxLen%
         IF tmp% > 1 THEN
            DO
               tmp% = tmp% - 1
            LOOP UNTIL MID$(St$, tmp%, 1) <> " " OR tmp% = 1
         END IF
         DO UNTIL MID$(St$, tmp%, 1) = " " OR tmp% = 1
            tmp% = tmp% - 1
         LOOP
         IF MID$(St$, tmp%, 1) = " " THEN tmp% = tmp% + 1
         CurPosn% = tmp%
      CASE 116  ' ctrl right arrow
         IF CurPosn% <= MaxLen% THEN tmp% = CurPosn% ELSE tmp% = MaxLen%
         DO UNTIL MID$(St$, tmp%, 1) = " " OR tmp% >= LEN(St$)
            tmp% = tmp% + 1
         LOOP
         IF MID$(St$, tmp%, 1) <> " " AND tmp% < LEN(St$) THEN tmp% = tmp% + 1
         DO UNTIL MID$(St$, tmp%, 1) <> " "
            tmp% = tmp% + 1
         LOOP
         IF MID$(St$, tmp%, 1) = " " THEN tmp% = tmp% - 1
         CurPosn% = tmp%
      CASE 117  ' ctrl end
         IF CurPosn% <= LEN(St$) THEN St$ = LEFT$(St$, CurPosn% - 1)
      CASE ELSE
         IF ExitMode% THEN ExitCode% = -ASC(RIGHT$(ky$, 1))
   END SELECT
   RETURN

NormalKeys:
   IF LEN(St$) = MaxLen% AND (Ins% OR NOT Ins% AND CurPosn% > MaxLen%) THEN
      IF FullBeep% THEN BEEP
      RETURN
   END IF
   TInstr ky$, ValidTypes%, Found%
   IF Found% = 0 OR CurPosn% > MaxLen% THEN
      IF BadBeep% THEN BEEP
      RETURN
   END IF
   IF Capitalize% THEN ky$ = UCASE$(ky$)
   IF CurPosn% > LEN(St$) THEN
      St$ = St$ + SPACE$(CurPosn% - LEN(St$) - 1) + ky$
   ELSEIF Ins% THEN
      St$ = LEFT$(St$, CurPosn% - 1) + ky$ + MID$(St$, CurPosn%)
   ELSE
      MID$(St$, CurPosn%, 1) = ky$
   END IF
   CurPosn% = CurPosn% + 1
   IF (LEN(St$) = MaxLen%) AND FullExit% THEN ExitCode% = 13
   RETURN
END SUB
