LISTING 6 - Bits Object Interface
/* bits.h:    Large bit sets */

#ifndef BITS_H
#define BITS_H

#include <stdio.h>

typedef struct bits Bits;

Bits * bits_create(size_t nbits);
unsigned bits_to_uint(Bits *);
Bits * bits_from_uint(Bits *, unsigned);
Bits * bits_set(Bits *, size_t bit);
Bits * bits_set_all(Bits *);
Bits * bits_reset(Bits *, size_t bit);
Bits * bits_reset_all(Bits *);
Bits * bits_toggle(Bits *, size_t bit);
Bits * bits_toggle_all(Bits *);
int bits_test(Bits *, size_t bit);
int bits_any(Bits *);
size_t bits_count(Bits *);
Bits * bits_put(Bits *, FILE *);
Bits * bits_get(Bits *, FILE *);
void bits_destroy(Bits *);

#endif
