EXAMPLE ONE:

#include <iostream.h>
#include <math.h>
#include <stdlib.h>

class fuzzy
{
    private:
        double  truth;
    public:
        inline fuzzy(const double);
        void get(double *);
        double get(void) const;
        fuzzy operator!(void) const;
        fuzzy very(void) const;
        fuzzy somewhat(void) const;
        inline fuzzy& operator|=(fuzzy&);
        inline fuzzy& operator&=(fuzzy&);
        fuzzy& operator=(const fuzzy&);
        fuzzy& operator=(const double);
        friend fuzzy operator|(const fuzzy&, 
                               const fuzzy&);
        friend fuzzy operator&(const fuzzy&,
                               const fuzzy&);
        friend fuzzy fuzzy_implies(const fuzzy&,
                                   const fuzzy&);
        friend fuzzy fuzzy_iff(const fuzzy&,
                               const fuzzy&);
        friend inline int operator<(const fuzzy&,
                                    const fuzzy&);
        friend inline int operator<=(const fuzzy&,
                                     const fuzzy&);
        friend inline int operator==(const fuzzy&,
                                     const fuzzy&);
        friend inline int operator>=(const fuzzy&,
                                     const fuzzy&);
        friend inline int operator>(const fuzzy&,
                                    const fuzzy&);
        friend inline int operator!=(const fuzzy&,
                                     const fuzzy&);
        friend ostream& operator<<(ostream& s, 
                                   const fuzzy& z);
};

inline fuzzy::fuzzy(const double temp_truth = 0.0)
{
    truth = ((temp_truth >= 0.0) 
          && (temp_truth <= 1.0)) ?
              temp_truth : 0.0;
    return;
}

void fuzzy::get(double *get_truth)
{
    *get_truth = truth;
    return;
}

double fuzzy::get(void) const
{
    return truth;
}

fuzzy fuzzy::operator!(void) const
{
    return (1.0 - truth);
}

fuzzy fuzzy::very(void) const
{
    return (truth * truth);
}

fuzzy fuzzy::somewhat(void) const
{
    return sqrt(truth);
}

inline fuzzy& fuzzy::operator|=(fuzzy& value)
{
    return (*this = *this | value);
}

inline fuzzy& fuzzy::operator&=(fuzzy& value)
{
    return (*this = *this & value);
}

fuzzy& fuzzy::operator=(const fuzzy& fuzzy_in)
{
    truth = fuzzy_in.truth;
    return *this;
}

fuzzy& fuzzy::operator=(const double dbl_in)
{
    truth = ((dbl_in >= 0.0) && (dbl_in <= 1.0)) ?
              dbl_in : 0.0;
    return *this;
}

fuzzy operator|(const fuzzy& value_a, const fuzzy& value_b)
{
    return (value_a.truth > value_b.truth) ?
            value_a : value_b;
}

fuzzy operator&(const fuzzy &value_a, 
                const fuzzy &value_b)
{
    return (value_a < value_b) ? value_a : value_b;
}

fuzzy fuzzy_implies(const fuzzy& value_a, 
                    const fuzzy& value_b)
{
    auto double temp_value;
    
    temp_value = 1.0 - value_a.truth + value_b.truth;
    return ((temp_value < 1.0) ? temp_value : 1.0);
}

fuzzy fuzzy_iff(const fuzzy& value_a, 
                const fuzzy& value_b)
{
    return 1.0 - fabs(value_a.truth - value_b.truth);
}

inline int operator<(const fuzzy& value_a, 
                     const fuzzy& value_b)
{
    return (value_a.truth < value_b.truth);
}

inline int operator<=(const fuzzy& value_a, 
                      const fuzzy& value_b)
{
    return (value_a.truth <= value_b.truth);
}

inline int operator==(const fuzzy& value_a,
                      const fuzzy& value_b)
{
    return (value_a.truth == value_b.truth);
}

inline int operator>=(const fuzzy& value_a,
                      const fuzzy& value_b)
{
    return (value_a.truth >= value_b.truth);
}

inline int operator>(const fuzzy& value_a,
                     const fuzzy& value_b)
{
    return (value_a.truth > value_b.truth);
}

inline int operator!=(const fuzzy& value_a,
                      const fuzzy& value_b)
{
    return (value_a.truth != value_b.truth);
}

ostream& operator<<(ostream& s, const fuzzy& z)
{
    return s << z.truth;
}

istream& operator>>(istream& s, fuzzy& fur)
{
    auto double lint = 0.0;
    
    s >> lint;
    fur = lint;

    return s;
}

