//
// String class with overloaded cat function
//

#include <iostream.h>
#include <string.h>

class String
    {
public:
    String(const char *);
    String(const String &);
    ~String()
        { delete [] str; }
    String &operator=(const String &);
    String &operator+=(const String &);
    size_t length()
        { return len; }
    operator const char *()
        { return str; }
    char &operator[](size_t i)
        { return str[i]; }
    // ...
private:
    size_t len;
    char *str;
    };

String::(const char *s)
    {
    len = strlen(s);
    str = strcpy(new char[len + 1], s);
    }

String::String(const String &s)
    {
    len = s.len;
    str = strcpy(new char[len + 1], s.str);
    }

String &String::operator=(const String &s)
    {
    if (len != s.len)
        {
        char *p = new char[s.len + 1];
        strcpy(p, s.str);
        delete [] str;
        len = s.len;
        str = p;
        }
    return *this;
    }

String &String::operator+=(const String &s)
    {
    if (s.len > 0)
        {
        char *p = new char[len + s.len + 1];
        strcat(strcpy(p, str), s.str);

        delete [] str;
        len += s.len + 1;
        str = p;
        }
    return *this;
    }

String operator+(const String &s1, const String &s2)
    {
    String s = s1;
    return s += s2;
    }
