/*
listing 3
vds.c - VDS interface functions
Written by Robert Watson
(C) Copyright Robert Watson 1993
*/

#include <dos.h>

#include "vds.h"

/* IsVDSAvailable - Returns non-zero if VDS services
   are available */

int IsVDSAvailable (void) {
   return (0x20 & *((char *)MK_FP(0x40,0x7B)));
}

/* RequestVDSBuffer - Request the DMA buffer
   maintained by VDS services */

int RequestVDSBuffer (VDS_DDS * DDS) {
   struct REGPACK regs;

   regs.r_ax = 0x8107;
   regs.r_dx = 0;
   regs.r_es = FP_SEG (DDS);
   regs.r_di = FP_OFF (DDS);
   intr (0x4B, &regs);
   if (regs.r_flags & 1) return (regs.r_ax);
   return (0);
}

/* ReleaseVDSBuffer - Release a buffer allocated
   by RequestVDSBuffer */

int ReleaseVDSBuffer (VDS_DDS * DDS) {
   struct REGPACK regs;

   regs.r_ax = 0x8108;
   regs.r_dx = 0;
   regs.r_es = FP_SEG (DDS);
   regs.r_di = FP_OFF (DDS);
   intr (0x4B, &regs);
   if (regs.r_flags & 1) return (regs.r_ax);
   return (0);
}

/* DisableVDSTranslation - Disable automatic
   address translation on a DMA channel. */

int DisableVDSTranslation (int Channel) {
   struct REGPACK regs;

   regs.r_ax = 0x810B;
   regs.r_bx = Channel;
   regs.r_dx = 0;
   intr (0x4B, &regs);
   if (regs.r_flags & 1) return (regs.r_ax);
   return (0);
}

/* Enable automatic translation that was disabled
   by DisableVDSTranslation. */

int EnableVDSTranslation (int Channel) {
   struct REGPACK regs;

   regs.r_ax = 0x810C;
   regs.r_bx = Channel;
   regs.r_dx = 0;
   intr (0x4B, &regs);
   if (regs.r_flags & 1) return (regs.r_ax);
   return (0);
}

/* CopyFromDMABuffer - Copy data from a DMA buffer
   to a malloc'd buffer */

int CopyFromDMABuffer (VDS_DDS * DDS,
                       long BufferOffset) {
    struct REGPACK regs;

    regs.r_ax = 0x810A;
    regs.r_dx = 0;
    regs.r_es = FP_SEG (DDS);
    regs.r_di = FP_OFF (DDS);
    regs.r_bx = BufferOffset >> 16;
    regs.r_cx = BufferOffset;
    intr (0x4B, &regs);
    if (regs.r_flags & 1) return (regs.r_ax);
    return (0);
}
