//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  TIME (ANSI and POSIX)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#ifndef __TIME_H_INCLUDED

#define CLOCKS_PER_SEC  1000        /* Clock ticks in 1 second  */

#define NULL    _NULL

#if _POSIX1_SOURCE == 1
#define CLK_TCK     CLOCKS_PER_SEC  /* Archaism in first draft POSIX.1 */
#endif

#ifndef _TIME_T_DEFINED
typedef _Time_t time_t;
#define _TIME_T_DEFINED
#endif

#ifndef _CLOCK_T_DEFINED
typedef _Clock_t clock_t;
#define _CLOCK_T_DEFINED
#endif

#ifndef _SIZE_T_DEFINED
typedef _Size_t size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _STRUCT_TM_DEFINED
struct tm {
    int tm_sec;     // seconds after the minute - [0,61]
    int tm_min;     // minutes after the hour   - [0,59]
    int tm_hour;    // hours of the day         - [0,23]
    int tm_mday;    // day of the month         - [1,31]
    int tm_mon;     // months of the year       - [0,11]
    int tm_year;    // years since 1900
    int tm_wday;    // days since Sunday        - [0,6]
    int tm_yday;    // days since January 1     - [0,365]
    int tm_isdst;   // daylight savings time flag
};
#define _STRUCT_TM_DEFINED
#endif

extern "C" {

char *  _CDECL  asctime     (const struct tm *);
clock_t _CDECL  clock       (void);
char *  _CDECL  ctime       (const time_t *);
double  _CDECL  difftime    (time_t, time_t);
struct tm * _CDECL  gmtime  (const time_t *);
struct tm * _CDECL  localtime   (const time_t *);
time_t  _CDECL  mktime      (struct tm *);
size_t  _CDECL  strftime    (char *, size_t, const char *, const struct tm *);
time_t  _CDECL  time        (time_t *);

#if _POSIX1_SOURCE > 0
void    _CDECL  tzset       (void);

extern int _CDECL       daylight;   // non-zero if DST is used
extern long _CDECL      timezone;   // seconds west of GMT
extern char * _CDECL    _TZname[2]; // standard/daylight savings names
#endif

#if _MSDOS_SOURCE > 0
char *  _CDECL  _strdate    (char *);
char *  _CDECL  _strtime    (char *);
#endif

}

#if _POSIX1_SOURCE > 0
#define tzname _TZname
#endif

#define __TIME_H_INCLUDED
#endif

