Program FastTTT5_Demo_3;
uses CRT, FastTTT5;

var
   Ch : char;

Procedure Intro_Screen;
begin
    TextBackground(Black);
    Textcolor(white);
    Clrscr;
    Box(20,1,60,5,yellow,black,2);
    Box(3,7,78,25,15,1,1);
    ClearText(4,8,77,24,white,blue);
    VertLine(33,8,10,white,blue,1);
    VertLine(47,8,10,white,blue,1);
    HorizLine(5,75,11,white,blue,2);
    WriteAT(74,1,white,black,'V 5.0');
    WriteCenter(2,green,black,'TECHNOJOCK''S');
    WriteCenter(3,green,black,'TURBO');
    WriteCenter(4,green,black,'TOOLKIT');
    WriteVert(1,16,lightgray,black,'Technojock');
    WriteVert(80,16,lightgray,black,'Technojock');
    WriteBetween(33,47,8,white,blue,'Procedures');
    WriteBetween(33,47,9,white,blue,'&');
    WriteBetween(33,47,10,white,blue,'Functions');
    WriteAT(9,12,yellow,blue,'This is a demonstration of some of the procedures and functions');
    WriteAT(9,13,yellow,blue,'contained in the unit FastTTT5.TPU. The screen is updated very');
    WriteAT(9,14,yellow,blue,'quickly using an inline procedure.');
    WriteAT(9,16,yellow,blue,'The procedures in FastTTT5.TPU include box and line drawing,');
    WriteAT(9,17,yellow,blue,'text centering on the screen or between two X coordinates,');
    WriteAT(9,18,yellow,blue,'vertical text writing and much more.');
    WriteAT(9,20,lightcyan,blue,'Other utilities in the TTT series include window management, screen');
    WriteAT(9,21,lightcyan,blue,'management, fullscreen input routines, pulldown menus, directory');
    WriteAT(9,22,lightcyan,blue,'listers, string handling, full mouse support and much much more!');
end;

Procedure Animate;      {the following procedure was written by Pete Knarr}
                        {to demo the animation posibilities using TTT}
  Var
    Ip:Char;

  Procedure Curtain;
     Var
       Total,Cnt,I,J:Integer;
       Count,Line1,Line2:String;
    Begin
      WriteAT(1,1,0,0,'  ');GotoXY(1,2);
      Port[$3D9]:=1;
      TextBackGround(1);ClrScr;
      Box(20,7,62,19,14,4,2);
      Window(21,8,61,18);TextBackGround(4);ClrScr;
      WriteVert(41,8,12,0,'');
      TextColor(15);
      GotoXY(4,3);Write('Press Any Key ...');
      GotoXY(4,5);Write('To see Pete');
      GotoXY(4,6);Write('Knarr''s superb');
      GotoXY(4,7);Write('demo built with');
      GotoXY(4,8);Write('the Toolkit.');
      Window(1,1,80,25);
      WriteAT(1,1,1,1,'  ');
      GotoXY(2,1);
      Repeat Ip:=ReadKey Until Ip<>'';
      TextBackGround(0);
      For I:=1 to 9 Do
        Begin
          Sound(I*100);
          Window(41-I*2,8,41+2*I,18);
          ClrScr;
          WriteAT(42-I*2,12,0,0,'  ');GotoXY(3,5);
          Delay(20)
       End;
      WriteVert(22,8,12,0,'');
      WriteVert(60,8,12,0,'');
      Delay(50);
      NoSound;
      Window(1,1,80,25);
      Line1:='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      WriteAT(1,1,1,1,'  ');GotoXY(2,1);
      J:=8;
      Cnt:=0;
      Total:=0;
      For I:=8 to 36 Do
        Begin
          If I<11 Then
            Begin
              WriteAT(23,8,14,0,Line1[I-7]);
              Sound(100);
              Delay(10);
              NoSound;
              Delay(70);
              Case I of
                 9:WriteAT(23,9,14,0,Line1[I-8]);
                10:Begin
                     WriteAT(23,9,14,0,Line1[I-8]);
                     WriteAT(23,10,14,0,Line1[I-9])
                   End
              End
           End
         Else
           Begin
             If I>Length(Line1)+7 Then
               Begin
                 If J<12 Then
                   WriteAT(23,J,14,0,' ');
                 J:=J+1
               End
             Else
               Begin
                 WriteAT(23,8,14,0,Line1[I-8]);
                 WriteAT(23,9,14,0,Line1[I-9]);
                 WriteAT(23,10,14,0,Line1[I-10])
               End;
             WriteAT(13+I,10,14,0,Line1[I-10]);
             Sound(100);
             Delay(10);
             NoSound;
             Delay(70);
             If I<20 Then
               WriteAT(13+I,10,14,0,Line1[I-10]);
             Cnt:=Cnt+1;
             Total:=Total+1;
           End;
          Str(Cnt:2,Count);
          WriteAT(56,10,15,0,Count);
          Str(Total:2,Count);
          WriteAT(56,14,15,0,Count)
        End;
      Line2:=Line1;
      For I:=23 to 27 Do
        Begin
          Line2:=' '+Line2;
          WriteAT(23,10,14,0,Line2);
          Sound(1354);
          Delay(10);
          NoSound;
          Delay(20)
        End;
      J:=8;
      Cnt:=0;
      For I:=8 to 36 Do
        Begin
          If I<13 Then
            Begin
              WriteAT(23,8,14,0,Line1[I-7]);
              Sound(100);
              Delay(10);
              NoSound;
              Delay(70);
              Case I of
                 9:WriteAT(23,9,14,0,Line1[I-8]);
                10:Begin
                     WriteAT(23,9,14,0,Line1[I-8]);
                     WriteAT(23,10,14,0,Line1[I-9])
                   End;
                11:Begin
                     WriteAT(23,9,14,0,Line1[I-8]);
                     WriteAT(23,10,14,0,Line1[I-9]);
                     WriteAT(23,11,14,0,Line1[I-10])
                   End;
                12:Begin
                     WriteAT(23,9,14,0,Line1[I-8]);
                     WriteAT(23,10,14,0,Line1[I-9]);
                     WriteAT(23,11,14,0,Line1[I-10]);
                     WriteAT(23,12,14,0,Line1[I-11])
                   End
              End
            End
          Else
            Begin
              If I>Length(Line1)+6 Then
                Begin
                  If J<15 Then
                    WriteAT(23,J,14,0,' ');
                  J:=J+1
                End
              Else
                Begin
                  WriteAT(23,8,14,0,Line1[I-8]);
                  WriteAT(23,9,14,0,Line1[I-9]);
                  WriteAT(23,10,14,0,Line1[I-10]);
                  WriteAT(23,11,14,0,Line1[I-11]);
                  WriteAT(23,12,14,0,Line1[I-12])
                End;
              WriteAT(11+I,12,14,0,Line1[I-12]);
              Sound(100);
              Delay(10);
              NoSound;
              Delay(70);
              If I<20 Then
              WriteAT(11+I,12,14,0,Line1[I-12])
            End;
          Str(Cnt:2,Count);
          WriteAT(56,12,15,0,Count);
          Str(Total:2,Count);
          WriteAT(56,14,15,0,Count);
          If I>9 Then
            Begin
              Cnt:=Cnt+1;
              Total:=Total+1
            End
        End;
      Line2:=Line1;
      For I:=23 to 27 Do
        Begin
          Line2:=' '+Line2;
          WriteAT(23,12,14,0,Line2);
          Sound(677);
          Delay(10);
          NoSound;
          Delay(20)
        End;
      WriteAT(28,14,15,0,'Two Alphabets Exactly Equal');
      WriteCenter(16,12,0,'AMAZING !!');
      WriteCenter(22,0,7,' Press Any Key to Partly Close ');
      Repeat Ip:=ReadKey Until Ip<>'';
      For I:=9 DownTo 1 Do
        Begin
          Sound(I*110);
          WriteVert(41-I*2,8,15,5,'           ');
          WriteVert(41+2*I,8,15,5,'           ');
          Delay(10)
        End;
      Sound(2500);Delay(30);
      WriteVert(41,8,13,0,'');
      Window(1,1,80,25);
      WriteAT(1,1,1,1,'  ');
      GotoXY(2,1);
      NoSound;
      WriteCenter(22,0,7,' Press Any Key to Completely Close ');
      Repeat Ip:=ReadKey Until Ip<>'';
      WriteCenter(22,1,1,'                                   ');
      For I:=19 DownTo 1 Do
        Begin
          If I>9 Then
            Sound(I*150)
          Else
            Sound(2000-I*200);
          If I=10 Then
            Begin
              WriteVert(31,8,12,0,'');
              WriteVert(51,8,12,0,'');
              WriteAT(41,15,14,0,Chr(2));
              WriteAT(36,16,14,0,
Chr(192)+Chr(196)+Chr(196)+Chr(196)+Chr(196)+Chr(197)+Chr(196)+Chr(196)+Chr(196)+Chr(196)+Chr(217));
              WriteAT(41,17,14,0,Chr(179));
              WriteAT(40,18,14,0,'/ \');
              Delay(100);
              Sound(I*200);
              Delay(250);
              Sound(I*150);
              Delay(400)
            End
          Else If I>10 Then Delay(20);
          WriteVert(41-I,8,15,4,'           ');
          WriteVert(41+I,8,15,4,'           ')
        End;
      Sound(3000);Delay(30);
      WriteVert(41,8,12,0,'');
      WriteAT(24,13,15,4,'And Finished !');
      WriteAT(45,13,15,4,'Press  Any Key');
      Line1:='';
      WriteAT(24,14,7,4,Line1);
      WriteAT(45,14,7,4,Line1);
      Box(20,7,62,19,7,4,2);
      WriteAT(41,16,14,4,Chr(2));
      NoSound;
      For I:=0 to 4 Do
        Begin
          WriteAT(65+I*2,20+I,15,1,Chr(220));
          WriteAT(17-I*2,20+I,15,1,Chr(220));
          WriteAT(17-I*2,6-I,15,1,Chr(223));
          WriteAT(65+I*2,6-I,15,1,Chr(223));
          WriteAT(41,6-I,15,1,Chr(223));
          WriteAT(41,20+I,15,1,Chr(220));
          WriteAT(17-I*2,13,15,1,Chr(223));
          WriteAT(65+I*2,13,15,1,Chr(223))
        End;
      WriteAT(7,13,15,1,Chr(223));
      WriteAT(75,13,15,1,Chr(223));
      WriteAT(3,2,1,1,'  ');GotoXY(4,2);
      Box(1,1,80,25,14,4,2);
      Line1:=Replicate(23,Chr(219));
      WriteVert(2,2,4,4,Line1);
      WriteVert(79,2,4,4,Line1);
      Line1:=Replicate(23,Chr(178));
      WriteVert(3,2,0,7,Line1);
      WriteVert(78,2,0,7,Line1);
      WriteCenter(1,0,7,' The Wonders of TTT from TechnoJock''s Turbo Toolkit 5.0 ');
      WriteCenter(2,15,1,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
      WriteCenter(25,0,7,' By TechnoJock Software, Inc.  (c) 1986, 1989');
      WriteCenter(24,15,1,'________________________________________');
      Repeat Ip:=ReadKey Until Ip<>'';
      Window(1,1,80,25);
      J:=1;
      I:=1;
      TextBackGround(0);
      While I<40 Do
        Begin
          Window(40-I,13-J,40+I,13+J);
          ClrScr;
          Inc(I,4);
          Inc(J,1);
          Sound(I*70);
          Delay(10);
          NoSound;
          Delay(65)
        End;
      Window(1,2,80,25);
      Port[$3D9]:=0;TextBackGround(0);ClrScr;
      Window(1,1,80,25);
      WriteAT(1,1,14,4,Chr(205));
      WriteAT(80,1,14,4,Chr(205));
      WriteCenter(2,15,0,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
      GotoXY(1,3)
    End;

  Begin       {procedure animate}
    ClrScr;
    Curtain
  End;   {animate}

begin
    Intro_Screen;
    WriteCenter(24,white+blink,blue,'Press any key to continue');
    Ch := readkey;
    Animate;
    WriteAT(1,24,white,black,'Run DemoTTT.exe for the main demo program');
    WriteAT(1,25,white,black,'TechnoJock''s Turbo Toolkit v5.0');
    Ch := Readkey;
    ClrScr;
end.

