{$R-}
Program IOTTT5_Demo_2;

{IMPORTANT NOTE: Set Options Compile Conditional Defines to IOFull and
                 select Compile Build.
}

{$V-}   {turn of that damn string checking!!}

Uses CRT,FastTTT5,IOTTT5;
Const
      X1 = 5;      {main coordinates - make them constants so they can }
      Y1 = 5;      {be easily modified if the screen doesn't look right}
      X2 = 75;
      Y2 = 17;

Type
    Company_Record = Record
                          Name : string[40];
                          Title: string[40];
                          Company: string[40];
                          Addr1  : string[40];
                          Addr2  : string[40];
                          City   : string[40];
                          State  : string[2];
                          Zip    : string[9];
                     end;
var
   BoxF : byte;    {box foreground color}
   Misc : byte;    {Misc. text foreground color}
   Back : byte;    {main background color}
   MsgF : byte;    {message foreground color}
   MsgB : byte;    {message background color}
   HiF  : byte;    {highlighted field foreground color}
   HiB  : byte;    {highlighted field background color}
   LoF  : byte;    {normal field foreground color}
   LoB  : byte;    {normal field background color}
   Info : Company_Record;


 Procedure Set_Colors;
 {}
 begin
     If ColorScreen then
     begin
         BoxF := yellow;
         Misc := LightCyan;
         Back := blue;
         MsgF := yellow;
         MsgB := red;
         HiF  := white;
         HiB  := red;
         LoF  := white;
         LoB  := Cyan;
     end
     else
     begin
         BoxF := white;
         Misc := Lightgray;
         Back := black;
         MsgF := black;
         MsgB := lightgray;
         HiF  := black;
         HiB  := lightgray;
         LoF  := white;
         LoB  := black;
     end;
 end; {of proc Set_Colors}

 Procedure Paint_Screen;
 {Clears the screen and writes all the peripheral text to the screen}
 begin
     Set_Colors;
     ClrScr;                         {clear the screen}
     FBox(X1,Y1,X2,Y2,BoxF,Back,2);    {draw a filled box}
     FastTTT5.Fcol := Misc;          {set default write colors}
     FastTTT5.Bcol := Back;
     ColWrite(X1+5,Y1+2,'Name');
     ColWrite(X1+5,Y1+3,'Title');
     ColWrite(X1+5,Y1+4,'Company');
     ColWrite(X1+5,Y1+5,'Address');
     ColWrite(X1+5,Y1+7,'City');
     ColWrite(X1+38,Y1+7,'State');
     ColWrite(X1+50,Y1+7,'Zip');
     ColWrite(X1+12,Y1+11,'Enter data and press F10 to complete input');
 end; {of proc Paint_Screen}

  Procedure Write_Info;
  {}
  var CH : char;
  begin
      Clrscr;
      If I_Char = #027 then
         Writeln('You Escaped!!');
      Writeln('Your input was:');
      Writeln(Info.Name);
      Writeln(Info.Title);
      Writeln(Info.Company);
      Writeln(Info.Addr1);
      Writeln(Info.Addr2);
      Writeln(Info.City);
      Writeln(Info.State);
      Writeln(Info.Zip);
      WriteLN;
      Writeln('press any key');
      Ch := readkey;
  end; {of proc Write_Info}



begin    {Main program}
    Paint_Screen;
    Fillchar(Info,sizeOf(Info),#0);            {clear the variable Info}
    Create_Tables(1);                          {we will only be having 1 simultaneous update}
    Create_Fields(8);                          {create 8 input fields}
    Define_Colors(HiF,Hib,LoF,LoB,MsgF,MsgB);  {tell IO what colors to use}
    Allow_Esc(True);                           {let the user Escape}

    Add_Field(1,   8,2,8,2,  X1+18, Y1+2);     {add field info for field 1}
    String_Field(1, Info.Name, '***********************************'); {assign variable to field and define format}

    Add_Field(2,   1,3,1,3,  X1+18, Y1+3);   {add field info for field 2}
    String_Field(2, Info.Title, '***********************************');

    Add_Field(3,   2,4,8,4,  X1+18, Y1+4);   {add field info for field 3}
    String_Field(3, Info.Company, '***********************************');

    Add_Field(4,   3,5,3,5,  X1+18, Y1+5);   {add field info for field 4}
    String_Field(4, Info.Addr1, '***********************************');

    Add_Field(5,   4,6,4,6,  X1+18, Y1+6);   {add field info for field 5}
    String_Field(5, Info.Addr2, '***********************************');

    Add_Field(6,   5,7,5,7,  X1+18, Y1+7);   {add field info for field 6}
    String_Field(6, Info.City, '********************');

    Add_Field(7,   6,8,6,8,  X1+45, Y1+7);   {add field info for field 7}
    String_Field(7, Info.State, '!!');       {Force Upper case}

    Add_Field(8,   7,1,7,1,  X1+55, Y1+7);   {add field info for field 8}
    String_Field(8, Info.Zip, '#####-####'); {Force numbers with a "-"}

    Process_Input(1);   {allow the user to input data}

    Write_Info;         {call write_info procedure above}

    Dispose_Fields;
    Dispose_Tables;
    Clrscr;
    WriteAT(1,1,white,black,'Run DemoTTT.exe for the main demo program');
    WriteAT(1,2,white,black,'TechnoJock''s Turbo Toolkit v5.0');
    GotoXY(1,5);
end.
