*:*****************************************************************************
*:
*: Procedure file: C:\SOURCE\DIAG\DIAG.PRG
*:
*:         System: System Diagnostics Tool
*:         Author: Bil Simser
*:      Copyright (c) 1993, Bil Simser
*:  Last modified: 04/27/93     13:48
*:
*:  Procs & Fncts: DIAG()
*:
*:  Generic diagnostics routine that prints out a full report
*:  for dealing with problems. This may take up a lot of paper so
*:  some sort of parameter passing would be needed to filter out
*:  unwanted reports.
*:  For use as a generic diagnostics tool in all Clipper and C programs
*:  since we use funcky we'll just add a _; to the function calls to make
*:  them C callable
*:
*:      Documented 04/27/93 at 13:55                SNAP!  version 5.02
*:*****************************************************************************
#include "funcky.ch"

*!*****************************************************************************
*!
*!       Function: DIAG()
*!
*!    Other Files: REPORT.TXT
*!               : AUTOEXEC.BAT
*!               : CONFIG.BAT
*!
*!*****************************************************************************
FUNCTION Diag( cName )

LOCAL nHandle := FCREATE( "report.txt" ), nTempHandle
LOCAL nRetVal1, nRetVal2, nRetVal3, nCount
LOCAL cString := "", aInfo[12]

// Array for reporting mice type
LOCAL aMice := { "None","Bus","Serial", ;
   "InPort","PS/2", "Hewlett Packard" }

// Array for reporting hard drive info
LOCAL aStatus := { "bytes per sector                  ",;
   "sectors per cluster               ",;
   "reserved sectors                  ",;
   "FATs (File Allocation Tables)     ",;
   "possible root directory entries   ",;
   "sectors on disk             ",;
   "is the Disk media descriptor byte                  ",;
   "sectors per FAT                   ",;
   "sectors per track                 ",;
   "heads                             ",;
   "hidden sectors                    ",;
   "Serial number                               "}

CLS
? "Clipper Diagnostics"
? "Version 1.00"
? "Copyright (c) 1993 Bil Simser"
? "All Rights Reserved"
?
? "Building System Statistics..."

Fwriteline( nHandle, PADC( " System Summary Information ", 78, "-" ) )
Fwriteline( nHandle, "" )

nRetVal1 := Cputype()

DO CASE
   
CASE nRetVal1 ==  -1
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "Unknown" )
CASE nRetVal1 ==  8086
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "8088 or 8086 microprocessor" )
CASE nRetVal1 ==  80186
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "80186 CPU" )
CASE nRetVal1 ==  80286
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "80286 CPU" )
CASE nRetVal1 ==  80386
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "80386 CPU" )
CASE nRetVal1 ==  80486
   Fwriteline( nHandle, PADL(   "Computer : ", 40 ) + "80486 CPU" )
   
ENDCASE

nRetVal1 := Dosmem()
nRetVal2 := Extmem()
nRetVal3 := Expmem()

cString := ALLTRIM( STR( nRetval1 ) ) + ;
   "K DOS, " + ;
   ALLTRIM( STR( nRetval2 ) ) + ;
   "K Ext, " + ;
   ALLTRIM( STR( nRetval3 ) ) + ;
   "K EMS"

Fwriteline( nHandle, PADL( "Memory : ", 40 ) + cString )

nRetVal1 := montype()

DO CASE
   
CASE( nRetVal1 EQ -1 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "Display combination unknown." )
   
CASE( nRetVal1 EQ 0 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "No video available." )
   
CASE( nRetVal1 EQ 1 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "MDA with monochrome monitor in use." )
   
CASE( nRetVal1 EQ 2 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "CGA with color monitor in use." )
   
CASE( nRetVal1 EQ 4 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "EGA with color monitor in use." )
   
CASE( nRetVal1 EQ 5 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "EGA with monochrome monitor in use." )
   
CASE( nRetVal1 EQ 6 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "PGA adapter in use." )
   
CASE( nRetVal1 EQ 7 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "VGA with monochrome monitor in use." )
   
CASE( nRetVal1 EQ 8 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "VGA with color monitor in use." )
   
CASE( nRetVal1 EQ 10 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "MCGA with digital color display." )
   
CASE( nRetVal1 EQ 11 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "MCGA with analog monochrome display." )
   
CASE( nRetVal1 EQ 12 )
   Fwriteline( nHandle, PADL(   "Video : ", 40 ) + "MCGA with analog color display." )
   
ENDCASE

nRetVal1 := Dosvers()

Fwriteline( nHandle, PADL(   "OS Version : ", 40 ) + "MS-DOS Version " + ;
   ALLTRIM( STR( nRetVal1 ) ) )

nRetVal1 := m_version()
nRetVal2 := m_type()

Fwriteline( nHandle, PADL(   "Mouse : ", 40 ) + aMice[ nRetVal2 + 1 ] + ;
   IIF( nRetVal2 <> 0, ;
   " Mouse Version " + ;
   ALLTRIM( STR( nRetVal1 * .01 ) ), "" ) )

Fwriteline( nHandle, PADL(   "Disk Drives : ", 40 ) + alldrives() )

nRetVal1 := lptcount()

Fwriteline( nHandle, PADL(   "LPT Ports : ", 40 ) + ;
   ALLTRIM( STR( nRetVal1 ) ) )

nRetVal1 := comcount()

Fwriteline( nHandle, PADL(   "COM Ports : ", 40 ) + ;
   ALLTRIM( STR( nRetVal1 ) ) )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " Computer ", 78, "-" ) )
Fwriteline( nHandle, "" )

nRetVal1 := Romdate()

Fwriteline( nHandle, PADL(   "BIOS Date : ", 40 ) + nRetVal1 )

nRetVal1 := Ndptype()

DO CASE
   
CASE nRetVal1 == -1
   Fwriteline( nHandle, PADL(   "Math Coprocessor : ", 40 ) + "Unknown" )
   
CASE nRetVal1 == 0
   Fwriteline( nHandle, PADL(   "Math Coprocessor : ", 40 ) + "No math coprocessor installed" )
   
CASE nRetVal1 == 8087
   Fwriteline( nHandle, PADL(   "Math Coprocessor : ", 40 ) + "8087 NDP" )
   
CASE nRetVal1 == 80287
   Fwriteline( nHandle, PADL(   "Math Coprocessor : ", 40 ) + "80287 NDP" )
   
CASE nRetVal1 == 80387
   Fwriteline( nHandle, PADL(   "Math Coprocessor : ", 40 ) + "80387 NDP" )
   
ENDCASE

Fwriteline( nHandle, PADL(   "Keyboard : ", 40 ) + IIF( Isextended(), ;
   "Enhanced", "Standard") )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " Video ", 78, "-" ) )
Fwriteline( nHandle, "" )

nRetVal1 := Vidtype()

DO CASE
   
CASE( nRetVal1 EQ -1 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "Adapter type unknown." )
   
CASE( nRetVal1 EQ 0 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "Monochrome adapter in use." )
   
CASE( nRetVal1 EQ 1 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "CGA adapter in use." )
   
CASE( nRetVal1 EQ 2 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "EGA adapter in use." )
   
CASE( nRetVal1 EQ 3 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "VGA adapter in use." )
   
CASE( nRetVal1 EQ 4 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "MCGA adapter in use." )
   
CASE( nRetVal1 EQ 5 )
   Fwriteline( nHandle, PADL(   "Video Adapter Type : ", 40 ) + "PGA adapter in use." )
   
ENDCASE

nRetVal1 := Getmode()

Fwriteline( nHandle, PADL(   "Video Mode : ", 40 ) + ;
   ALLTRIM( STR( nRetVal1 ) ) )
Fwriteline( nHandle, PADL(   "Number of Columns : ", 40 ) + ;
   ALLTRIM( STR( lastcol() ) ) )
Fwriteline( nHandle, PADL(   "Number of Rows : ", 40 ) + ;
   ALLTRIM( STR( lastrow() ) ) )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " OS Version ", 78, "-" ) )
Fwriteline( nHandle, "" )
Fwriteline( nHandle, PADL(   "Operating System : ", 40 ) + ;
   "MS-DOS " + ;
   ALLTRIM( STR( Dosvers() ) ) )
Fwriteline( nHandle, PADL(   "Boot Drive : ", 40 ) + ;
   CHR( bootdrive() + 65 ) + ":" )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " Memory Status ", 78, "-" ) )

// Conventional Memory
Fwriteline( nHandle, "" )
Fwriteline( nHandle, PADL(   "Conventional Memory", 40 ) )
Fwriteline( nHandle, PADL( "Total : ", 40 ) + ;
   ALLTRIM( STR( Dosmem() ) ) + " K" )
Fwriteline( nHandle, PADL( "Available : ", 40 ) + ;
   ALLTRIM( STR( MEMORY(0) ) ) + " K" )

Fwriteline( nHandle, "" )
Fwriteline( nHandle, PADL( "Extended Memory (XMS)", 40 ) )
Fwriteline( nHandle, PADL( "Available : ", 40 ) + ;
   ALLTRIM( STR( Extmem() ) ) + " K" )

Fwriteline( nHandle, "" )
Fwriteline( nHandle, PADL( "Expanded Memory (EMS)", 40 ) )
Fwriteline( nHandle, PADL( "EMS Memory Manager Installed : ", 40 ) + ;
   IIF( Isems(), "Yes", "No" ) )
Fwriteline( nHandle, PADL( "Active Expanded Memory handles : ", 40 ) + ;
   ALLTRIM( STR( ems_count() ) ) )
Fwriteline( nHandle, PADL( "Total number of pages available : ", 40 ) + ;
   ALLTRIM( STR( ems_pages( 1 ) ) ) )
Fwriteline( nHandle, PADL( "Number of remaining pages available : ", 40 ) + ;
   ALLTRIM( STR( ems_pages( 0 ) ) ) )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " Environment Strings ", 78, "-" ) )
Fwriteline( nHandle, "" )

FOR nRetVal1 := 1 TO envc()
   
   Fwriteline( nHandle, env( nRetVal1 ) )
   
NEXT

Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " Disk Drives ", 78, "-" ) )
Fwriteline( nHandle, "" )
Fwriteline( nHandle, SPACE( 2 ) + "Drive" + SPACE( 2 ) + "Type" + ;
   SPACE( 34 ) + "Free Space" + SPACE( 10 ) + "Total Size" )
Fwriteline( nHandle, SPACE( 2 ) + "-----" + SPACE( 2 ) + "----" + ;
   SPACE( 34 ) + "----------" + SPACE( 10 ) + "----------" )
Fwriteline( nHandle, "" )

FOR nRetVal1 := 1 TO LEN( Drivestr() )
   
   cString := ""
   
   // Build our information for each drive
   IF UPPER(SUBSTR( Drivestr(), nRetVal1, 1 )) == "A" .OR. ;
         UPPER(SUBSTR( Drivestr(), nRetVal1, 1 )) == "B"
      
      cString += "Floppy Drive, "
      nRetVal2 := drivetype( SUBSTR( Drivestr(), nRetVal1, 1 ) )
      DO CASE
         
      CASE( nRetVal2 EQ 360 )
         cString += " 360k 5 1/4 in."
      CASE( nRetVal2 EQ 720 )
         cString += " 720k 3 1/2 in."
      CASE( nRetVal2 EQ 120 )
         cString += " 1.2m 5 1/4 in."
      CASE( nRetVal2 EQ 144 )
         cString += " 1.44m 3 1/2 in."
      CASE( nRetVal2 EQ 280 )
         cString += " 2.8m 3 1/2 in."
         
      ENDCASE
      
      Fwriteline( nHandle, SPACE( 2 ) + SUBSTR( Drivestr(), nRetVal1, 1 ) + ;
         ":" + SPACE( 5 ) + PADR( cString, 31 ) )
   ELSE
      
      cString += IIF( Getvolume( SUBSTR( Drivestr(), nRetVal1, 1 ) ) == "MS-RAMDRIVE", ;
         "RAM Drive", "Fixed " + ;
         IIF( isremote( SUBSTR( Drivestr(), nRetVal1, 1 ) ), ;
         "remote drive", ;
         "local drive" ) )
      
      Fwriteline( nHandle, SPACE( 2 ) + SUBSTR( Drivestr(), nRetVal1, 1 ) + ":" + ;
         SPACE( 5 ) + PADR( cString, 31 ) + ;
         PADL( ;
         TRANSFORM( DISKSPACE( SUBSTR( Drivestr(), nRetVal1, 1 ) ), ;
         "@Z 999,999,999" ) + " K", 20 ) + ;
         PADL( ;
         TRANSFORM( Disksize( SUBSTR( Drivestr(), nRetVal1, 1 ) ), ;
         "@Z 999,999,999" ) + " K", 20 ) )
      Fwriteline( nHandle, SPACE( 9 ) + ;
         "Volume : " + ;
         IIF( EMPTY( Getvolume( SUBSTR( Drivestr(), nRetVal1, 1 ) ) ), ;
         "No Volume Label", ;
         Getvolume( SUBSTR( Drivestr(), nRetVal1, 1 ) ) ) )
      
      diskinfo( SUBSTR( Drivestr(), nRetVal1, 1 ), @aInfo )
      
      FOR nCount := 1 TO LEN( aInfo ) - 1
         
         Fwriteline( nHandle, SPACE( 9 ) + ;
            ALLTRIM( STR( aInfo[ nCount ] ) ) + ;
            " " + ALLTRIM( aStatus[ nCount ] ) )
         
      NEXT
      
   ENDIF
   
NEXT

Fwriteline( nHandle, "" )
Fwriteline( nHandle, "LASTDRIVE=" + Lastdrive() )
IIF( phantom() == 1, Fwriteline( nHandle, "Drive A: is acting as drive B:" ), )
Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " LPT Ports ", 78, "-" ) )
Fwriteline( nHandle, "" )
Fwriteline( nHandle, SPACE( 2 ) + "Port" + SPACE( 4 ) + "Status" )
Fwriteline( nHandle, REPLICATE( "-", 60 ) )

FOR nRetVal1 := 1 TO lptcount()
   
   cString := ""
   
   IF Islpt( nRetVal1 )
      
      nRetVal2 := Prnstatus()
      
      DO CASE
         
      CASE nRetVal2 == 0
         cString += "Not busy and on line"
         
      CASE nRetVal2 == 1
         cString += "Off line or not turned on"
         
      CASE nRetVal2 == 2
         cString += "Off or not connected"
         
      CASE nRetVal2 == 3
         cString += "No paper"
         
      CASE nRetVal2 == 4
         cString += "Not connected"
         
      CASE nRetVal2 == -1
         cString += "Cannot determine status"
         
      ENDCASE
      
      Fwriteline( nHandle, SPACE( 2 ) + "LPT" + STR( nRetVal1, 1 ) + ;
         SPACE( 4 ) + cString )
      
   ENDIF
   
NEXT

Fwriteline( nHandle, "" )

Fwriteline( nHandle, PADC( " AUTOEXEC.BAT ", 78, "-" ) )
Fwriteline( nHandle, "" )

nTempHandle := FOPEN( CHR( bootdrive() + 65 ) + ":\AUTOEXEC.BAT" )

FOR nRetVal1 := 1 TO Flinecount( nTempHandle )
   
   Fwriteline( nHandle, Freadline( nTempHandle ) )
   
NEXT

FCLOSE( nTempHandle )

Fwriteline( nHandle, "" )
Fwriteline( nHandle, PADC( " CONFIG.SYS ", 78, "-" ) )
Fwriteline( nHandle, "" )

nTempHandle := FOPEN( CHR( bootdrive() + 65 ) + ":\CONFIG.BAT" )

FOR nRetVal1 := 1 TO Flinecount( nTempHandle )
   
   Fwriteline( nHandle, Freadline( nTempHandle ) )
   
NEXT

FCLOSE( nTempHandle )
FCLOSE( nHandle )

?
? "All done!"
?

RETURN(NIL)

*: EOF: DIAG.PRG
