//  Copyright (c) 1993 John Deurbrouck, Box 390, Mountlake Terrace, WA 98043
#include<windows.h>
#include"wstring.hpp"
void WinMessageString::SetDefaults(){
    arr[0]=0;
    space_left=ARRSIZE;
    is_hex=0;
    fuStyle=MB_ICONSTOP;
}
void WinMessageString::err(){
    this->show("Memory Error");
    arr[0]=0;
    space_left=ARRSIZE;
}
void WinMessageString::show(char *caption){
    DWORD ver=GetVersion();
    unsigned int winver=LOBYTE(LOWORD(ver));
    winver<<=8;
    winver|=HIBYTE(LOWORD(ver));
    if(winver>=0x30A){
        switch(fuStyle&(MB_ICONASTERISK|MB_ICONEXCLAMATION|MB_ICONHAND|MB_ICONQUESTION)){
        case MB_ICONASTERISK:    MessageBeep(MB_ICONASTERISK);    break;
        case MB_ICONEXCLAMATION: MessageBeep(MB_ICONEXCLAMATION); break;
        case MB_ICONHAND:        MessageBeep(MB_ICONHAND);        break;
        case MB_ICONQUESTION:    MessageBeep(MB_ICONQUESTION);    break;
        default:                 MessageBeep(MB_OK);              break;
        }
    }
    else MessageBeep(-1);
    MessageBox((HWND)hwndParent,arr,caption,(UINT)(fuStyle|MB_OK));
    SetDefaults();
}
WinMessageString& WinMessageString::operator<<(char __far *cp){
    if(cp==NULL)return *this;
    int len=lstrlen(cp);
    if(len<1)return *this;
    if(len>space_left)err();
    if(len<=space_left){
        lstrcpy(avail(),cp);
        space_left-=len;
    }
    return *this;
}
#ifndef __BORLANDC__
WinMessageString& WinMessageString::operator<<(char *cp){
    if(cp==NULL)return *this;
    int len=lstrlen(cp);
    if(len<1)return *this;
    if(len>space_left)err();
    if(len<=space_left){
        lstrcpy(avail(),cp);
        space_left-=len;
    }
    return *this;
}
#endif
WinMessageString& WinMessageString::operator<<(int x){
    if(space_left<6)err();
    space_left-=wsprintf(avail(),is_hex?"%04X":"%d",x);
    return *this;
}
WinMessageString& WinMessageString::operator<<(long x){
    if(space_left<11)err();
    space_left-=wsprintf(avail(),is_hex?"%08X":"%ld",x);
    return *this;
}
WinMessageString& WinMessageString::operator<<(unsigned int x){
    if(space_left<6)err();
    space_left-=wsprintf(avail(),is_hex?"%04X":"%u",x);
    return *this;
}
WinMessageString& WinMessageString::operator<<(unsigned long x){
    if(space_left<11)err();
    space_left-=wsprintf(avail(),is_hex?"%08X":"%lu",x);
    return *this;
}
