/*
    Copyright (c) 1993 John Deurbrouck, Box 390, Mountlake Terrace, WA 98043

    class WinMessageString used to accumulate data to show through MessageBox()

    SetHwndParent() sets the parent window handle for the MessageBox(). Defaults to NULL.
    SetStyle() sets style to be OR'ed with MB_OK for MessageBox(). Defaults to MB_ICONSTOP.
    show() shows accumulated data, with passed caption (defaults to "Error"), in MessageBox() call
    SetHex(0), the default state, makes integral types show in decimal. SetHex(1) shows them in hex.
    Use WinMessageString much like a iostream class, using << insertion operator. << is overloaded
        for types listed below (now char __far *,char *, int, long, unsigned int, unsigned long).

    Normal usage:
        #include"wstring.hpp"
            ...
            WinMessageString s;
            s<<"hello "<<4<<" there";
            s.show("Caption");
*/
class WinMessageString{
    enum a{ARRSIZE=1000};
    char arr[ARRSIZE+1];
    int space_left,is_hex;
    unsigned long hwndParent;
    unsigned long fuStyle;
    void SetDefaults();
    void err();
    inline char *avail(){return &arr[ARRSIZE-space_left];}
public:
    WinMessageString(){hwndParent=NULL;SetDefaults();};
    void SetHwndParent(unsigned long hw){hwndParent=hw;};
    void SetStyle(unsigned long st){fuStyle=st;};
    void show(char *caption="Error");
    void SetHex(int on_off){is_hex=on_off;};
    WinMessageString& operator<<(char __far *);
#ifndef __BORLANDC__
// Borland doesn't allow overloading based on pointer size
    WinMessageString& operator<<(char *);
#endif
    WinMessageString& operator<<(int);
    WinMessageString& operator<<(long);
    WinMessageString& operator<<(unsigned int);
    WinMessageString& operator<<(unsigned long);
};
