// chimes.cpp : Defines the class behaviors for the application.
//

#include "chimes.h"

#include "afxdlgs.h"


/////////////////////////////////////////////////////////////////////////////

// theApp:
// Just creating this application object runs the whole application.
//
CTheApp theApp;

/////////////////////////////////////////////////////////////////////////////


// CMainWindow constructor:
// Create the window with the appropriate style, size, menu, etc.
//
CMainWindow::CMainWindow()
{
	RECT r;
	
	r = rectDefault;
	r.right = r.left + 500;
	r.bottom = r.top + 500;
	
	VERIFY(LoadAccelTable( "MainAccelTable" ));
	VERIFY(Create( NULL, "MIDI Chimes",
		WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME,
		r, NULL, "MainMenu" ));
		
}

CMainWindow::~CMainWindow()
{
	delete p_dlg;
}

// OnCreate
//

int CMainWindow::OnCreate( LPCREATESTRUCT /* lpcs */)
{
	
	// Set up the dialog
	
	p_dlg = new CMyMainDialog(this);

	return 0;
}

// OnPlayStop
//

void
CMainWindow::OnPlayStop()
{
	p_dlg->playstop();
}

// OnAbout:
//

void CMainWindow::OnAbout()
{
	CModalDialog about( "AboutBox", this );
	about.DoModal();
}

// OnProgram:
//


// OnExit:
//

void CMainWindow::OnExit()
{
	p_dlg->cleanup();
	DestroyWindow();
}

void CMainWindow::OnClose()
{
	p_dlg->cleanup();
	DestroyWindow();
}

// OnOpen:
//

void CMainWindow::OnOpen()
{
}

// CMainWindow message map:
// Associate messages with member functions.
//
// It is implied that members connected with the ON_COMMAND macro
// receive no arguments and are void of return type, e.g., "void OnAbout()".
//
BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	ON_COMMAND( IDM_ABOUT, OnAbout )
	ON_COMMAND( IDM_OPEN,  OnOpen )
	ON_COMMAND( IDM_EXIT,  OnExit )
	ON_COMMAND( IDM_PLAYSTOP, OnPlayStop )
	ON_WM_CREATE()
	ON_WM_CLOSE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTheApp

// InitInstance:
// When any CTheApp object is created, this member function is automatically
// called.  Any data may be set up at this point.
//
// Also, the main window of the application should be created and shown here.
// Return TRUE if the initialization is successful.
//
BOOL CTheApp::InitInstance()
{
	m_pMainWnd = new CMainWindow();
	m_pMainWnd->ShowWindow( m_nCmdShow );
	m_pMainWnd->UpdateWindow();

	return TRUE;
}
