
#ifndef __MAIN_H__
#define __MAIN_H__

#include <afxwin.h>
#include "dcemidi.h"
#include "maindlg.h"

#define CHIMEINI	"chimes.ini"
#define CHIMEVER	"chimes1.1"

/////////////////////////////////////////////////////////////////////////////

// CMyMainDialog

class CMyMainDialog : public CDialog
{
public:
	
	CMyMainDialog(CWnd *);
		
	afx_msg void OnCancel() {
		DestroyWindow();
	}
	
	afx_msg BOOL OnInitDialog();
	
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar *pSb);
	
	afx_msg void OnTimer(UINT);
	afx_msg void OnPlayStop();

	afx_msg void OnRandomize();
	afx_msg void OnWiggle();
	afx_msg void OnMajor();
	afx_msg void OnMinor();
	afx_msg void OnFourths();
	afx_msg void OnFifths();
	afx_msg void OnReset();
	afx_msg void OnIncrease();
	afx_msg void OnDecrease();
	afx_msg void OnZero();
	afx_msg void OnInvert();
	afx_msg void OnSwap();

	CScrollBar *channelSB() {
		return (CScrollBar *)GetDlgItem(SB_CHANNEL);
	}
	
	CStatic *channelST() {
		return (CStatic *)GetDlgItem(ST_CHANNEL);
	}
		
	CScrollBar *programSB() {
		return (CScrollBar *)GetDlgItem(SB_PROGRAM);
	}
	
	CStatic *programST() {
		return (CStatic *)GetDlgItem(ST_PROGRAM);
	}
		
	CScrollBar *minvolSB() {
		return (CScrollBar *)GetDlgItem(SB_MINV);
	}
	
	CStatic *minvolST() {
		return (CStatic *)GetDlgItem(ST_MINV);
	}
		
	CScrollBar *maxvolSB() {
		return (CScrollBar *)GetDlgItem(SB_MAXV);
	}
	
	CStatic *maxvolST() {
		return (CStatic *)GetDlgItem(ST_MAXV);
	}
	
	CScrollBar *minlenSB() {
		return (CScrollBar *)GetDlgItem(SB_MINL);
	}
	
	CStatic *minlenST() {
		return (CStatic *)GetDlgItem(ST_MINL);
	}
		
	CScrollBar *maxlenSB() {
		return (CScrollBar *)GetDlgItem(SB_MAXL);
	}
	
	CStatic *maxlenST() {
		return (CStatic *)GetDlgItem(ST_MAXL);
	}
		
	CScrollBar *lownoteSB() {
		return (CScrollBar *)GetDlgItem(SB_LOWNOTE);
	}
	
	CStatic *lownoteST() {
		return (CStatic *)GetDlgItem(ST_LOWNOTE);
	}
		
	CScrollBar *highnoteSB() {
		return (CScrollBar *)GetDlgItem(SB_HIGHNOTE);
	}
	
	CStatic *highnoteST() {
		return (CStatic *)GetDlgItem(ST_HIGHNOTE);
	}
	
	CScrollBar *restSB() {
		return (CScrollBar *)GetDlgItem(SB_REST);
	}
	
	CStatic *restST() {
		return (CStatic *)GetDlgItem(ST_REST);
	}
	
	CButton *playPB() {
		return (CButton *)GetDlgItem(PB_PLAYSTOP);
	}
	
	void channelChange(int);
	void programChange(int);
	void minVolChange(int, BOOL);
	void maxVolChange(int, BOOL);
	void minLengthChange(int, BOOL);
	void maxLengthChange(int, BOOL);
	void lowNoteChange(int, BOOL);
	void highNoteChange(int, BOOL);
	void restChange(int);
	
	void playstop();
	void nextNote();
	void program();
	
	int getNote();
	UINT getLength();
	BYTE getVolume();
	
	BOOL shifted();
	
	void cleanup();
	void saveDefaults();
	
	DECLARE_MESSAGE_MAP()

private:

	HMIDIOUT p_hMidi;
	
	BOOL p_gotProfile;
	
	BOOL p_playing;
	int p_note;
	
	BYTE p_channel;
	int p_lastChannel;
	
	int p_program[16];
	
	BYTE p_minVol;
	BYTE p_maxVol;
	
	WORD p_minLength;
	WORD p_maxLength;
	
	WORD p_noteProb[128];
	WORD p_restProb;
	
	BYTE p_lowNote;
	BYTE p_highNote;
	
};

#endif // __MAIN_H__

