             PAGE      70,132
             .RADIX    10

;	Utility to replace FDREAD, contained in FDFORMAT.ARC
;       This new version corrects a bug noticed on some computers,
;         when formatting a 720Ko disquette in an 1.2Mo floppy.
;         There was a problem switching between 40 and 80 tracks.
;
;       For any remark, send mail to ARMENGAU@FRECP12.BITNET
;                       (but not before Sept. 1st 1989)
;
cseg         segment   para public 'CODE'
             assume    cs:cseg

             org       100H
start:       jmp       begin                  ;Sprung zur Installationsroutine

old13        label     dword                  ;Speicherung alten Interrupt 13 Adresse
old13_ofs    dw        ?                      ;Offset-Teil
old13_seg    dw        ?                      ;Segment-Teil

entry:       push      ax                     ;Alle bentigten...
             push      bx                     ;...Register...
             push      ds                     ;...retten
             or        ah,ah                  ;Wurde Funktion 0 (RESET) aufgerufen?
             jz        exit                   ;Ja, dann Ende
             cmp       ah,4                   ;Wurde Funktion ber 4 aufgerufen?
             ja        exit                   ;Ja, dann Ende
             push      ax
             xor       ax,ax                  ;Setze AX=0
             mov       ds,ax                  ;Setze auch DS=0
             lds       bx,ds:[78h]            ;Lade die Disk-Parameter Tabelle in DS:BX
             mov       byte ptr ds:[bx+4],25  ;Setze auf maximal 25 Sektoren pro Spur
             pop       ax
exit:
             cmp        dl,2            	; No modif. if hard disk
             jae        no_try_swap
             xor        bx,bx
             push       bx
             pop	ds
             add        bl,dl
             cmp	byte ptr ds:[490H][bx],53H  ; with 53H it is slow (?)
             jnz	no_inc_value                ; so put 54H instead
             inc	byte ptr ds:[490H][bx]
no_inc_value:
             cmp	ah,2              ; swap only for ah=2,3,4,5
             jb		no_try_swap
             cmp	ah,5
             ja         no_try_swap
             mov	al,ds:[490H][bx]
             and	al,0F0H
             cmp	al,50H   ; Test the type (40:90/40:91)
             jz         try_swap
             cmp        al,70H   ;Will try to swap if upper half
             jz         try_swap ; is 50 / 70

no_try_swap:
             pop       ds                     ;Hole alle benutzten...
             pop       bx                     ;...Register...
             pop       ax                     ;...wieder zurck
             jmp       old13                  ;Springe an den alten Interrupt 13
try_swap:
             pop        ds
             pop        bx
             pop        ax

             push       ax
             push       bx
             push       cx
             push       dx
             pushf
             call	old13                 ; Try the INT 13H
             jc         swap                  ; if error swap

             add        sp,4*2                ; No error
             clc
             jmp	short sortie

swap:
             pop	dx
             push	ds
             xor        bx,bx
             push	bx
             pop	ds
             add        bl,dl
             xor        byte ptr ds:[490H][bx],20H ;Swap the value of 40:90
             pop	ds                         ; or 40:91
             pop	cx
             pop	bx
             pop	ax
             pushf
             call	old13                 ; Retry INT 13H
sortie:      push	bp
             mov	bp,sp
             jc		exit_c
             and	Word Ptr [bp+6],0FFFEH ; set the flags for iret
             jmp        short gle
exit_c:      or		Word Ptr [bp+6],1
gle:         or		Word Ptr [bp+6],200H
             pop	bp
             iret                            ; iret pops the flags !

             


begin:       mov       dx,offset text         ;Text in DS:DX laden
             mov       ah,9                   ;System Call 9 fr...
             int       21h                    ;Textausgabe
             mov       es,ds:[2ch]            ;Setze ES auf das Environment
             mov       ah,49h                 ;System Call 49 fr Speicherfreigabe
             int       21h                    ;Environment freigeben
             mov       ax,cs                  ;Setze AX auf das Code-Segment
             sub       ax,0ah                 ;Ziehe 160 Bytes ab (10 Paragraphen)
             mov       es,ax                  ;Speichere das Ergebnis in ES
             mov       si,100h                ;Setze SI auf den Anfang des Programms
             mov       di,si                  ;DI ebenfalls
             mov       cx,offset begin-start  ;Lnge des Programms in CX
             cld                              ;vorwrts...
             rep       movsb                  ;...nach oben verschieben
             push      es                     ;Setze DS...
             pop       ds                     ;...auf ES
             mov       ax,3513H               ;System Call 35, um...
             int       21h                    ;Adresse von Interrupt 13 in ES:BX zu kriegen
             mov       ds:old13_seg,es        ;Adresse fr spter...
             mov       ds:old13_ofs,bx        ;...abspeichern.
             mov       dx,offset entry        ;DS:DX auf den neuen Interrupt 13
             mov       ax,2513h               ;System Call 25...
             int       21h                    ;...zum Installieren
             push      cs                     ;DS wieder auf...
             pop       ds                     ;...das Code-Segment setzen
             mov       dx,offset begin-160    ;Bentigte Lnge die resident sein soll
             int       27h                    ;und Programm speicherresident verlassen

text         db        'FDREAD2 - Ver 2.00 - written by: J.Armengaud & C.Hochsttter',10,10,13,"$"

cseg         ends
             end       start

