#include "split.h"

/******************************************************************\
*                                                                  *
*		   w       w                oooo                           *
*		   w       w  iii  n   n   o    o   n   n  eeee            *
*		   w       w   i   nn  n  o      o  nn  n  e               *
*		   w   w   w   i   n n n  o      o  n n n  eee             *
*	  	    w w w w    i   n  nn   o    o   n  nn  e               *
*	 	     w   w    iii  n   n    oooo    n   n  eeee            *
*								   								   *
*     C o m m a n d   L a n g u a g e   I n t e r p r e t e r      *
*								   								   *
*								   								   *
*	Written by Lucien Cinc                                         *
*	Copyright (c) 1992, 1993                                       *
*                                                                  *
\******************************************************************/

int split(char *path, long offset);

int main(void)
{
	int offset;
	char *sp;

	sp = args();                // parse command line switches
    while(*sp)
        switch(*sp++) {
            case 'v' :          // show version information
                       printf("%cVersion %c%d.%01d\n", WHITE, YELLOW, VERSION / 10, VERSION % 10);
                       return 0;
            default:            // invalid switch
                       perror("Invalid switch");
                       return 1;
		}

	if (argnstr()) {			// no string arguments
		perror("Invalid argument");
		return 1;
    }

	if (argc() != 2) {
		perror("Too many or few arguments");
		return 1;
    }

	return split(argabs(1), atol(argv(2)));	// split the file
}

int copy(int src, char *path, long num)
{

	char *buffer;
	unsigned w;
	int dst, size;
	long count;

	if ((buffer = (char *)malloc(BUFSIZE)) == NULL) {	// get some space
		perror("Out of memory");
		return 0;
    }

	if (_dos_creatnew(path, 0, &dst)) {					// create the destination file
		perror("Destination file already exists");
		return 0;
	}

	printf("%c%s %c%9ld%c\n", GREEN, unixpath(padfilename(path)), YELLOW, num, LIGHTGRAY);

	count = 0;
	while (count < num) {

		size = BUFSIZE;				// next buffer size
		if (count + size >= num)
			size = num - count;

		if (_dos_read(src, buffer, size, &w) || w != size) {
			perror("Read error");
			break;
        }

		if (_dos_write(dst, buffer, size, &w) || w != size) {
			perror("Insuffient disk space");
			break;
		}

		if (isbreak())
			break;

		inc(size);	// update status bar

        count += size;
	}

	free(buffer);
    _dos_close(dst);

	if (count == num)
    	return 1;	// ok

	return 0;
}
 
int split(char *path, long offset)
{
	int handle;
    long flen;
	char temppath[MAXPATH];

	strcpy(temppath, path);

	if (_dos_open(path, O_RDONLY, &handle)) {
		perror("Invalid path or file name");
		return 1;
	}

	flen = filelength(handle);
	if (offset < 0 || offset > flen) {				// range check
		perror("Bad split size");
		_dos_close(handle);
		return 1;
	}

	limit(flen);	// status bar limit

	strcpy(strrchr(temppath, '.'), ".1");			// first half
	if (copy(handle, temppath, offset)) {

		strcpy(strrchr(temppath, '.'), ".2");		// second half
		copy(handle, temppath, flen - offset);

	}

	_dos_close(handle);
	empty();		// finished with status bar

    return 0;
}
