/*                              FBBSPCB.CPP                                 */
/*                     FILES.BBS to PCBoard DIR v1.1                        */
/*                     by Steve Walcher Jan 1995                            */
/*                     Compiled w/ Borland C++                              */
/*                                                                          */
/*   Syntax: FBBSPCB <drive:> <pcbdir_path> <desc_col#>                     */
/*                                                                          */
/*    where: <drive:>      = drive letter of the CD-ROM                     */
/*           <pcbdir_path> = path to directory to save DIR files            */
/*                           (uses directory name for DIR filename)         */
/*           <desc_col#>   = column # of description  (start from 0)        */
/*                                                                          */
/*   example:                                                               */
/*           FBBSPCB G: c:\pcb\dir\cd1\ 17                                  */
/*                                                                          */
/*                                                                          */
/*             This utility will convert the FILES.BBS                      */
/*             descriptions from many CD-ROMs and create a DIR Text File    */
/*             that can be used by PCBoard14.x/15.x.  A separate file       */
/*             will be created for each directory on the CD-ROM. They       */
/*             will be placed in the directory you specify.                 */
/*                                                                          */
/*                                                                          */
/* FILES.BBS sample:                                                2       */
/*           1         2         3         4         5         6    5       */
/* 0123456789012345678901234567890123456789012345678901234567890....5       */
/* ASTROFAQ.ZIP [0] How to become an Astronaut? Internet FAQ.               */
/*                                                                          */
/*                                                                          */
/*           o File names must start in column 0.                           */
/*           o File descriptions must be limited to one line and it must    */
/*             be the same line as the file name.                           */
/*           o File descriptions over 255 characters in length will be      */
/*             truncated.                                                   */
/*                                                                          */
/*             Special thanks to:                                           */
/*             Paul Kromann, and Dan Renfrow for their help.                */
/*                                                                          */
/*             Use this program at your own risk!!                          */
/*                                                                          */
/*             I have used this program without problems on my own system   */
/*             but make warrantee as to how it will work for you.           */
/*                                                                          */
/*             Dedicated to the Public Domain                               */
/*             You may borrow, use, abuse this source code to your hearts   */
/*             content....                                                  */
/*                                                                          */
/*             You can reach me at:                                         */
/*                                                                          */
/*             Internet: steve.walcher@tpalley.eskimo.com                   */
/*                 RIME: ->TPALLEY #1285                                    */
/*                       Tin Pan Alley BBS                                  */
/*                       Mukilteo, WA  USA                                  */
/*                       (206)742-7782 USR DS                               */
/*                                                                          */
/*                                                                          */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <dir.h>

#define D_LENGTH 45 /* number of characters in description */
#define LINES 3     /* number of lines in description */

void find_sp(char *str);
void find_nl(char *str);
void set_col(FILE *fp, int col);

int main(int argc, char **argv)
{

FILE *fileptr;
FILE *fileptr2;
FILE *stream;

struct ffblk ffblk, dir;
struct ftime ft;

char ch[1], filename[80], filename2[80];
char name[12],junk[5],desc[255], desc3[LINES][D_LENGTH];
char fname[80], s[8];

char cd_drv[3],cd_drv1[5],pcbdir[80];
char *ptr;

int handle;
unsigned date, time;
int done = 0;
long size;
int length;
int line, d_length;

int dircount = 0;
int i, i2, yr, mo, dy;
int name_col, desc_col;

desc3[0][0]='\0';       // may be unnecessary but better safe than sorry
desc3[1][0]='\0';
desc3[2][0]='\0';


if (argc != 4)
  {
   printf("  Usage: FBBSPCB <cd-rom_drive:> <PCBdirpath> <desc_col#>\n\n");
   printf("Example: FBBSPCB G: c:\\pcb\\files\\cd1\\ 17\n");
   return 1;
  }

strcpy (pcbdir,argv[2]);		// directory name for
strcpy (s,argv[3]);		// column number for description
desc_col = atoi(s);
name_col = 0;			// column number for filename

while(!done) {
   strcpy(cd_drv1,argv[1]);
   strcat(cd_drv1, "/*.*");
   done = findfirst(cd_drv1, &dir, FA_DIREC);
   for (i = dircount; i > 0; i--) {
	done = findnext(&dir);
    }
   if (dir.ff_attrib != '\1') {
	dircount++;
	// open FILES.BBS in found directory
	strcpy(cd_drv,argv[1]);
	strcat(cd_drv, "/");
	filename[0] ='\0';
	strcpy(filename, cd_drv);
	strcat(filename, dir.ff_name);
	strcat(filename, "/FILES.BBS");


	if ((fileptr =fopen(filename,"r")) == NULL)
	{
	printf("Error: cannot open input file\n");
	printf("%s", filename);
	exit(1);
	}

	/* open file for writing output to */
	/* use directory name for file name */
	filename2[0] ='\0';
	strcpy(filename2, pcbdir);
	strcat(filename2, dir.ff_name);

	if ((fileptr2 =fopen(filename2,"w")) == NULL)
	{
	printf("Error: cannot open output file\n");
	exit(0);
	}
	 printf("\nFilename       Size      Date    Description of File Contents\n");
	   printf("============ ========  ========  ============================================");
fprintf(fileptr2, "Filename       Size      Date    Description of File Contents\n");
fprintf(fileptr2, "============ ========  ========  ============================================");

	/* set fileptr to beginning of file */
	fseek(fileptr, 0, SEEK_SET);

	while(!feof(fileptr)) {
		name[0]='\0';
		junk[0]='\0';
		desc[0]='\0';
		set_col(fileptr, name_col);
		fgets(name, 13, fileptr);
		find_sp(name);
		//fgets(junk, 6,  fileptr);
		set_col(fileptr, desc_col);
		fgets(desc, 255, fileptr);
		strcpy(fname, cd_drv);
		strcat(fname, dir.ff_name);
		strcat(fname, "/");
		strcat(fname, name);
		//printf("%s\n", fname);
		findfirst(fname, &ffblk, 0);

/*
  ff_fdate 15..........98.....54.......0
   ͹
	   ͼ
	     Years since   Month     Day
		1980
*/
		yr = (ffblk.ff_fdate >> 9) + 80;
		mo = (ffblk.ff_fdate >> 5) & 0x0F;
		dy = ffblk.ff_fdate & 0x1F;

/*  format of output

Filename       Size      Date    Description of File Contents
============ ========  ========  ============================================
0803PR3.TXT      3316  09-22-93  August 3, 1993 CLI2NTON ADMINISTRATION ACTS TO
			       | MOVE TIMBER SALES
*/

		/* print name, size, date */

		printf("\n%-12s %8lu  %02i-%02i-%02i  ",ffblk.ff_name, ffblk.ff_fsize, mo, dy, yr);
     fprintf(fileptr2, "\n%-12s %8lu  %02i-%02i-%02i  ",ffblk.ff_name, ffblk.ff_fsize, mo, dy, yr);


/*  convert desc strings > 45 in length */
/*  put it into array desc3[LINE][D_LENGTH] */

		length = strlen(desc);
		ptr = desc;
		  if(length > D_LENGTH-1)
		  {
		     for(line=0; line < LINES; line++)
		     {


		       for(d_length=0; d_length < D_LENGTH; d_length++)
		       {
			 if(*ptr != '\n')
			 {
			     desc3[line][d_length] = *ptr++;
			     if(d_length+1 == D_LENGTH)
			     {
			       /* search for truncated words, back up if found */
			       while((*ptr != ' ')&&(*ptr != '\n'))
			       {
				d_length--;
				ptr--;
			       }
			       if(*ptr == ' ')
				 ptr++; /* get off of ' '(sp) */
			       desc3[line][d_length+1] = '\0';
			       break;
			     }
			 }
			 else /* replace '\n' with NULL */
			 {
			   desc3[line][d_length] = '\0';
			   break;
			 }
		       }//end for

			    /* print desc */
		       if(*desc3[line] != '\0')
			 {
			   if(line!=0)
			   {
			     printf("\n                               | %s", desc3[line]);
		  fprintf(fileptr2, "\n                               | %s", desc3[line]);
			   }
			   else
			   {
			     printf("%s", desc3[line]);
			     fprintf(fileptr2, "%s", desc3[line]);
			   }
			 }
		     }//end for
		  }
		  else
		  {
		    find_nl(desc);
		    printf("%s", desc);
		    fprintf(fileptr2, "%s", desc);
		  }

	}
	fclose(fileptr);

   }
   else dircount++;
   fclose(fileptr2);

}
return 0;
}

/* Function:  find_sp(char *str)  */
/* parameters: string                */
/* find first space in string, convert to '\0'(NULL) */

void find_sp(char *str)
{
   while (*str != '\0')
   {
	if (*str == ' ')
	{
	   *str = '\0';
	}
	str++;
   }
}
/* ----------------------------= END =------------------------------- */


/* Function:  find_nl(char *str)  */
/* parameters: string                */
/* find first '\n'(new line) in string, convert to '\0'(NULL) */

void find_nl(char *str)
{
   while (*str != '\0')
   {
	if (*str == '\n')
	{
	   *str = '\0';
	}
	str++;
   }
}
/* ----------------------------= END =------------------------------- */

/* Function: set_col(FILE *fp, int col)                      */
/* parameters: fp, col <column number to set>                */
/* set file pointer to column 'col' for a given line in file */
void set_col(FILE *fp, int col)
{
  long curpos;
  char ch;

  // first, set pointer to column 0

  curpos = ftell(fp);
  if (curpos != 0)			// check for begining of file
  {
    do
    {
      fseek (fp, -1, SEEK_CUR);		// move backwards 1 char
      ch = fgetc(fp);
      fseek (fp, -1, SEEK_CUR);		// move backwards 1 char
      curpos = ftell(fp);
    } while ((ch != '\n') && (curpos != 0));  // check for '\n' (newline)
    if (curpos != 0)			// check fo begining
    {
      fseek (fp, 1, SEEK_CUR);          // move forward to column 0
    }
  }
  fseek (fp, col, SEEK_CUR);		// set to column 'col'
}
/* ----------------------------= END =------------------------------- */
