/***********************************************************************
*                                                                      *
*  Edit class                                                          *
*                                                                      *
*  Purpose : Wrapping editor with /n codes in a virtual window         *
*            for small < 50Kb texts                                    *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*    Interface:                                                        *
*                                                                      *
*     Edit(int xx1, int yy1, int xx2, int yy2, char *txttxt) ;         *
*     int  setMargins(int top, int bottom, int tops, int bots) ;       *
*     int  setCursorPos(unsigned short pos) ;                          *
*     int  setWindow(int xx1, int yy1, int xx2, int yy2) ;             *
*     int  setText(char *st) ;                                         *
*     void setInput(unsigned int) ;                                    *
*     void setOutput(unsigned int) ;                                   *
*     void setTerm(unsigned int) ;                                     *
*     void setColor(unsigned char) ;                                   *
*     unsigned int getInput(void) ;                                    *
*     unsigned int getOutput(void) ;                                   *
*     unsigned int getTerm(void) ;                                     *
*     char *getText(void) ;                                            *
*     int  poll(void) ;                                                *
*     void interpKey(int key) ;                                        *
*     int  processKey(unsigned int) ;                                  *
*     void change(void) ;                                              *
*     void redraw(void) ;                                              *
*     void redrawCursor(void) ;                                        *
*     void clrWindow(void) ;                                           *
*     int  loadFile(char *fileName) ;                                  *
*     int  saveFile(char *fileName) ;                                  *
*     bool error(void) ;                                               *
*         --- Modifications to allow for Importing and displaying      *
*         --- the Insert Mode                                          *
*	 int  appendFile(char *fileName, char *FileName) ;             *
*	 bool insertmode ;                                             *
*	 bool isinsert;                                                *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
* $Header: C:\PROGRAMS\TC\EDIT\RCS\edit.hpv 1.1                        *
* 1994/07/30 09:30:40 BRAINBOX Exp BRAINBOX $                          *
*                                                                      *
*  Modified by Phil Ward                                               *
*           Nytech Software Design                                     *
*                                                                      *
* $Log: edit.cpv $                                                     *
// Modification  Dec 23, 1994  14:44:12 UTC +5  Nytech Software Design
// 1. Added the Append File routine
// 2. Made the Insertmode Public and added a Boolean
//
// Revision 1.16  1994/09/08  08:35:50  BRAINBOX
// 1. Added txtlength for speeding by I_A
//
// Revision 1.15  1994/08/25  20:03:42  BRAINBOX
// 1. Some minor reconstruction
// 2. Added getTopColor, BotColor, SetBorder, GetBorder
//
// Revision 1.14  1994/08/23  21:55:31  BRAINBOX
// 1. All implementation stuff moved to other files
//
// Revision 1.13  1994/08/22  20:44:07  BRAINBOX
// 1. Edit class totaly redesigned and split up into input and output
// 2. Added border controls
//                                                     *
* Revision 1.12  1994/08/21  10:04:30  BRAINBOX                        *
*  1. Speed improvement in calculatelinecolumn function                *
*  2. Page up/dn rewritten                                             *
*  3. Delete line rewritten                                            *
*                                                                      *
*  Revision 1.11  1994/08/20  13:30:10  BRAINBOX                       *
*  1. loadFile bug removed                                             *
*  2. setEditable implemented                                          *
*  3. Lot's of small bugs removed                                      *
*                                                                      *
*  Revision 1.10  1994/08/12  13:36:35  BRAINBOX                       *
*  1. Redraw bug removed                                               *
*                                                                      *
*  Revision 1.9  1994/08/11  22:32:42  BRAINBOX                        *
*  1. ANSI emulation fully supported                                   *
*  2. FILE output supported                                            *
*                                                                      *
*  Revision 1.8  1994/08/10  22:16:24  BRAINBOX                        *
*  1. Delete key for pexusers implemented and tested                   *
*  2. More comments added in code                                      *
*                                                                      *
*  Revision 1.7  1994/08/10  20:21:56  BRAINBOX                        *
*  1. Pure virtual function proccesKey now implemented correctly       *
*  2. Added static vars in classes Edit and Input for counting instances*
*                                                                      *
*  Revision 1.6  1994/08/08  14:51:55  BRAINBOX                        *
*  1. Colors implemented                                               *
*                                                                      *
*  Revision 1.5  1994/08/08  13:22:32  BRAINBOX                        *
*  1. PEX keys working now except home, end and insert keys            *
*  2. Bug removed when first character types was a \n                  *
*                                                                      *
*  Revision 1.4  1994/08/01  21:31:29  BRAINBOX                        *
*  1. Functions sorted on public, protected and private                *
*                                                                      *
*  Revision 1.3  1994/08/01  19:02:40  BRAINBOX                        *
*  1. Added support for file input and output                          *
*                                                                      *
*  Revision 1.2  1994/07/31  09:55:06  BRAINBOX                        *
*  1. END key bug removed                                              *
*                                                                      *
*  Revision 1.1  1994/07/30  09:30:40  BRAINBOX                        *
*  Initial revision                                                    *
*                                                                      *
*                                                                      *
************************************************************************
*/

#ifndef _EDIT_HPP
#define _EDIT_HPP

class Edit : public Output, public Instream
{
  protected:
	 int  x1, y1, x2 , y2 ;         // Screen coordinates
	 unsigned int  *strtcols ;      // array of integers of beginning lines
	 // I_A: made strtcols[] 'unsigned' to 'fix' 32K->64K max. without risk...

	 unsigned char  color ;          // Color of the edit box
	 unsigned short virorg ;         // Position of left uppermost character
			  short linpos, colpos, linmax ;
	 unsigned short lincur, linorg ;
	 unsigned short width, height,
					topMargin, bottomMargin,
					topSens, bottomSens ;

	 char **curScreen, **oldScreen ;// The edit screen and oldscreen
	 unsigned short memmaltxt, memmalint ;
	 bool c_fEditable;
	 int  border ;
	 int  topColor, botColor ;
	 bool doubleWidth ;
	 char *label ;
	 unsigned char *txt ;
	 unsigned int txtlength;        /* I_A: represents 'strlen(txt)' */
	 bool err ;
	 unsigned int curpos ;
	 void backspace(void) ;
	 void newline(void) ;
	 void addline(void) ;
	 virtual void display(void) ;
	 void copyScreen() ;
	 void formatText() ;
	 void calculateLineColumn() ;
	 int  delorg(int start,int lines) ;
	 void delpos(void) ;
	 void cursorDown(void) ;
	 void cursorUp(void) ;
	 void pagedown(void) ;
	 void pageup(void) ;
	 void home(void) ;
	 void end(void) ;
	 void deleteLine(void) ;
	 void deleteWord(void) ;
	 virtual void addchar(char) ;


  public:

	 Edit() ;
	 ~Edit() ;
	 Edit(int xx1, int yy1, int xx2, int yy2, unsigned char *txttxt) ;
	 int  setMargins(int top, int bottom, int tops, int bots) ;
	 int  setCursorPos(unsigned short pos) ;
	 int  setWindow(int xx1, int yy1, int xx2, int yy2, bool clear) ;
	 int  setText(unsigned char *st) ;
	 void setColor(unsigned char) ;
	 void setEditable(bool p_fEditable);
	 unsigned char *getText(void) ;
	 int  poll(void) ;
	 void interpKey(int key) ;
	 void change(void) ;
	 virtual void redraw(void) ;
	 void redrawCursor(void) ;
	 void clrWindow(void) ;
	 int  loadFile(char *fileName) ;
	 int  appendFile(char *fileName, char *FileName) ; //Added this for a local
	 int  saveFile(char *fileName) ;                   //file Import feature that would
	 bool error(void) ;                                //Append the text to what was already
	 void setTopColor(unsigned char col) ;             //there
	 unsigned char getTopColor(void) ;
	 void setBotColor(unsigned char col) ;
	 unsigned char getBotColor(void) ;
	 void setBorder(int brd) ;
	 int getBorder(void) ;
	 bool insertmode ; //made this public
	 bool isinsert;    //and added this for a Mode display
	 void drawborder(void) ;
	 virtual int  processKey(unsigned int) = 0 ;
} ;

#endif

