/***********************************************************************
*                                                                      *
*  Definition file for INPUT.CPP                                       *
*                                                                      *
*  Purpose : Input functions for edit                                  *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: input.cpv $
// Revision 1.3  1994/09/08  07:59:48  BRAINBOX
// 1. Bounce checked by I_A
//
// Revision 1.2  1994/08/25  20:05:04  BRAINBOX
// *** empty log message ***
//
// Revision 1.1  1994/08/23  21:57:14  BRAINBOX
// Initial revision
//                                                                *
*                                                                      *
************************************************************************
*/
#ifndef _INPUT_CPP
#define _INPUT_CPP

#include "TERM.CPP"
#include "INPUT.HPP"



Instream::Instream()
{
   nr++ ;                           // Increase the instance number
   lastpos = 0 ;
   keybuf = -1 ;

   sprintf(filename,"_INPUT_.%03i",nr) ;
   fpIn = fopen(filename,"wb") ;
   if (fpIn)  // I_A added
   fclose(fpIn) ;
   fpIn = fopen(filename,"rb") ;     // No checking is done!
                                      // If open fails, no input is ever
                                      // retrieved!
 if (!fpIn)                           // I_A added
 {                                    // I_A added
 printf("cannot open temp-file\n");   // I_A added
 exit(1);                             // I_A added
 }                                    // I_A added
}

int  Instream::setInputFile(char *fileName)
{
   fclose(fpIn) ;
   unlink(filename) ;
   strcpy(filename,fileName) ;

   fpIn = fopen(filename,"wb") ;
   if (fpIn)  // I_A added
   fclose(fpIn) ;
   if ( (fpIn = fopen(filename,"rb")) == NULL)     // No checking is done!
      return 1 ;
   else
      return 0 ;
}


Instream::~Instream()
{
   fclose(fpIn) ;
   unlink(filename) ;               // This will fail if someone
                                    // still opens this file for
                                    // read.
}


char *Instream::getInputFile(void)
{
   return filename ;
}

// Returns a non-zero integer if a key has entered the buffer
unsigned short Instream::peekbuffer(void)
{
   if (inputmode & INPUT_KEYBOARD)  // Look for keyboard input
      if (kbhit())
         return INPUT_KEYBOARD ;
#ifdef _PB_SDK_H
   if (inputmode & INPUT_PEXUSER)   // Look for pex input
   {
      if (keybuf != -1)
         return INPUT_PEXUSER ;
			if ( IO_Carrier() )
			{
         if ( (keybuf = IO_ReadByte()) != -1)
            return INPUT_PEXUSER ;           // Unfortunately IO_ReadByte reale read
                                    // the character, so put it in the buffer
			}
	 }
#endif
   if (inputmode & INPUT_FILE)      // Look for input from a file

//printf("\n%li\n",filelength(fileno(fpIn))) ;
      if ((filelength(fileno(fpIn)) != lastpos))
//      if(!feof(fpIn))
         return INPUT_FILE ;
   return INPUT_NONE ;
}

// If there is a key (check it with peekbuffer() ) get the key
int Instream::getkey(void)
{
   int c ;

   if (this->peekbuffer() == INPUT_KEYBOARD)
   {
      c = getch();                  // Get the key from keyboard
      if (!c)                       // if extended
         c = getch() << 8;          // get extended
      return c ;
   }
#ifdef _PB_SDK_H
   // Some parts borrowed from MBH
   // Function GetKey, published in PROBOARD.028
   if (this->peekbuffer() == INPUT_PEXUSER)
   {
      if (keybuf != -1)             // If there is a key in the keybuffer
         c = keybuf ;               // get it
      keybuf = -1 ;                 // clear the buffer

      switch(c)
      {
         case 25:
            return KEY_CTLY ;
         case 3:
            return KEY_PGDN ;
         case 18:
            return KEY_PGUP ;
         case 22:
            return KEY_INS ;
         case KEY_ESC:
            short l_sCountDown = 1000; // timout for single [esc] detection
                                       // tested on 12 mhz 0WS 80286


            for(;l_sCountDown && (c=IO_ReadByte()) == -1; l_sCountDown--);

            if(!l_sCountDown)          // return the "single" ESC key
               return(KEY_ESC);
            else
            {
               if(c != 0x005B)         // '['
               {
                  keybuf = c ;
                  return KEY_ESC ;     // Don't forget the previously type ESC
               } else                  // on our way to cursor keys!!!
               {
                  l_sCountDown = 1000; // timout for single [esc] detection
                  for(;l_sCountDown && (c=IO_ReadByte()) == -1; l_sCountDown--);
                  if(!l_sCountDown)    // return the "single" ESC key  + [
                  {
                     keybuf = c ;
                     return KEY_ESC ;  // Don't forget the previously type ESC
                                       // Forget the '[' character
                  }else
                  {
                     switch (c)
                     {
                        case 65:
                           return(KEY_UP);

                        case 66:
                           return(KEY_DN);

                        case 67:
                           return(KEY_RT);

                        case 68:
                           return(KEY_LT);

                        case 72:
                           return(KEY_HOME);

                        case 75:
                           return(KEY_END);

                        default:
                           return(c);
                     }              // End switch
                  }
               }                    // ESC was followed by [
            }

         case 127:
            return KEY_DEL;
         default:
            return c ;              // Return the single key

      }                             // end switch
   }                                // Endif inputmode = PEXUSER
#endif

   if (this->peekbuffer() == INPUT_FILE)
   {
      c = fgetc(fpIn) ;               // get key from file
      if (!c)                       // if extended
         c = fgetc(fpIn) << 8;        // get extende key
      return c ;
   }

   return NULL ;
}


void  Instream::setInput(unsigned int inp)
{
   inputmode = inp ;
}

unsigned int  Instream::getInput(void)
{
   return inputmode ;
}

#endif
