#
#   HALOWEEN.CMD  (HALLOWEEN)
#
#   This file demonstrates some examples for creating an interactive
#   Halloween display using XA.  Here's the scenario:
#
#   We placed an X10-controlled lamp inside a Jack O' Lantern near the
#   front door.  When the doorbell was pressed, the lamp is brightened and 
#   the pumpkin greets the trick or treaters by playing a "VOC" file.
#   As the door is opened, another "VOC" file is played simulating a creaking
#   door.  Later, when the door is closed, another "VOC" file simulates 
#   a slamming door.  The process is repeated the next time the doorbell is
#   pressed.  
#

define PUMPKIN A10      # House/Unit code for module controlling pumpkin light
define JOY_PORT 201H    # Use Joystick port for Input
define FLASH 1          # Pin 2 of LPT outputs FLASH strobe
define DOOR_BELL 10H    # Pin 2  (JOYPORT A) Button 1 is DOORBELL input
define DOOR_OPEN 40H    # Pin 10 (JOYPORT B) Button 3 is status of DOOR 
                        #        if 0, then closed
                        #        if 1, then open
declare var IN_DATA     # This variable collects all inputs
declare var COUNTER     # This variable counts the number of cycles

:repeat                     
display on
debug2                      # Display each variables' current value

# Waiting for Doorbell...
display off                 # Turn display off when using INPORT
:bell_wait
IN_DATA = INPORT JOY_PORT   # Read data from Joystick port
if (IN_DATA & DOOR_BELL)    # Has the doorbell been pressed?
  goto :bell_wait           # - No, keep waiting...
endif
counter = counter + 1       # - Yes, increment counter and continue
display on

PUMPKIN DIM 0 fast          # Use 'fast' so pumpkin speaks immediately.
#spawn vplay yourang2.voc /q


# Wait for the door to open...
display off
:door_wait_open
IN_DATA = INPORT JOY_PORT   # Read data from Joystick port
if !(IN_DATA & DOOR_OPEN)   # Has the door been opened?
  goto :door_wait_open      # - No, keep waiting...
endif                       # - Yes, play "creaking" VOC file
display on

#spawn vplay creakF.voc /q

# Wait for the door to close...
display off
:door_wait_close
IN_DATA = INPORT JOY_PORT   # Read data from Joystick port
if (IN_DATA & DOOR_OPEN)    # Has door been shut?
  goto :door_wait_close     # - No, keep waiting
endif                       # - Yes, play "slam" VOC file
display on

#spawn vplay slam.voc /q

goto :repeat                # Repeat sequence.

:exit
