DISPLAY OFF
#
#  SCENARIO: SPECIAL SEQUENCES WHEN LOGGING OFF COMPUTER
#     1)  Turn ON selected lights if late at night.
#     2)  Post reminder on Saturdays to insert appropriate tape
#         into backup unit.
#
#  I always use this command file when I'm or logging off the computer. This 
#  file is useful when it's very late at night and all the X10-controlled 
#  lights have been turned off by the CP-290. I want selected lights turned
#  on so I don't bump into any furniture or walk over the dog. Then, I want 
#  these lights turned off after about a 2 minute period after I reach the
#  bedroom. 
#
#  This can be accomplished by comparing the current time (CTIME) with
#  SUNSET and SUNRISE time:
#
#        IF (CTIME > SUNSET) && (CTIME < SUNRISE)
#                LIVING_ROOM_LAMP STAIRS ON
#                LIVING_ROOM_LAMP STAIRS OFF NOW 2
#        ENDIF
#
#  Therefore, if you execute the above statements after sunset (and before 
#  sunrise), the living room lamp and stairs lights will be turned on, and 
#  2 minutes later the CP-290 will turn them off.  However, you may not want
#  the lights activated if they are already turned on.
#
#  In this case, we need to determine what their current state is and control 
#  the lights accordingly. To do this, we'll use the STATUS token to examine 
#  the CP-290's schedule and determine what the current state of the module 
#  should be in. 
#
#  Note: This method only reports the current state based on the CP-290's 
#        schedule. Therefore, if you override the schedule and trigger a 
#        module from the command line (such as: XA "A2 OFF"), the correct 
#        status may not be returned.  
#
#        Use XT (a TSR for the CP-290) to obtain the latest status 
#        of all 256 modules).
#
#  
#  Note: This program uses IF/ELSE/ENDIF constructs which are only operational
#        in the REGISTERED version of XA.  
#
GOTO :START

# Subroutine to determine what tape to insert into backup drive.
# If Saturday is the last day of the month, then make sure that
# we use tape #1. 
#   Month:  1  2  3  4  5  6  7  8  9 10 11 12
#    Days: 31 28 31 30 31 30 31 31 30 31 30 31
#
# The following IF/ELSE statements could have been programmed on a single
# (and very long) line, but were shown in this format to make reading them
# a little easier.
#
:CALC_WEEK_OF_MONTH
DISPLAY OFF
Week_Of_Month = (CMONTHDAY \ 7) + 1
IF (CDAY == SAT)
  IF (CDATE == 1/31) 
    Week_Of_Month = 1
  ELSE 
    IF (CDATE == 2/28) && (CYEAR != 1996)
      Week_Of_Month = 1
    ELSE
      IF (CDATE == 3/31)
        Week_Of_Month = 1
      ELSE
        IF (CDATE == 4/30)
          Week_Of_Month = 1
        ELSE
          IF (CDATE == 5/31)
            Week_Of_Month = 1
          ELSE
            IF (CDATE == 6/30)
              Week_Of_Month = 1
            ELSE
              IF (CDATE == 7/31)
                Week_Of_Month = 1
              ELSE
                IF (CDATE == 8/31)
                  Week_Of_Month = 1
                ELSE
                  IF (CDATE == 9/30)
                    Week_Of_Month = 1
                  ELSE
                    IF (CDATE == 10/31)
                      Week_Of_Month = 1
                    ELSE
                      IF (CDATE == 11/30)
                        Week_Of_Month = 1
                      ELSE
                        IF (CDATE == 12/31)
                          Week_Of_Month = 1
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDIF
    ENDIF
  ENDIF
ENDIF
RETURN 

#
# The following subroutines display the appropriate backup reminder.
#
:TAPE_1
DISPLAY ON
#
# Use TAPE 1 for full backup of Drive C.    
#
DISPLAY OFF
RETURN

:TAPE_2
DISPLAY ON
#
# Use TAPE 2 for full backup of Drive D.    
#
DISPLAY OFF
RETURN

:TAPE_3
DISPLAY ON
#
# Use TAPE 3 for full backup of Drive E.    
#
DISPLAY OFF
RETURN

:TAPE_4
DISPLAY ON
#
# Use TAPE 4 for differential backup of Drives C, D, E.    
#
DISPLAY OFF
RETURN

:START
#
#
#  DECLARE (3) variables which will hold the state of the selected modules.
#
DECLARE var Bedroom_State
DECLARE var L_Room_State
DECLARE var Stairs_State

#
#  The STATUS command will return one of the following values (in the lower
#  byte of the variable) to indicate the module's programmed state:
#
#       0: OFF (issued from an ALL_UNITS_OFF command)
#       1: ON  (issued from an ALL_LIGHTS_ON command)
#       2: ON  (standard ON command)
#       3: OFF (standard OFF command)
#   **  4: DIM (standard DIM command)
#   **  5: DIM (standard DIM command)
#       6: OFF (issued from an ALL_LIGHTS_OFF command - not supported by XA)
#       7: UNKNOWN command
#
#   **  The upper byte of the variable contains the brightness level with
#       0 being fully bright, 15 (hex F) as completely dim.
#       In this example, we always mask off this byte because we're only
#       concerned with the OFF command.
#

DEFINE X10_OFF 3          # A '3' will be returned if selected module is OFF

# The returned status contains the DIM level (0...16) in the upper byte 
# if applicable, and the X10 function (ON/OFF/DIM) in the lower byte.
# For simple comparisons, we'll mask out the DIM level by using the '&' (AND)
# operator.
# 

Bedroom_State = (A3 STATUS & 0FH)   # Mask off upper byte (possible DIM level)
L_Room_State  = (A8 STATUS & 0FH)
Stairs_State  = (H1 STATUS & 0FH)

DISPLAY ON
IF (((SUNSET < CTIME) && (CTIME <= 11:59 PM)) || ((CTIME < SUNRISE) && (CTIME >= 12:00 AM)))
  #
  # Determine if it's necessary to activate any lights...
  #
  IF (L_Room_State == X10_OFF)       # Is it OFF?
      Living_Room_Lamp On            # Yes, turn it ON now...
      Living_Room_Lamp Off NOW 2     # ...and turn it OFF in 2 mins
  ENDIF
  IF (Stairs_State == X10_OFF)       # Is it OFF?
      Stairs On                      # Yes, turn it ON now...
      Stairs Off NOW 2               # ...and turn it OFF in 2 mins
  ENDIF
  IF (Bedroom_State == X10_OFF) && (CTIME < SUNRISE)  # Is it OFF?
      Bedroom_Light DIM 25           # Yes, turn it ON now...
  ENDIF
ENDIF                

DISPLAY OFF
DECLARE var Week_Of_Month
#
# If it's Saturday, then remind me to put the proper tape into the 
# backup unit.  POWERUP.EXE (see AUTOEXEC.BAT) will invoke the tape
# backup software on Sunday mornings after the CP-290 has been updated.
# The backup schedule is:
#   1st week of month - [Tape 1] Drive C (Full), Drives D+E (Differential)
#   2nd week of month - [Tape 2] Drive D (Full), Drives C+E (Differential)
#   3rd week of month - [Tape 3] Drive E (Full), Drives C+D (Differential)
#   All other weeks   - [Tape 4] Drives C+D+E (Differential)
#
# Use CMONTHDAY token to calculate which tape to insert into drive.
# The declared variable "Week_Of_Month" is calculated by dividing
# CMONTHDAY by 7, then adding 1. BEEP and DELAY tokens along with the 
# proper comment statements will issue the reminder.
#

DISPLAY OFF
IF ((CDAY == SAT) || ((CDAY == SUN) && (CTIME < 3:00)))
  GOSUB :CALC_WEEK_OF_MONTH       # Determine the current week number
  BEEP                      
  IF (Week_Of_Month == 1)
    GOSUB :TAPE_1
  ELSE
    IF (Week_Of_Month == 2)
      GOSUB :TAPE_2
    ELSE
      IF (Week_Of_Month == 3)
        GOSUB :TAPE_3
      ELSE
        IF (Week_Of_Month == 4) || (Week_Of_Month == 5)
          GOSUB :TAPE_4
        ENDIF
      ENDIF
    ENDIF
  ENDIF
  DISPLAY OFF DELAY 0:0:5 DISPLAY ON
ENDIF

COMPUTER OFF                         # Turn Computer off no matter what...

