
/*
 * File......   : RESTARR.PRG
 * Author....   : Peter Kulek
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * And is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 */

/*
   
   Endor Ltd 
   63 Church Road
   Albrighton 
   Shropshire
   WV7 3HL
   England

   Specialists in design and implementation of EIS and MIS systems 

   
   Telephone: 
       Analysis  081 558 2279    Peter Jordan  MD 
       Technical 0902 374 900    Peter Kulek   Technical Director
   
   Compuserve ID 100140,1220
   
   We design EIS and MIS systems for large data users for use on
   laptops to large networks with auto downloading from mainframes.

   If you have a large database and cannot get it into a user friendly 
   format please give us a call and we will send you a live sample 
   application that will show you how to manipulate vast quantities 
   of data EASILY, with a minimum of tables. 
   
   For example a complete hierachy from parent holding company through 
   to salesperson with profit and loss at each level, targeting, variances 
   both monetary and percentage, graphs at each level for period and weekly 
   figures all with five tables and designed and implemented within a month 
   from recieving TOR. 
   
   Directors and Managers in large corporations have found it very friendly 
   and most important they use it daily. 
   
   To really appreciate the vast amount of data and the easy interface a
   copy of the application has to be seen.
   
   This is not some system using commercial EIS applications which need
   months of training and have heaps of files floating all over the place.
   This is far superior methodology to any of the current commercial offerings.
    

   No Problem to large to solve.
*/

/*  $DOC$
 *  $FUNCNAME$
 *     FILE2ARRAY()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Save Clipper array to a disc file.
 *  $SYNTAX$
 *    File2Array( <cFileName>)  -> aArray
 *  $ARGUMENTS$
 *     <cFileName> is a DOS file name.
 *  $RETURNS$
 *     <aArray> a Clipper array 
 *  $DESCRIPTION$
 *     File2Array restores a Clipper Array saved by Array2File
 *  $EXAMPLES$
 *  $SEEALSO$
 *     Array2File()
 *  $END$
 */

#include "FILEIO.CH"
//-----------------------------------------------------------------------------
function File2Array(cFile,nLen,hFile)
LOCAL cData,cType,nDataLen,nBytes
local nDepth := 0
local aRay   := {}
if hFile == NIL             
     if (hFile:=fOpen(cFile,FO_READ)) == -1
         return(aRay)
     endif
     cData := space(3)
     fRead(hFile,@cData,3) 
     if left(cData,1) != 'A'
         return( aRay)
     endif
     nLen := bin2i(right(cData,2))
endif
do while nDepth < nLen 
    cData  := space(3)
    nBytes := fRead(hFile,@cData,3)   
    if nBytes<3
       exit
    endif
    cType:= padl(cData,1)
    nDataLen:= bin2i(right(cData,2))
    if cType != 'A'
       cData := space(nDataLen)
       nBytes:= fRead(hFile,@cData,nDataLen)
       if nBytes<nDataLen
           exit
       endif
    endif
    nDepth++
    aadd(aRay,NIL)
    if cType=='C'
        aRay[nDepth] := cData
    elseif cType=='N'
        aRay[nDepth] := val(cData)
    elseif cType=='D'
        aRay[nDepth] := stod(cData)
    elseif cType=='L'
        aRay[nDepth] := (cData=='T')
    elseif cType=='A'
        aRay[nDepth] := File2Array(,nDataLen,hFile)   
    endif
enddo
if cFile!=NIL                            
    fClose(hFile)
endif
return(aRay)



