// Syntax:
//   ABinChop(<aToBeScanned>, <xItem>) -> nElement
//
// Purpose:
//   Scan an array for a matching item.
//   Uses the classic Binary chop method.
//
// Category:
//   ARRAY SEARCHING               
//
// Library:
//   None    
//
// Formal Arguments:
//   <aToBeScanned>
//     Single dimensional homogenous array to search in
//
//   <xItem>
//      Item to match. Must be of same type as elements in array.
//
// Returns:
//   nElement         0 if not found, otherwise element where match occurred
//
// Notes:
//  This code is provided strictly as is. The code is released as freeware.
//
// Author:
//   JDW @ HASH Computer Centre, Lewes, England
//
// See Also:
//
Function ABinChop(aToBeScanned, xItem)
  Local nLow     := 1
  Local nHigh    := len(aToBeScanned)
  Local nMiddle  := 1
  Local nElement := 0
                      
  do while nLow <= nHigh

    // Select midpoint of the array depending on the high and
    // low watermarks

    nMiddle := int((nLow+nHigh)/2)

    if xItem < aToBeScanned[nMiddle]

      // not in top half of the array
      // restrict next iteration to the bottom part of the array

      nHigh := nMiddle-1
    else
      if xItem > aToBeScanned[nMiddle]

        // not in bottom half of the array
        // restrict next iteration to the top part of the array

        nLow := nMiddle+1
      else

        // Match - exit loop quickly

        nElement := nMiddle
        exit
      endif
    endif
  end do
        
return nElement

