/* Program Ŀ
 ݳ  Application: Whatever                                                   
 ݳ  Description: See detailed comments at the end of this file              
 ݳ    File Name: XBOX.PRG                                                   
 ݳ       Author: Don Opperthauser       Modified by: Kevin S. Gallagher     
 ݳ Date created: 08-17-91              Date updated: 07-05-94              
 ݳ Time created: 03:47:06pm            Time updated: 12:29:54am            
 ݳ    Make File: MAKEFILE.RMK                                               
 ݳ    Exec File: TEST.EXE                                                   
 ݳ    Copyright: Public Domain - from nanforum toolkit version 2.1          
 Ĵ
 ݳ Function/Procedure Prototype Table                                       
 ݳ  
 ݳ Return Value     Function/Arguments                                      
 ݳ   
 ݳ nil              static function _ftsay(nSayRow,nSayCol,cSayStr)         
 ݳ nil              function ft_xbox(cJustType,cRetWait,nStartRow,nStartCol)
 ݳ nil              function ft_rgnstack(.....)                             
 ݳ xOldValue        function xBoxBord( xNewValue )                          
 ݳ xOldValue        function xBoxText( xNewValue )                          
 ݳ xOldValue        function xBoxType( xNewValue )                          
 
   */

//
// Create demo version (remove /dFT_TEST for production).
// Compile: C> clipper xbox /n/m/w/dFT_TEST
//    Link: C> blinker file xbox lib nanfor
//

#include "inkey.ch"
#include "box.ch"

#translate ISCHAR( <x> )        => ( valtype( <x> ) == "C" )
#translate ISNUM( <x> )         => ( valtype( <x> ) == "N" )

#xtranslate FT_SPACES( <n> )    => replicate( chr(255), <n> )

#xcommand FT_BYEBYEBOX()        => ft_xbox(.t.)

#xcommand FT_XCOLORS( <c> )     =>   ;
    xBoxBord( <c> )                 ;;
    xBoxText( xBoxBord() )

#ifdef FT_TEST
function main
    local i := 0
    local x := setcursor(0)

    panel()
    GetUm()
    /*
    * change border and text color
    */
    ft_xcolors("gr+/b")
    ft_xbox(,,,,"This is centered","on the console","No border for this guy")
    /*
    * change ft_xbox() border
    */
    xBoxType(B_DOUBLE_SINGLE + " ")
    ft_xcolors("w+/b")
    ft_xbox(,"W",1,20,"Line one - column twenty","Press a key to move on!")
    /*
    * change ft_xbox() border
    */
    xBoxType(B_SINGLE+" ")
    ft_xbox(,"W",16,1,"Should be B_SINGLE","Press any key to continue!")
    /*
    * original would crap on bound array error
    * this will not do so since i check for it
    */
    for i := 1 to 5
        FT_BYEBYEBOX()
        tone(2,15)
    next
    /*
    * change ft_xbox() border
    */
    xBoxType(B_DOUBLE + " ")
    /*
    * Lazy method to change colors  !!
    *                               / \
    * change both text and box colors at once
    * which is the same as calling the following;
    *
    * xBoxBord("w+/g")
    * xBoxText( xBoxBord() )
    *
    */
    FT_XCOLORS("w+/n")
    ft_xbox(,"W",16,1,"Press any key to continue please")
    FT_BYEBYEBOX()

    /*
    * Change border and text using two seperate function calls
    */
    xBoxBord("w+/g")
    xBoxText("n/g")
    xBoxType(' ')
    ft_xbox(,,,,"This is is end of the test",;
                "This last box will stay on the screen",;
                "Since there is no call to pop it from the stack",;
                "It should be a double box in 'w+/g'";
    )

    @row()+3,0
    setpos(row()-1,0)
    setcursor(x)
return nil

procedure panel
    local xStr := REPL( "Clipper Five is alittle ziggy... o ... ", 3 ), nCnt
    for nCnt := 0 to 24
        @ nCnt, 0 say subs( xStr, nCnt + 1, 80 ) color 'w+/r'
    next
return

procedure GetUm()
    local getlist := {}
    local cString := space(20)
    local nCursor := setcursor(1)
    local nGetLen := 0

    set scoreboard off

    nGetLen := len(cString)
    ft_xcolors("w+/rb")
    ft_xbox(,,21,50,"Enter your name:" + ft_spaces(nGetLen) )
    @row(),col() -nGetLen get cString color "w+/n"
    read
    setcursor(nCursor)
    ft_byebyebox()
return
#endif

function ft_xbox(cJustType,cRetWait,nStartRow,nStartCol,cLine1,cLine2,  ;
                 cLine3,cLine4,cLine5,cLine6,cLine7,cLine8              ;
    )
    local nLCol,nRCol,nTRow,nBRow,nLoop,nSayRow,nSayCol,nNumRows
    local cSayStr,cOldColor
    local aLines_[8]
    local KSGcolor  := setcolor()
    local cBoxColor := xBoxBord()
    local nLLen     := 0

    if valtype(cJustType) == "L"
        if !empty(cJustType)
            FT_RGNSTACK("pop")
            return nil
        endif
    endif

    cJustType  := if(ISCHAR(cJustType), upper(cJustType), "")
    cRetWait   := if(ISCHAR(cRetWait ), upper(cRetWait) , "")
    nStartRow  := if(ISNUM(nStartRow) , nStartRow       , 99)
    nStartCol  := if(ISNUM(nStartCol) , nStartCol       , 99)
    nNumRows   := Min(PCount()-4,8)
    aLines_[1] := if(ISCHAR(cLine1)   , alltrim( subs(cLine1,1,74)), "")
    aLines_[2] := if(ISCHAR(cLine2)   , alltrim( subs(cLine2,1,74)), "")
    aLines_[3] := if(ISCHAR(cLine3)   , alltrim( subs(cLine3,1,74)), "")
    aLines_[4] := if(ISCHAR(cLine4)   , alltrim( subs(cLine4,1,74)), "")
    aLines_[5] := if(ISCHAR(cLine5)   , alltrim( subs(cLine5,1,74)), "")
    aLines_[6] := if(ISCHAR(cLine6)   , alltrim( subs(cLine6,1,74)), "")
    aLines_[7] := if(ISCHAR(cLine7)   , alltrim( subs(cLine7,1,74)), "")
    aLines_[8] := if(ISCHAR(cLine8)   , alltrim( subs(cLine8,1,74)), "")

    asize(aLines_,Min(nNumRows,8))

    nLoop := 1
    aeval(aLines_,{|| nLLen:=max(nLLen,Len(aLines_[nLoop])),nLoop++})

    nLCol := if(nStartCol=99,int((76-nLLen)/2),Min(nStartCol,74-nLLen))
    nRCol := nLCol+nLLen+3
    nTRow := if(nStartRow=99,int((24-nNumRows)/2),Min(nStartRow,22-nNumRows))
    nBRow := nTRow+nNumRows+1

    cOldColor := setcolor(cBoxColor)
    ft_rgnstack("push",nTRow,nLCol,nBRow+2,nRCol+2)
    dispbox(nTRow,nLCol,nBRow,nRCol, xBoxType(),cBoxColor)
    ft_shadow(nTRow,nLCol,nBRow,nRCol)

    setcolor( xBoxText() )
    nLoop :=1

    aeval( aLines_,{ |cSayStr|                                       ;
           nSayRow := nTRow + nLoop,nSayCol := if(cJustType = 'L'   ,;
           nLCol +2, nLCol +2 + (nLLen-Int(Len(aLines_[nLoop])))/2) ,;
           nLoop++, _FTSAY(nSayRow,nSayCol,cSayStr)                  ;
                   };
    )

    if cRetWait == 'W'
        // was inkey() in the original code.
        ft_sinkey(0)
    endif
    setcolor( KSGcolor )
return nil

static function _FTSAY(nSayRow,nSayCol,cSayStr)
    @ nSayRow,nSayCol SAY cSayStr
return nil

*
* File......: SCREGION.PRG
* Author....: David A. Richardson
* Tweaker...: Kevin S. Gallagher
*
function FT_RGNSTACK(cAction, nTop, nLeft, nBottom, nRight)
    static aRgnStack_[0], nStackPtr := 0
    local nPopTop

    if cAction == "push"
        asize(aRgnStack_,++nStackPtr)[nStackPtr] =  ;
                ft_savrgn(nTop,nLeft,nBottom, nRight)

    elseif cAction == "pop" .or. cAction = "pop all"
        nPopTop := if("all" $ cAction, 0, nStackPtr-1)
        if len(aRgnStack_) >0
            while nStackPtr > nPopTop
                FT_RSTRGN(aRgnStack_[nStackPtr--])
            enddo
        endif
        asize(aRgnStack_, nStackPtr)
    endif
return nil

/*
*  Function: xBoxText( [<xNewValue>] ) --> "C"
*          :
*   Purpose: used to set color of ft_xbox() messages/lines of text
*          :
* Arguments: character string which is used to set colors
*          :
*/
function xBoxText( xNewValue )
    static xValue := "w+/b"
    local xOldValue := xValue
    if xNewValue != nil
        xValue := xNewValue
    endif
return ( xOldValue )

/*
*  Function: xBoxBord( [<xNewValue>] ) --> "C"
*          :
*   Purpose: used to set box colors for the function ft_xbox()
*          :
* Arguments: character string which is used to set colors
*          :
*/
function xBoxBord( xNewValue )
    static xValue := "w+/b"
    local xOldValue := xValue
    if xNewValue != nil
        xValue := xNewValue
    endif
return ( xOldValue )

/*
* Calling this function will allow the boxtype used for ft_xbox to be
* checked to see what is being used, as well as changing it.
*/
function xBoxType( xNewValue )
    static xValue := "         "
    local xOldValue := xValue
    if xNewValue != nil
        xValue := xNewValue
    endif
return ( xOldValue )

/***************************************************************************\
* Information on the modified copy of FT_XBOX routine                       *
* ---------------------------------------------------                       *
* The original version (currently in NANFOR.LIB) of ft_xbox was designed to *
* allow a program to display a self-sizing box on the display screen that   *
* could show up to eight lines of text, and would allow the position to be  *
* changed to other locations if the optional row/column parameters were     *
* passed. Colors and box type were also optional parameters.                *
*                                                                           *
* 1) Old colors settings were not restored after using ft_xbox              *
*    KSG modified code to restore old colors                                *
* 2) No method was available to remove boxs from screen after displaying    *
*    the boxs.                                                              *
*    KSG added method for allowing boxs to be removed (optional), i use a   *
*    modified version of FT_RGNSTACK() to remove boxs. The original         *
*    copy of ft_rgnstack would crap-out if the stack array had 0 elements   *                                                                       *
*    and it was called to pop a screen from the stack array. fixed          *
*                                                                           *
* 3) Box/message colors were changed via function parameters                *
*    KSG removed parameters, in favor of functions similar to how colors    *
*    are changed in Grump.lib routines.                                     *
*                                                                           *
* This is about the fourth copy i have uploaded to CIS, and will most       *
* likely will be the final modified version of ft_xbox().                   *
* I hope that it may be of use to other Clipper programmers, as i have      *
* found it of great usage for projects that didn't allow the use of 3rd     *
* party libraries because there were lack of funds to do so.                *
*                                                                           *
*/
