/*** WINDOW.H ***/

/* Written By P.A. McKenzie
 * The C Window Library
 * Copyright (C) 1990,1991,1992,1993,1994   All Rights Reserved
 * Last updated 7/21/94
*/

#ifndef WINDOW_DEF
#define WINDOW_DEF

#ifndef UNKNOWNARGS
#ifndef __cplusplus
#define UNKNOWNARGS
#else
#define UNKNOWNARGS ...
extern "C" {
#endif
#endif

/* define prototype macro */
#define MSDOS             /* Define if MSDOS system */
/*define COHERENT*/    /* Define if COHERENT OS */
/* #define UNIX_V   */    /* Define for UNIX System V */

#ifdef MSDOS
#define __PROTO__         /* Delete this line for compilers that do not support
                           * prototyping */
#define __CWLVOID__       /* Use this for compilers that have the void keyword */
#define __VOIDPTR__       /* Use this for compilers that support (void *) */
#define __FAR__           /* Use this if compiler supports 'far' keyword */
#define __NEAR__
#define __INTERRUPT__     /* keyword 'interrupt' is defined for this compiler */
#define __NEWSTYLE__      /* defines the new style of function headers */
#define __IBMPC_GRAPHICS__  /* defines the IBM PC upper graphics characters */
#define __USEINT__          /* says that int type is 16 bits wide */
#endif

#ifdef GNUCPP
#define __CWLVOID__
#define __VOIDPTR__
#define __PROTO__
#define __NEWSTYLE__
#endif

#ifdef COHERENT     /* This definition can also be used for UNIX V
                       operating system */

#define __CWLVOID__
#define __BIGALLOC__
#define __IBMPC_GRAPHICS__  /* defines the IBM PC upper graphics characters.
                               Use this for IBM PC CPU's only */
#define __USESHORT__        /* says that short is 16 bits   */
/*#define __EXTATTRIBUTES__ */  /* says that extended attributes are to be used */
#endif

#ifdef __PROTO__
#define _PROTO_(s)    s
#else
#define _PROTO_(s) ()
#endif

#ifdef __CWLVOID__
#define CWL_VOID    void
#else
#define CWL_VOID
#endif

#ifdef __VOIDPTR__
#define VOIDPTR   void *
#else
#define VOIDPTR   char *
#endif

#ifdef __FAR__
#define _FAR_  far
#else
#define _FAR_
#endif

#ifdef __NEAR__
#define _NEAR_  near
#else
#define _NEAR_
#endif

#ifdef __INTERRUPT__
#define _INTERRUPT_  interrupt
#else
#define _INTERRUPT_
#endif

#ifdef __NEWSTYLE__
#define _NEWSTYLE_
#endif

#ifdef __BIGALLOC__
#define _BIGALLOC_
#endif

#ifdef __IBMPC_GRAPHICS__
#define _IBMPC_GRAPHICS_
#endif

#ifdef   __USEINT__
typedef  unsigned int   WBUFFERTYPE;
#endif

#ifdef   __USESHORT__
typedef  unsigned short  WBUFFERTYPE;
#endif

#ifdef __EXTATTRIBUTES__
#define _EXTATTRIBUTES_
#endif

#define FUNCPTR_SIZE  (sizeof(VOIDPTR))

/* Window definitions */

#ifndef WNULLFN
#define WNULLFN   ((WPOINTER (*)()) 0)
#endif
#ifndef VWNULLFN
#define VWNULLFN  ((VWPOINTER (*)()) 0)
#endif
#ifndef NULLFN
#define NULLFN    ((int (*)()) 0)
#endif

#ifndef VOIDNULLFN
#ifdef __CWLVOID__
#define VOIDNULLFN  ((CWL_VOID (*)()) 0)
#endif
#endif

#ifndef UNULLFN
#define UNULLFN ((unsigned (*)()) 0)
#endif

#ifdef MSC
#ifndef NULL
#define NULL ((char *)0)
#endif
#endif

#ifdef GLOBAL_DEF
#define CWL_EXTERN
#else
#define CWL_EXTERN  extern
#endif

#ifdef POWERC
#define CWLmouse_hidden  mouhid_
#endif

#define CWL_NULL     ((char *)0)

#if __cplusplus
struct tagWINDOW;
struct tagSCROLLBAR;

struct tagBARMENU;
typedef tagBARMENU *BAR_MENU_PTR;

struct tagPOPUPMENU;
typedef tagPOPUPMENU *POPUP_MENU_PTR;

#endif


#ifdef MSDOS
#define MAXVBUFSIZE  64000UL  /* Maximum size of each virtual buffer */
#endif

#ifdef _BIGALLOC_
#define MAXVBUFSIZE  2000000000UL /* Maximum size for each virtual buffer
                                   Use this if MAXINT is greater than
                                   65,535 and running on a non-segmented
                                   operating system.                   */
#endif

#ifdef MSDOS
#ifdef LPOWERC
  typedef  char _FAR_ *  WBUFPTR;
#else
  typedef  char *      WBUFPTR;
#endif
#define CELLSIZE_      sizeof(char)
#endif

#ifdef COHERENT
typedef char *  WBUFPTR;
#define  CELLSIZE_   sizeof(char)
#endif



#ifndef NUMBOXCHARS
#define NUMBOXCHARS  8
#endif
#ifndef MAXSCROLLSTRING
#define MAXSCROLLSTRING 36
#endif

/* define structures used */

typedef struct tagVWINSTATUS
{
  unsigned viewport_flag:1;     /* tells if virtual window has a viewport */
  unsigned vwtype:1;            /* tells what type of virtual window */
  unsigned wrap_flag:1;
  unsigned sync_curs:1;
}  V_WIN_STAT;




typedef struct tagVIRTUALWINDOW
{
  unsigned nbufs;                         /* number of buffers required */
  unsigned char _FAR_ * _FAR_ *text;      /* pointer to huge text */
  unsigned char _FAR_ * _FAR_ *attr;      /* pointer to attributes */
  unsigned char _FAR_ * _FAR_ *exattr;    /* pointer to extended attributes */
  unsigned  nrows;                        /* number of rows in window */
  unsigned  ncols;                        /* number of columns in window */
  unsigned row;                           /* row of logical cursor */
  unsigned col;                           /* col of logical cursor */
  int wnum;                               /* virtual window number */
  int num_windows;                        /* total number of viewports */
  int oattr;                              /* original attribute */
  V_WIN_STAT stat_info;
} VWINDOW, *VWPOINTER;





 /****************************
 * Define window status bits *
 ****************************/

typedef struct tagWINSTATUS
{
  unsigned border_flag:1;       /* Window border flag */
  unsigned wrap_flag:1;         /* Window wrap flag */
  unsigned open_flag:1;         /* window open flag */
  unsigned init_flag:1;         /* window initialized flag */
  unsigned visible_flag:1;      /* window visible flag */
  unsigned v_window_flag:1;     /* window is a viewport flag */
  unsigned bufptr_flag:1;       /* tells if memory allocated for window buffer
                                 * pointer   */
  unsigned sync_curs:1;         /* tells if cursor is to be moved */
  unsigned frozen_flag:1;       /* tells if virtual window is frozen */
  unsigned seethru_flag:1;      /* tells if window is a see thru window */
  unsigned move_flag:1;         /* used internally for window update routines */
  unsigned v_hide_cursor:1;     /* tells if cursor is hidden by virtual
                                 * window */
  unsigned use_flag:4;          /* tells the object that is using the window */
  unsigned shadow_use:1;        /* tells if window is used as a shadow to
                                   another window */
  unsigned shadow_trans:1;      /* tells if shadow is transparent */
  unsigned child_enum:1;        /* tells that this is a child that is
                                   to be enumerated in WindowEnumChildren()
                                   function */
} WIN_STAT;




typedef struct tagSHADOWSTAT
{
  unsigned shadow_flag:1;       /* tells if there is a shadow */
  unsigned shadow_pos:3;        /* tells where shadow is */
} SHADOW_STAT;


typedef struct tagBITSTRING
{
  unsigned char *bit_string;
  unsigned nbits;
} BITSTRING;



typedef struct tagWINTITLE
{
  char *titletop;
  char *titlebot;
  int titletop_attr;
  int titlebot_attr;
  unsigned titletop_pos:2;
  unsigned titlebot_pos:2;
} WIN_TITLE;


typedef struct tagSCROLLBAR
{
  int scr_urow,       /* upper row of window */
      scr_ucol;       /* upper col. of window */
  int scr_min;        /* minimum scroll position */
  int scr_max;        /* maximum scroll position */
  int scr_boxpos;     /* current position of scroll box */
  unsigned int scr_type:2;     /* scroll bar type (horizontal, vertical, or user) */
  int scr_length;     /* length of scroll bar */
  unsigned int scr_enableup:1; /* tells if up or left scroll character is enabled */
  unsigned int scr_enabledown:1; /* tells if down or right scroll char is enabled */
  unsigned int visible:1;      /* tells if scroll bar is visible */
  unsigned int noupdate:1;     /* tells if scroll bar is NOT to be updated */
  unsigned char scr_attr[4];  /* colors of scroll bar */
  unsigned char scr_chars[3]; /* characters that make up scroll bar */
  int scroll_orig_length;     /* original length of scroll bar */
  VOIDPTR obj_ptr;   /* pointer to object that scroll bar will be used for */
#if __cplusplus
  struct tagWINDOW *scr_wind;  /* window to use if this is a scroll control */
#else
  VOIDPTR scr_wind;
#endif
} SCROLLBAR, *SCROLLPTR;


/* Default Mouse Hotspots */

typedef struct tagHOTSPOT
{
  unsigned int border:1;
  unsigned int zoom_on:1;
  unsigned int minimized:1;
  unsigned int caption:1;
  unsigned int adjust:1;
  unsigned int whichzoom:2;
  unsigned int track_scroll_top:1;
  unsigned int track_scroll_bottom:1;
  unsigned int zoomhighlight:1;
  unsigned int save_zoom;
  unsigned char hotspot_string[MAXSCROLLSTRING];
  char box[NUMBOXCHARS];
  char *caption_string;
  int  capture_len;
  int  bitpos;        /* tells the position in the minimize bitstring */
  long     options;
  long     save_options;  /* needed for a minimized window */
  SCROLLPTR sbarvert;
  SCROLLPTR sbarhorz;
#if __cplusplus
  int (*alt_move_func) _PROTO_((struct tagWINDOW *,int,int));
#else
  int (*alt_move_func) ();
#endif
} HOTSPOT, *HOTSPOTPTR;

/* object class constants */
#define FORMOBJECT              0
#define POPUPOBJECT             1
#define BAROBJECT               2
#define PULLDOWNOBJECT          3
#define VIRTUALOBJECT           4
#define WINDOWOBJECT            5
#define VBLOCKOBJECT            6
#define KEYTABLEOBJECT          7
#define BARUSEROBJECT           8
#define POPUPUSEROBJECT         9
#define PULLDOWNUSEROBJECT      10
#define TERMINFOOBJECT          11
#define OBJECTCONTAINER         12
#define BASEWINDOWOBJECT        13
#define TRANSPARANTOBJECT       14
#define ACCELOBJECT             15
#define CHILDOBJECT             16

#define USEROBJECT              1000

typedef struct tagOBJSTRUCT
{
#if defined (MSDOS) || (GNUCPP)
  CWL_VOID **objarray;
#else
  char **objarray;
#endif
  long num;
  int obj_type;
} CWLOBJECT, *CWLOBJECTPTR;


typedef struct tagWINSHADOW
{
   int schar;                     /* shadow character */
   int sattr;                     /* shadow attribute */
   int swidth;
   int sheight;
   SHADOW_STAT shadow_stat;
} WIN_SHADOW;


 /**************************
 * Define window structure *
 **************************/

 typedef struct tagWINDOW
{
  VWPOINTER vwptr;                 /* pointer to virtual window */
  unsigned int vwrow;              /* virtual window row */
  unsigned int vwcol;              /* virtual window column */
  int origx;                       /* original x-position */
  int origy;                       /* original y-position */
  int col;                         /* window column */
  int row;                         /* window row  */
  int width;                       /* window width */
  int height;                      /* window height */
  int xpos;                        /* current window x position */
  int ypos;                        /* current window y position */
  int srow;                        /* row of window in screen coordinates */
  int scol;                        /* col of window in screen coordinates */
  unsigned wnum;                   /* Window number */
  int rank;                        /* Where window is in list of windows */
  int saverank;                    /* Previous rank of a displayed window */
  int temprank;                    /* rank used for child windows if parent
                                      is not displayed */
  int pagenum;                     /* video page where window is opened */
  int cursorshape;                 /* tells the cursor shape */
  int save_cursorshape;            /* tells shape of cursor if cursor is
                                      * temporarily hidden */
  int battr;                       /* border attribute */
  int wattr;                       /* window attribute */
  char boxchars[NUMBOXCHARS];      /* box characters */
  WBUFPTR textbuf;                 /* points to text plane */
  WBUFPTR exattr;                  /* extended attributes */
  WIN_STAT stat_info;              /* window status flags */
  struct tagWINDOW *shadow_window; /* Window used as a shadow */
  WIN_SHADOW shadow_info;          /* shadow status */
  WIN_TITLE title_info;            /* window title info */
  HOTSPOTPTR hotspot;              /* default hotspots */
  unsigned poplite_loc;            /* location of popup menu highlight */
  VOIDPTR use_ptr;                 /* pointer to object that the window
                                      is being used for */
  CWLOBJECTPTR child;              /* array of child window objects */
  struct tagWINDOW *parent,        /* window's immediate parent   */
                   *baseparent;    /* window's base window ancestor */

  int (*window_proc) _PROTO_((struct tagWINDOW *, int, int, long));
                                   /* event driven window procedure */

  unsigned first_row;              /* tells where the first writeable row */
  VOIDPTR userbytes;                 /* information needed by the programmer */
} CWLWINDOW, *WPOINTER;


typedef struct tagCWLPOINT
{
  int x;
  int y;
} CWLPOINT;


typedef struct tagCWLRECT
{
  int left;
  int top;
  int right;
  int bottom;
} CWLRECT;


#define MAKEPOINT(x)   (*((CWLPOINT _FAR_ *)&(x)))
typedef int      (*TIMERPROC) _PROTO_((WPOINTER,int,int,long));
typedef int      (*CWLENUMPROC) _PROTO_((WPOINTER,long));

typedef struct tagCWLMSG
{
  unsigned message;      /* event */
  CWLPOINT point;        /* position of the mouse */
  unsigned wParam;       /* additional info */
  long     lParam;       /* additional info */
  WPOINTER win;          /* identifies window where message belongs to */
  VOIDPTR  msginfo;      /* extra info concerning message */
  unsigned int post:1;   /* tells if message was posted by the user */
} CWLMSG;



typedef struct tagTIMER
{
  unsigned int status:1;/* tells if timer is being used.  TRUE if
                          used, FALSE otherwise */
  WPOINTER window;      /* window that owns the timer */
  unsigned ticks;       /* current count of the number of clock ticks
                          left before timer goes off */
  unsigned numticks;    /* Total number of clock ticks */
  TIMERPROC TimerProc;  /* user defined function to call */

}  CMLTIMER;




typedef struct tagQUEUE
{
  CWLMSG *queue_ptr;     /* pointer to message queue */
  int queue_back;        /* indicates back of queue */
  int initial_size;      /* indicates initial size of queue or size of
                            queue when extra entries have to be allocated */
  int extra_size;        /* # of queue entries to allocate if
                            initial size is exceeded */
} QUEUE, *QUEUEPTR;




 /**********************************************
  * Define video and other miscellaneous flags *
  *********************************************/

#ifdef POWERC
   #define  CWLcrt_port        crtport_
   #define  CWLpagesize        pagesiz_
   #define  CWLcaldelay        caldely_
   #define  CWLstack_seg       stckseg_
   #define  CWLstack_bot       stckbot_
   #define  CWLoldseg          oldseg_
   #define  CWLoldtop          oldtop_
   #define  CWLevents_on       eventon_
   #define  CWLmouse_used      mouused_
   #define  CWLmouse_hidden    mouhid_
   #define  CWLscrnseg         scrnseg_
#endif

#ifndef offsetof
#define offsetof(type,memb) \
	       (unsigned)&((( type *)0x10)->memb)-(unsigned)(( type *)0x10)
#endif

#define MAXBUFSIZE    1024
#define MAXSCROLLWIDTH 140

 /********************************
  * Define video block structure *
  *******************************/


typedef struct tagVBLOCK
{
  CWLRECT vRect;
  int pagenum;        /* page number where block
                         is opened */
  char *scrnsave;     /* pointer to video block
                         structure */
} *VBLOCKPTR, VBLOCK;


typedef struct tagSYSFLAGS
{
  unsigned  scrnwrt_flag:1;        /* either BIOS or DMA          */

  unsigned  cga_flag:1;            /* cga flag                    */
  unsigned  mda_flag:1;            /* mono adapter flag           */
  unsigned  hgc_flag:1;            /* Hercules flag               */

  unsigned  vga_in_flag:1;         /* vga installed flag          */
  unsigned  vga_active_flag:1;     /* vga is active flag          */
  unsigned  vga_color_monitor:1;   /* vga color monitor attached  */
  unsigned  vga_color_flag:1;      /* vga color mode on           */

  unsigned  mcga_color_flag:1;     /* MCGA color on               */
  unsigned  mcga_in_flag:1;        /* MCGA installed flag         */

  unsigned  ega_in_flag:1;         /* ega installed flag          */
  unsigned  ega_active_flag:1;     /* ega active flag             */
  unsigned  ega_color_monitor:1;   /* ega color monitor attached  */
  unsigned  ega_color_flag:1;      /* ega is in color mode flag   */
}  SYS_FLAGS;


typedef struct tagVCONFIG
{
  unsigned int video_mode;         /* current video mode */
  unsigned int cursor_startline;   /* starting scan line of the cursor */
  unsigned int cursor_endline;     /* ending scan line of the cursor */
  unsigned int cursor_row;         /* row of cursor */
  unsigned int cursor_col;         /* column of cursor */
  unsigned int video_page;         /* video page */
  unsigned int video_pagesize;     /* video page size in bytes */
  unsigned int video_rows;         /* number of displayable rows */
  unsigned int video_cols;         /* number of displayable columns */
  unsigned int char_height;        /* height of characters in scan lines */
  unsigned int crt_port_address;   /* address of crt status port */
  unsigned int crt_mode_setting;   /* mode setting of crt */
  unsigned int crt_color_setting;  /* color setting of crt */
} VIDEO_CONFIG;




 /*******************
 * Define box types *
 ********************/

#ifdef _IBMPC_GRAPHICS_   /* Use this for PC's only (may use on other non-PC
                             systems, but characters may not be 'safe') */

#define DOUBLEBOX      "ͻͼ"
#define SINGLEBOX      "Ŀ"
#define MIXEDBOX1      "͸;"
#define MIXEDBOX2      "ķĽ"
#define HATCHBOX1      ""
#define HATCHBOX2      ""
#define HATCHBOX3      ""
#define SOLIDBOX1      ""
#define SOLIDBOX2      ""
#define BLANKBOX       "        "
#define DOTTEDLINE     "---||---"

#else

/* If using TERMINFO, you should set up the graphics string using the
   acsc terminfo description. */

#define DOUBLEBOX      "---||---"
#define SINGLEBOX      "---||---"
#define MIXEDBOX1      "---||---"
#define MIXEDBOX2      "---||---"
#define HATCHBOX1      "---||---"
#define HATCHBOX2      "---||---"
#define HATCHBOX3      "---||---"
#define SOLIDBOX1      "---||---"
#define SOLIDBOX2      "---||---"
#define BLANKBOX       "        "
#define DOTTEDLINE     "---||---"

#endif

#ifndef NUMBOXCHARS
#define NUMBOXCHARS  8
#endif

/* Macro Definitions */

#define SCREEN_WRITE_METHOD       CWLvideo_flags.scrnwrt_flag
#define CGA_ACTIVE                CWLvideo_flags.cga_flag

#define VGA_INSTALLED             CWLvideo_flags.vga_in_flag
#define VGA_ACTIVE                CWLvideo_flags.vga_active_flag
#define VGA_COLOR_ON              CWLvideo_flags.vga_color_flag

#define MCGA_COLOR_ON             CWLvideo_flags.mcga_color_flag
#define MCGA_INSTALLED            CWLvideo_flags.mcga_in_flag

#define EGA_INSTALLED             CWLvideo_flags.ega_in_flag
#define EGA_ACTIVE                CWLvideo_flags.ega_active_flag
#define EGA_COLOR_ON              CWLvideo_flags.ega_color_flag

#define VGA_MONO_ON               (VGA_ACTIVE && !VGA_COLOR_ON)
#define EGA_MONO_ON               (EGA_ACTIVE && !EGA_COLOR_ON)
#define HERCULES_ACTIVE           CWLvideo_flags.hgc_flag
#define MDA_ACTIVE                CWLvideo_flags.mda_flag
#define VGA_COLOR_ATTACHED        CWLvideo_flags.vga_color_monitor
#define EGA_COLOR_ATTACHED        CWLvideo_flags.ega_color_monitor

#define MONO_MODE_ON              ((!EGA_COLOR_ON && !VGA_COLOR_ON && \
                                    !MCGA_COLOR_ON && !CGA_ACTIVE) || \
                                   (MDA_ACTIVE || HERCULES_ACTIVE))

#define COLOR_MODE_ON             (!MONO_MODE_ON)
#define VGA_MODE_ON               (VGA_ACTIVE)
#define EGA_MODE_ON               (EGA_ACTIVE)
#define CGA_MODE_ON               (CGA_ACTIVE)
#define MCGA_MONO_ON              (MCGA_INSTALLED && VGA_ACTIVE && \
                                   !MCGA_COLOR_ON)
#define MCGA_MODE_ON              (MCGA_INSTALLED && VGA_ACTIVE)
#define VGA_MONO_ATTACHED         (VGA_ACTIVE && !VGA_COLOR_ATTACHED)

#define CHECK_SNOW                CWLchksnow
#define SCREEN_SEGMENT            CWLscrnseg
#define VIDEO_PAGESIZE            CWLpagesize

/*  Video Macros */

#define LINEMODE43       (get_video_info(4) == 43)
#define LINEMODE50       (get_video_info(4) == 50)
#define LINEMODE25       (get_video_info(4) == 25)

#define CREATE_VIDEO_ATTRIBUTE(x,y) (((int)(x) << 4) + (y)) /* creates a video attribute */
#define GET_BGROUND_COLOR(c)        ((int)(c) >> 4)
#define GET_FGROUND_COLOR(c)        ((int)(c) & 0x000F)

#if 0

#ifdef COHERENT
#define CREATE_VIDEO_ATTRIBUTE(x,y) (((int)(x) << 8) + (y)) /* creates a video attribute */
#define GET_BGROUND_COLOR(c)        ((int)(c) >> 8)
#define GET_FGROUND_COLOR(c)        ((int)(c) & 0x00FF)
#endif

#endif

#define SCREEN_OFFSET(r,c,a) \
                          (((((r))*CWLscreen_cols + (c)) + (a)*CWLpagesize)<<1)
#define GET_SEGMENT(x)  \
                  ((unsigned) ((long)(char _FAR_ *)(x) >> 16))
#define GET_OFFSET(x)   \
                   ((unsigned) ((long)(char _FAR_ *)(x) & 0x0000FFFF))
#define SCREEN_OFFSET_ATTR(r,c,a)        (SCREEN_OFFSET((r),(c),(a))+1)

#define MAKE_FAR_POINTER(a,b)  ((char _FAR_ *)(((unsigned long)(a) << 16)+(b)))

#define GetVideoAttribute(row,col,page)   get_chat((row)+1,(col)+1,(page),1)
#define GetVideoMode()                    get_video_info(1)
#ifdef MSDOS
#define MoveCursor(row,col,page)          goto_xy((row),(col),(page))
#endif
#define ReportCharacter(row,col,page)     get_chat((row),(col),(page),0)

/* Fast Output/Non-window related Video Functions */
int                CheckVideoPage _PROTO_((int page));
CWL_VOID           ClearRegion _PROTO_((int urow, int ucol, int lrow, int lcol, int attr));
CWL_VOID           ClearScreen _PROTO_((int attr));
CWL_VOID           GetCursorPosition _PROTO_((unsigned *row, unsigned *col, int page));
CWL_VOID           GetVideoBiosInfo _PROTO_((VIDEO_CONFIG *video_struct));
CWL_VOID           ScrollScreenUp _PROTO_((int numlines, int urow, int ucol, int lrow,
                                           int lcol, int attr));
CWL_VOID           ScrollScreenDown _PROTO_((int numlines, int urow, int ucol, int lrow,
                                             int lcol, int attr));
int                SetActiveVideoPage _PROTO_((int page));
int                SetVisibleVideoPage _PROTO_((int page));
CWL_VOID           SetVideoMode _PROTO_((int modenum));
int                SetVideoRows _PROTO_((int numrows, int flag));
CWL_VOID           VideoDrawBox _PROTO_((int urow, int ucol, int lrow, int lcol, char *box));
CWL_VOID           VideoDrawBoxAttr _PROTO_((int urow, int ucol, int lrow, int lcol,
                                             char *box, int attr));
CWL_VOID           VideoFree _PROTO_((VBLOCKPTR vid_block));
CWL_VOID           VideoMove _PROTO_((VBLOCKPTR vid_block, int row, int col));
CWL_VOID           VideoPrintf _PROTO_((char *format, ...));
CWL_VOID           VideoPrintfAttr _PROTO_((int attr, char *format, ...));
VBLOCKPTR          VideoSave _PROTO_((CWLRECT *vRect));
CWL_VOID           VideoRestore _PROTO_((VBLOCKPTR vid_block));
CWL_VOID           VideoWriteString _PROTO_((char *string, int row, int col));
CWL_VOID           VideoWriteStringAttr _PROTO_((char *string, int row, int col, int attr));
CWL_VOID           VideoWriteAttributes _PROTO_((char *string, int row, int col,
                                                 int length));
CWL_VOID           VideoWriteCenterString _PROTO_((char *string, int row));
CWL_VOID           VideoWriteCenterStringAttr _PROTO_((char *string, int row, int attr));
CWL_VOID           VideoWriteCharAndAttr _PROTO_((char *string, int row, int col,
                                                  int length));
CWL_VOID           VideoWriteStringCC _PROTO_((char *string, int row, int col));
CWL_VOID           VideoWriteStringCCAttr _PROTO_((char *string, int row, int col,
                                                   int attr));
CWL_VOID           VideoWriteStringRJ _PROTO_((char *string, int row, int col));
CWL_VOID           VideoWriteStringRJAttr _PROTO_((char *string, int row, int col,
                                                   int attr));
CWL_VOID           VideoReadAttributes _PROTO_((char *buffer, int row, int col,
                                                int length));
CWL_VOID           VideoReadCharacters _PROTO_((char *buffer, int row, int col,
                                                int length));
CWL_VOID           VideoReadCharAndAttr _PROTO_((char *buffer, int row, int col,
                                                 int length));

int                InitializeScanLines _PROTO_((int,int));
int                LoadCharacterSet _PROTO_((int,int));
CWL_VOID           goto_xy _PROTO_((int,int,int));

/* define the keycodes */

/* CWL Key definitions for non-event programming */
#define F1               0x3b00
#define SHIFTF1          0x5400
#define CTRLF1           0x5e00
#define ALTF1            0x6800

#define F2               0x3c00
#define SHIFTF2          0x5500
#define CTRLF2           0x5f00
#define ALTF2            0x6900

#define F3               0x3d00
#define SHIFTF3          0x5600
#define CTRLF3           0x6000
#define ALTF3            0x6a00

#define F4               0x3e00
#define SHIFTF4          0x5700
#define CTRLF4           0x6100
#define ALTF4            0x6b00

#define F5               0x3f00
#define SHIFTF5          0x5800
#define CTRLF5           0x6200
#define ALTF5            0x6c00

#define F6               0x4000
#define SHIFTF6          0x5900
#define CTRLF6           0x6300
#define ALTF6            0x6d00

#define F7               0x4100
#define SHIFTF7          0x5a00
#define CTRLF7           0x6400
#define ALTF7            0x6e00

#define F8               0x4200
#define SHIFTF8          0x5b00
#define CTRLF8           0x6500
#define ALTF8            0x6f00

#define F9               0x4300
#define SHIFTF9          0x5c00
#define CTRLF9           0x6600
#define ALTF9            0x7000

#define F10              0x4400
#define SHIFTF10         0x5d00
#define CTRLF10          0x6700
#define ALTF10           0x7100

#define F11              0x8500
#define SHIFTF11         0x8700
#define CTRLF11          0x8900
#define ALTF11           0x8b00

#define F12              0x8600
#define SHIFTF12         0x8800
#define CTRLF12          0x8a00
#define ALTF12           0x8c00

#define LARROW           0x4b00
#define SHIFTLARROW    '4'
#define CTRLLARROW       0x7300

#define RARROW           0x4d00
#define SHIFTRARROW    '6'
#define CTRLRARROW       0x7400

#define UARROW           0x4800
#define SHIFTUARROW    '8'
#define CTRLUARROW       0x8d00

#define DARROW           0x5000
#define SHIFTDARROW    '2'
#define CTRLDARROW       0x9100

#define GRAY_LARROW      0x4be0
#define GRAY_CTRLLARROW  0x73e0

#define GRAY_RARROW      0x4de0
#define GRAY_CTRLRARROW  0x74e0

#define GRAY_UARROW      0x48e0
#define GRAY_CTRLUARROW  0x8de0

#define GRAY_DARROW      0x50e0
#define GRAY_CTRLDARROW  0x91e0

#define HOME             0x4700
#define GRAY_HOME        0x47e0
#define SHIFTHOME     '7'

#define CTRLHOME         0x7700
#define GRAY_CTRLHOME    0x77e0

#define END              0x4f00
#define SHIFTEND      '1'
#define CTRLEND          0x7500

#define GRAY_END         0x4fe0
#define GRAY_CTRLEND     0x75e0

#define PGUP             0x4900
#define SHIFTPGUP     '9'
#define CTRLPGUP         0x8400

#define GRAY_PGUP        0x49e0
#define GRAY_CTRLPGUP    0x84e0

#define PGDN             0x5100
#define SHIFTPGDN     '3'
#define CTRLPGDN         0x7600

#define GRAY_PGDN        0x51e0
#define GRAY_CTRLPGDN    0x76e0

#define INS              0x5200
#define SHIFTINS      '0'

#define GRAY_INS         0x52e0

#define DEL              0x5300
#define SHIFTDEL      '.'

#define GRAY_DEL         0x53e0

#define ESC           0x1B
#define SHIFTESC      0x1B
#define CTRLESC       0x1B
#define BACKSP        8
#define SHIFTBACKSP   8
#define CTRLBACKSP    127
#define TAB           9
#define SHIFTTAB      0x0F00
#define RETURN        13
#define CTRLRETURN    10

#define GRAY_ENTER     0xe00d
#define GRAY_MINUS     0x4a2d
#define GRAY_PLUS      0x4e2b
#define GRAY_DIVIDE    0xe02f
#define GRAY_MULTIPLY  0x372a

#define CTRLA         1
#define CTRLB         2
#define CTRLC         3
#define CTRLD         4
#define CTRLE         5
#define CTRLF         6
#define CTRLG         7
#define CTRLH         8
#define CTRLI         9
#define CTRLJ         10
#define CTRLK         11
#define CTRLL         12
#define CTRLM         13
#define CTRLN         14
#define CTRLO         15
#define CTRLP         16
#define CTRLQ         17
#define CTRLR         18
#define CTRLS         19
#define CTRLT         20
#define CTRLU         21
#define CTRLV         22
#define CTRLW         23
#define CTRLX         24
#define CTRLY         25
#define CTRLZ         26

#define ALTA          0x1e00
#define ALTB          0x3000
#define ALTC          0x2e00
#define ALTD          0x2000
#define ALTE          0x1200
#define ALTF          0x2100
#define ALTG          0x2200
#define ALTH          0x2300
#define ALTI          0x1700
#define ALTJ          0x2400
#define ALTK          0x2500
#define ALTL          0x2600
#define ALTM          0x3200
#define ALTN          0x3100
#define ALTO          0x1800
#define ALTP          0x1900
#define ALTQ          0x1000
#define ALTR          0x1300
#define ALTS          0x1f00
#define ALTT          0x1400
#define ALTU          0x1600
#define ALTV          0x2f00
#define ALTW          0x1100
#define ALTX          0x2d00
#define ALTY          0x1500
#define ALTZ          0x2c00
#define ALT0          0x8100
#define ALT1          0x7800
#define ALT2          0x7900
#define ALT3          0x7a00
#define ALT4          0x7b00
#define ALT5          0x7c00
#define ALT6          0x7d00
#define ALT7          0x7e00
#define ALT8          0x7f00
#define ALT9          0x8000
#define ALTHYPHEN     0x8200
#define ALTEQUAL      0x8300


/* These keys should be used if porting application to UNIX system */
/* The constant names should match the names that are used in tinfo.h */

#ifdef MSDOS
#define CWLKEY_FN1	   F1
#define CWLKEY_FN2	   F2
#define CWLKEY_FN3	   F3
#define CWLKEY_FN4	   F4
#define CWLKEY_FN5	   F5
#define CWLKEY_FN6	   F6
#define CWLKEY_FN7	   F7
#define CWLKEY_FN8	   F8
#define CWLKEY_FN9	   F9
#define CWLKEY_FN10	   F10
#define CWLKEY_FN11	   F11
#define CWLKEY_FN12	   F12
#define CWLKEY_DOWN        DARROW
#define CWLKEY_UP          UARROW
#define CWLKEY_LEFT        LARROW
#define CWLKEY_RIGHT       RARROW
#define CWLKEY_HOME        HOME
#define CWLKEY_END         END
#define CWLKEY_DELETE      DEL
#define CWLKEY_BACKSPACE   BACKSP
#define CWLKEY_BACKTAB     SHIFTTAB
#define CWLKEY_PAGEDOWN    PGDN
#define CWLKEY_PAGEUP      PGUP
#define CWLKEY_INSERT      INS
#define CWLKEY_CTRLE       CTRLE
#define CWLKEY_ESCAPE      ESC
#define CWLKEY_RETURN      13
#define CWLKEY_TAB         9
#define CWLKEY_CUSTOM      10000
#endif

/* The following keys are used to test the shift state */

#define RSHIFT        1     /* Right Shift key */
#define LSHIFT        2     /* Left Shift key */
#define CTRL          4     /* Control key */
#define ALT           8     /* Alt key */
#define SCRLOCK       16    /* Scroll lock */
#define NUMLOCK       32    /* Num lock    */
#define CAPSLOCK      64    /* Caps Lock   */
#define INSERT        128   /* Insert key  */
#define LCTRL         256   /* Left CTRL key (enhanced keyboard only) */
#define LALT          512   /* Left ALT key (enhanced keyboard only) */
#define RCTRL         1024  /* Right CTRL key (enhanced keyboard only) */
#define RALT          2048  /* Right ALT key */
#define SCRLOCK2      4096  /* Same as SCRLOCK (enhanced keyboard only) */
#define NUMLOCK2      8192  /* Same as NUMLOCK (enhanced keyboard only) */
#define CAPSLOCK2     16384 /* Same as CAPSLOCK (enhanced keyboard only) */
#define SYSREQ        32768 /* SYSREQ (can only be tested with INT 15H) */



/* PC scan codes */

#define SC_ESC                   0x01
#define SC_1                     0x02
#define SC_2                     0x03
#define SC_3                     0x04
#define SC_4                     0x05
#define SC_5                     0x06
#define SC_6                     0x07
#define SC_7                     0x08
#define SC_8                     0x09
#define SC_9                     0x0A
#define SC_0                     0x0B
#define SC_HYPHEN                0x0C
#define SC_EQUAL                 0x0D
#define SC_BS                    0x0E
#define SC_TAB                   0x0F
#define SC_Q                     0x10
#define SC_W                     0x11
#define SC_E                     0x12
#define SC_R                     0x13
#define SC_T                     0x14
#define SC_Y                     0x15
#define SC_U                     0x16
#define SC_I                     0x17
#define SC_O                     0x18
#define SC_P                     0x19
#define SC_LBRACKET              0x1A
#define SC_RBRACKET              0x1B
#define SC_ENTER                 0x1C
#define SC_CTRL                  0x1D
#define SC_A                     0x1E
#define SC_S                     0x1F
#define SC_D                     0x20
#define SC_F                     0x21
#define SC_G                     0x22
#define SC_H                     0x23
#define SC_J                     0x24
#define SC_K                     0x25
#define SC_L                     0x26
#define SC_SCOLON                0x27
#define SC_QUOTE                 0x28
#define SC_ACCENT                0x29
#define SC_LSHIFT                0x2A
#define SC_BSLASH                0x2B
#define SC_Z                     0x2C
#define SC_X                     0x2D
#define SC_C                     0x2E
#define SC_V                     0x2F
#define SC_B                     0x30
#define SC_N                     0x31
#define SC_M                     0x32
#define SC_COMMA                 0x33
#define SC_DOT                   0x34
#define SC_FSLASH                0x35
#define SC_RSHIFT                0x36
#define SC_MULTIPLY              0x37
#define SC_ALT                   0x38
#define SC_SPACE                 0x39
#define SC_CAPSLOCK              0x3A
#define SC_F1                    0x3B
#define SC_F2                    0x3C
#define SC_F3                    0x3D
#define SC_F4                    0x3E
#define SC_F5                    0x3F
#define SC_F6                    0x40
#define SC_F7                    0x41
#define SC_F8                    0x42
#define SC_F9                    0x43
#define SC_F10                   0x44
#define SC_NUMLOCK               0x45
#define SC_SCRLOCK               0x46
#define SC_HOME                  0x47
#define SC_UP                    0x48
#define SC_PGUP                  0x49
#define SC_MINUS                 0x4A
#define SC_LEFT                  0x4B
#define SC_NUMPAD5               0x4C
#define SC_RIGHT                 0x4D
#define SC_ADD                   0x4E
#define SC_END                   0x4F
#define SC_DOWN                  0x50
#define SC_PGDN                  0x51
#define SC_INS                   0x52
#define SC_DEL                   0x53
#define SC_F11                   0x57
#define SC_F12                   0x58

#define SC_LBUTTON               0x60
#define SC_RBUTTON               0x61
#define SC_MBUTTON               0x62

/* Fake scan codes for enhanced keys */
#define FAKE_SCAN                0xE0
#define SC_ENHANCED              (FAKE_SCAN + 0)
#define SC_PRTSCR                (FAKE_SCAN + 1)   /* Made up printscr scan code */


#define ISFKEY(code)      (((code) >= SC_F1 && (code) <= SC_F10) || \
                            (code) == SC_F11 || (code) == SC_F12)

#define SC_NUMPAD0        0x70
#define SC_NUMPAD1        0x71
#define SC_NUMPAD2        0x72
#define SC_NUMPAD3        0x73
#define SC_NUMPAD4        0x74
#define SC_NUMPAD6        0x75
#define SC_NUMPAD7        0x76
#define SC_NUMPAD8        0x77
#define SC_NUMPAD9        0x78


/* virtual keys (compatible with Microsoft Windows) */
#define VK_LBUTTON          0x01
#define VK_RBUTTON          0x02
#define VK_CANCEL           0x03
#define VK_MBUTTON          0x04
#define VK_BACK             0x08
#define VK_TAB              0x09
#define VK_CLEAR            0x0C
#define VK_RETURN           0x0D
#define VK_SHIFT            0x10
#define VK_CONTROL          0x11
#define VK_MENU             0x12
#define VK_PAUSE            0x13
#define VK_CAPITAL          0x14
#define VK_ESCAPE           0x1B
#define VK_SPACE            0x20
#define VK_PRIOR            0x21
#define VK_NEXT             0x22
#define VK_END              0x23
#define VK_HOME             0x24
#define VK_LEFT             0x25
#define VK_UP               0x26
#define VK_RIGHT            0x27
#define VK_DOWN             0x28
#define VK_SELECT           0x29
#define VK_PRINT            0x2A
#define VK_EXECUTE          0x2B
#define VK_SNAPSHOT         0x2C
#define VK_INSERT           0x2D
#define VK_DELETE           0x2E
#define VK_HELP             0x2F

#define VK_0                0x30
#define VK_1                0x31
#define VK_2                0x32
#define VK_3                0x33
#define VK_4                0x34
#define VK_5                0x35
#define VK_6                0x36
#define VK_7                0x37
#define VK_8                0x38
#define VK_9                0x39
#define VK_A                0x41
#define VK_B                0x42
#define VK_C                0x43
#define VK_D                0x44
#define VK_E                0x45
#define VK_F                0x46
#define VK_G                0x47
#define VK_H                0x48
#define VK_I                0x49
#define VK_J                0x4A
#define VK_K                0x4B
#define VK_L                0x4C
#define VK_M                0x4D
#define VK_N                0x4E
#define VK_O                0x4F
#define VK_P                0x50
#define VK_Q                0x51
#define VK_R                0x52
#define VK_S                0x53
#define VK_T                0x54
#define VK_U                0x55
#define VK_V                0x56
#define VK_W                0x57
#define VK_X                0x58
#define VK_Y                0x59
#define VK_Z                0x5A

#define VK_NUMPAD0          0x60
#define VK_NUMPAD1          0x61
#define VK_NUMPAD2          0x62
#define VK_NUMPAD3          0x63
#define VK_NUMPAD4          0x64
#define VK_NUMPAD5          0x65
#define VK_NUMPAD6          0x66
#define VK_NUMPAD7          0x67
#define VK_NUMPAD8          0x68
#define VK_NUMPAD9          0x69
#define VK_MULTIPLY         0x6A
#define VK_ADD              0x6B
#define VK_SEPARATOR        0x6C
#define VK_SUBTRACT         0x6D
#define VK_DECIMAL          0x6E
#define VK_DIVIDE           0x6F
#define VK_F1               0x70
#define VK_F2               0x71
#define VK_F3               0x72
#define VK_F4               0x73
#define VK_F5               0x74
#define VK_F6               0x75
#define VK_F7               0x76
#define VK_F8               0x77
#define VK_F9               0x78
#define VK_F10              0x79
#define VK_F11              0x7A
#define VK_F12              0x7B
#define VK_F13              0x7C
#define VK_F14              0x7D
#define VK_F15              0x7E
#define VK_F16              0x7F
#define VK_F17              0x80
#define VK_F18              0x81
#define VK_F19              0x82
#define VK_F20              0x83
#define VK_F21              0x84
#define VK_F22              0x85
#define VK_F23              0x86
#define VK_F24              0x87
#define VK_NUMLOCK          0x90
#define VK_SCROLL           0x91
#define VK_COMMA            0xBC
#define VK_PERIOD           0xBE

#define VK_LSHIFT           0xC0
#define VK_RSHIFT           0xC1

#define VK_ALT              VK_MENU

#define ST_NUMLOCK          0
#define ST_CAPITAL          1
#define ST_SCROLL           2
#define NUMTOGGLEKEYS       3

#ifdef MSDOS
#define FLUSH_KEYBOARD()       flush_keyboard(CWLenhanced_keyboard?17:1)
#define ISKEYREADY()           key_ready(CWLenhanced_keyboard?17:1)
#define GET_SHIFT_STATE()      bioskbd(2)
#define GET_KEY()              getkeyfunc(0)
#define GET_ENHANCED_KEY()     getkeyfunc(1)
#define ENHANCED_KEYBOARD()    (CWLenhanced_keyboard?1:0)
#endif

#ifdef COHERENT
#define GET_KEY()              CWLtermgetkey()
#define ISKEYREADY()           CWLtermkeyready()
#define GET_ENHANCED_KEY()     GET_KEY()
#define GET_SHIFT_STATE()      (0)
#define FLUSH_KEYBOARD()       CWLtermflushkbd()
#endif


#define OVERSTRIKEMODE      0
#define INSERTMODE          1

#define KEYPRESSED          0
#define MOUSEPRESSED        1


#define UPPERCASE                1
#define LOWERCASE                2
#define CHECKSPACES              4
#define ENHANCEDKEY              8
#define CHECKREGEXP             16
#define AUTORETURN              32
#define CHECKREGEXP_IGNORECASE  64
#define FLUSHBUFFER            128
#define HOMECURSOR             256
#define USEMOUSE               512
#define CLEARFIELD            1024
#define VIRTUALFIELD          2048

#define DONT_PROCESS        0
#define MOVE_CURSOR_LEFT    1
#define MOVE_CURSOR_RIGHT   2
#define DELETE_AT_CURSOR    3
#define TOGGLE_INSERT       4
#define DESTRUCT_BACKSPACE  5
#define ACCEPT_INPUT        6
#define ACCEPT_DEFAULT      7
#define ERASE_INPUT         8
#define GOTO_FIRST          9
#define GOTO_LAST          10
#define INSERT_CHARACTER   11
#define MOVE_TO_CHARACTER  12
#define GOTO_NEXT_FIELD    13
#define GOTO_PREV_FIELD    14
#define EXIT_FORM_ACCEPT   15
#define EXIT_FORM_CLEAR    16
#define CLEAR_FORM         17

#define MOVELEFT_KEY        0
#define MOVERIGHT_KEY       1
#define DELNOMOVE_KEY       2
#define INSTOGGLE_KEY       3
#define ERASE_KEY           4
#define BACKSPACE_KEY       5
#define ACCEPT_KEY          6
#define ACCEPTDEFAULT_KEY   7
#define HOME_KEY            8
#define END_KEY             9

/********************************************
 * Key locations in the CWLform_edit_key array *
 ********************************************/

#define FIELD_MOVELEFT_KEY         MOVELEFT_KEY
#define FIELD_MOVERIGHT_KEY        MOVERIGHT_KEY
#define FIELD_DELNOMOVE_KEY        DELNOMOVE_KEY
#define FIELD_INSTOGGLE_KEY        INSTOGGLE_KEY
#define FIELD_ERASE_KEY            ERASE_KEY
#define FIELD_BACKSPACE_KEY        BACKSPACE_KEY
#define FIELD_ACCEPT_KEY           ACCEPT_KEY
#define FIELD_ACCEPTDEFAULT_KEY    ACCEPTDEFAULT_KEY
#define FIELD_HOME_KEY             HOME_KEY
#define FIELD_END_KEY              END_KEY
#define FIELD_PREVFIELD_KEY        10
#define FIELD_NEXTFIELD_KEY        11
#define FORM_EXIT_ACCEPT_KEY       12
#define FORM_CANCEL_KEY            13
#define FORM_CLEAR_KEY             14
#define FIELD_TOGGLE_KEY           15

#define RADIO_PREVENTRY_KEY        16
#define RADIO_NEXTENTRY_KEY        17
#define RADIO_NEXTFIELD_KEY        18
#define RADIO_PREVFIELD_KEY        19

#define CHECKBOX_CHOICE_KEY        20
#define CHECKBOX_PREVENTRY_KEY     21
#define CHECKBOX_NEXTENTRY_KEY     22
#define CHECKBOX_NEXTFIELD_KEY     23
#define CHECKBOX_PREVFIELD_KEY     24

#define BUTTON_ACCEPT_KEY          25
#define BUTTON_PREVFIELD_KEY       26
#define BUTTON_NEXTFIELD_KEY       27

#define LIST_UP_KEY              28
#define LIST_DOWN_KEY            29
#define LIST_ACCEPT_KEY          30
#define LIST_HOME_KEY            31
#define LIST_END_KEY             32
#define LIST_PAGEUP_KEY          33
#define LIST_PAGEDOWN_KEY        34
#define LIST_NEXTFIELD_KEY       35
#define LIST_PREVFIELD_KEY       36


#define FIELD_CONTINUE         DONT_PROCESS
#define FIELD_MOVELEFT         MOVE_CURSOR_LEFT
#define FIELD_MOVERIGHT        MOVE_CURSOR_RIGHT
#define FIELD_DELNOMOVE        DELETE_AT_CURSOR
#define FIELD_INSTOGGLE        TOGGLE_INSERT
#define FIELD_BACKSPACE        DESTRUCT_BACKSPACE
#define FIELD_ACCEPT           ACCEPT_INPUT
#define FIELD_ACCEPTDEFAULT    ACCEPT_DEFAULT
#define FIELD_ERASEINPUT       ERASE_INPUT
#define FIELD_GOTOFIRST        GOTO_FIRST
#define FIELD_GOTOLAST         GOTO_LAST
#define FIELD_INSERTCHAR       INSERT_CHARACTER
#define FIELD_MOVE_TO_CHARACTER MOVE_TO_CHARACTER
#define FIELD_NEXTFIELD        GOTO_NEXT_FIELD
#define FIELD_PREVFIELD        GOTO_PREV_FIELD
#define FORM_ACCEPT            EXIT_FORM_ACCEPT
#define FORM_CANCEL            EXIT_FORM_CLEAR
#define FORM_CLEAR             CLEAR_FORM


#define FORM_END                18
#define FIELD_REEDIT            19
#define FIELD_NEWFIELD          20
#define FIELD_PROCESS_DATA      21
#define FIELD_CONTINUE_PROCESS  22
#define FORM_REEDIT             23
#define FIELD_EDIT              24
#define FORM_END_PROCESS        25
#define LIST_MOVE_UP            26
#define LIST_MOVE_DOWN          27
#define LIST_ACCEPT             28
#define LIST_PAGEUP             29
#define LIST_PAGEDOWN           30
#define LIST_HOME               31
#define LIST_END                32


#define NO_HELP                 (-1)





unsigned      bioskbd _PROTO_((int));
int           GetEnhancedKeyboard _PROTO_((CWL_VOID ));
#ifdef MSDOS
unsigned      getkeyfunc _PROTO_((int));
#endif
int           key_ready _PROTO_((int));
CWL_VOID      flush_keyboard _PROTO_((int));
unsigned      process_keyval _PROTO_((int));
int           CWLcheck_form_help _PROTO_((unsigned));
CWL_VOID      StartKeyboardEvent _PROTO_((CWL_VOID ));
CWL_VOID      EndKeyboardEvent _PROTO_((CWL_VOID ));
CWL_VOID      CWLQuitMessage _PROTO_((CWL_VOID ));


/* define error messages */
/******************** Window Error Codes*****************/
#define NO_ERROR            0

#define NO_HEAP_MEM        (-1)
#define BAD_DISPLAY_PAGE   (-2)
#define INVALID_VIDEO_MODE (-3)
#define INVALID_ROWS       (-4)
#define NOT_SUPPORTED      (-5)

#define BAD_WINDOW         (-100)
#define BAD_WINDOW_SIZE    (-101)
#define WINDOW_NOT_OPEN    (-102)
#define WINDOW_BOUND       (-103)
#define MAX_WINDOW         (-104)
#define WINDOW_INV_PARAM   (-105)
#define NO_INPUT_CHARS     (-106)
#define TOO_MANY_CHARS     (-107)

#define BAD_V_WINDOW       (-200)
#define END_V_WINDOW       (-201)
#define V_WINDOW_BOUND     (-202)
#define MAX_V_WINDOW       (-203)
#define NO_ATTRIB          (-204)

#define FILE_NO_EXIST      (-300)
#define FILE_CANT_CLOSE    (-301)
#define FILE_CANT_OPEN     (-302)


#define MENU_ENTRY_INVALID  (-400)
#define POPUP_VHEIGHT_ERROR (-401)
#define POPUP_VWIDTH_ERROR  (-402)
#define BAR_WWIDTH_ERROR    (-403)
#define BAR_WHEIGHT_ERROR   (-404)
#define POPUP_NOT_ATTACHED  (-405)
#define BAR_NOT_ATTACHED    (-406)
#define PULL_NO_BARMENU     (-407)
#define POPUP_MENU_INVALID  (-408)
#define BAR_MENU_INVALID    (-409)
#define PULLDOWN_MENU_INVALID (-410)
#define NO_ENTRIES_DEFINED  (-411)



#define NO_FIELDS_DEFINED    (-500)
#define UNDEFINED_FORM       (-501)
#define UNDEFINED_FIELD      (-502)
#define FIELD_MINCHARS_ERROR (-503)
#define FIELD_REGEXP_ERROR   (-504)
#define FIELD_RANGE_ERROR    (-505)
#define INVALID_FIELD_OPTION (-506)
#define FIELD_NOT_IN_VIEW    (-507)
#define NO_FIELD_HELP        (-508)
#define FIELDTYPE_NOT_SUPPORTED (-509)
#define HELP_NOT_SUPPORTED   (-510)
#define VFORM_NOT_SUPPORTED  (-511)
#define WRONG_FIELDTYPE      (-512)
#define HELP_NOT_ON          (-513)


#define NO_USER_HOTSPOTS     (-600)
#define HOTSPOT_NOT_DEFINED  (-601)
#define NO_DEFAULT_HOTSPOTS  (-602)
#define NO_CAPTION           (-603)

#define NO_TIMERS            (-603)
#define INVALID_TIMEID       (-604)

#define TERM_ENVIRONMENT     (-700)
#define TERMINAL_NOT_FOUND   (-701)
#define TERMINFO_NOT_FOUND   (-702)
#define TERMINAL_CLOSE_ERROR (-703)
#define TERMINAL_OPEN_ERROR  (-704)
#define TERMKEY_NOT_FOUND    (-705)

#define NUM_WINDOW_ERRORS  48
/**********************  End of Error Codes ************************/

/* define constants that non MS-DOS systems will use for output */
#define CLEAR_SCREEN      0
#define CURSOR_GETPOS     1
#define CURSOR_SETPOS     2
#define CHAR_ATTR         3
#define READ_WRITE_MATRIX 4
#define CHAR_ATTR_VERT    5
#define CURSOR_OFF        6
#define CURSOR_ON         7
#define BLINK_MODE	  8
#define BOLD_MODE         9
#define STANDOUT_MODE    10
#define UNDERLINE_MODE   11
#define EXIT_BLINK_MODE	 12
#define EXIT_STANDOUT_MODE 13
#define EXIT_BOLD_MODE   14
#define EXIT_UNDERLINE_MODE   15
#define CHAR_NOATTR_NULL  16
#define CHAR_NOATTR	17
#define CHAR_ATTR_1_NULL 18
#define CURSOR_SAVE_POS  19
#define CURSOR_RESTORE_POS 20
#define SCROLL_UP	21
#define SCROLL_DOWN	22
#define KEYPAD_ON       23
#define KEYPAD_OFF      24

/**********************  Cursor Definitions ************************/
#define CREATE_CURSOR_SHAPE(beginline,endline)  ((beginline)<<4+(endline))
#define THIN          0
#define BLOCK         1
#define HALFBLOCK     2
#define INVISIBLE     3

/**********************  Testing Constants *************************/
#define NO_RELATION        0
#define PARENT_CHILD       1
#define CHILD_PARENT       2
#define PARENT_DESCENDANT  3
#define DESCENDANT_PARENT  4
#define SIBLING_WINDOWS    5


CWL_VOID  GetCursorShape _PROTO_((unsigned *, unsigned *));
CWL_VOID  ChangeCursor _PROTO_((unsigned, unsigned));
CWL_VOID  BlockCursor _PROTO_((CWL_VOID ));
CWL_VOID  ThinCursor _PROTO_((CWL_VOID ));
CWL_VOID  HideCursor _PROTO_((CWL_VOID ));
CWL_VOID  HalfblockCursor _PROTO_((CWL_VOID ));

#define SOURCE_LINE   __LINE__
#define SOURCE_FILE   __FILE__

/* define window manifest constants and functions */

#define WIN_NULL_PTR    ((WPOINTER)0)   /* Null Window Pointer */
#define VWIN_NULL_PTR   ((VWPOINTER)0)  /* Null virtual window pointer */
#define VBLOCK_NULL_PTR ((VBLOCKPTR)0)  /* Null video block pointer */

/* Other defines */

#define SAVE          0
#define RESTORE       1

#define BORDER        1
#define NOBORDER      0

#define NOATTRIBUTE 0
#define ATTRIBUTE   1

#ifndef TRUE
#define TRUE          1
#endif

#ifndef FALSE
#define FALSE         (!TRUE)
#endif

#define MAXWIDTH         140     /* Maximum width of the screen in columns */
#define MAXCOLS          140     /* Maximum columns in a normal window */
#define NUMEDITKEYS      12      /* Number of field edit keys */

#define MAXHEIGHT     80      /* Maximum height of a normal window */
#define MAXBUFSIZE    1024    /* Maximum internal write buffer size */

#define DMA           1       /* Direct Screen write */
#define BIOS          0       /* BIOS screen write */

#define WRAP          1       /* Wrap flag in window */
#define CLIP          0       /* Clip output in window */

#define ANCHORLEFT    1
#define ANCHORRIGHT   2
#define ANCHORTOP     1
#define ANCHORBOTTOM  2

#define WINDOW_HIDDEN_RANK  (-1)

#define UP            1
#define DOWN          2
#define LEFT          3
#define RIGHT         4

#define MAXTAB        50      /* Maximum tab size in windows */
#define DEFTAB        4       /* Default tab size */

#define NO_OPTIONS     0      /* Constant defining no options */

#define MAXPAGES      16      /* Maximum number of video pages */
#define MAXWINDOWS    32767   /* Maximum windows including base screen */

#define SHADOWUPLEFT   1      /* Shadow position */
#define SHADOWUPRIGHT  2      /*       "         */
#define SHADOWLOWLEFT  3      /*       "         */
#define SHADOWLOWRIGHT 4      /*       "         */

#define WINDOWCHECK    1      /* Check constant  */
#define VWINDOWCHECK   2      /* Check constant  */

/* Explosion effects */
#define NOEFFECT       0
#define EXPLODE        1
#define CONTRACT       2
#define BRICKS         3
#define MIDDLEROWOUT   4
#define TOPBOTTOMIN    5
#define TOPDOWN        6
#define BOTTOMUP       7
#define MIDDLECOLOUT   8
#define LEFTRIGHTIN    9
#define LEFTTORIGHT   10
#define RIGHTTOLEFT   11
#define SLIDELEFT     12
#define SLIDERIGHT    13
#define SLIDEDOWN     14
#define SLIDEUP       15

#define MAX_SPECIAL_EFFECT  15

/*** Colors used as macros ***/

#define BLACK_        0
#define BLUE_         1
#define GREEN_        2
#define CYAN_         3
#define RED_          4
#define MAGENTA_      5
#define BROWN_        6
#define WHITE_        7
#define GRAY_         8
#define LIGHTBLUE_    9
#define LIGHTGREEN_   10
#define LIGHTCYAN_    11
#define LIGHTRED_     12
#define LIGHTMAGENTA_ 13
#define YELLOW_       14
#define LIGHTWHITE_   15

#ifdef MSDOS
#define UNDERLINE_    BLUE_       /* use as foreground */

#if 0
#define BRIGHT_       LIGHTBLUE_  /* use as foreground */
#define BLINK_        LIGHTBLUE_  /* use as background */
#endif

#endif

#ifdef MSDOS
/* Macros for monochrome colors */
#define BRIGHT_        8
#define BLINK_         8
#endif

/* Macros for COHERENT / UNIX */

#ifdef COHERENT
#define BLINK_     8
#define BOLD_      8
#endif

/* Constants used for centering a window */
#define HORIZCENTER   1
#define VERTCENTER    2

/* Constants used when copying window */
#define COPYTEXT      1
#define MAKEVIEWPORT  2

/* define is... macros */
#define ISBORDER(w)          (int) (((w)->stat_info.border_flag)?1:0)
#define ISWRAP(w)            (int) (((w)->stat_info.wrap_flag)?1:0)
#define ISOPEN(w)            (int) (((w)->stat_info.open_flag)?1:0)
#define ISVISIBLE(w)         (int) (((w)->stat_info.visible_flag)?1:0)
#define ISVIEWPORT(w)        (int) (((w)->stat_info.v_window_flag)?1:0)
#define ISWINDOW(vw)         (int) (((vw)->stat_info.viewport_flag)?1:0)
#define ISSEETHRU(w)         (int) (((w)->stat_info.seethru_flag)?1:0)
#define ISINITIAL(w)         (int) (((w)->stat_info.init_flag)?1:0)
#define ISFROZEN(w)          (int) (((w)->stat_info.frozen_flag)?1:0)
#define ISSHADOW(w)          (int) \
                              (((w)->shadow_info.shadow_stat.shadow_flag)?1:0)
#define ISSHADOWTRANS(w)     (int) ((ISSHADOW(w) && \
                             SHADOW_WINDOW(w)->stat_info.shadow_trans)?1:0)

#define TRANSPARENT_WINDOW(w) (int) ((w)->stat_info.shadow_trans)

/* The following macros are title macros */
#define ISNULLCHAR(s)        (((s) == (char *)0) || (*(s) == '\0'))
#define WINDOW_TITLE_TOP(w)       ((w)->title_info.titletop)
#define WINDOW_TITLE_BOTTOM(w)    ((w)->title_info.titlebot)
#define WINDOW_TITLE_TOP_COLOR(w)       ((w)->title_info.titletop_attr)
#define WINDOW_TITLE_BOTTOM_COLOR(w)    ((w)->title_info.titlebot_attr)

#define ISTITLE_TOP(w)        (int) (ISNULLCHAR(WINDOW_TITLE_TOP(w))?0:1)

#define WINDOW_TITLE_TOP_POS(w)  (int) \
                             (ISTITLE_TOP(w)?(w)->title_info.titletop_pos:0)

#define ISTITLE_BOTTOM(w)     (int) (ISNULLCHAR(WINDOW_TITLE_BOTTOM(w))?0:1)

#define WINDOW_TITLE_BOTTOM_POS(w)  (int) \
                             (ISTITLE_BOTTOM(w)?(w)->title_info.titlebot_pos:0)

#define ISTITLE(w)           (int) (ISTITLE_TOP(w) || ISTITLE_BOTTOM(w))

#define TITLECENTER          1
#define TITLELEFT            2
#define TITLERIGHT           3
#define TITLETOP             4
#define TITLEBOTTOM          5

/***************************************************/

/* Shadow macros */
#define SHADOW_POS(w)        (int)(((w)->shadow_info.shadow_stat.shadow_pos))
#define SHADOW_CHAR(w)       (int)(((w)->shadow_info.schar))
#define SHADOW_ATTR(w)       (int)(((w)->shadow_info.sattr))
#define SHADOW_WIDTH(w)      (int)(((w)->shadow_info.swidth))
#define SHADOW_HEIGHT(w)     (int)(((w)->shadow_info.sheight))


#define VWTYPE(vw)      (int) ((vw)->stat_info.vwtype)
#define VWWRAP(vw)      (vw)->stat_info.wrap_flag

#define EDGES(w)              ((int)((ISBORDER((w))?2:0)))
#define EDGEDIF(w)            ((int)((ISBORDER((w))?1:-1)))

#define WLASTROW(w)           get_last_row(w)

#define WLASTCOL(w)           get_last_col(w)

/* Existence macros */
#define WINDOW_EXIST(w)   ((CWLfind_object(CWLwindow_object,(w)) == -1 \
                             || (!w))?0:1)

#define VIRTUAL_WINDOW_EXIST(vw) ((CWLfind_object(CWLvwindow_object,(vw)) == -1 \
                                    || (!vw))?0:1)

/* General window macros */

#define DESKTOP_WINDOW               ((WPOINTER)1)
#define DESKTOP_PAGE_WINDOW(x)       ((WPOINTER)((x) + 1))

#define VIEWPORT_ROW(w)              ((w)->vwrow)
#define VIEWPORT_COLUMN(w)           ((w)->vwcol)
#define VIRTUAL_WINDOW(w)            ((w)->vwptr)
#define WINDOW_RANK(w)               ((w)->rank)
#define WINDOW_TEXT_COLOR(w)         ((w)->wattr)
#define WINDOW_BORDER_COLOR(w)       ((w)->battr)
#define WINDOW_PAGENUM(w)            ((w)->pagenum)
#define WINDOW_WIDTH(w)              ((w)->width)
#define WINDOW_HEIGHT(w)             ((w)->height)
#define SHADOW_WINDOW(w)             ((w)->shadow_window)
#define SHADOW_USE(w)                ((w)->stat_info.shadow_use)
#define CHILD_ENUM(w)                ((w)->stat_info.child_enum)
#define WINDOW_ROW(w)                ((w)->row)
#define WINDOW_FIRST_ROW(w)          ((w)->first_row)
#define WINDOW_TEXTAREA_HEIGHT(w)    ((w)->height - (w)->first_row)
#define WINDOW_TEXTAREA_WIDTH(w)     ((w)->width)
#define WINDOW_NCHEIGHT(w)           (WINDOW_HEIGHT(w) - \
                                      WINDOW_TEXTAREA_HEIGHT(w) + ISBORDER(w))
#define WINDOW_NCWIDTH(w)            (ISBORDER(w))
#define WINDOW_TOTAL_HEIGHT(w)       ((w)->height + EDGES(w))
#define WINDOW_TOTAL_WIDTH(w)        ((w)->width + EDGES(w))
#define WINDOW_PARENT(w)             ((w)->parent)
#define BASEPARENT(w)                ((w)->baseparent)
#define ABS_SCREEN_ROW(w)            ((w)->srow)
#define ABS_SCREEN_COL(w)            ((w)->scol)

#define WINDOWPTR(i)        ((WPOINTER)(CWLwindow_object->objarray[i]))

#define FIND_WINDOWPTR(w)   (CWLfind_object(CWLwindow_object,(w)))

#define ADD_WINDOWPTR(w)    (CWLadd_object(CWLwindow_object,(w)))

#define DELETE_WINDOWPTR(w) (CWLdelete_object(CWLwindow_object, \
                                              FIND_WINDOWPTR(w)))

#ifdef POWERC
  int WINDOW_COLUMN(WPOINTER w);
#else
  #define WINDOW_COLUMN(w)             ((w)->col)
#endif

#define WINDOW_BORDER_CHARS(w)       ((w)->boxchars)
#define VIRTUAL_TEXT_COLOR(vw)       ((vw)->attr)
#define VIRTUAL_WIDTH(vw)            ((vw)->ncols)
#define VIRTUAL_HEIGHT(vw)           ((vw)->nrows)
#define VIRTUAL_ATTRIBUTE_ON(vw)     ((vw)->stat_info.vwtype)
#define VWINDOW_COORD_IN_VIEWPORT(w,row,col) \
                                   ((((col) >= (w)->vwcol) && \
                                   ((col) <= (w)->vwcol+(w)->width-1) && \
                                   ((row) >= (w)->vwrow) && \
                                   ((row) <= (w)->vwrow+(w)->height-1))?1:0)

#define WINDOW_USE(w)              ((w)->stat_info.use_flag)

/* miscellaneous macros */
#define SCROLL_BOTTOM      1
#define SCROLL_SIDE        2

#define POPUP_USE            1
#define BAR_USE              2
#define FORM_USE             3
#define HIWORD(x)            ((long)((long)(x) >> 16))
#define LOWORD(x)            ((long)((long)(x) & 0x0000FFFF))
#define LOBYTE(w)            ((unsigned char)(w))
#define HIBYTE(w)            ((unsigned char)((unsigned)(w) >> 8))
#define MAKELONG(low, high)  ((unsigned long)(((unsigned)(low)) | \
                             (((unsigned long)((unsigned)(high))) << 16)))
#ifdef MSDOS
#define SETNULLFUNC(x)       memset((CWL_VOID **)&(x),0,sizeof(NULLFN))
#else
#define SETNULLFUNC(x)       memset((char **)&(x),0,sizeof(NULLFN))
#endif

#define UPDATE_CHILDREN    0
#define HIDE_CHILDREN      1
#define CHILD_ADD_COL      2
#define CHILD_ADD_ROW      3
#define REPLACE_CHILDREN   4
#define MOVE_RELATIVE_X    5
#define MOVE_RELATIVE_Y    6
#define HIGH_LEVEL_HIDE    7
#define HIGH_LEVEL_DISPLAY 8
#define INITIALIZE_POSITION 9
#define RERANK_CHILDREN    10
#define CHILD_ADD_SROW     11
#define CHILD_ADD_SCOL     12
#define CHILD_MOVE_VERT    13
#define CHILD_MOVE_HORZ    14
#define CLOSE_CHILDREN     15
#define CHILD_PAINT_SEETHRU 16


/* Virtual Window Panning Keys */

#define  VPAN_RIGHT     0
#define  VPAN_LEFT      1
#define  VPAN_DOWN      2
#define  VPAN_UP        3
#define  VPAN_PGDN      4
#define  VPAN_PGUP      5
#define  VPAN_HOME      6
#define  VPAN_END       7
#define  VPAN_ELINE     8
#define  VPAN_BLINE     9
#define  VPAN_PGRT      10
#define  VPAN_PGLT      11
#define  VPAN_QUIT      12

#define NUMVPANKEYS     13
#define DEFAULTPANKEYS  ((unsigned int *)0)



 /*****************************
  * Define external variables *
  ****************************/


/* Miscellaneous Routines */
CWL_VOID      AdjustGlobalData _PROTO_((CWL_VOID ));
int           AdjustScreenInfo _PROTO_((int page));
VOIDPTR       Allocate2DArray _PROTO_((int rows, int cols, int size));
char *        ParseEntryName _PROTO_((char *str, char *outstr));
char *        CharToString _PROTO_((int));
char *        CreateRepeatedString _PROTO_((char *str, int num));
CWL_VOID      Free2DArray _PROTO_((VOIDPTR *array));
int           RegExpStringLength _PROTO_((char *regexp));
char *        RegExpString _PROTO_((char *regexp, char *buffer, int *reverse));
CWL_VOID      MakeSound _PROTO_((unsigned freq, unsigned millisec));


int           TranslateCaptionPosToWindowPos _PROTO_((WPOINTER w, int crow,
                                 int ccol, int *wrow, int *wcol));
char *        TranslateMaskStringToString _PROTO_((char *str, char *mask, char *str2,
                                             int mchar));
char *        TranslateStringToMaskString _PROTO_((char *str, char *mask, char *str2,
                                             int mchar, int flag));
int           TranslateMaskPosToStringPos _PROTO_((char *, int, int));

int           TranslateStringPosToMaskPos _PROTO_((char *, int, int));
int           TranslateVirtualPosToWindowPos _PROTO_((WPOINTER w, unsigned r,
                                                unsigned c, int *wr, int *wc));
int           TranslateWindowPosToVirtualPos _PROTO_((WPOINTER w, int r, int c,
                                                unsigned *wr, unsigned *wc));
int           VirtualClear _PROTO_((VWPOINTER vw));
int           VirtualClearAttr _PROTO_((VWPOINTER vw, int attr));
int           VirtualClearRegion _PROTO_((VWPOINTER vw, unsigned urow, unsigned ucol,
                                    unsigned lrow, unsigned lcol));
int           VirtualClearRegionAttr _PROTO_((VWPOINTER vw, unsigned urow,
                                        unsigned ucol, unsigned lrow,
                                        unsigned lcol, int attr));
int           VirtualClose _PROTO_((VWPOINTER vw, int hideflag, int effect));
int           VirtualGetCursorPosition _PROTO_((VWPOINTER vw, unsigned *row,
                                          unsigned *col));
VWPOINTER     VirtualInitialize _PROTO_((int vwtype, unsigned nrows, unsigned ncols,
                                   int attr));
int           VirtualMoveCursor _PROTO_((VWPOINTER vw, unsigned row, unsigned col));
int           VirtualPrintf _PROTO_((VWPOINTER vw, char *format, ...));
int           VirtualPrintfAttr _PROTO_((VWPOINTER vw, int attr, char *format, ...));
int           VirtualReadAttributes _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                       unsigned col, unsigned length));
int           VirtualReadCharacters _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                       unsigned col, unsigned length));
int           VirtualReadCharAndAttr _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                        unsigned col, unsigned length));
int           VirtualResize _PROTO_((VWPOINTER *vw, unsigned nrows, unsigned ncols));
int           VirtualSetWrap _PROTO_((VWPOINTER vw, int wrapflag));
int           VirtualWriteAttributes _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                        unsigned col, unsigned length));
int           VirtualWriteCenterString _PROTO_((VWPOINTER vw, char *string,
                                          unsigned row));
int           VirtualWriteCenterStringAttr _PROTO_((VWPOINTER vw, char *string,
                                              unsigned row, int attr));
int           VirtualWriteCharacters _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                        unsigned col, unsigned length));
int           VirtualWriteCharactersAttr _PROTO_((VWPOINTER w, char *buffer,
                                            unsigned row, unsigned col,
                                            int attr, unsigned length));
int           VirtualWriteCharAndAttr _PROTO_((VWPOINTER vw, char *buffer, unsigned row,
                                         unsigned col, unsigned length));
int           VirtualWriteRepeatAttribute _PROTO_((VWPOINTER vw, int attr, unsigned row,
                                             unsigned col, unsigned length));
int           VirtualWriteRepeatCharacter _PROTO_((VWPOINTER vw, int ch, unsigned row,
                                             unsigned col, unsigned length));
int           VirtualWriteString _PROTO_((VWPOINTER vw, char *string, unsigned row,
                                    unsigned col));
int           VirtualWriteStringAttr _PROTO_((VWPOINTER vw, char *string, unsigned row,
                                        unsigned col, int attr));
int           VirtualWriteStringCC _PROTO_((VWPOINTER vw, char *string, unsigned row,
                                      unsigned col));
int           VirtualWriteStringCCAttr _PROTO_((VWPOINTER vw, char *string,
                                          unsigned row, unsigned col, int attr));
int           VirtualWriteStringRJ _PROTO_((VWPOINTER vw, char *string, unsigned row,
                                            unsigned col));
int           VirtualWriteStringRJAttr _PROTO_((VWPOINTER vw, char *string,
                                          unsigned row, unsigned col, int attr));
int           VirtualWriteTextToFile _PROTO_((VWPOINTER vw, char *filename, int mode));

/* Window Functions */
int           WindowAllocUserBytes _PROTO_((WPOINTER w, int numbytes));
int           WindowAssignToVirtual _PROTO_((WPOINTER w, VWPOINTER vw, unsigned row,
                                       unsigned col));
int           WindowCenter _PROTO_((WPOINTER w, int options));
int           WindowChangeCursor _PROTO_((WPOINTER w, int shape));
int           WindowChangeBorderAttribute _PROTO_((WPOINTER w, int attr));
int           WindowChangeTextAttribute _PROTO_((WPOINTER w, int attr));
int           WindowClear _PROTO_((WPOINTER w));
int           WindowClearAttr _PROTO_((WPOINTER w, int attr));
int           WindowClearRegion _PROTO_((WPOINTER w, int urow, int ucol, int lrow,
                                   int lcol));
int           WindowClearRegionAttr _PROTO_((WPOINTER w, int urow, int ucol, int lrow,
                                       int lcol, int attr));

int           WindowClearEOL _PROTO_((WPOINTER w, int row, int col));
int           WindowClearBOL _PROTO_((WPOINTER w, int row, int col));
int           WindowClearEOLAttr _PROTO_((WPOINTER w, int row,
                                          int col, int attr));
int           WindowClearBOLAttr _PROTO_((WPOINTER w, int row, int col,
                                          int attr));
int           WindowClearLine _PROTO_((WPOINTER w, int row));
int           WindowClearLineAttr _PROTO_((WPOINTER w, int row, int attr));


int           WindowClose _PROTO_((WPOINTER w, int effect));
int           WindowCloseAll _PROTO_((int page, int effect));
int           WindowCloseViewport _PROTO_((WPOINTER w, int hide, int effect));
int           WindowCompareRank _PROTO_((WPOINTER w1, WPOINTER w2));
WPOINTER      WindowCopy _PROTO_((WPOINTER w, int row, int col, int options));
int           WindowDisplay _PROTO_((WPOINTER w, int rank, int effect));
int           WindowDrawBox _PROTO_((WPOINTER w, int urow, int ucol, int lrow,
                               int lcol, char *box));
int           WindowDrawBoxAttr _PROTO_((WPOINTER w, int urow, int ucol, int lrow,
                                   int lcol, char *box, int attr));
int           WindowDrawBorder _PROTO_((WPOINTER w, char *box));
int           WindowDrawShadow _PROTO_((WPOINTER w, int spos, int swidth,
                                  int sheight, int schar, int sattr, int tflag));
int           WindowEnumChildren _PROTO_((WPOINTER parent,
                                          CWLENUMPROC enumproc,
                                          long lParam));
int           WindowFill _PROTO_((WPOINTER w, int ch));
int           WindowFreeze _PROTO_((WPOINTER w, int flag));
int           WindowFreeUserBytes _PROTO_((WPOINTER w));

int           WindowGetCursorPosition _PROTO_((WPOINTER w, int *row, int *col));

int           WindowGetMaskPassword _PROTO_((WPOINTER w, int row, int col,
                                       char *buffer, char *mask, int fillchar,
                                       int passchar, int minchars, int maxwidth,
                                       long options, int startpos, char *regexp));

int           WindowGetMaskPasswordAttr _PROTO_((WPOINTER w, int row, int col,
                                           char *buffer, char *mask,
                                           int fillchar, int passchar,
                                           int minchars, int maxwidth,
                                           long options, int startpos,
                                           int attr, char *regexp));

int           WindowGetMaskString _PROTO_((WPOINTER w, int row, int col, char *buffer,
                                     char *mask, int fillchar, int minchars,
                                     int maxwidth, long options,
                                     int startpos, char *regexp));

int           WindowGetMaskStringAttr _PROTO_((WPOINTER w, int row, int col,
                                         char *buffer, char *mask, int fillchar,
                                         int minchars, int maxwidth,
                                         long options, int startpos,
                                         int attr, char *regexp));

int           WindowGetPassword _PROTO_((WPOINTER w, int row, int col, char *buffer,
                                   int fillchar, int passchar, int minchars,
                                   int maxwidth, long options,
                                   int startpos, char *regexp));

int           WindowGetPasswordAttr _PROTO_((WPOINTER w, int row, int col,
                                       char *buffer, int fillchar, int passchar,
                                       int minchars, int maxwidth, long options,
                                       int startpos, int attr, char *regexp));

int           WindowGetString _PROTO_((WPOINTER w, int row, int col, char *buffer,
                                 int fillchar, int minchars, int maxwidth,
                                 long options, int startpos, char *regexp));

int           WindowGetStringAttr _PROTO_((WPOINTER w, int row, int col, char *buffer,
                                     int fillchar, int minchars, int maxwidth,
                                     long options, int startpos, int attr,
                                     char *regexp));

int           WindowHide _PROTO_((WPOINTER w, int effect));
WPOINTER      WindowInitialize _PROTO_((WPOINTER parent,int bordflag, int rows,
                                        int cols, int width,
                                        int height, int wattr, int battr,
                                        char *box));

int           WindowInitializeSystem _PROTO_((CWL_VOID));
int           WindowIsChild _PROTO_((WPOINTER parent, WPOINTER child));
int           WindowIsDescendant _PROTO_((WPOINTER w1, WPOINTER w2));
int           WindowIsRelated _PROTO_((WPOINTER w1, WPOINTER w2));
int           WindowIsSibling _PROTO_((WPOINTER w1, WPOINTER w2));
int           WindowSetParent _PROTO_((WPOINTER parent, WPOINTER child,
                                       int rank, int row, int col));
WPOINTER      WindowGetParent _PROTO_((WPOINTER w));

CWL_VOID      CWLDesktopToClient    _PROTO_((WPOINTER w, CWLPOINT * point));
CWL_VOID      CWLClientToDesktop    _PROTO_((WPOINTER w, CWLPOINT * point));
CWL_VOID      CWLMapWindowPoints    _PROTO_((WPOINTER w, WPOINTER w2,
                                          CWLPOINT * point, unsigned numpts));
CWL_VOID      CWLMouseToScreen   _PROTO_((CWLPOINT *pt));
CWL_VOID      CWLScreenToMouse   _PROTO_((CWLPOINT *pt));
CWL_VOID      CWLMouseToClient   _PROTO_((WPOINTER w, CWLPOINT *p));
CWL_VOID      CWLClientToMouse   _PROTO_((WPOINTER w, CWLPOINT *p));
CWL_VOID      CWLVirtualToClient _PROTO_((WPOINTER w, CWLPOINT *pt));
CWL_VOID      CWLClientToVirtual _PROTO_((WPOINTER w, CWLPOINT *pt));
int           CWLGetClientRect   _PROTO_((WPOINTER w, CWLRECT *r));
unsigned      CWLGetRectArea _PROTO_((CWLRECT *r));
int           CWLGetWindowRect   _PROTO_((WPOINTER w, CWLRECT *r));
int           CWLPointInRect     _PROTO_((CWLRECT *r, CWLPOINT *p));
int           CWLGetVisibleWindowRect _PROTO_((WPOINTER w, CWLRECT *r));
int           CWLGetIntersectRect _PROTO_((CWLRECT *r, CWLRECT *result,
                                           int numrects));
int           CWLDefWindowProc   _PROTO_((WPOINTER w, int message,
                                          int wParam, long lParam));

int           get_last_row _PROTO_((WPOINTER w));
int           get_last_col _PROTO_((WPOINTER w));
int           AbsoluteWindowRow _PROTO_((WPOINTER w, int row));
int           AbsoluteWindowCol _PROTO_((WPOINTER w, int col));
int           AbsoluteWindowCol _PROTO_((WPOINTER w, int col));

int           WindowMakeNormal _PROTO_((WPOINTER w));
int           WindowMakeSeeThru _PROTO_((WPOINTER w));
int           WindowMove _PROTO_((WPOINTER w, int row, int col));
int           WindowMoveCursor _PROTO_((WPOINTER w, int row, int col));
int           WindowMoveViewportCursor _PROTO_((WPOINTER w, unsigned row,
                                          unsigned col));
int           WindowOpen _PROTO_((WPOINTER w));
int           WindowPanViewport _PROTO_((WPOINTER w, unsigned int *VPanKeys));
int           WindowPositionViewport _PROTO_((WPOINTER w, unsigned row, unsigned col));
int           WindowPrintf _PROTO_((WPOINTER w, char *format, ...));
int           WindowPrintfAttr _PROTO_((WPOINTER w, int attr, char *format, ...));
int           WindowReadCharacters _PROTO_((WPOINTER w, char *buffer, int row,
                                      int col, int length));
int           WindowReadAttributes _PROTO_((WPOINTER w, char *buffer, int row,
                                      int col, int length));
int           WindowReadCharAndAttr _PROTO_((WPOINTER w, char *buffer, int row,
                                       int col, int length));
int           WindowRemoveBorder _PROTO_((WPOINTER w));
int           WindowRemoveShadow _PROTO_((WPOINTER w));
int           WindowResizeHeight _PROTO_((WPOINTER w, int height, int flag));
int           WindowResizeWidth _PROTO_((WPOINTER w, int width, int flag));
int           WindowInitDesktop _PROTO_((int page));
int           WindowScroll _PROTO_((WPOINTER w, int lines, int direct));
int           WindowScrollAttr _PROTO_((WPOINTER w, int lines, int direct, int attr));
int           WindowScrollRegion _PROTO_((WPOINTER w, int lines, int urow, int ucol,
                                    int lrow, int lcol, int direct));
int           WindowScrollRegionAttr _PROTO_((WPOINTER w, int lines, int urow,
                                        int ucol, int lrow, int lcol, int direct,
                                        int attr));
int           WindowScrollViewport _PROTO_((WPOINTER w, unsigned units, int direct));
int           WindowSetWrap _PROTO_((WPOINTER w, int flag));
int           WindowSlide _PROTO_((WPOINTER w, int direct, int num));
int           WindowSyncCursor _PROTO_((WPOINTER w, int flag));
int           WindowTitleBottom _PROTO_((WPOINTER w, char *title, int pos));
int           WindowTitleBottomAttr _PROTO_((WPOINTER w, char *title, int pos,
                                       int attr));
int           WindowTitleTop _PROTO_((WPOINTER w, char *title, int pos));
int           WindowTitleTopAttr _PROTO_((WPOINTER w, char *title, int pos,
                                    int attr));
CWL_VOID      WindowUninitSystem _PROTO_((CWL_VOID ));
VOIDPTR       WindowUserBytesPtr _PROTO_((WPOINTER w));
WPOINTER      WindowWhich _PROTO_((int row, int col, int page));
int           WindowWriteAttributes _PROTO_((WPOINTER w, char *buffer, int row,
                                       int col, int length));
int           WindowWriteCharacters _PROTO_((WPOINTER w, char *buffer, int row,
                                       int col, int length));
int           WindowWriteCharAndAttr _PROTO_((WPOINTER w,char *buffer, int row,
                                        int col, int length));
int           WindowWriteCharactersAttr _PROTO_((WPOINTER w, char *buffer, int row,
                                           int col, int attr, int length));
int           WindowWriteCenterString _PROTO_((WPOINTER w, char *string, int row));
int           WindowWriteCenterStringAttr _PROTO_((WPOINTER w, char *string, int row,
                                             int attr));
int           WindowWriteRepeatAttribute _PROTO_((WPOINTER w, int attr, int row,
                                            int col, int length));
int           WindowWriteRepeatCharacter _PROTO_((WPOINTER w, int ch, int row,
                                            int col, int length));
int           WindowWriteRepeatCharAttr _PROTO_((WPOINTER w, int ch, int attr,
                                               int row, int col, int length));

int           WindowWriteString _PROTO_((WPOINTER w, char *string, int row, int col));
int           WindowWriteStringAttr _PROTO_((WPOINTER w, char *string, int row,
                                       int col, int attr));
int           WindowWriteStringRJ _PROTO_((WPOINTER w, char *string, int row, int col));
int           WindowWriteStringRJAttr _PROTO_((WPOINTER w, char *string, int row,
                                         int col, int attr));
int           WindowWriteStringCC _PROTO_((WPOINTER w, char *string, int row, int col));
int           WindowWriteStringCCAttr _PROTO_((WPOINTER w, char *string,int row,
                                         int col, int attr));
int           WindowWriteTextToFile _PROTO_((WPOINTER w, char *string, int mode));


/****************** Scroll bar functions ************************/

/* Scroll bar constants and functions */
#define SB_HORZ             0
#define SB_VERT             1
#define SB_CTL              2
#define SB_BOTH             3

#define SCR_UP_ARROW        0
#define SCR_DOWN_ARROW      1
#define SCR_REGION_CHAR     2

#define SCR_LEFT_ARROW        SCR_UP_ARROW
#define SCR_RIGHT_ARROW       SCR_DOWN_ARROW

#define SCR_UP_ATTR         0
#define SCR_DOWN_ATTR       1
#define SCR_RIGHT_ATTR      SCR_DOWN_ATTR
#define SCR_LEFT_ATTR       SCR_UP_ATTR
#define SCR_HBOX_NORM     2
#define SCR_HBOX_HIGH     3
#define SCR_VBOX_NORM     SCR_HBOX_NORM
#define SCR_VBOX_HIGH     SCR_HBOX_HIGH

#define SCRLEFT    1
#define SCRRIGHT   2
#define SCRUP      3
#define SCRDOWN    4
#define SCRVBOX    5
#define SCRHBOX    6
#define SCRPGLEFT  7
#define SCRPGRIGHT 8
#define SCRPGUP    9
#define SCRPGDOWN  10
#define MOVETOP    11


SCROLLPTR ScrollBarCreate _PROTO_((int type, int minnum, int maxnum,
                                     int length, int *attr));


/* define point translation macros */
#define MOUSE_TO_CLIENT(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLMouseToClient(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define CLIENT_TO_VIRTUAL(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLClientToVirtual(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }


#define VIRTUAL_TO_CLIENT(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLVirtualToClient(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define CLIENT_TO_MOUSE(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLClientToMouse(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define MOUSE_TO_SCREEN(row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLMouseToScreen(&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }


#define SCREEN_TO_MOUSE(row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLScreenToMouse(&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define DESKTOP_TO_CLIENT(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLDesktopToClient(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define CLIENT_TO_DESKTOP(w,row,col,nrow,ncol)   {  \
                                     CWLPOINT pt; \
                                     pt.x = col,  \
                                     pt.y = row,  \
                                     CWLClientToDesktop(w,&pt), \
                                     nrow = pt.y, \
                                     ncol = pt.x; \
                                     }

#define INIT_RECT(rect, t, l, b, r)   { \
                                         (rect).top = t,    \
                                         (rect).left = l,   \
                                         (rect).bottom = b, \
                                         (rect).right = r;  \
                                      }


/******** Define CWL Menu Functions and Structures ******/

#define MAXMENUBUFFER  256
#define MAXMENUSTRING  (MAXMENUBUFFER - 2)

/* define offsets for pop-up menu keys */

#define POPUP_UPKEY              0
#define POPUP_DOWNKEY            1
#define POPUP_ACCEPTKEY          2
#define POPUP_QUITKEY            3
#define POPUP_HOMEKEY            4
#define POPUP_ENDKEY             5
#define POPUP_RIGHTKEY           6
#define POPUP_LEFTKEY            7
#define POPUP_PULLDOWN_QUITKEY   8
#define POPUP_PAGEUPKEY          9
#define POPUP_PAGEDOWNKEY       10

#define NUMPOPUPKEYS     11

#define PULLDOWN_EXIT       3
#define PULLDOWN_CONTINUE   5

/* define offsets for bar menu keys */
#define BAR_RIGHTKEY           0
#define BAR_LEFTKEY            1
#define BAR_ACCEPTKEY          2
#define BAR_QUITKEY            3
#define BAR_HOMEKEY            4
#define BAR_ENDKEY             5

#define NUMBARKEYS     6

#define NO_BAR_OPTIONS 0
#define BARWRAP        1
#define BARSTATIC      2
#define BARCONFIRM     4
#define BARDISPLAY     8
#define BAROVERRIDE    16
#define BARENHANCEDKEY 32
#define BARMOUSE       64
#define BARCREATEWIN   128

#define BARDEFOPTIONS  (BARWRAP | BARMOUSE | BARCREATEWIN | BARSTATIC)

#define NO_POPUP_OPTIONS 0
#define POPUPWRAP        1
#define POPUPSTATIC      2
#define POPUPCONFIRM     4
#define POPUPDISPLAY     8
#define POPUPOVERRIDE    16
#define POPUPENHANCEDKEY 32
#define POPUPMOUSE       64
#define POPUPCREATEWIN   128
#define POPUPSCROLL      256
#define POPUPSCROLLBAR   (POPUPSCROLL | POPUPMOUSE)
#define POPUPRESIZEWIDTH    512
#define POPUPRESIZEHEIGHT   1024
#define POPUPRESIZEALL      (POPUPRESIZEWIDTH | POPUPRESIZEHEIGHT)

#define POPUPDEFOPTIONS   (POPUPMOUSE | POPUPRESIZEALL | \
                           POPUPSCROLLBAR | POPUPCREATEWIN | POPUPSTATIC)

#define CWL_MRESIZE       0x1
#define CWL_MDISABLED     0x2
#define CWL_MSTRING       0x4
#define CWL_MSEPARATOR    0x8
#define CWL_BYPOSITION    0x10
#define CWL_BYCOMMAND     0x20
#define CWL_MPOPUP        (CWL_MSTRING | 0x40)
#define CWL_MCHECKED      0x80
#define CWL_MGRAYED       0x100
#define CWL_MUNCHECKED    0x00
#define CWL_MENABLED      0x00


/**********  Popup return values for user-defined functions **********/

#define KEEP_GETTING_INPUT         0
#define MOVE_CONTINUE_DONE        (-1)
#define POPUP_CONTINUE            (-2)
#define POPUP_MOVE_UP             (-3)
#define POPUP_MOVE_DOWN           (-4)
#define POPUP_DO_CHOICE           (-5)
#define POPUP_MOVE_CONTINUE       (-6)
#define POPUP_ESCAPE              (-7)
#define POPUP_MOVE_LEFT           (-8)
#define POPUP_MOVE_RIGHT          (-9)
#define POPUP_MOVE_HOME           (-10)
#define POPUP_MOVE_END            (-11)
#define POPUP_PULLDOWN_QUIT       (-12)
#define POPUP_MOVE_BAR_CHOICE     (-13)
#define POPUP_MOVE_PAGEDOWN       (-14)
#define POPUP_MOVE_PAGEUP         (-15)


/* The following macros are used for compatibility with versions prior to
 * Version 1.5 */
#define PULLDOWN_POPUP_EXIT   POPUP_PULLDOWN_QUIT
#define POPUP_PULLDOWN_EXIT   POPUP_PULLDOWN_QUIT
#define PULLDOWN_POPUP_QUIT   POPUP_PULLDOWN_QUIT
#define POPUP_EXIT            POPUP_ESCAPE
#define BAR_EXIT              BAR_ESCAPE

/**********  Bar return values for user-defined functions **********/

#define BAR_CONTINUE         (-14)
#define BAR_MOVE_RIGHT       (-15)
#define BAR_MOVE_LEFT        (-16)
#define BAR_DO_CHOICE        (-17)
#define BAR_MOVE_CONTINUE    (-18)
#define BAR_ESCAPE           (-19)
#define BAR_MOVE_HOME        (-20)
#define BAR_MOVE_END         (-21)


#define ENTRYCOLOR       0
#define BORDERCOLOR      1
#define HOTKEYCOLOR      2
#define HIGHLIGHTCOLOR   3
#define UNAVAILCOLOR     4

#define NUMPOPUPCOLORS 5
#define NUMBARCOLORS   5

#define MENU_PRESS     0
#define MENU_RELEASE   1
#define NUMMOUSEINFO   8

#define SEPARATOR      ((char *)1)
#define NO_HEIGHT_LIMIT  (-1)
#define NO_WIDTH_LIMIT   (-1)

#define POPUP_SETHEIGHT   0x1
#define POPUP_SETWIDTH    0x2
#define POPUP_SETALL      (POPUP_SETHEIGHT | POPUP_SETWIDTH)

typedef struct tagPOPSTATUS
{
  unsigned int open_flag:1;     /* menu is activated ? */
  unsigned int pulldown_flag:1; /* menu is part of pulldown system? */
  unsigned int pick_list:1;     /* tells if popup menu is used as a picklist */

} POPUP_MENU_STAT, BAR_MENU_STAT;


typedef struct tagPOPUPENTRY
{
  char *entry_name;
  unsigned int menuid;
  unsigned int mtype;
#if __cplusplus
  int (*func) _PROTO_((struct tagPOPUPMENU *, int));
#else
  int (*func) _PROTO_((UNKNOWNARGS));
#endif
} POPUP_MENU_ENTRY, *POPUP_MENU_ENTRY_PTR;


typedef struct tagPOPUPEXTRA  /* Allocated members for each popup entry */
{
  POPUP_MENU_ENTRY pop;
  unsigned char hotkey_pos;
  int  row;
  int entry_offset;
  unsigned int cascade:1;
  unsigned int highlighted:1;
  unsigned char *menu_string;
  VOIDPTR popmenu;
} POPUP_ENTRY_EXTRA;


typedef struct tagPOPUPMENU
{
  WPOINTER w;
  struct tagPOPUPMENU *parent;
  CWLOBJECTPTR entry_object;
  unsigned menu_color[NUMPOPUPCOLORS];
  unsigned menu_key[NUMPOPUPKEYS];
  POPUP_MENU_STAT popmenu_flags;
  int options;
  int num_entries;
  int totheight;
  int totwidth;
  BITSTRING active_entry;
  unsigned int attached:1;
  unsigned int cascade:1;
  unsigned int init_highlight:1;
  unsigned int exit_cascade:1;
  unsigned int hide_cascade:1;
  unsigned int lowlight_first:1;
  unsigned int unshrinkable:1;
  unsigned int show_disabled:1;
  int next_select;
  int maxheight;
  int maxwidth;
  int pwidth;
  int last_entry;
  int exp_method;
  unsigned int scr_repaint:1;
  VOIDPTR pulldown;
  VOIDPTR listptr;
  int (*confirm_func) _PROTO_((struct tagPOPUPMENU *, unsigned));
  unsigned int mouse_scroll:1;
  int (*local_undef_key) _PROTO_((struct tagPOPUPMENU *, int, int *));
  int (*stray_click_func) _PROTO_((struct tagPOPUPMENU *, int, int, int));
  unsigned press_no_wait:1;
  unsigned owner_window:1;
  int form_entry;
  SCROLLPTR sptr;

} POPUP_MENU, *POPUP_MENU_PTR;




#define POPUP_WRAP_ON(p)              ((p)->options & POPUPWRAP)
#define POPUP_STATIC_ON(p)            ((p)->options & POPUPSTATIC)
#define POPUP_CONFIRM_ON(p)           ((p)->options & POPUPCONFIRM)
#define POPUP_DISPLAY_ON(p)           ((p)->options & POPUPDISPLAY)
#define POPUP_OVERRIDE_ON(p)          ((p)->options & POPUPOVERRIDE)
#define POPUP_ENHANCED_ON(p)          ((p)->options & POPUPENHANCEDKEY)
#define POPUP_MOUSE_ON(p)             ((p)->options & POPUPMOUSE)
#define POPUP_CREATEWIN_ON(p)         ((p)->options & POPUPCREATEWIN)
#define POPUP_SCROLL_ON(p)            ((p)->options & POPUPSCROLL)
#define POPUP_RESIZE_WIDTH_ON(p)      ((p)->options & POPUPRESIZEWIDTH)
#define POPUP_RESIZE_HEIGHT_ON(p)     ((p)->options & POPUPRESIZEHEIGHT)

#define POPUP_OPEN(p)                 ((p)->popmenu_flags.open_flag)
#define POPUP_PULLDOWN_ON(p)          ((p)->popmenu_flags.pulldown_flag)
#define POPUP_LIST_ON(p)              ((p)->popmenu_flags.pick_list)


#define S_UP_CHAR   0
#define S_DN_CHAR   1
#define S_UP_ATTR   2
#define S_DN_ATTR   3
#define S_UP_ROW    4
#define S_UP_COL    5
#define S_DN_ROW    6
#define S_DN_COL    7

#define OTHER_BUTTON     0
#define OUTSIDE_POPUP    1
#define OUTSIDE_PULLDOWN 2
#define OUTSIDE_BAR      3

#define MAXMENULEN      256

#define POPUP_SCROLL_UP_CHAR(p)       (p)->popup_mouse_status[S_UP_CHAR]
#define POPUP_SCROLL_DOWN_CHAR(p)     (p)->popup_mouse_status[S_DN_CHAR]
#define POPUP_SCROLL_UP_ATTR(p)       (p)->popup_mouse_status[S_UP_ATTR]
#define POPUP_SCROLL_DOWN_ATTR(p)     (p)->popup_mouse_status[S_DN_ATTR]
#define POPUP_SCROLL_UP_ROW(p)        (p)->popup_mouse_status[S_UP_ROW]
#define POPUP_SCROLL_UP_COLUMN(p)     (p)->popup_mouse_status[S_UP_COL]
#define POPUP_SCROLL_DOWN_ROW(p)      (p)->popup_mouse_status[S_DN_ROW]
#define POPUP_SCROLL_DOWN_COLUMN(p)   (p)->popup_mouse_status[S_DN_COL]

CWL_VOID menu_init();

typedef struct tagBARENTRY
{
  char *entry_name;
  unsigned int menuid;
  unsigned int mtype;
#if __cplusplus
  int (*func) _PROTO_((struct tagBARMENU *, int));
#else
  int (*func) _PROTO_((UNKNOWNARGS));
#endif
} BAR_MENU_ENTRY, *BAR_MENU_ENTRY_PTR;



typedef struct tagBAREXTRA
{
  BAR_MENU_ENTRY bar;
  unsigned char hotkey_pos;
  int entry_offset;
  int row;
  int col;
  char *menu_string;
} BAR_ENTRY_EXTRA;



typedef struct tagBARMENU
{
  WPOINTER w;
  unsigned attached : 1;
  unsigned options;
  unsigned menu_color[NUMBARCOLORS];
  unsigned menu_key[NUMBARKEYS];
  CWLOBJECTPTR entry_object;
  BITSTRING active_entry;
  int num_entries;
  BAR_MENU_STAT barmenu_flags;
  int exp_method;
  unsigned last_entry;
  int (*confirm_func) _PROTO_((struct tagBARMENU *, unsigned));
  VOIDPTR pulldown;
  int (*local_undef_key) _PROTO_((struct tagBARMENU *, unsigned, unsigned *));
  int (*stray_click_func) _PROTO_((struct tagBARMENU *, int, int, int));
} BAR_MENU, *BAR_MENU_PTR;



#define BAR_WRAP_ON(b)              ((b)->options & BARWRAP)
#define BAR_STATIC_ON(b)            ((b)->options & BARSTATIC)
#define BAR_CONFIRM_ON(b)           ((b)->options & BARCONFIRM)
#define BAR_DISPLAY_ON(b)           ((b)->options & BARDISPLAY)
#define BAR_OVERRIDE_ON(b)          ((b)->options & BAROVERRIDE)
#define BAR_ENHANCED_ON(b)          ((b)->options & BARENHANCEDKEY)
#define BAR_MOUSE_ON(b)             ((b)->options & BARMOUSE)
#define BAR_CREATEWIN_ON(b)         ((b)->options & BARCREATEWIN)


#define BAR_OPEN(b)                 (b)->barmenu_flags.open_flag
#define BAR_PULLDOWN_ON(b)          (b)->barmenu_flags.pulldown_flag

typedef struct tagPULLEXTRA
{
  POPUP_MENU_PTR popup;      /* popup item */
} PULLDOWN_ENTRY_EXTRA;


typedef struct tagPULLMENU
{
  BAR_MENU_PTR barmenu;
  CWLOBJECTPTR entry_object;
  WPOINTER wOwner;
  int num_entries;
  unsigned int attached:1;
  unsigned int show_disabled:1;
}  PULLDOWN_MENU, *PULLDOWN_MENU_PTR;





typedef WPOINTER  (*BARWPROC)           _PROTO_((CWL_VOID));
typedef int       (*BARCONFIRMPROC)     _PROTO_((BAR_MENU_PTR,unsigned));
typedef int       (*BARCLICKPROC)       _PROTO_((BAR_MENU_PTR,int,int,int));
typedef int       (*BARSELECTPROC)      _PROTO_((BAR_MENU_PTR,int));
typedef int       (*BARUNDEFKEYPROC)    _PROTO_((BAR_MENU_PTR,unsigned,int *));

typedef WPOINTER  (*POPUPWPROC)         _PROTO_((CWL_VOID));
typedef VWPOINTER (*POPUPVWPROC)        _PROTO_((CWL_VOID));
typedef int       (*POPUPCLICKPROC)     _PROTO_((POPUP_MENU_PTR,int,int,int));
typedef int       (*POPUPSELECTPROC)    _PROTO_((POPUP_MENU_PTR,int));
typedef int       (*POPUPCONFIRMPROC)   _PROTO_((POPUP_MENU_PTR,unsigned));
typedef int       (*POPUPUNDEFKEYPROC)  _PROTO_((POPUP_MENU_PTR, unsigned, int *));

typedef struct tagENTRYINFO
{
  unsigned menu_type:1;             /* 0 for popup, 1 for bar */
  int  menu_entry_num;              /* entry number */
  int  menu_entry_type;             /* entry type bits */
  char *menu_string;                /* menu string (includes ampersand) */
  char *menu_display_string;        /* actual string displayed */
  unsigned menu_entry_active: 1;    /* 1 if enabled, 0 otherwise */
  union {
    POPUPSELECTPROC popmenu_func;     /* pointer to menu function if popup */
    BARSELECTPROC barmenu_func;       /* pointer to menu function if bar */
  } menu_proc;
  int  menu_id;                     /* menu id */
} POPUP_ENTRY_INFO, BAR_ENTRY_INFO;


typedef struct tagACCELERATOR
{
  VOIDPTR menuptr;    /* pointer to menu, can be void *
                         if general accelerator */
  int entry;          /* entry that contains key definition */
  int menuid;         /* The id of the menu */
  unsigned key;       /* The key to look for */
  unsigned keyflag;   /* key flags (ALT, CTRL, etc.) */
}  CWL_ACCELERATOR;

int                FindPopupInParent _PROTO_((POPUP_MENU_PTR p));

int                FindPopupInBar _PROTO_((POPUP_MENU_PTR p));

int                AddAcceleratorKey _PROTO_((VOIDPTR menuptr,
                                              unsigned key, int entry));

int                SearchAcceleratorKey _PROTO_((VOIDPTR menuptr,
                                                 unsigned key));

int                DeleteMenuAccelerators _PROTO_((VOIDPTR menu));

BAR_MENU_ENTRY_PTR BarAllocate _PROTO_((int numentry));

int                BarAppendEntry _PROTO_((BAR_MENU_PTR b,
                                           int type,
                                           char *entry_string,
                                           int menuid,
                                           BARSELECTPROC func));

int               BarAppendMultEntries _PROTO_((BAR_MENU_PTR b,
                                                BAR_MENU_ENTRY *entry,
                                                int numentries));

int               BarAssignColors _PROTO_((BAR_MENU_PTR barptr,
                                           unsigned *colors));

int               BarAssignKeys _PROTO_((BAR_MENU_PTR barptr,
                                         unsigned *keys));

int               BarSetEntryString _PROTO_((BAR_MENU_PTR barptr,
                                                int entry,
                                                char *string));

CWL_VOID          BarCreateEntry _PROTO_((BAR_MENU_ENTRY *entry,
                                          int entrynum,
                                          char *name,
                                          int menuid,
                                          BARSELECTPROC func));

BAR_MENU_PTR      BarCreateMenu _PROTO_((WPOINTER wOwner,
                                         unsigned options,
                                         unsigned *bcolor,
                                         int row,
                                         int col,
                                         int width));

CWL_VOID          BarDeallocate _PROTO_((BAR_MENU_ENTRY_PTR bentry));

int               BarDeleteEntry _PROTO_((BAR_MENU_PTR b, int where));

int               BarDeleteMultEntries _PROTO_((BAR_MENU_PTR b,
                                                int where, int num));
int               BarEnableEntry _PROTO_((BAR_MENU_PTR b,
                                          int entry, unsigned mflags));

CWL_VOID          BarEntryEnd _PROTO_((BAR_MENU_ENTRY_PTR entry,
                                       int numfields));

POPUP_MENU_PTR    BarGetPopup _PROTO_((BAR_MENU_PTR b, int entry));

int               BarInsertEntry _PROTO_((BAR_MENU_PTR b,
                                          int type,
                                          int where,
                                          char *entry_string,
                                          unsigned menuid,
                                          BARSELECTPROC func));

int               BarInsertMultEntries _PROTO_((BAR_MENU_PTR b,
                                                int where,
                                                BAR_MENU_ENTRY *entry,
                                                int numentries));

int               BarMenuClose _PROTO_((BAR_MENU_PTR barptr));

int               BarMenuCloseAll _PROTO_((CWL_VOID));

int               BarSetExplosionType _PROTO_((BAR_MENU_PTR barptr,
                                               int effect));

int               BarSetOptions _PROTO_((BAR_MENU_PTR barptr,
                                         int options, int flag));

int               BarSelectMenu _PROTO_((BAR_MENU_PTR barptr,
                                         int rank, int entry));

int               BarSetConfirmFunction _PROTO_((BAR_MENU_PTR barptr,
                                                 BARCONFIRMPROC cfunc));

int               BarSetClickFunction _PROTO_((BAR_MENU_PTR barptr,
                                               BARCLICKPROC func));


POPUP_MENU_ENTRY_PTR   PopupAllocate _PROTO_((int numentry));

int               PopupAppendEntry _PROTO_((POPUP_MENU_PTR p,
                                           int type,
                                           char *entry_string,
                                           int menuid,
                                           POPUPSELECTPROC func));

int               PopupAppendPopup _PROTO_((POPUP_MENU_PTR p,
                                            POPUP_MENU_PTR p2, int type,
                                            char *entry_string, int menuid));






int               PopupAssignColors _PROTO_((POPUP_MENU_PTR popptr,
                                             unsigned *colors));

int               PopupAssignKeys _PROTO_((POPUP_MENU_PTR popptr,
                                           unsigned *keys));

int               PopupCheckEntry _PROTO_((POPUP_MENU_PTR p,
                                           int entry,
                                           unsigned onoff));

CWL_VOID          PopupCreateEntry _PROTO_((POPUP_MENU_ENTRY_PTR entry,
                                            int entrynum,
                                            char *name,
                                            int menuid,
                                            POPUPSELECTPROC func));

POPUP_MENU_PTR    PopupCreateMenu _PROTO_((WPOINTER wOwner,
                                           unsigned options, /* options to use */
                                           unsigned *pcolor,
                                           int row, int col)); /* colors for popup menu */

CWL_VOID          PopupDeallocate _PROTO_((POPUP_MENU_ENTRY_PTR pentry));

int               PopupDeleteEntry _PROTO_((POPUP_MENU_PTR p, int where));

int               PopupEnableEntry _PROTO_((POPUP_MENU_PTR p, int entry,
                                            unsigned mflags));

CWL_VOID          PopupEntryEnd _PROTO_((POPUP_MENU_ENTRY_PTR entry,
                                         int numfields));

BAR_MENU_PTR      PopupGetBar _PROTO_((POPUP_MENU_PTR p));

PULLDOWN_MENU_PTR PopupGetPulldown _PROTO_((POPUP_MENU_PTR p));


CWL_VOID          PopupGetEntryInfo _PROTO_((POPUP_MENU_PTR p,
                                             int entry,
                                             POPUP_ENTRY_INFO *pinfo));

int               PopupInsertEntry _PROTO_((POPUP_MENU_PTR p,
                                            int where,
                                            int type,
                                            char *entry_string,
                                            int menuid,
                                            POPUPSELECTPROC func));

int               PopupInsertPopup _PROTO_((POPUP_MENU_PTR p,
                                            POPUP_MENU_PTR p2, int type,
                                            int where, char *entry_string,
                                            int menuid));


int               PopupMenuCloseAll _PROTO_((CWL_VOID));

int               PopupSelectMenu _PROTO_((POPUP_MENU_PTR popptr, int rank,
                                           int entry));

int               PopupSetOptions _PROTO_((POPUP_MENU_PTR popptr,
                                           unsigned options,
                                           int flag));

int               PopupSetDimensions _PROTO_((POPUP_MENU_PTR p, int width,
                                              int height, int option));

int               PopupShowDisabled _PROTO_((POPUP_MENU_PTR p, int flag));



int               PopupSetEntryString _PROTO_((POPUP_MENU_PTR popptr,
                                                  int entry, char *string));

int               PopupSetExplosionType _PROTO_((POPUP_MENU_PTR popptr,
                                                 int effect));

int               PopupSetClickFunction _PROTO_((POPUP_MENU_PTR popptr,
                                                 POPUPCLICKPROC func));

int               PopupSetConfirmFunction _PROTO_((POPUP_MENU_PTR popptr,
                                                   POPUPCONFIRMPROC cfunc));

int               PopupSetWinDimensions _PROTO_((POPUP_MENU_PTR popptr,
                                      int width, int height, int options));

int               PopupMenuClose _PROTO_((POPUP_MENU_PTR popptr));

PULLDOWN_MENU_PTR PulldownCreateMenu _PROTO_((WPOINTER wOwner,int options,
                                        unsigned *bcolor, int row, int col,
                                        int width));

int               PulldownInsertEntry _PROTO_((PULLDOWN_MENU_PTR pd,
                                               int type,
                                               int where,
                                               char *entry_string,
                                               int menuid,
                                               BARSELECTPROC func,
                                               POPUP_MENU_PTR p));

int               PulldownAppendEntry _PROTO_((PULLDOWN_MENU_PTR pd,
                                               int type,
                                               char *entry_string,
                                               int menuid,
                                               BARSELECTPROC func,
                                               POPUP_MENU_PTR p));

int               PulldownCUA _PROTO_((PULLDOWN_MENU_PTR pull));
int               PulldownDeleteEntry _PROTO_((PULLDOWN_MENU_PTR pd,
                                               int where));
BAR_MENU_PTR      PulldownGetBar _PROTO_((PULLDOWN_MENU_PTR pd));

POPUP_MENU_PTR    PulldownGetPopup _PROTO_((PULLDOWN_MENU_PTR pd, int entry));

int               PulldownSelectMenu _PROTO_((PULLDOWN_MENU_PTR pullptr,
                                              int rankbar,
                                              int startbar,
                                              int imode));

int               PulldownMenuClose    _PROTO_((PULLDOWN_MENU_PTR pullptr));
int               PulldownMenuCloseAll _PROTO_((PULLDOWN_MENU_PTR pullptr));
int               PulldownShowDisabled _PROTO_((PULLDOWN_MENU_PTR pullptr,
                                                int flag));


/* Other defines */
#define   BAR_NULL_PTR      ((BAR_MENU_PTR)0)
#define   POPUP_NULL_PTR    ((POPUP_MENU_PTR)0)
#define   PULLDOWN_NULL_PTR ((PULLDOWN_MENU_PTR)0)
#define   BAR_ENTRY_NULL    ((BAR_MENU_ENTRY *)0)
#define   POPUP_ENTRY_NULL  ((POPUP_MENU_ENTRY *)0)
#define   POPUP_ENTRY_AVAILABLE(p,e) (test_bit((p)->active_entry,(e)))

#define   POPUP_GET_MENU_ENTRY(p,e) \
          ((POPUP_ENTRY_EXTRA *)CWLget_object((p)->entry_object,(long)(e)))

#define   BAR_GET_MENU_ENTRY(b,e) \
               ((BAR_ENTRY_EXTRA *)CWLget_object((b)->entry_object,(e)))

#define   BAR_ENTRY_OFFSET(b,e) \
            (BAR_GET_MENU_ENTRY(b,e)->entry_offset)

#define   POPUP_ENTRY_TYPEBITS(p,e)  (POPUP_GET_MENU_ENTRY(p,e)->pop.mtype)

#define   POPUP_ENTRY_TYPE(p,e)  \
          ((POPUP_ENTRY_TYPEBITS(p,e) & CWL_MSEPARATOR)?CWL_MSEPARATOR: \
          ((POPUP_ENTRY_TYPEBITS(p,e) & CWL_MPOPUP)?CWL_MPOPUP:CWL_MSTRING))

#define   BAR_ENTRY_TYPEBITS(b,e)  (BAR_GET_MENU_ENTRY(b,e)->bar.mtype)

#define   BAR_ENTRY_TYPE(b,e)  \
          ((BAR_ENTRY_TYPEBITS(b,e) & CWL_MSEPARATOR)?CWL_MSEPARATOR: \
          ((BAR_ENTRY_TYPEBITS(b,e) & CWL_MPOPUP)?CWL_MPOPUP:CWL_MSTRING))

#define   BAR_ENTRY_ID(b,e) \
            (BAR_GET_MENU_ENTRY(b,e)->bar.menuid)


#define   POPUP_ENTRY_ID(p,e) \
            (POPUP_GET_MENU_ENTRY(p,e)->pop.menuid)

#define   POPUP_ENTRY_FUNCTION(p,e) \
            (POPUP_GET_MENU_ENTRY(p,e)->pop.func)

#define   POPUP_CASCADE(p)              ((p)->cascade)
#define   POPUP_CASCADE_ENTRY(p,e)    \
            (POPUP_GET_MENU_ENTRY(p,e)->cascade)

#define   POPUP_MENU_FROM_CASCADE(p,e) \
                ((POPUP_MENU_PTR)(POPUP_GET_MENU_ENTRY(p,e)->popmenu))

#define   POPUP_PARENT(p)               ((p)->parent)
#define   POPUP_PARENT_ENTRY(p)   \
                      (FindPopupInParent(p))
#define   POPUP_BAR_ENTRY(p)      \
                      (FindPopupInBar(p))
#define   POPUP_WINDOW(p)               ((p)->w)
#define   POPUP_VIRTUAL_WINDOW(p)       ((p)->w->vwptr)

#define   POPUP_ENTRY_OFFSET(p,e) \
            (POPUP_GET_MENU_ENTRY(p,e)->entry_offset)

#define   POPUP_ENTRY_STRING(p,e) \
             (POPUP_GET_MENU_ENTRY(p,e)->menu_string)

#define   POPUP_ENTRY_RAWSTRING(p,e) \
             (POPUP_ENTRY_STRING(p,e) + POPUP_ENTRY_OFFSET(p,e))

#define   POPUP_ENTRY_HIGHLIGHTED(p,e) \
            (POPUP_GET_MENU_ENTRY(p,e)->highlighted)

#define   POPUP_ENTRY_CHECKED(p,e)      (POPUP_ENTRY_TYPEBITS(p,e) & \
                                         CWL_MCHECKED)
#define   POPUP_ENTRY_GRAYED(p,e)       (POPUP_ENTRY_TYPEBITS(p,e) & \
                                         CWL_MGRAYED)
#define   POPUP_ENTRY_DISABLED(p,e)     (POPUP_ENTRY_TYPEBITS(p,e) & \
                                         CWL_MDISABLED)
#define   BAR_ENTRY_AVAILABLE(b,e)      (POPUP_ENTRY_AVAILABLE((b),(e)))
#define   BAR_WINDOW(b)                 ((b)->w)


#define   BAR_ENTRY_STRING(b,e)  \
                (BAR_GET_MENU_ENTRY(b,e)->menu_string)

#define   BAR_ENTRY_RAWSTRING(b,e) \
             (BAR_ENTRY_STRING(b,e) + BAR_ENTRY_OFFSET(b,e))

#define   BAR_GET_HOTKEY(b,e,c) \
                                { \
                                  BAR_ENTRY_EXTRA *be; \
                                  char *s = BAR_ENTRY_RAWSTRING(b,e); \
                                  be = BAR_GET_MENU_ENTRY(b,e);   \
                                  if (be->hotkey_pos == strlen(s)) \
                                    c = '\0'; \
                                  else       \
                                    c = *(s + be->hotkey_pos + 1); \
                                }


#define   PULLDOWN_MENU_PTR_FROM_BAR(b)  \
                      ((PULLDOWN_MENU_PTR)((b)->pulldown))

#define   PULLDOWN_MENU_PTR_FROM_POPUP(p) \
                      ((PULLDOWN_MENU_PTR)((p)->pulldown))

#define   BAR_MENU_PTR_FROM_PULLDOWN(pull) ((pull)->barmenu)

#define   PULLDOWN_GET_MENU_ENTRY(pull,entry) \
   ((PULLDOWN_ENTRY_EXTRA *)CWLget_object((pull)->entry_object,(long)(entry)))

#define   POPUP_MENU_PTR_FROM_PULLDOWN(pull,entry) \
              ((POPUP_MENU_PTR)(PULLDOWN_GET_MENU_ENTRY(pull,entry)->popup))

#define   PULLDOWN_POPUP_PTR(pull,entry) \
              POPUP_MENU_PTR_FROM_PULLDOWN(pull,entry)

#define   BAR_MENU_PTR_FROM_POPUP(p) \
          (BAR_MENU_PTR_FROM_PULLDOWN(PULLDOWN_MENU_PTR_FROM_POPUP(p)))

#define   POPUP_MENU_PTR_FROM_BAR(b,entry) \
          (POPUP_MENU_PTR_FROM_PULLDOWN(PULLDOWN_MENU_PTR_FROM_BAR(b),entry))

#define   ISPOPUP_MENU(w) (int)(((w)->stat_info.use_flag == POPUP_USE)?1:0)
#define   ISBAR_MENU(w)   (int)(((w)->stat_info.use_flag == BAR_USE)?1:0)

#define   GET_POPUP_FROM_WINDOW(w) \
             (ISPOPUP_MENU(w)?(POPUP_MENU_PTR)((w)->use_ptr):POPUP_NULL_PTR)

#define   GET_BAR_FROM_WINDOW(w) \
             (ISBAR_MENU(w)?(BAR_MENU_PTR)((w)->use_ptr):BAR_NULL_PTR)

#define   POPUP_ENTRY_ROW(p,e)  (POPUP_GET_MENU_ENTRY(p,e)->row)
#define   POPUP_OWNER_WINDOW(p) ((p)->owner_window)

#define   BAR_ENTRY_ROW(b,e)  (BAR_GET_MENU_ENTRY(b,e)->row)
#define   BAR_ENTRY_COL(b,e)  (BAR_GET_MENU_ENTRY(b,e)->col)

#define   POPUP_STRING_IN_WINDOW(p,e)  \
            VWINDOW_COORD_IN_VIEWPORT(POPUP_WINDOW(p),POPUP_ENTRY_ROW(p,e),0)

/**************** Define CWL Form structures and functions ***************/

enum field_types   {FIELDEND,
                    INTEGER=1,
                    UINTEGER,
                    LINTEGER,
                    ULINTEGER,
                    FLOAT,
                    DOUBLE,
                    STRING,
                    CHAR,
                    TOGGLE,
                    NORMALFIELDCUTOFF,
                    BUTTON,
                    SUBFORM,
                    VSUBFORM,
                    RADIO,
                    CHECKBOX,
                    LIST,
                    USERTYPE
                    };


#define NO_FIELD_OPTIONS             0UL
#define NO_FORM_OPTIONS              0UL
#define FIELD_UPPERCASE              0x1UL
#define FIELD_LOWERCASE              0x2UL
#define FIELD_CHECKSPACES            0x4UL
#define FIELD_ENHANCEDKEY            0x8UL
#define FIELD_CHECKREGEXP            0x10UL
#define FIELD_AUTORETURN             0x20UL
#define FIELD_CHECKREGEXP_IGNORECASE 0x40UL
#define FIELD_FLUSHBUFFER            0x80UL

#define FIELD_HOMECURSOR             0x100UL
#if !defined (SHAREWARE)
#define FIELD_USEMOUSE               0x200UL
#else
#define FIELD_USEMOUSE               0x0UL
#endif
#define FIELD_CLEARFIELD             0x400UL
#define FIELD_VIRTUAL                0x800UL
#define FIELD_PROTECT                0x1000UL
#define FIELD_COMMA                  0x2000UL
#define FIELD_RJUSTIFY               0x4000UL
#define FIELD_LJUSTIFY               0x8000UL
#define FIELD_ZSUPPRESS1             0x10000UL
#define FIELD_ZSUPPRESS2             0x20000UL
#define FIELD_PASSWORD               0x40000UL
#define FIELD_CHECK                  0x80000UL
#define FIELD_OVERRIDE_FORWARD       0x100000UL
#define FIELD_OVERRIDE_BACKWARD      0x200000UL
#define FORMFLAG                     0x800000UL

#define NUMFIELDOPTS               22

#define HELP_START_KEY          0
#define HELP_END_KEY            1
#define HELP_UP_KEY             2
#define HELP_DOWN_KEY           3
#define HELP_RIGHT_KEY          4
#define HELP_LEFT_KEY           5
#define HELP_ZOOM_KEY           6

#define NUMHELPKEYS             7

#define NUMFORMKEYS             45      /* Number of form edit keys */


#define USINGFORM   (1UL << NUMFIELDOPTS)
#define FORM_FORWARD  1
#define FORM_BACKWARD 2
#define FORM_BOTHDIR  3
#define FORM_WRAP          1
#define FORM_CHECK         2
#define FORM_EXIT_INITIAL  4
#define FORM_NOEXIT_LAST   8
#define FORM_HIGHLIGHT     16

#if !defined (SHAREWARE)
#define FORM_VIRTUAL       32
#else
#define FORM_VIRTUAL       0
#endif

#define FORM_STATIC        64

#define FIELD_LOW           1
#define FIELD_HIGH          2
#define FIELD_OUT_OF_RANGE  (FIELD_LOW | FIELD_HIGH)
#define FIELD_OK            0

#define INCLUDE_LOW         1
#define INCLUDE_HIGH        2
#define EXCLUDE_LOW         4
#define EXCLUDE_HIGH        8
#define NO_RANGE_OPT        (INCLUDE_LOW|INCLUDE_HIGH)


#define UINTEGER_REGEXP "[0-9]"
#define SINTEGER_REGEXP "[0-9+/-]"
#define UDECIMAL_REGEXP "[0-9/.]"
#define DECIMAL_REGEXP  "[0-9/.+/-]"
#define SCIENTIFIC_REGEXP "[0-9/.Ee+/-]"
#define REPEAT_REGEXP(regexp,num)  num##regexp
#define FORM_NULL_PTR   ((FORMPTR)0)
#define FIELD_ENTRY_NULL_PTR  ((FIELD_ENTRY_PTR)0)

#define MAXFIELDSIZE  256



#define INTMAX    "32767"
#define INTMIN    "32768"
#define UINTMAX   "65535"
#define UINTMIN   "0"
#define LINTMIN   "2147483648"
#define LINTMAX   "2147483647"
#define ULINTMIN  "0"
#define ULINTMAX  "4294967295"

#define FIELD_PROTECT_ON(entry)           (int) ((entry).options & FIELD_PROTECT)
#define FIELD_COMMA_ON(entry)             (int) ((entry).options & FIELD_COMMA)
#define FIELD_RJUSTIFY_ON(entry)          (int) ((entry).options & FIELD_RJUSTIFY)
#define FIELD_LJUSTIFY_ON(entry)          (int) ((entry).options & FIELD_LJUSTIFY)
#define FIELD_UPPERCASE_ON(entry)         (int) ((entry).options & FIELD_UPPERCASE)
#define FIELD_LOWERCASE_ON(entry)         (int) ((entry).options & FIELD_LOWERCASE)
#define FIELD_CHECKSPACES_ON(entry)       (int) ((entry).options & FIELD_CHECKSPACES)
#define FIELD_ENHANCEDKEY_ON(entry)       (int) ((entry).options & FIELD_ENHANCEDKEY)
#define FIELD_CHECKREGEXP_ON(entry)       (int) ((entry).options & FIELD_CHECKREGEXP)
#define FIELD_AUTORETURN_ON(entry)        (int) ((entry).options & FIELD_AUTORETURN)
#define FIELD_CHECKREGEXP_IGNORECASE_ON(entry)   (int) ((entry).options & \
                                                  FIELD_CHECKREGEXP_IGNORECASE)
#define FIELD_FLUSHBUFFER_ON(entry)       (int) ((entry).options & FIELD_FLUSHBUFFER)
#define FIELD_HOMECURSOR_ON(entry)        (int) ((entry).options & FIELD_HOMECURSOR)
#define FIELD_ZSUPPRESS1_ON(entry)        (int) ((entry).options & FIELD_ZSUPPRESS1)
#define FIELD_ZSUPPRESS2_ON(entry)        (int) ((entry).options & FIELD_ZSUPPRESS2)
#define FIELD_PASSWORD_ON(entry)          (int) ((entry).options & FIELD_PASSWORD)
#define FIELD_CHECK_ON(entry)             (int) ((entry).options & FIELD_CHECK)
#define FIELD_SUBFORM_ON(entry)           (int) ((entry).options & FIELD_SUBFORM_DEF)
#define FIELD_OVERRIDE_FORWARD_ON(entry)  (int) ((entry).options & FIELD_OVERRIDE_FORWARD)
#define FIELD_OVERRIDE_BACKWARD_ON(entry) (int) ((entry).options & FIELD_OVERRIDE_BACKWARD)
#define FIELD_USEMOUSE_ON(entry)          (int) ((entry).options & FIELD_USEMOUSE)
#define FIELD_CLEARFIELD_ON(entry)        (int) ((entry).options & FIELD_CLEARFIELD)


#define FORM_DIRECTION(form)         ((form)->formdir)
#define FORM_EXPLODE_TYPE(form)      ((form)->explode)
#define FORM_WRAP_ON(form)           ((form)->options & FORM_WRAP)
#define FORM_CHECK_ON(form)          ((form)->options & FORM_CHECK)
#define FORM_EXIT_INITIAL_ON(form)   ((form)->options & FORM_EXIT_INITIAL)
#define FORM_HIGHLIGHT_ON(form)      ((form)->options & FORM_HIGHLIGHT)
#define FORM_VIRTUAL_ON(form)        ((form)->options & FORM_VIRTUAL)
#define FORM_NOEXIT_LAST_ON(form)    ((form)->options & FORM_NOEXIT_LAST)
#define FORM_STATIC_ON(form)         ((form)->options & FORM_STATIC)

#define GET_FIELDPTR_FROM_FORM(form,fldnum) \
                    ((FIELDPTR)((form)->field[(fldnum)]))

#define GET_FIELD_FROM_FORM(form,entry) \
                    (GET_FIELDPTR_FROM_FORM(form,entry)->fentry)

#define GET_FIELD_NUMBER(form,entry) \
	      (GET_FIELDPTR_FROM_FORM(form,entry)->field_number)

#define FIELD_DECIMAL_PLACES(form,entry) \
        (GET_FIELDPTR_FROM_FORM(form,entry)->numdec)



#define FIELD_ROW(entry)                  ((entry).row)
#define FIELD_COLUMN(entry)               ((entry).col)
#define FIELD_TYPE(entry)                 ((entry).type)
#define FIELD_MASK(entry)                 ((entry).mask)
#define FIELD_FILL(entry)                 ((entry).fillchar)
#define FIELD_MINIMUM(entry)              ((entry).minchars)
#define FIELD_VISIBLE_WIDTH(entry)        ((entry).maxwidth)
#define FIELD_REGEXP(entry)               ((entry).regexp)
#define FIELD_ATTRIBUTE(entry)            ((entry).attr)
#define FIELD_START_POSITION(entry)       ((entry).startpos)
#define FIELD_VARPTR(form,entry)          \
                       (GET_FIELDPTR_FROM_FORM(form,entry)->uservar)
#define FIELD_CHANGE(form,entry)          \
                       (GET_FIELDPTR_FROM_FORM(form,entry)->field_change)

#define FIELD_NUMERIC(field)   ((field)->fentry.type == INTEGER    || \
                                (field)->fentry.type == UINTEGER   || \
                                (field)->fentry.type == LINTEGER   || \
                                (field)->fentry.type == ULINTEGER  || \
                                (field)->fentry.type == FLOAT      || \
                                (field)->fentry.type == DOUBLE)

#define FIELD_BUFSIZE(form,entry) (GET_FIELDPTR_FROM_FORM(form,entry)->bufsize)

#define FORM_WINDOW(form)                 ((form)->form_window)
#define FORM_VIRTUAL_WINDOW(form)         ((form)->form_vwindow)
#define FORM_CHANGE(form)                 ((form)->form_change)
#define FORM_NUMBER_OF_FIELDS(form)       ((form)->numfields)
#define FIELD_IN_RANGE(form,entry)    (((entry) < FORM_NUMBER_OF_FIELDS(form)) \
                                        && ((entry) >= 0))

#define FIELD_CURSORTYPE(form,entry,which) \
  (GET_FIELDPTR_FROM_FORM(form,entry)->cursortype[which])

#define FIELD_CURSORMODE(form,entry) \
  (GET_FIELDPTR_FROM_FORM(form,entry)->defmode)


#define SUBFORM_UP     1
#define SUBFORM_DOWN   2
#define SKIP_FIELD     24
#define FIELD_ERROR    25

#define LAST_FIELD_EXIT  (-1)
#define FIRST_FIELD_EXIT (-2)
#define FORM_END_CLEAR   (-3)
#define TESTFORM  1
#define TESTFIELD 2
#define TOGGLE_NULL  ((char *)0)

#define FIELD_HELP_CONTINUE  0
#define FIELD_HELP_UP        1
#define FIELD_HELP_DOWN      2
#define FIELD_HELP_RIGHT     3
#define FIELD_HELP_LEFT      4
#define FIELD_HELP_QUIT      5
#define FIELD_HELP_ZOOM      6
#define VIRTUAL_HELP         0
#define DISK_HELP            1
#define ONLINE_HELP          1
#define STATIC_HELP          0
#define FIELDHELPLEN         15


#define MAXHELPLINE  132

#define GET_HELP_TYPE(form,htype) \
      ((htype == ONLINE_HELP)?((FIELD_HELP_PTR)((form)->field_help1)): \
                              ((FIELD_HELP_PTR)((form)->field_help2)))

#define FIELD_HELP_START_KEY(fhp) \
         (fhp->help_key[HELP_START_KEY])

#define FIELD_HELP_END_KEY(fhp)   \
         (fhp->help_key[HELP_END_KEY])

#define FIELD_HELP_UP_KEY(fhp)    \
         (fhp->help_key[HELP_UP_KEY])

#define FIELD_HELP_DOWN_KEY(fhp)  \
         (fhp->help_key[HELP_DOWN_KEY])

#define FIELD_HELP_LEFT_KEY(fhp)  \
         (fhp->help_key[HELP_LEFT_KEY])

#define FIELD_HELP_RIGHT_KEY(fhp) \
         (fhp->help_key[HELP_RIGHT_KEY])

#define FIELD_HELP_ZOOM_KEY(fhp) \
         (fhp->help_key[HELP_ZOOM_KEY])

#define FIELD_HELP_DEFINED(fhp) (fhp)

#define FIELD_HELP_ON(form,htype) \
      ((htype == ONLINE_HELP)?(form)->help1_on:(form)->help2_on)


#define FIELD_HELP_WINDOW(fhp)  (fhp->help_window)

#define FIELD_HELP_VWINDOW(fhp) (fhp->help_vwindow)

#define FIELD_HELP_NAME(fhp, num) (fhp->helpname[num])
#define FIELD_HELP_TYPE(fhp)      (fhp->helptype)

#define NUMRADIOCOLORS       4
#define NUMCHECKBOXCOLORS    NUMRADIOCOLORS
#define NUMBUTTONCOLORS      NUMRADIOCOLORS
#define NORMATTR             0
#define HIATTR               1
#define HOTATTR              2
#define UNAVAILATTR          3



typedef struct {
    unsigned alldigits:1;      /* tells if all digits */
    unsigned attrdef:1;        /* attribute is defined */
    unsigned maskdisp:1;        /* mask defined */
    unsigned insert:1;         /* tells if in insert mode */
    unsigned uppercase:1;      /* tells if alpha characters are displayed in
                                * upper case */
    unsigned lowercase:1;      /* tells if alpha characters are displayed in
                                * lower case */
    unsigned checkspaces:1;    /* tells if input manager should check for
                                * blank spaces when checking input
                                * requirements */
    unsigned enhancedkey:1;    /* Tells if enhanced keys should be detected */
    unsigned checkregexp:1;    /* tells if each input position matches the
                                * regular expression desired */
    unsigned other_field_type:3; /* other field type */
 }
 FIELD_OPTIONS;



/* define form structure */

typedef struct tagFORMSTRUCT
{
  char **field;             /* pointer to char must be
                               same size as pointer to field -
                               array of field pointers */
  unsigned *form_key;       /* keys defined for form */
  WPOINTER form_window;     /* window for form */
  VWPOINTER form_vwindow;   /* virtual window for form */
  char *inputbuffer;
  int orig_rank;            /* used for forms with list fields */
  int (*form_exit_func) _PROTO_((struct tagFORMSTRUCT *, int, int *));
  int numfields;
  unsigned long total_bufsize;
  unsigned num_protected;
  int explode;
  unsigned formdir:3;
  unsigned form_change:1;
  unsigned options;
  unsigned help1_on:1;
  unsigned help2_on:1;
  VOIDPTR field_help1;       /* pointer to field help structure */
  VOIDPTR field_help2;       /* pointer to perpetual field help */

} FORM, *FORMPTR;

typedef int (*FORMEXITPROC)      _PROTO_((FORMPTR, int, int *));
typedef int (*FIELDPREPROC)      _PROTO_((FORMPTR, int *));
typedef int (*FIELDPOSTPROC)     _PROTO_((FORMPTR, int *));
typedef int (*FIELDVALIDATEPROC) _PROTO_((FORMPTR, int, char *));
typedef int (*BUTTONPROC)        _PROTO_((FORMPTR,int,int *));

/* define basic field entry */

typedef struct tagFIELDENTRY
{
  int type;              /* field type */
  unsigned row,          /* field row */
           col;          /* field column */
  char *mask;            /* user defined mask */
  int fillchar;          /* fill character */
  int minchars;          /* minimum characters */
  int maxwidth;          /* maximum width of shown field */
  unsigned long options; /* options */
  int startpos;          /* starting position in the field */
  int attr;              /* attribute to use for the field */
  char *regexp;          /* regular expression */
} FIELD_ENTRY, *FIELD_ENTRY_PTR;



/* define 'official' field entry */
typedef struct tagFIELD
{
  int field_number;     /* field position */
  FIELD_ENTRY fentry;   /* basic field entry */
  FIELDPREPROC  prefunc;            /* pre function to field */
  FIELDPOSTPROC postfunc;           /* post function to field */
  FIELDVALIDATEPROC validate_func;  /* error function */
  int cursortype[2];    /* cursor shapes for insert/overwrite */
  unsigned defmode:1;  /* cursor mode on start of input */
  VOIDPTR uservar;        /* pointer to user variable */
  VOIDPTR other;           /* pointer to other types of fields -
                         * for future expansion */
  int passchar;         /* password character if passwords used */
  int bufsize;          /* size of field buffer
                         *  (depends on regular expression)   */
  char *buffer;         /* field buffer */
  unsigned editkeys[NUMFORMKEYS];   /* field edit keys */
  unsigned int numdec;  /*  number of decimal places */
  unsigned field_change:1; /* 1 if field has been changed, 0 otherwise */
  FIELD_OPTIONS field_opt;  /* options for field */
} FIELD, *FIELDPTR;


/* help info structure pointers */
typedef struct tagVHELPSTRUCT
{
  unsigned f_line;
  unsigned l_line;
  unsigned line_length;
} VHELP_STRUCT, *VHELP_STRUCT_PTR;


typedef struct tagDHELPSTRUCT
{
  long filepos;
  unsigned nlines;
  unsigned line_length;
} DHELP_STRUCT, *DHELP_STRUCT_PTR;


/* field help structure */
typedef struct tagFIELD_HELP
{
  FIELDPTR *field;
  char *filename;
  WPOINTER help_window;
  VWPOINTER help_vwindow;
  unsigned help_key[NUMHELPKEYS];
  VHELP_STRUCT_PTR vhelp_struct;
  DHELP_STRUCT_PTR dhelp_struct;
  unsigned num_help;
  unsigned helptype:1;
  unsigned fileopen:1;
  unsigned online:1;
  char **helpname;
  VOIDPTR handle;
} FIELD_HELP, *FIELD_HELP_PTR;


/* SUBFORM structure */
typedef struct tagSUBFORM
{
  FORMPTR parent;
  FORMPTR form;
  int start_entry;
  int rank;
} SUBFORM_FIELD, *SUBFORM_FIELD_PTR, VSUBFORM_FIELD, *VSUBFORM_FIELD_PTR;


/* LIST structure */
typedef struct tagLIST
{
  POPUP_MENU_PTR popup;
  int choice;
  int start_entry;
  int rank;
  int new_entry;    /* needed if new entry was found */
  int return_value; /* return value used by form manager */
} LIST_FIELD, *LIST_FIELD_PTR;




/* TOGGLE structure */
typedef struct tagTOGGLE
{
  char **toglist;
  int choice;
  int start_entry;
} TOGGLE_FIELD, *TOGGLE_FIELD_PTR;



/* BUTTON structure */
typedef struct tagBUTTON
{
  int retval;
  char *name;
  BUTTONPROC button_func;
  int attr[NUMBUTTONCOLORS];
  int pending;
} BUTTON_FIELD, *BUTTON_FIELD_PTR;


/* RADIO_ENTRY and CHECKBOX structure */
typedef union tagRADCHECK
{
  unsigned radio_prompt_row,
           checkbox_prompt_row;
} PROMPT_ROW;


typedef union
{
  unsigned radio_prompt_col,
           checkbox_prompt_col;
} PROMPT_COL;


typedef union
{
  unsigned radio_button_row,
           checkbox_button_row;
} BUTTON_ROW;


typedef union
{
  unsigned radio_button_col,
           checkbox_button_col;
} BUTTON_COL;


typedef struct
{
  char *prompt;
  int  hot_letter;
  PROMPT_ROW p_row;
  PROMPT_COL p_col;
  BUTTON_ROW b_row;
  BUTTON_COL b_col;
} RADIO_ENTRY, *RADIO_ENTRY_PTR, CHECKBOX_ENTRY, *CHECKBOX_ENTRY_PTR;



/* RADIO structure */
typedef struct tagRADIO
{
  int radio_current;
  int radio_char;
  int num_entries;
  int attr[NUMRADIOCOLORS];  /* attribute of unhighlighted radio button */
  BITSTRING active;
  int pending;
  int start_entry;
  RADIO_ENTRY_PTR radio_entry;
} RADIO_FIELD, *RADIO_FIELD_PTR;



typedef struct tagCHECKBOX
{
  int checkbox_current;
  int checkbox_char;
  int num_entries;
  int attr[NUMCHECKBOXCOLORS];
  int pending;
  int start_entry;
  BITSTRING active;
  BITSTRING chosen;
  CHECKBOX_ENTRY_PTR checkbox_entry;
} CHECKBOX_FIELD, *CHECKBOX_FIELD_PTR;



#define GET_LIST_FIELD(form,entry) \
     ((LIST_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define GET_LIST_FIELD_FROM_POPUP(p)  ((LIST_FIELD_PTR)((p)->listptr))

#define GET_POPUP_FROM_LIST_FIELD(form,entry) \
        (GET_LIST_FIELD(form,entry)->popup)

#define GET_TOGGLE_FIELD(form,entry) \
     ((TOGGLE_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define GET_BUTTON_FIELD(form,entry) \
     ((BUTTON_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)


#define GET_RADIO_FIELD(form,entry) \
     ((RADIO_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define GET_SUBFORM_FIELD(form,entry) \
     ((SUBFORM_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define GET_SUBFORM_FORMPTR(form,entry) \
     ((GET_SUBFORM_FIELD(form,entry))->subform)


#define GET_VSUBFORM_FIELD(form,entry) \
     ((VSUBFORM_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define GET_VSUBFORM_FORMPTR(form,entry) \
     ((GET_VSUBFORM_FIELD(form,entry))->subform)

#define GET_CHECKBOX_FIELD(form,entry) \
      ((CHECKBOX_FIELD_PTR)(GET_FIELDPTR_FROM_FORM(form,entry))->other)

#define LIST_START_ENTRY(form,entry) \
    (GET_LIST_FIELD(form,entry)->start_entry)

#define TOGGLE_START_ENTRY(form,entry) \
    (GET_TOGGLE_FIELD(form,entry)->start_entry)

#define CHECKBOX_START_ENTRY(form,entry) \
    (GET_CHECKBOX_FIELD(form,entry)->start_entry)

#define RADIO_START_ENTRY(form,entry) \
    (GET_RADIO_FIELD(form,entry)->start_entry)

#define SUBFORM_START_ENTRY(form,entry) \
    (GET_SUBFORM_FIELD(form,entry)->start_entry)

#define VSUBFORM_START_ENTRY(form,entry) \
    (GET_VSUBFORM_FIELD(form,entry)->start_entry)

#define BUTTON_FIELD_RETURN(form,entry) \
        (GET_BUTTON_FIELD(form,entry)->retval)

#define BUTTON_FIELD_USER_FUNC(form,entry) \
        (GET_BUTTON_FIELD(form,entry)->button_func)

#define BUTTON_FIELD_PENDING(form,entry) \
        (GET_BUTTON_FIELD(form,entry)->pending)

#define LIST_FIELD_CHOICE(form,entry) \
      (GET_LIST_FIELD(form,entry)->choice)


#define LIST_FIELD_NEWENTRY(form,entry) \
      (GET_LIST_FIELD(form,entry)->new_entry)

#define TOGGLE_FIELD_CHOICE(form,entry) \
      (GET_TOGGLE_FIELD(form,entry)->choice)


#define CHECKBOX_FIELD_PENDING(form,entry) \
        (GET_CHECKBOX_FIELD(form,entry)->pending)

#define CHECKBOX_FIELD_ACTIVE(form,entry,entrynum) \
        (test_bit((GET_CHECKBOX_FIELD(form,entry)->active),(entrynum)))

#define CHECKBOX_FIELD_CHOSEN(form,entry,entrynum) \
        (test_bit((GET_CHECKBOX_FIELD(form,entry)->chosen),(entrynum)))

#define CHECKBOX_FIELD_BUTTON_ROW(form,entry,entrynum) \
(GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].b_row.checkbox_button_row)

#define CHECKBOX_FIELD_BUTTON_COLUMN(form,entry,entrynum) \
(GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].b_col.checkbox_button_col)

#define CHECKBOX_FIELD_PROMPT_COLUMN(form,entry,entrynum) \
(GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].p_col.checkbox_prompt_col)

#define CHECKBOX_FIELD_PROMPT_ROW(form,entry,entrynum) \
(GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].p_row.checkbox_prompt_row)

#define CHECKBOX_FIELD_HOTKEY_LETTER(form,entry,entrynum) \
(GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].hot_letter)

#define CHECKBOX_FIELD_NORMATTR(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->attr[NORMATTR])

#define CHECKBOX_FIELD_HIATTR(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->attr[HIATTR])

#define CHECKBOX_FIELD_HOTATTR(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->attr[HOTATTR])

#define CHECKBOX_FIELD_UNAVAILATTR(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->attr[UNAVAILATTR])

#define CHECKBOX_FIELD_PROMPT(form,entry,entrynum) \
     (GET_CHECKBOX_FIELD(form,entry)->checkbox_entry[(entrynum)].prompt)

#define CHECKBOX_FIELD_CURRENT_CHOICE(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->checkbox_current)

#define CHECKBOX_FIELD_CHAR(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->checkbox_char)

#define CHECKBOX_FIELD_NUM_ENTRIES(form,entry) \
     (GET_CHECKBOX_FIELD(form,entry)->num_entries)

#define RADIO_FIELD_PENDING(form,entry) \
        (GET_RADIO_FIELD(form,entry)->pending)

#define RADIO_FIELD_ACTIVE(form,entry,entrynum) \
        (test_bit((GET_RADIO_FIELD(form,entry)->active),(entrynum)))

#define RADIO_FIELD_BUTTON_ROW(form,entry,entrynum) \
(GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].b_row.radio_button_row)

#define RADIO_FIELD_BUTTON_COLUMN(form,entry,entrynum) \
(GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].b_col.radio_button_col)

#define RADIO_FIELD_PROMPT_COLUMN(form,entry,entrynum) \
(GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].p_col.radio_prompt_col)

#define RADIO_FIELD_PROMPT_ROW(form,entry,entrynum) \
(GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].p_row.radio_prompt_row)

#define RADIO_FIELD_HOTKEY_LETTER(form,entry,entrynum) \
        (GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].hot_letter)

#define RADIO_FIELD_NORMATTR(form,entry) \
        (GET_RADIO_FIELD(form,entry)->attr[NORMATTR])

#define RADIO_FIELD_HIATTR(form,entry) \
        (GET_RADIO_FIELD(form,entry)->attr[HIATTR])

#define RADIO_FIELD_HOTATTR(form,entry) \
        (GET_RADIO_FIELD(form,entry)->attr[HOTATTR])

#define RADIO_FIELD_UNAVAILATTR(form,entry) \
        (GET_RADIO_FIELD(form,entry)->attr[UNAVAILATTR])

#define RADIO_FIELD_PROMPT(form,entry,entrynum) \
        (GET_RADIO_FIELD(form,entry)->radio_entry[(entrynum)].prompt)

#define RADIO_FIELD_CURRENT_CHOICE(form,entry) \
        (GET_RADIO_FIELD(form,entry)->radio_current)

#define RADIO_FIELD_CHOSEN   RADIO_FIELD_CURRENT_CHOICE

#define RADIO_FIELD_CHAR(form,entry) \
        (GET_RADIO_FIELD(form,entry)->radio_char)

#define RADIO_FIELD_NUM_ENTRIES(form,entry) \
        (GET_RADIO_FIELD(form,entry)->num_entries)

#define NO_BUTTON_FUNC         ((BUTTONPROC)0)
#define NO_UNDEF_SPECIAL_FUNC  ((int (*)(FORMPTR,int,int *))0)


CHECKBOX_ENTRY_PTR CheckboxAllocate _PROTO_((int num));

CWL_VOID         CheckboxDeallocate _PROTO_((CHECKBOX_ENTRY_PTR pentry));

CWL_VOID         CheckboxCreateEntry _PROTO_((CHECKBOX_ENTRY *entry,
                                      int entrynum,
                                      char *pname, int hot_letter,
                                      unsigned prow, unsigned pcol,
                                      unsigned brow, unsigned bcol));

CWL_VOID         CheckboxEntryEnd _PROTO_((CHECKBOX_ENTRY_PTR entry,
                                         int numfields));

FIELD_ENTRY_PTR  FieldAllocate _PROTO_((int numfields));

CWL_VOID         FieldCreate _PROTO_((FIELD_ENTRY_PTR field, int fldnum,
                                      int fldtype, unsigned fldrow,
                                      unsigned fldcol, char *mask,
                                      int fillchar, int minchars, int maxwidth,
                                      unsigned long fldopts, int startpos,
                                      int attr, char *regexp));

CWL_VOID         FieldEnd _PROTO_((FIELD_ENTRY_PTR field, int numfields));

CWL_VOID         FieldDeallocate _PROTO_((FIELD_ENTRY_PTR field));

int              FormActivateRadioEntry _PROTO_((FORMPTR form, int entry,
                                           int entrynum, int flag));

int              FormActivateCheckboxEntry _PROTO_((FORMPTR form, int entry,
                                              int entrynum, int flag));

int              FormCallFieldHelp _PROTO_((FORMPTR form, int entry,
                                            int online));
int              FormCheckCheckboxEntry _PROTO_((FORMPTR form, int entry,
                                                 int centry,int flag));

int              FormCloseHelp _PROTO_((FORMPTR form, int online));

int              FormConvDataToString _PROTO_((FORMPTR form, int entry,
                                         VOIDPTR dataptr, char *buf));

int              FormDisplay _PROTO_((FORMPTR form, int rank, int effect));

int              FormGetHelpNumber _PROTO_((FORMPTR form, char *name, int online));

int              FormGetListChoice _PROTO_((FORMPTR form, int entry));

int              FormGetRadioChoice _PROTO_((FORMPTR form, int entry));

int              FormGetToggleChoice _PROTO_((FORMPTR form, int entry));

int              FormGetCheckboxChoice _PROTO_((FORMPTR form, int entry,
                                          int centry));

int              FormHide _PROTO_((FORMPTR form, int effect));

FORMPTR          FormInitialize _PROTO_((VOIDPTR win, FIELD_ENTRY *fldptr, int options));

int              FormInitializeSystem _PROTO_((CWL_VOID));

int              FormInitializeFieldData _PROTO_((FORMPTR form, char **data, int start,
                                           int end));

int              FormInitializeFieldHelp _PROTO_((FORMPTR form, WPOINTER w,
                                            char *filename, int helptype,
                                            int online));

CWL_VOID         FormInitializeFloat _PROTO_((CWL_VOID));

int              FormMove _PROTO_((FORMPTR form, int row, int col));

int              FormGetInput _PROTO_((FORMPTR form, int rank, int entry, ...));

int              FormClose _PROTO_((FORMPTR form));

CWL_VOID         FormCloseAll _PROTO_((CWL_VOID ));

int              FormSetButtonField _PROTO_((FORMPTR form, int entry, int retval,
                                       char *name, int *attr,
                                       BUTTONPROC func));

int              FormSetCheckboxField _PROTO_((FORMPTR form, int entry,
                                         CHECKBOX_ENTRY_PTR cptr,
                                         int cchar, int start, int *attr));

int              FormSetFieldOptions _PROTO_((FORMPTR form, int entry,
                                        unsigned long option, int flag));

int              FormSetFieldPreFunction _PROTO_((FORMPTR form, int entry,
                                                  FIELDPREPROC func));

int              FormSetExitFunction _PROTO_((FORMPTR form,
                                              FORMEXITPROC exit_func));

int              FormSetFieldValidateFunction _PROTO_((FORMPTR form, int entry,
                                                       FIELDVALIDATEPROC func));

int              FormSetFieldPostFunction _PROTO_((FORMPTR form, int entry,
                                                   FIELDPOSTPROC func));

int              FormSetFieldStart _PROTO_((FORMPTR form,  int entry,
                                            int startpos));

int              FormSetFieldDecimal _PROTO_((FORMPTR form, int entry,
                                              unsigned numdec));

int              FormSetHelpKeys _PROTO_((FORMPTR form, unsigned *keys,
                                          int online));

int              FormSetListField _PROTO_((FORMPTR form, int entry, int rank,
                                           int start, POPUP_MENU_PTR p));

int              FormSetMouse _PROTO_((FORMPTR form, int opt));

int              FormSetOptions _PROTO_((FORMPTR form, int options, int flag));

int              FormSetRadioField _PROTO_((FORMPTR form, int entry,
                                            RADIO_ENTRY_PTR rptr, int rchar,
                                            int start, int *attr));

int              FormSetSubformField _PROTO_((FORMPTR form, int entry, int rank,
                                              int start,
                                              FORMPTR subform));

int              FormSetVSubformField _PROTO_((FORMPTR form, int entry,
                                               int rank, int start,
                                               FORMPTR subform, WPOINTER w));

int              FormSetToggleField _PROTO_((FORMPTR form, int entry,
                                             char **toglist));

int              FormToggleFieldHelp _PROTO_((FORMPTR form, int online,
                                              int flag));

int              FormAssignFieldKeys _PROTO_((FORMPTR form, int entry,
                                              unsigned *keys));

int              FormGetFieldRowCol _PROTO_((FORMPTR form, int entry,
                                             unsigned *row,
                                             unsigned *col));

int              FormGetFieldData _PROTO_((FORMPTR form, int entry,
                                           VOIDPTR data));

char *           FormGetFieldString _PROTO_((FORMPTR form, int entry));

int              FormClear _PROTO_((FORMPTR form, int entry));

int              FormSetFieldVariable _PROTO_((FORMPTR form, int entry,
                                               VOIDPTR dataptr, int display));

int              FormPutFieldData _PROTO_((FORMPTR form, int entry, ...));

int              FormWriteFieldValue _PROTO_((FORMPTR form, int entry,
                                              char *value));

int              FormCheckFieldRange _PROTO_((FORMPTR form, int entrynum,
                                              int options, ...));

RADIO_ENTRY_PTR  RadioAllocate _PROTO_((int num));

CWL_VOID         RadioDeallocate _PROTO_((RADIO_ENTRY_PTR pentry));

CWL_VOID         RadioCreateEntry _PROTO_((RADIO_ENTRY *entry, int entrynum,
                                           char *pname, int hot_letter,
                                           unsigned prow, unsigned pcol,
                                           unsigned brow, unsigned bcol));

CWL_VOID         RadioEntryEnd _PROTO_((RADIO_ENTRY_PTR entry, int numfields));



/*********************** End of Forms Definitions *************************/


/*********************** Mouse Functions *****************************/
#define NOMOUSE   (-1)
#define MOUSEFOUND 0

#define MOUSELEFT_PRESS            500
#define MOUSERIGHT_PRESS           501
#define MOUSEMIDDLE_PRESS          502
#define MOUSELEFTRIGHT_PRESS       503
#define MOUSEMIDDLERIGHT_PRESS     504
#define MOUSEMIDDLELEFT_PRESS      505
#define MOUSEMIDDLERIGHTLEFT_PRESS 506

#define LEFT_MBUTTON           0
#define RIGHT_MBUTTON          1
#define MIDDLE_MBUTTON         2

#define CURSORMOVE             1
#define LEFTBUTTONPRESSED      2
#define LEFTBUTTONRELEASED     4
#define RIGHTBUTTONPRESSED     8
#define RIGHTBUTTONRELEASED    16
#define MIDDLEBUTTONPRESSED    32
#define MIDDLEBUTTONRELEASED   64
#define IGNORERELEASE         128
#define PRESSFIRST            256
#define RELEASEFIRST          512
#define PRESSORRELEASEFIRST   (PRESSFIRST | RELEASEFIRST)
#define BUTTONRELEASED     (LEFTBUTTONRELEASED | RIGHTBUTTONRELEASED | \
                            MIDDLEBUTTONRELEASED)
#define BUTTONPRESSED      (LEFTBUTTONPRESSED | RIGHTBUTTONPRESSED | \
                            MIDDLEBUTTONPRESSED)

#define RIGHTBUTTON_DPRESS  (RIGHTBUTTONPRESSED|IGNORERELEASE|PRESSFIRST)
#define LEFTBUTTON_DPRESS   (LEFTBUTTONPRESSED|IGNORERELEASE|PRESSFIRST)
#define MIDDLEBUTTON_DPRESS (MIDDLEBUTTONPRESS|IGNORERELEASE|PRESSFIRST)

#define RIGHTBUTTON_PRESSRELEASE (RIGHTBUTTONPRESSED|RIGHTBUTTONRELEASED| \
                                   PRESSFIRST)
#define LEFTBUTTON_PRESSRELEASE (LEFTBUTTONPRESSED|LEFTBUTTONRELEASED| \
                                   PRESSFIRST)
#define MIDDLEBUTTON_PRESSRELEASE (MIDDLEBUTTONPRESSED|MIDDLEBUTTONRELEASED| \
                                   PRESSFIRST)


#define LEFTTOPCORNER     0
#define LEFTBOTTOMCORNER  1
#define RIGHTTOPCORNER    2
#define RIGHTBOTTOMCORNER 3

#define MIN_HOTSPOT_WIDTH       7
#define MIN_SCROLLBAR_SIZE      4
#define DEFAULT_SCROLLHI_COLOR  CREATE_VIDEO_ATTRIBUTE(BLACK_,LIGHTWHITE_)
#define NO_MOUSE_GRAB_FUNC      ((CWL_VOID (*)(WPOINTER,int,int))0)

#define M_EVENT    1
#define K_EVENT    2
#define T_EVENT    4
#define NUMTIMERS  16       /* define the maximum number of timers */

/* Use Microsoft Windows style macros */
#define WS_VSCROLL          0x00200000L
#define WS_HSCROLL          0x00100000L
#define WS_MINIMIZEBOX      0x00020000L
#define WS_MAXIMIZEBOX      0x00010000L
#define WS_SYSMENU          0x00080000L


#define CWL_VSCROLL          WS_VSCROLL
#define CWL_HSCROLL          WS_HSCROLL
#define CWL_MINIMIZEBOX      WS_MINIMIZEBOX
#define CWL_MAXIMIZEBOX      WS_MAXIMIZEBOX
#define CWL_SYSMENU          WS_SYSMENU
#define CWL_MINMAXBOX        (WS_MINIMIZEBOX | WS_MAXIMIZEBOX)
#define CWL_MINBOX           WS_MINIMIZEBOX
#define CWL_MAXBOX           WS_MAXIMIZEBOX


/* Mouse Messages Microsoft Windows Style */
#define CWL_MOUSEMOVE        0x0200
#define CWL_LBUTTONDOWN      0x0201
#define CWL_LBUTTONUP        0x0202
#define CWL_LBUTTONDBLCLK    0x0203
#define CWL_RBUTTONDOWN      0x0204
#define CWL_RBUTTONUP        0x0205
#define CWL_RBUTTONDBLCLK    0x0206
#define CWL_MBUTTONDOWN      0x0207
#define CWL_MBUTTONUP        0x0208
#define CWL_MBUTTONDBLCLK    0x0209
#define CWL_PRERESIZE        0x020A
#define CWL_POSTRESIZE       0x020B
#define CWL_PREMOVE          0x020C
#define CWL_POSTMOVE         0x020D
#define CWL_BEGINRESIZE      0x020E
#define CWL_BEGINMOVE        0x020F

/* Mouse return and event messages */
#define CWL_ENDRESIZE       0x0210
#define CWL_ENDMOVE         0x0211
#define CWL_SIZE            0x0005
#define CWL_MOVE            0x0003

/* User message starting point */
#define CWL_USER                0x0400

/* Timer message */
#define CWL_TIMER       0x0113

/* Hit test message */
#define CWL_HITTEST     0x0084

/* Keyboard messages */
#define CWL_KEYDOWN          0x0100
#define CWL_KEYUP            0x0101
#define CWL_CHAR             0x0102
#define CWL_MESSAGE_QUIT     0x0012

/* Mouse 'Where Are You' Codes */
#define CWL_HTMINBUTTON      2
#define CWL_HTMAXBUTTON      3
#define CWL_HTCAPTION        4
#define CWL_HTZOOM           CWL_HTMAXBUTTON
#define CWL_HTREDUCE         CWL_HTMINBUTTON
#define CWL_HTRIGHT          5
#define CWL_HTLEFT           6
#define CWL_HTTOP            7
#define CWL_HTBOTTOM         8
#define CWL_HTBOTTOMLEFT     9
#define CWL_HTBOTTOMRIGHT    10
#define CWL_HTTOPLEFT        11
#define CWL_HTTOPRIGHT       12
#define CWL_HTHSCROLL        13
#define CWL_HTVSCROLL        14
#define CWL_HTCLIENT         15
#define CWL_HTNOWHERE        16
#define CWL_HTBORDER         17


/* Other mouse macros */
#define CLIENT_AREA            1
#define NONCLIENT_AREA         0

#define CWL_MKLBUTTON          0x0001
#define CWL_MKRBUTTON          0x0002
#define CWL_MKSHIFT            0x0004
#define CWL_MKCONTROL          0x0008
#define CWL_MKMBUTTON          0x0010

#define RESIZE_DOWNRIGHT       0x0001
#define RESIZE_DOWNLEFT        0x0002
#define RESIZE_UPRIGHT         0x0003
#define RESIZE_UPLEFT          0x0004
#define RESIZE_DOWN            0x0005
#define RESIZE_UP              0x0006
#define RESIZE_LEFT            0x0007
#define RESIZE_RIGHT           0x0008

#define CWLMOUSE_ACTIVE        1
#define CWLMOUSE_SAVE          TRUE



/* Hotspot macros */

#define NO_SCROLLBARS                    0L
#define SCROLLBAR_VERTICAL               WS_VSCROLL
#define SCROLLBAR_HORIZONTAL             WS_HSCROLL
#define WINDOW_MAXIMIZE                  WS_MAXIMIZEBOX
#define WINDOW_MINIMIZE                  WS_MINIMIZEBOX
#define WINDOW_HIDE                      0x8L
#define WINDOW_CLOSE                     0x10L
#define WINDOW_MOVE_TOP                  0x20L
#define WINDOW_MOVE_BOTTOM               0x40L
#define WINDOW_MOVE_LSIDE                0x80L
#define WINDOW_MOVE_RSIDE                0x100L
#define WINDOW_RESIZE_TOPLEFT            0x200L
#define WINDOW_RESIZE_TOPRIGHT           0x400L
#define WINDOW_RESIZE_BOTTOMLEFT         0x800L
#define WINDOW_RESIZE_BOTTOMRIGHT        0x1000L
#define WINDOW_PLACE_ON_TOP              0x2000L
#define WINDOW_DBLCLK                    0x4000L
#define WINDOW_SYSMENU                   WS_SYSMENU
#define CWL_DEFAULT_SCROLLBARS           (WS_VSCROLL | WS_HSCROLL)
#define CWL_DBLCLK                       WINDOW_DBLCLK
#define CWL_BACKGROUND                   0x8000L
#define WINDOW_ZOOM                      WINDOW_MAXIMIZE

#define SEETHRU_MODE         1
#define NORMAL_MODE          2



#define ONZOOM               1
#define ONMINIMIZE           2
#define ALLZOOM              3
#define MINSCROLLHEIGHT      4
#define MINIMIZE_WIDTH       7


#define H_C_CHAR             0
#define Z_CHAR               1
#define UNZ_CHAR             2
#define H_C_ATTR             3
#define Z_ATTR               4
#define UNZ_ATTR             5
#define Z_ROW                6
#define Z_COL                7
#define H_C_ROW              8
#define H_C_COL              9
#define Z_OLDHEIGHT         10
#define Z_OLDWIDTH          11
#define Z_OLDROW            12
#define Z_OLDCOL            13
#define MIN_ROW             14
#define MIN_COL             15
#define MAXIMIZE_CHAR       16
#define MINIMIZE_CHAR       17
#define Z_OPEN_CHAR         18
#define Z_OPEN_ATTR         19
#define Z_CLOSE_CHAR        20
#define Z_CLOSE_ATTR        21
#define Z_MIN_ROW           22
#define Z_MIN_COL           23
#define Z_MIN_WIDTH         24
#define Z_MIN_HEIGHT        25
#define Z_MIN_CHAR          26
#define Z_MIN_ATTR          27
#define CAP_ATTR            28
#define Z_HIGH_ATTR         29
#define N_OLDHEIGHT         30
#define N_OLDWIDTH          31
#define N_OLDROW            32
#define N_OLDCOL            33



#define ANY_SCROLLBARS  (SCROLLBAR_HORIZONTAL | SCROLLBAR_VERTICAL)


#define WIN_CLOSE  1
#define WIN_HIDE   2

#define WINDOW_MOVE  (WINDOW_MOVE_TOP | WINDOW_MOVE_BOTTOM | WINDOW_MOVE_LSIDE | \
                      WINDOW_MOVE_RSIDE)

#define CWL_CAPTION   WINDOW_MOVE_TOP


#define CWL_DEFAULT_RESIZE  (WINDOW_RESIZE_TOPLEFT | WINDOW_RESIZE_TOPRIGHT | \
                             WINDOW_RESIZE_BOTTOMLEFT | \
                             WINDOW_RESIZE_BOTTOMRIGHT)

#define CWL_RESIZE  CWL_DEFAULT_RESIZE

#define CWL_DEFAULT_HOTSPOTS   (CWL_DEFAULT_SCROLLBARS | WINDOW_ZOOM | \
                                WINDOW_HIDE | WINDOW_MOVE | CWL_DEFAULT_RESIZE | \
                                WINDOW_PLACE_ON_TOP)

#define DEFAULT_HOTSPOTS(w) ((w)->hotspot)
#define HOTSPOTS_DEFINED(w)   \
                 (USER_HOTSPOTS(w) || DEFAULT_HOTSPOTS(w))

#define HIDE_CLOSE_CHAR(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[H_C_CHAR])
#define ZOOM_CHAR(w)        (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_CHAR])
#define UNZOOM_CHAR(w)      (DEFAULT_HOTSPOTS(w)->hotspot_string[UNZ_CHAR])
#define HIDE_CLOSE_ATTR(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[H_C_ATTR])
#define ZOOM_ATTR(w)        (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_ATTR])
#define UNZOOM_ATTR(w)      (DEFAULT_HOTSPOTS(w)->hotspot_string[UNZ_ATTR])
#define ZOOM_ROW(w)         (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_ROW])
#define ZOOM_COLUMN(w)      (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_COL])
#define ZOOM_ORIG_HEIGHT(w) (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OLDHEIGHT])
#define ZOOM_ORIG_WIDTH(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OLDWIDTH])
#define ZOOM_ORIG_ROW(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OLDROW])
#define ZOOM_ORIG_COL(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OLDCOL])
#define ZOOM_OPEN_CHAR(w)   (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OPEN_CHAR])
#define ZOOM_OPEN_ATTR(w)   (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_OPEN_ATTR])
#define ZOOM_CLOSE_CHAR(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_CLOSE_CHAR])
#define ZOOM_CLOSE_ATTR(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_CLOSE_ATTR])
#define ZOOM_MIN_ROW(w)     (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_ROW])
#define ZOOM_MIN_COLUMN(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_COL])
#define ZOOM_MIN_WIDTH(w)   (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_WIDTH])
#define ZOOM_MIN_HEIGHT(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_HEIGHT])
#define ZOOM_MIN_CHAR(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_CHAR])
#define ZOOM_MIN_ATTR(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_MIN_ATTR])
#define CAPTION_ATTR(w)     (DEFAULT_HOTSPOTS(w)->hotspot_string[CAP_ATTR])
#define ZOOM_HIGH_ATTR(w)   (DEFAULT_HOTSPOTS(w)->hotspot_string[Z_HIGH_ATTR])
#define NORM_ORIG_HEIGHT(w) (DEFAULT_HOTSPOTS(w)->hotspot_string[N_OLDHEIGHT])
#define NORM_ORIG_WIDTH(w)  (DEFAULT_HOTSPOTS(w)->hotspot_string[N_OLDWIDTH])
#define NORM_ORIG_ROW(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[N_OLDROW])
#define NORM_ORIG_COL(w)    (DEFAULT_HOTSPOTS(w)->hotspot_string[N_OLDCOL])


#define CHARTOINT(c)         (int)(c)
#define INTTOCHAR(i)         (char)(i)


#define RESIZE_RIGHTTOP_ON(w)    (DEFAULT_HOTSPOTS(w) && \
               (DEFAULT_HOTSPOTS(w)->options & WINDOW_RESIZE_TOPRIGHT))

#define RESIZE_LEFTTOP_ON(w)     (DEFAULT_HOTSPOTS(w) && \
               (DEFAULT_HOTSPOTS(w)->options & WINDOW_RESIZE_TOPLEFT))

#define RESIZE_RIGHTBOTTOM_ON(w) (DEFAULT_HOTSPOTS(w) && \
               (DEFAULT_HOTSPOTS(w)->options & WINDOW_RESIZE_BOTTOMRIGHT))

#define RESIZE_LEFTBOTTOM_ON(w)  (DEFAULT_HOTSPOTS(w) && \
               (DEFAULT_HOTSPOTS(w)->options & WINDOW_RESIZE_BOTTOMLEFT))

#define RESIZE_ON(w) (RESIZE_RIGHTTOP_ON(w) || RESIZE_LEFTTOP_ON(w) || \
                      RESIZE_RIGHTBOTTOM_ON(w) || RESIZE_LEFTBOTTOM_ON(w))

#define SCROLLBARS_ON(w)      (DEFAULT_HOTSPOTS(w) && \
               (DEFAULT_HOTSPOTS(w)->options & ANY_SCROLLBARS))

#define SCROLLBAR_HORIZONTAL_ON(w)  (SCROLLBARS_ON(w) && \
                        (DEFAULT_HOTSPOTS(w)->options & SCROLLBAR_HORIZONTAL))

#define SCROLLBAR_VERTICAL_ON(w)  (SCROLLBARS_ON(w) && \
                        (DEFAULT_HOTSPOTS(w)->options & SCROLLBAR_VERTICAL))


#define GET_SCROLLBAR_HORZ(w)  (DEFAULT_HOTSPOTS(w)->sbarhorz)

#define GET_SCROLLBAR_VERT(w)  (DEFAULT_HOTSPOTS(w)->sbarvert)

#define SCROLLBAR_HORZ_VISIBLE(w) (SCROLLBAR_HORIZONTAL_ON(w) && \
                                   GET_SCROLLBAR_HORZ(w)->visible)

#define SCROLLBAR_VERT_VISIBLE(w) (SCROLLBAR_VERTICAL_ON(w) && \
                                   GET_SCROLLBAR_VERT(w)->visible)

#define ZOOM_BUTTON(w) (DEFAULT_HOTSPOTS(w) && (DEFAULT_HOTSPOTS(w)->options & WINDOW_ZOOM))


#define ZOOM_MODE_ON(w)     (ZOOM_BUTTON(w) && DEFAULT_HOTSPOTS(w)->zoom_on)

#define MINIMIZE_BUTTON(w)  (DEFAULT_HOTSPOTS(w) && (DEFAULT_HOTSPOTS(w)->options & WINDOW_MINIMIZE))

#define MINIMIZE_MODE_ON(w) (MINIMIZE_BUTTON(w) && DEFAULT_HOTSPOTS(w)->minimized)

#define WINDOW_PLACEONTOP_ON(w)     (DEFAULT_HOTSPOTS(w) && \
                                   (DEFAULT_HOTSPOTS(w)->options & WINDOW_PLACE_ON_TOP))

#define WINDOW_BACKGROUND_ON(w)    (DEFAULT_HOTSPOTS(w) && \
                                   (DEFAULT_HOTSPOTS(w)->options & CWL_BACKGROUND))

#define WINDOW_MOVE_ON(w)    (DEFAULT_HOTSPOTS(w) && \
                             (DEFAULT_HOTSPOTS(w)->options & WINDOW_MOVE))

#define WINDOW_MOVE_TOP_ON(w) (DEFAULT_HOTSPOTS(w) && \
                              (DEFAULT_HOTSPOTS(w)->options & WINDOW_MOVE_TOP))

#define WINDOW_MOVE_BOTTOM_ON(w) (DEFAULT_HOTSPOTS(w) && \
                                 (DEFAULT_HOTSPOTS(w)->options & WINDOW_MOVE_BOTTOM))

#define WINDOW_MOVE_LSIDE_ON(w) (DEFAULT_HOTSPOTS(w) && \
                                (DEFAULT_HOTSPOTS(w)->options & WINDOW_MOVE_LSIDE))

#define WINDOW_MOVE_RSIDE_ON(w) (DEFAULT_HOTSPOTS(w) && \
                                (DEFAULT_HOTSPOTS(w)->options & WINDOW_MOVE_RSIDE))

#define TRACK_SCROLL_SIDE(w)  (DEFAULT_HOTSPOTS(w)->track_scroll_top)

#define TRACK_SCROLL_BOTTOM(w) (DEFAULT_HOTSPOTS(w)->track_scroll_bottom)

#define WINDOW_DOUBLE_CLICK(w) (DEFAULT_HOTSPOTS(w) && \
                               (DEFAULT_HOTSPOTS(w)->options & WINDOW_DBLCLK))

#define ISWINDOW_MINIMIZED(w)  (DEFAULT_HOTSPOTS(w) && \
                                DEFAULT_HOTSPOTS(w)->minimized)

#define WINDOW_MINIMIZE_ON(w)  (DEFAULT_HOTSPOTS(w) && \
                                DEFAULT_HOTSPOTS(w)->options & CWL_MINBOX)

#define WINDOW_MAXIMIZE_ON(w)  (DEFAULT_HOTSPOTS(w) && \
                                DEFAULT_HOTSPOTS(w)->options & CWL_MAXBOX)

#define WINDOW_MINMAX_ON(w)    (DEFAULT_HOTSPOTS(w) && \
                               (DEFAULT_HOTSPOTS(w)->options & CWL_MINMAXBOX))

#define MINZOOMWIDTH(w)        (WINDOW_MINIMIZE_ON(w)?3:0 + \
                                WINDOW_MAXIMIZE_ON(w)?3:0)

#define WINDOW_CAPTION(w)      (DEFAULT_HOTSPOTS(w)->caption)
#define WINDOW_CAPTION_ON(w)   (DEFAULT_HOTSPOTS(w) && WINDOW_CAPTION(w)?1:0)
#define WINDOW_CAPTION_STRING(w) \
          (WINDOW_CAPTION_ON(w)?DEFAULT_HOTSPOTS(w)->caption_string:(char *)0)

#define WINDOW_MINMAX_VISIBLE(w)  (WINDOW_MINMAX_ON(w) && \
                                   WINDOW_CAPTION_ON(w) && \
                                   WINDOW_WIDTH(w) >= MINZOOMWIDTH(w) && \
                                   !ISWINDOW_MINIMIZED(w))

#define WINDOW_SAVE_BORDER(w)       (DEFAULT_HOTSPOTS(w)->border)
#define WINDOW_SAVE_BORDER_CHARS(w) (DEFAULT_HOTSPOTS(w)->box)
#define ALTERNATE_MOVE_FUNC(w)      (DEFAULT_HOTSPOTS(w)->alt_move_func)
#define WINDOW_NOBORDER_SCROLL(w)   (SCROLLBARS_ON(w) && !ISBORDER(w))
#define WINDOW_NOBORDER_SCRH(w)    (int)(SCROLLBAR_HORIZONTAL_ON(w) && !ISBORDER(w))
#define WINDOW_NOBORDER_SCRV(w)    (int)(SCROLLBAR_VERTICAL_ON(w) && !ISBORDER(w))



#define MOUSEPRESSED               1
#define KEYBOARDPRESSED            0

#define MOUSE_FULL_INSTALL         1
#define MOUSE_TEST                 2
#define GET_MPRESS_KEY(a)                get_mouse_or_key(0,a)
#define GET_MPRESS_ENHANCED_KEY(a)       get_mouse_or_key(1,a)
#define FOCUS    1
#define NOFOCUS  2


#define WINDOW_PROC(w)      ((w)->window_proc)


#if defined (POWERC)
CWL_EXTERN unsigned pow_ss_;
CWL_EXTERN unsigned pow_sp_;
CWL_EXTERN unsigned pow_stk_;
CWL_EXTERN unsigned pow_top_;
CWL_EXTERN unsigned pow_stack_;
#endif



typedef struct tagMINVALUES
{
  int           num;    /* Number of minimized windows per row */
  unsigned char *table;  /* table of column positions */
  int           width;  /* width of each minimized window */
  int           total;  /* total number of minimized windows */
  BITSTRING     bits;   /* determines next position for minimized window */
  unsigned int  isinit:1;
} MINVALUES;


typedef int (*WNDPROC)     _PROTO_((WPOINTER,int,int,long));


int       _FAR_ EventFunction _PROTO_((CWL_VOID));
CWL_VOID      _FAR_ EnqueueEvents _PROTO_((int event, int status, int y, int x));
CWL_VOID      MouseStartQueue _PROTO_((CWL_VOID));
CWL_VOID      MouseSwapButtons _PROTO_((CWL_VOID));
int           MouseButtonsSwapped _PROTO_((CWL_VOID));
CWL_VOID      StartMouseEvent _PROTO_((CWL_VOID));
CWL_VOID      EventLoop _PROTO_((CWL_VOID));
int           ProcessAllEvents _PROTO_((int option));
CWL_VOID      StartKeyboardEvent _PROTO_((CWL_VOID));
CWL_VOID      EndKeyboardEvent _PROTO_((CWL_VOID));
CWL_VOID      EndMouseEvent _PROTO_((CWL_VOID));
CWL_VOID      StartTimerEvent _PROTO_((CWL_VOID));
CWL_VOID      EndTimerEvent _PROTO_((CWL_VOID));


/* The Int 13H functions */
CWL_VOID      _FAR_ CWLdisk_handler _PROTO_((UNKNOWNARGS));
CWL_VOID      _FAR_ CWLDiskHandler _PROTO_((UNKNOWNARGS));
/* all assembly modules have UNKNOWNARGS as the prototype.  Refer to the
   documentation for exact parameters */

int           MouseInitializeSystem _PROTO_((int intype, int *num,
                                             int row, int col));
int           MouseInstall _PROTO_((int row, int col));
CWL_VOID _FAR_  MouseAssembly   _PROTO_((CWL_VOID));
CWL_VOID _FAR_  CWLInt9Handler _PROTO_((CWL_VOID));
CWL_VOID _FAR_  CWLInt1CHandler _PROTO_((CWL_VOID));
CWL_VOID _FAR_  CWLKbdHandler   _PROTO_((int scancode, int brkcode));
CWL_VOID _FAR_  CWLTimerHandler _PROTO_((CWL_VOID));
CWL_VOID _FAR_  CWLInt13Handler _PROTO_((CWL_VOID));
int           MouseRestoreSystem _PROTO_((int save));


int           MouseInitialize _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseShow _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseHide _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetStatAndPos _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetCursorPos _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetButtonPress _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetButtonRelease _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetHMinMax _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetVMinMax _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetGraphicsCursor _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetPage _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetTextCursor _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseReadMotionCounters _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetIntAddress _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseEnableLightPen _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseDisableLightPen _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetMickeyPixelRatio _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseConditionalOff _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetThresholdSpeed _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSwapIntFunctions _PROTO_((UNKNOWNARGS));
int           MouseGetStorageSize _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSaveState _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseRestoreState _PROTO_((UNKNOWNARGS));
int           MouseSetAltIntFunction _PROTO_((UNKNOWNARGS));
int           MouseGetAltFuncAddress _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetSensitivity _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetSensitivity _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetIntRate _PROTO_((UNKNOWNARGS));
int           MouseDisableDriver _PROTO_((UNKNOWNARGS));
int           MouseEnableDriver _PROTO_((UNKNOWNARGS));
int           MouseSoftwareReset _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseSetLanguage _PROTO_((UNKNOWNARGS));
int           MouseGetLanguage _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetDriverIRQType _PROTO_((UNKNOWNARGS));
int           MouseGetDriverInfo _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetMaxVirtualXY _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetMaskMickeyCount _PROTO_((UNKNOWNARGS));
int           MouseSetVideoMode _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseCountVideoModes _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetHotspot _PROTO_((UNKNOWNARGS));
int           MouseLoadAccCurves _PROTO_((UNKNOWNARGS));
int           MouseReadAccCurves _PROTO_((UNKNOWNARGS));
int           MouseSetGetAccCurve _PROTO_((UNKNOWNARGS));
int           MouseHardwareReset _PROTO_((UNKNOWNARGS));
int           MouseSetGetBallInfo _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetMinMaxCoords _PROTO_((UNKNOWNARGS));
int           MouseGetAdvancedFuncs _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetSwitchSettings _PROTO_((UNKNOWNARGS));
CWL_VOID      MouseGetINI _PROTO_((UNKNOWNARGS));

SCROLLPTR     ScrollBarCreate _PROTO_((int type, int minnum, int maxnum,
                                       int length, int *attr));

int           TranslateMousePress _PROTO_((int press));

CWL_VOID      TranslateMousePosToScreenPos _PROTO_((int ypos,int xpos,int *nypos,
                                         int *nxpos));
CWL_VOID      TranslateScreenPosToMousePos _PROTO_((int ypos,int xpos,int *nypos,
                                          int *nxpos));
CWL_VOID      TranslateMousePosToWindowPos _PROTO_((WPOINTER w, int ypos, int xpos,
                                          int *nypos, int *nxpos));
CWL_VOID      TranslateWindowPosToMousePos _PROTO_((WPOINTER w, int ypos, int xpos,
                                          int *nypos, int *nxpos));
int           WindowMinimize _PROTO_((WPOINTER w));

int           WindowSetEventStyle _PROTO_((WPOINTER w, long stylebits));
int           WindowGetEventStyle _PROTO_((WPOINTER w, long *stylebits));
int           WindowFreeEventStyle _PROTO_((WPOINTER w));
int           WindowSetCaption _PROTO_((WPOINTER w, char *caption));
int           WindowGetCaption _PROTO_((WPOINTER w, char *buffer, int len));
CWL_VOID      SetCaptionColor _PROTO_((int color, int flag));
int           GetCaptionColor _PROTO_((int flag));

int           WindowZoom _PROTO_((WPOINTER w));

int          WindowScrollVisible _PROTO_((WPOINTER w, int which));
int          WindowSetCapture _PROTO_((WPOINTER w));
CWL_VOID     WindowReleaseCapture _PROTO_((CWL_VOID));
WPOINTER     WindowGetCapture _PROTO_((CWL_VOID));
int          WindowSetEventProc _PROTO_((WPOINTER w, WNDPROC func));
int          WindowSetFocus _PROTO_((WPOINTER w));
WPOINTER     WindowGetFocus _PROTO_((CWL_VOID));
CWL_VOID     CWLQuitMessage _PROTO_((CWL_VOID));
int          SendWinMessage _PROTO_((WPOINTER w, int message, int wParam, long lParam));
int          PostWinMessage _PROTO_((WPOINTER w, int message, int wParam, long lParam));
int          SetWinTimer _PROTO_((WPOINTER w, int TimeID, unsigned mil, TIMERPROC TimeFunc));
void         GetTimerInfo _PROTO_((int TimeID, CMLTIMER * tm));

int          GetCurKeyState _PROTO_((int vkey));
int          GetKeyStateAtMsg _PROTO_((int vkey));
CWL_VOID     SetAllToggleKeys _PROTO_((int state));
CWL_VOID     SetToggleKey _PROTO_((int vkey, int state));
int          GetToggleKeyState _PROTO_((int vkey));
CWL_VOID     GetCurKeyboardState _PROTO_((unsigned char *buf));
CWL_VOID     GetKeyboardStateAtMsg _PROTO_((unsigned char *buf));
CWL_VOID     SetKeyboardState _PROTO_((unsigned char *buf));



/*******************************************/
#ifndef SOUND_DEF
#define SOUND_DEF

#ifdef POWERC
CWL_VOID           cwlsound _PROTO_((UNKNOWNARGS));
#define sound(x)      cwlsound(x)
#endif

#endif

#ifndef __TURBOC__
CWL_VOID          delay _PROTO_((unsigned));
#ifndef POWERC
CWL_VOID          sound _PROTO_((unsigned));
#endif
CWL_VOID          nosound _PROTO_((CWL_VOID));
#endif

#ifdef COHERENT
long nap();
#define delay(x)  nap(x)
#endif

/* More functional typedefs */
typedef CWL_VOID (*CWLERRORPROC)      _PROTO_((int errorcode, char *sourcefile,
                                               int sourceline, char *funcname));

typedef int      (*UNDEFKEYPROC)      _PROTO_((char *,int,int,int *));

typedef int      (*CHARSENTEREDPROC)  _PROTO_((char *,int));

typedef int      (*REGEXPERRORPROC)   _PROTO_((char *, int));

typedef int      (*FIELDERRORPROC)    _PROTO_((int, char *, int, int));

typedef int      (*FORMUNDEFPROC)     _PROTO_((char *, int, int *, int));

typedef CWL_VOID (*KEYIDLEPROC)       _PROTO_((CWL_VOID));

typedef unsigned (*KEYINTERCEPTPROC)  _PROTO_((int,unsigned));

typedef int      (*BARPREPROC)        _PROTO_((BAR_MENU_PTR,int *));

typedef int      (*POPUPPREPROC)      _PROTO_((POPUP_MENU_PTR, int *));

typedef CWL_VOID (*POPUPMOUSEPROC)    _PROTO_((POPUP_MENU_PTR p,
                                               unsigned sel));

typedef int      (*FIELDUNDEFKEYPROC) _PROTO_((FORMPTR, int, int, int *));

typedef CWL_VOID (*SPECFIELDPREPROC)  _PROTO_((FORMPTR,int,int));

typedef int      (*FORMLISTPROC)      _PROTO_((POPUP_MENU_PTR, unsigned));

typedef int      (*EDITERRORPROC)     _PROTO_((FORMPTR,int,int,char *,int));

typedef int      (*FORMUNDEFKEYPROC)  _PROTO_((FORMPTR,int,char *,int,int *));

typedef int      (*HELPUNDEFKEYPROC)  _PROTO_((FORMPTR, int, int));

typedef int      (*HELPPREPROC)       _PROTO_((FORMPTR,int,WPOINTER,int,
                                               int, int));

typedef CWL_VOID  (_FAR_ *VOIDFARPROC)  _PROTO_((UNKNOWNARGS));

/* Compatibility with CWL 2.53 */
#define VirtualFree(x,y,z)            VirtualClose(x,y,z)
#define WindowFree(x,y)               WindowClose(x,y)
#define WindowFreeAll(x,y)            WindowCloseAll(x,y)
#define PopupMenuFree(x)              PopupMenuClose(x)
#define PopupMenuFreeAll()            PopupMenuCloseAll()
#define BarMenuFree(x)                BarMenuClose(x)
#define BarMenuFreeAll()              BarMenuCloseAll()
#define PulldownMenuFree(x)           PulldownMenuClose(x)
#define PulldownMenuFreeAll()         PulldownMenuCloseAll()

#ifdef COHERENT
#include "tinfo.h"
#endif

#include "cwlglob.h"
#include "internal.h"
#ifdef __cplusplus
}
#endif

#endif

