/*** INTERNAL.H ***/

#ifndef INTERNAL_DEF
#define INTERNAL_DEF

/* Written By P.A. McKenzie
 * The C Window Library
 * Copyright (C) 1993         All Rights Reserved
 * Last updated : July 21, 1994
*/

#if defined (POWERC)
  #define CWLmouse_hidden  mouhid_
#endif

typedef struct tagSHADOWSAVE
{
  int sattr;
  int swidth;
  int sheight;
  int spos;
  int schar;
  int t;
} SHADOW_SAVE;

#ifdef SOURCE
#include "cwldebug.h"
#endif

typedef int (*OBJECTPROC)   _PROTO_((CWLOBJECTPTR object, VOIDPTR objecttype,
                                     long objectnum));

/*  These are the prototypes for routines used internally */
int          abs_shadow_coord _PROTO_((WPOINTER, int, int));

int          CWLadd_object _PROTO_((CWLOBJECTPTR, CWL_VOID *));
CWLOBJECTPTR CWLinit_object_class _PROTO_((long numobjects, int objtype));
int          CWLdelete_object _PROTO_((CWLOBJECTPTR objectptr, long which));
CWL_VOID     CWLGetInDos _PROTO_((CWL_VOID));
CWL_VOID  _FAR_   CWLAssignHandlers _PROTO_((CWL_VOID));
CWL_VOID  _FAR_   CWLUnassignHandlers _PROTO_((CWL_VOID));
int          CWLset_object _PROTO_((CWLOBJECTPTR objectptr, long which,
                                    CWL_VOID *newobject));
int          CWLchild_enum_proc _PROTO_((WPOINTER w, long lParam));
VOIDPTR      CWLget_object _PROTO_((CWLOBJECTPTR objectptr, long which));
int          CWLinsert_object _PROTO_((CWLOBJECTPTR objectptr, long which,
                                       VOIDPTR newobject));
int          CWLenum_objects _PROTO_((CWLOBJECTPTR objectptr,
                                      OBJECTPROC ofunc));
long         CWLget_object_count _PROTO_((CWLOBJECTPTR objectptr));
int          CWLdispose_object_class _PROTO_((CWLOBJECTPTR objectptr));
long         CWLfind_object _PROTO_((CWLOBJECTPTR objectptr, void *object));
CWLOBJECTPTR CWLcopy_object_class _PROTO_((CWLOBJECTPTR objectptr, long *num));
int          CWLcompare_rank _PROTO_((WPOINTER w1, WPOINTER w2));
int          CWLwindow_in_point _PROTO_((WPOINTER w, int row, int col));
CWL_VOID     CWLsave_shadow    _PROTO_((WPOINTER w, SHADOW_SAVE *sstruct));
CWL_VOID     CWLrestore_shadow _PROTO_((WPOINTER w, SHADOW_SAVE *sstruct));
int          CWLchild_move_proc _PROTO_((WPOINTER w, long lParam));
CWL_VOID     CWLupdate_all _PROTO_((WPOINTER w, CWLOBJECTPTR wobject,
                                    int numobjects, int endpos,
                                    CWLRECT *pRect));
int          CWLclose_window _PROTO_((WPOINTER w));
long         CWLdelete_all_objects _PROTO_((CWLOBJECTPTR objectptr));
int          CWLdisk_active _PROTO_((CWL_VOID));
int          CWLInDos _PROTO_((CWL_VOID));

int          CWLcapture_window_func _PROTO_((WPOINTER *w, int x, int y,
                                    int event, CWLMSG *mouevent,
                                    int doing_default,
                                    WPOINTER *current_window, int newy,
                                    int newx, int htwhere, int *ny, int *nx,
                                    long *current_mouse_pos, int *dblclk,
                                    int minmax_press));

int          CWLscroll_window_highlight _PROTO_((WPOINTER w, int wrow, int wcol, int stype));

int          CWLpopup_undef_proc _PROTO_((POPUP_MENU_PTR p, int prefuncdone,
                                     int stray_click,
                                     int *current_selection, int sel,
                                     int mouse_done, int undefval, int last,
                                     int rehighlight, int *nextrow,
                                     int *trow, int *sp, int *bselect));

int          CWLcheck_popup_hotkey _PROTO_((POPUP_MENU_PTR p,
                                            int *i, unsigned sel,
                                            int *nextrow, int *trow,
                                            int nset));

int          CWLprocess_mouse _PROTO_((POPUP_MENU_PTR p, int *sel, int *which,
                                       int *mouse_press, int *current_selection,
                                       int *keypress, int *cascade,
                                       int *trow, int *last, int *nextrow,
                                       int *rehighlight, int *prefuncdone,
                                       int *last_cascade, int *undefval,
                                       int *mouse_done, int *sp,
                                       int *outofbounds, int *menu_choice,
                                       int *initial_press, int *mouse_release));


int          CWLwindow_on_scrollbar _PROTO_((WPOINTER w, int row, int col));

CWL_VOID     CWLmove_bar_to_popup_entry _PROTO_((POPUP_MENU_PTR p,
                                                int sel,
                                                int *nextrow, int *trow,
                                                int *last));

CWL_VOID     CWLmove_popup_bar_down _PROTO_((POPUP_MENU_PTR p,
                                             int *current_selection,
                                             int *last,
                                             int *nextrow,
                                             int *trow,
                                             int which));

CWL_VOID     CWLmove_popup_bar_up _PROTO_((POPUP_MENU_PTR p,
                                           int *current_selection,
                                           int *last,
                                           int *nextrow,
                                           int *trow,
                                           int which));

CWL_VOID     CWLpopup_pagedown _PROTO_((POPUP_MENU_PTR p, int *trow,
                                        int *current_selection,
                                        int *last, int which));

CWL_VOID     CWLpopup_pageup _PROTO_((POPUP_MENU_PTR p, int *trow,
                                      int *current_selection, int *last,
                                      int which));

CWL_VOID     CWLmove_bar_to_window _PROTO_((POPUP_MENU_PTR p,
                                            int trow,
                                            int current,
                                            int *last,
                                            int which));

CWL_VOID     CWLdisplay_cascade _PROTO_((POPUP_MENU_PTR p,
                                         int selection, int dispflag));

int          CWLmouse_in_cascade _PROTO_((POPUP_MENU_PTR p,
                                          int selection, int nrow,
                                          int ncol));

int          CWLmouse_in_parent _PROTO_((POPUP_MENU_PTR p, int nrow, int ncol,
                                         POPUP_MENU_PTR *pw));

int          CWLcall_cascade_popup _PROTO_((POPUP_MENU_PTR p,
                                            int current_selection,
                                            int menu_choice, int keypress));

int          CWLclose_cascade_popup _PROTO_((POPUP_MENU_PTR p,
                                             POPUP_MENU_PTR ptemp,
                                             int menu_choice,
                                             int current_selection,
                                             int mousepress));
int          CWLwindow_resize_height _PROTO_((WPOINTER w,
                                              int newheight,
                                              int flag,
                                              int capflag));

int          CWLwindow_resize_width _PROTO_((WPOINTER w,
                                             int newwidth,
                                             int flag,
                                             int capflag));

CWL_VOID     CWLprocess_mousemove _PROTO_((CWLMSG *mouevent));

CWL_VOID     CWLprocess_timer _PROTO_((CWLMSG *mouevent));

CWL_VOID     CWLprocess_kbdmsg _PROTO_((WPOINTER focus_window, CWLMSG *mouevent,
                                        long *current_mouse_pos, int doing_default));

int          CWLresize_window _PROTO_((WPOINTER w, unsigned event, int area,
                                       int pos1, int pos2, int htwhere,
                                        WPOINTER *current_window));

CWL_VOID     CWLdisplay_seethru_window _PROTO_((WPOINTER w, WPOINTER tempw,
                                                int rank, int flag));

int          CWLscroll_window_hotspot _PROTO_((WPOINTER w, int event,
                                               int area, int wrow,
                                               int wcol, int chkflag));

int          CWLprocess_mousemsg _PROTO_((WPOINTER *w,int newy, int newx, int *ny,
                                          int *nx, int x, int y,
                                          int event, int *dblclk,
                                          WPOINTER *current_window,
                                          WPOINTER focus_window,
                                          int *first_press_flag,
                                          CWLMSG *msg, CWLMSG *mouevent,
                                          int htwhere, long current_mouse_pos,
                                          int *minmax_press));

int          CWLmove_window _PROTO_((WPOINTER w, unsigned event, int area,
                                     int pos1, int pos2, WPOINTER *current_window,
                                     int *dblclk));

int          CWLdo_mouse_zoom _PROTO_((WPOINTER w, int retval, int event,
                                       int posy, int posx));

int          CWLon_size_button _PROTO_((WPOINTER w, int row, int col));

int          CWLwindow_mouse_func _PROTO_((int type, WPOINTER w, int event,
                                           long mouseparam, int param1,
                                           long param2, WPOINTER *current_window,
                                           int *dblclk, int minmax_press));

int          CWLpoint_in_client _PROTO_((WPOINTER w, int row, int col));
int          CWLon_resize_pos _PROTO_((WPOINTER w, int wrow, int wcol));
int          CWLon_caption _PROTO_((WPOINTER w, int row, int col));


int          MouseOff _PROTO_((CWL_VOID));
int          MouseOn  _PROTO_((int status));

int          compare_rank _PROTO_((WPOINTER w1, WPOINTER w2));

CWL_VOID     bios_write_vertical _PROTO_((UNKNOWNARGS));
CWL_VOID     calibrate_timer _PROTO_((CWL_VOID));
int          CWLcheck_existence _PROTO_((unsigned, VWPOINTER, WPOINTER));
int          check_transparent_attribute _PROTO_((WPOINTER, int, int, int *));
int          clear_window_region _PROTO_((WPOINTER, int, int, int, int, int));

CWL_VOID     draw_caption _PROTO_((WPOINTER w));
CWL_VOID     draw_separator _PROTO_((POPUP_MENU_PTR p, int where));
int          draw_window_box _PROTO_((WPOINTER,int));
int          explode_buffer _PROTO_((WPOINTER, int, unsigned char *, int));
CWL_VOID     fill_wblock _PROTO_((WPOINTER, unsigned char *, int,
                                  int, int, int));
CWL_VOID     free_virtual_window_buffers _PROTO_((unsigned char _FAR_ * _FAR_ *, int));
int          CWLget_masked_input _PROTO_((WPOINTER, int, int, char *, char *, int,
                                 int, int, int, char *, int, int, int,
                                 long, char, int, unsigned *, int *));
int          CWLget_numchars _PROTO_((char *, char));
CWL_VOID     get_xy _PROTO_((UNKNOWNARGS));
CWL_VOID     hide_all_children _PROTO_((WPOINTER w, int hflag));
int          init_key_defs _PROTO_((CWL_VOID));
int          nabs_shadow_coord _PROTO_((WPOINTER, int, int));
int          CWLinit_screen_image _PROTO_((int));
CWL_VOID     paint_seethru _PROTO_((WPOINTER));
CWL_VOID     nosnow_move _PROTO_((UNKNOWNARGS));
CWL_VOID     nosnow_read _PROTO_((UNKNOWNARGS));
CWL_VOID     nosnow_write_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     nosnow_write_string _PROTO_((UNKNOWNARGS));
CWL_VOID     nosnow_write_vertical _PROTO_((UNKNOWNARGS));
char *       parse_regexp _PROTO_((char *, char *, int, int *, int));
CWL_VOID     bios_save_restore _PROTO_((int ux, int uy, int lx, int ly,
                              WBUFPTR scrnsptr, int option, int page));
int          CWLrank_window _PROTO_((WPOINTER w, int rank, int uflag));
CWL_VOID     read_bios_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     read_bios_string _PROTO_((UNKNOWNARGS));
CWL_VOID     read_bios_char_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     read_window_text_buffer _PROTO_((int, WPOINTER, int, int, int,
                                    unsigned char *));
CWL_VOID     redraw_border _PROTO_((WPOINTER,int,int));
int          CWLremove_screen_image _PROTO_((int));
int          setup_regexp _PROTO_((char *, int));
int          test_mono _PROTO_((UNKNOWNARGS));
int          translate_scrollpos_to_row _PROTO_((WPOINTER w, SCROLLPTR sptr,
                                           int side));
int          translate_row_to_scrollpos _PROTO_((WPOINTER w, SCROLLPTR sptr,
                                           int side));
int          get_scrollbox_pos _PROTO_((SCROLLPTR sptr));

#if defined (MSC) || (LATTICE) || (__ZTC__)
unsigned     TCpeek _PROTO_((unsigned seg, unsigned off));
unsigned     TCpoke _PROTO_((unsigned seg, unsigned off, unsigned num));
#endif

CWL_VOID     update_children _PROTO_((WPOINTER w));
CWL_VOID     mark_children_enum _PROTO_((WPOINTER parent, int mark));
int          window_enum_children _PROTO_((WPOINTER parent,
                                           CWLENUMPROC enumproc, long lParam));

CWL_VOID     update_children_block _PROTO_((WPOINTER w, CWLRECT *wRect,
                                            int action, int value));

CWL_VOID     update_screen_image _PROTO_((WPOINTER, int, int));
CWL_VOID     update_screen_image_block _PROTO_((WPOINTER, CWLRECT *, int, int));
CWL_VOID     update_shadow _PROTO_((WPOINTER w));
CWL_VOID     update_viewport _PROTO_((WPOINTER, VWPOINTER));
CWL_VOID     update_viewport_line _PROTO_((WPOINTER, VWPOINTER, unsigned, unsigned,
                                       int, int));
CWL_VOID     vblock_save_restore _PROTO_((UNKNOWNARGS));
CWL_VOID     video_draw_box _PROTO_((int, int, int, int, int, char *, int));
CWL_VOID     video_write_CC _PROTO_((char *, int, int, int, int));
CWL_VOID     video_write_center _PROTO_((char *, int, int, int));
CWL_VOID     video_write_RJ _PROTO_((char *, int, int, int, int));
int          CWLvirtual_clear _PROTO_((VWPOINTER , int , int ));
int          CWLvirtual_clear_region _PROTO_((VWPOINTER vw, unsigned uy,unsigned ux,
                                     unsigned ly, unsigned lx, int attr,
                                     int flag));
int          CWLvirtual_printf _PROTO_((VWPOINTER, unsigned char *, int, int));
int          CWLvirtual_read_write_chars _PROTO_((VWPOINTER,char *,unsigned,unsigned,
                                              unsigned,int,int,int,int));
int          virtual_write_cjust_string _PROTO_((VWPOINTER,char *,unsigned,unsigned,int,
                                           int));
int          virtual_write_center_string _PROTO_((VWPOINTER,char *,unsigned,int,int));
int          virtual_write_rjstring _PROTO_((VWPOINTER,char *,unsigned,unsigned,int,
                                       int));
int          virtual_write_string _PROTO_((VWPOINTER,char *,unsigned,unsigned,int,
                                     int));
int          what_xy _PROTO_((UNKNOWNARGS));
int          window_addto_transparent _PROTO_((WPOINTER));
CWL_VOID     write_bios_char_attr _PROTO_((UNKNOWNARGS));
int          CWLwindow_clear_region _PROTO_((WPOINTER,int,int,int,int,int));
int          window_covered _PROTO_((WPOINTER));
int          window_delete_transparent _PROTO_((WPOINTER));
int          CWLwindow_draw_box _PROTO_((WPOINTER,int,int,int,int,int,char *));
int          window_draw_title _PROTO_((WPOINTER, char *, int, int, int, int));
CWL_VOID     window_get_valid _PROTO_((WPOINTER, int *, int *, int *, int *));
int          window_hide _PROTO_((WPOINTER,int,int));
int          CWLwindow_open _PROTO_((WPOINTER w));
CWL_VOID     window_paint _PROTO_((WPOINTER));
CWL_VOID     window_paint_region _PROTO_((WPOINTER w, CWLRECT *wRect));
int          window_print_char _PROTO_((WPOINTER,int,int));
int          window_printf _PROTO_((WPOINTER w, char *str, int attr));
int          CWLwindow_read_chars _PROTO_((WPOINTER,char *,int,int,int,int));
int          CWLtoggle_seethru _PROTO_((WPOINTER,int));
WPOINTER     window_top _PROTO_((int));
CWL_VOID     window_unrank _PROTO_((WPOINTER));
CWL_VOID     window_update_region _PROTO_((WPOINTER w, CWLRECT *wRect));
int          window_write_center_string _PROTO_((WPOINTER, char *, int, int));
int          window_write_rjstring _PROTO_((WPOINTER, char *, int, int, int));
int          window_write_characters _PROTO_((WPOINTER, char *, int, int, int,
                                        int, int, int,int));

int          window_write_client _PROTO_((WPOINTER w, char *buf, int row,
                                          int col, int len, int opt, int ch,     /* character if repeat option is chosen */
                                          int sflag, int vscroll));

int          window_write_string _PROTO_((WPOINTER, char *, int, int, int, int));
int          window_write_cjust_string _PROTO_((WPOINTER, char *, int, int, int));
CWL_VOID     write_bios_char_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     write_screen_image_area _PROTO_((WPOINTER,CWLRECT *,int,int,int));
int          CWLwindow_scroll _PROTO_((WPOINTER, int, int, int, int, int, int, int));
CWL_VOID     write_bios_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     write_bios_string _PROTO_((UNKNOWNARGS));
CWL_VOID     write_bios_str_with_attr _PROTO_((UNKNOWNARGS));
CWL_VOID     write_shadow _PROTO_((WPOINTER));
int          write_temp_screen_buffer _PROTO_((WPOINTER, int, int, int, int));
CWL_VOID     write_vertical _PROTO_((UNKNOWNARGS));
CWL_VOID     write_viewport _PROTO_((VWPOINTER));
CWL_VOID     write_window_text_buffer _PROTO_((int, WPOINTER, int, int, int,
                                         unsigned char *, int));

/* Internal Macros */
#define      WRITE_SCREEN_BLOCK(rect,p)  \
             write_screen_image_area((CWLWINDOW *)0,(rect),0,(p),0)

#define      WRITE_SCREEN_BLOCK_ATTR(w,rect,a,p) \
             write_screen_image_area((w),(rect),(a),(p),1)


/* Queue functions */
int          queue_initialize _PROTO_((QUEUE *queue, int size, int allocsize));
int          queue_add _PROTO_((QUEUE *queue, CWLMSG *mouevent));
int          queue_delete _PROTO_((QUEUE *queue, int position));
int          queue_insert _PROTO_((QUEUE *queue, CWLMSG *mouevent, int position)                                                                  );
int          get_queue _PROTO_((QUEUE *queue, int item, CWLMSG *mouevent));
int          queue_destroy _PROTO_((QUEUE *queue));
int          dequeue_queue _PROTO_((QUEUE *queue, CWLMSG *mouevent));
int          find_queue _PROTO_((QUEUE *queue, CWLMSG *msg, char *findtype));
int          change_queue _PROTO_((QUEUE *queue, int item, CWLMSG *mouevent));



/* Prototypes for Non-window related internal functions */
int          get_max_pages _PROTO_((CWL_VOID));
CWL_VOID     get_screen_type _PROTO_((CWL_VOID));
char *       get_start_colRJ _PROTO_((char *, unsigned *));
unsigned     get_start_colCC _PROTO_((char *, unsigned));
int          get_video_info _PROTO_((int));
CWL_VOID     get_screen_segment _PROTO_((CWL_VOID));
int          get_chat _PROTO_((int, int, int, int));
CWL_VOID     goto_xy _PROTO_((int,int,int));
CWL_VOID     video_draw_box _PROTO_((int, int, int, int, int, char *, int));
CWL_VOID     video_write_center _PROTO_((char *, int, int, int));
CWL_VOID     video_write_CC _PROTO_((char *, int, int, int, int));
CWL_VOID     video_write_RJ _PROTO_((char *, int, int, int, int));


/* Prototypes for scrollbar functions */
CWL_VOID     draw_scroll_bars _PROTO_((WPOINTER,int));
CWL_VOID     scrollbar_status _PROTO_((WPOINTER, int *, int *));

#define MOUSEHIDE() {if (CWLmouse_active && !CWLmouse_hidden) (*CWLmouse_hide_func)();}
#define MOUSESHOW() {if (CWLmouse_active && CWLmouse_hidden) (*CWLmouse_show_func)();}

/* Internal form functions */

int          CWLcheck_fields _PROTO_((FORMPTR form, int *entry));
int          CWLprocess_field_error _PROTO_((int errtype, char *str, int errval, int flag));
CWL_VOID     clear_form _PROTO_((FORMPTR form, int entry, int *status));
CWL_VOID     erase_comma_field _PROTO_((FORMPTR form, int entry));
int          CWLget_field _PROTO_((FORMPTR form, int entry, int *status, int inform));
CWL_VOID     get_data_from_field _PROTO_((FORMPTR form, int entry, VOIDPTR data));
CWL_VOID     display_mask _PROTO_((FIELDPTR f, VOIDPTR win, int doattr, int vflag));
int          form_exist _PROTO_((FORMPTR form));
int          add_form _PROTO_((FORMPTR form));
int          delete_form _PROTO_((FORMPTR form));
CWL_VOID     zero_suppress _PROTO_((char *buf, int opt));
CWL_VOID     form_free _PROTO_((FORMPTR form));
CWL_VOID     print_justified _PROTO_((VOIDPTR win, FIELDPTR field, int flag, int col,
                        int just, int doattr, int vflag));
CWL_VOID     left_justify _PROTO_((char *str));
CWL_VOID     right_justify _PROTO_((char *str, int bufwidth));
int          find_next_field _PROTO_((FORMPTR form, int entry, int dir, int *fstatus));
CWL_VOID     paste_value _PROTO_((FORMPTR form, int entry, char *data, int flag));
int          CWLform_test _PROTO_((FORMPTR form, int entry, int options));
char         *CWLcomma_fmt _PROTO_((char *buf1, char *buf2));
int          CWLprocess_field_error _PROTO_((int, char *, int, int));
int          do_undef_form_func _PROTO_((char *, int, int *, int));
int          check_form_change_status _PROTO_((FORMPTR form));
int          CWLform_get_fieldnum _PROTO_((FORMPTR form, unsigned row,
                                         unsigned col, int flag));
void         CWLdisplay_list _PROTO_((FORMPTR form, int hideflag));
unsigned int CWLform_search _PROTO_((int row, int col));
CWL_VOID     CWLget_field_rowcol _PROTO_((FORMPTR form, int entry,
                                       int *row, int *col));
CWL_VOID     CWLreadjust_rowcol _PROTO_((FORMPTR form, int entry, int *row, int *col,
                                      int *extra, int flag));

int          CWLprocess_picklist _PROTO_((POPUP_MENU_PTR p, unsigned sel));
CWL_VOID     convert_data_to_string _PROTO_((FORMPTR form, int entry, VOIDPTR dataptr,
                                             char *buf));
CWL_VOID     convert_double_to_string _PROTO_((FORMPTR form, int entry, char *buf,
                                               VOIDPTR data));
CWL_VOID     convert_string_to_double _PROTO_((char *buf, VOIDPTR uservar, int ftype));
int          field_double_compare _PROTO_((double num1, double r1, double r2,
                                           int options));
int          field_float_compare _PROTO_((float num1, float r1, float r2,
                                          int options));
int          CWLform_close_help _PROTO_((FORMPTR form, int online));

CWL_VOID     CWLwrite_radio_button _PROTO_((FORMPTR form, int entry,
                                         RADIO_FIELD_PTR radio, int pos,
                                         int attr1, int attr2, int newflag));

int          CWLget_toggle _PROTO_((FORMPTR form, int entry, unsigned row,
                                 unsigned col, int *new_entry));

int          get_subform_info _PROTO_((FORMPTR form, int entry));
int          CWLget_radio_field _PROTO_((FORMPTR form, int entry, int *new_entry));
int          CWLget_button _PROTO_((FORMPTR form, int entry, int *new_entry));
int          CWLget_picklist _PROTO_((FORMPTR form, int entry, int *new_entry));
int          CWLsearch_radio_or_check _PROTO_((FORMPTR form, int entry, int nrow, int ncol,
                                          int type, int flag));
int          CWLget_checkbox_field _PROTO_((FORMPTR form, int entry, int *new_entry));
CWL_VOID     CWLcheckbox_setup _PROTO_((FORMPTR form, int entry, int centry));
CWL_VOID     write_checkbox_char _PROTO_((FORMPTR form, int entry, int pos,
                            int cchar));

CWL_VOID CWLradio_setup _PROTO_((FORMPTR form, int entry, int rentry));
CWL_VOID CWLwrite_radio_check_hotkey _PROTO_((FORMPTR form, int entry,  VOIDPTR box,
                                 int entrynum, int type));
int      CWLset_radio_check_status _PROTO_((FORMPTR form, int entry, int entrynum,
                              int flag, int type));
CWL_VOID CWLpending_func _PROTO_((int));

int      CWLget_special_field_selection _PROTO_((FORMPTR form, int entry,
                                   int ftype, int choice));
int      CWLget_next_radio _PROTO_((FORMPTR form, int entry, int dir));
int      CWLget_next_checkbox _PROTO_((FORMPTR form, int entry, int dir));
CWL_VOID write_checkbox _PROTO_((FORMPTR form, int entry, int current));
int      CWLcheck_field_type _PROTO_((FORMPTR form, int entry, int ftype));
int      CWLspecial_field_test _PROTO_((FORMPTR form, int entry, int cond, int ftype));
int      CWLsearch_list _PROTO_((FORMPTR form, int entry, int row, int col));


SUBFORM_FIELD_PTR get_new_subform _PROTO_((FORMPTR form, FORMPTR subform,
                                     int rank,
                                     int start));


int           CWLparse_hotkey _PROTO_((char *str));

int           CWLdisplay_bar_entries _PROTO_((BAR_MENU_PTR b, int where,
                                              int newone));
int           CWLbar_set_options _PROTO_((BAR_MENU_PTR b, int option,
                                          int flag));
CWL_VOID      write_barmenu_entry _PROTO_((BAR_MENU_PTR, int));
int           display_barmenu_window _PROTO_((BAR_MENU_PTR, int, int));
int           get_barmenu_entry _PROTO_((BAR_MENU_PTR, int, int *));
CWL_VOID      highlight_barmenu_entry _PROTO_((BAR_MENU_PTR, int, int));
int           call_barmenu_function _PROTO_((BAR_MENU_PTR, int, int *));
int           move_barmenu_highlight _PROTO_((BAR_MENU_PTR, int ,int));
int           bar_hide_entry _PROTO_((BAR_MENU_PTR, unsigned, int));
CWL_VOID      write_popupmenu_entry _PROTO_((POPUP_MENU_PTR, int));
int           display_popupmenu_window _PROTO_((POPUP_MENU_PTR, int, unsigned));
int           call_popupmenu_function _PROTO_((POPUP_MENU_PTR, int, int *));
CWL_VOID      highlight_popupmenu_entry _PROTO_((POPUP_MENU_PTR, unsigned, int));
int           process_popupmenu _PROTO_((POPUP_MENU_PTR, int, int *, int *));
int           CWLpopup_hide_entry _PROTO_((POPUP_MENU_PTR, int, int));
int           popup_set_options _PROTO_((POPUP_MENU_PTR p,
                                         unsigned options,
                                         int flag));
CWL_VOID      write_barmenu_hotkey _PROTO_((BAR_MENU_PTR , unsigned));
CWL_VOID      write_popupmenu_hotkey _PROTO_((POPUP_MENU_PTR, int));
int           process_barmenu _PROTO_((BAR_MENU_PTR, unsigned int, int *, int));
CWL_VOID      write_popup_scroll_chars _PROTO_((POPUP_MENU_PTR p));
int           CWLmove_bar_highlight_far _PROTO_((BAR_MENU_PTR, int, int *));
CWL_VOID      highlight_popup_scroll _PROTO_((POPUP_MENU_PTR p, int where, int flag));
int       CWLinit_list_highlight _PROTO_((POPUP_MENU_PTR p, int *start));



int      scroll_bar_assign _PROTO_((WPOINTER w, SCROLLPTR sptr, int pos1,
                                    int pos2, int flag));
int      reset_scrollbar _PROTO_((SCROLLPTR sbar, int minnum, int maxnum, int length,
                                  int pos1, int pos2, int repaint));
int      set_scroll_pos _PROTO_((SCROLLPTR sptr, int npos, int repaint));
int      scrollbar_paintbox _PROTO_((SCROLLPTR sptr, int attr));
int      scrollbar_repaint _PROTO_((SCROLLPTR sptr, int hideflag));
int      assign_scroll_chars _PROTO_((SCROLLPTR sptr, unsigned char *schars));
int      on_scrollbar _PROTO_((SCROLLPTR sptr, int row, int col));
int      set_scrollpos_approx _PROTO_((SCROLLPTR sptr, int pos));
int      hide_scrollbar _PROTO_((SCROLLPTR sptr));
CWL_VOID      resolve_hotspot_conflict _PROTO_((WPOINTER w));
CWL_VOID      assign_hotspots _PROTO_((WPOINTER w));
CWL_VOID      draw_all_hotspots _PROTO_((WPOINTER w,int capflag));
CWL_VOID      draw_zoom_hotspot _PROTO_((WPOINTER w, int which, int highflag));
CWL_VOID      draw_hide_close_button _PROTO_((WPOINTER w));
unsigned      get_mouse_or_key _PROTO_((int flag, int *which));
unsigned      getmousekey _PROTO_((int flag, int *which, int *hpos, int *vpos));
CWL_VOID      mouse_wait_for_release _PROTO_((CWL_VOID));
CWL_VOID      CWLdo_mouse_scroll _PROTO_((WPOINTER w, int dir, int button));
int           scroll_window_hotspot _PROTO_((WPOINTER w, int event, int area,
                                      int wrow, int wcol, int chkflag));
int           scroll_bar_assign _PROTO_((WPOINTER w, SCROLLPTR sptr, int pos1,
                                  int pos2, int flag));
int           reset_scrollbar _PROTO_((SCROLLPTR sbar, int minnum, int maxnum, int length,
                                int pos1, int pos2, int repaint));
int           set_scroll_pos _PROTO_((SCROLLPTR sptr, int npos, int repaint));
int           approx_delay _PROTO_((int mil, int button));
int           IsPressed _PROTO_((int button));
int           IsReleased _PROTO_((int button));
CWL_VOID      get_minimize_rowcol _PROTO_((int *row, int *col));
CWL_VOID      uninit_minimize     _PROTO_((CWL_VOID));
int           initialize_minimize _PROTO_((int minwidth));
int           get_minmax_colpos   _PROTO_((WPOINTER w, int *col1, int *col2));

CWL_VOID      popup_disable_scrollbar _PROTO_((POPUP_MENU_PTR p));
CWL_VOID      popup_enable_scrollbar  _PROTO_((POPUP_MENU_PTR p));
CWL_VOID      popup_set_scroll        _PROTO_((POPUP_MENU_PTR p, int flag));



#define clear_bits(b,s,e)  set_clear_bits((b),(s),(e),0)
#define set_bits(b,s,e)    set_clear_bits((b),(s),(e),1)

/* These work using the BITSTRING structure */
#define test_bit(b,bit)    (((b).bit_string[(bit) / (sizeof(char) << 3)] & \
                           (1 << ((bit) % (sizeof(char) << 3))))?1:0)
#define set_bit(b,bit) ((b).bit_string[(bit) / (sizeof(char) << 3)] |= \
                        (1U << ((bit) % (sizeof(char) << 3))))

#define clear_bit(b,bit) ((b).bit_string[(bit) / (sizeof(char) << 3)] &= \
                         ~(1U << ((bit) % (sizeof(char) << 3))))


int          create_bit_string _PROTO_((BITSTRING *, unsigned));
CWL_VOID     free_bit_string _PROTO_((BITSTRING *));
CWL_VOID     set_clear_bits _PROTO_((BITSTRING *, unsigned, unsigned, int));
unsigned     get_bits_set _PROTO_((BITSTRING *, int));
unsigned     get_first_bit_set _PROTO_((BITSTRING *, unsigned, int, int *));
unsigned     search_bit_set _PROTO_((BITSTRING *, unsigned, int, int *));
CWL_VOID     copy_bits_to_char _PROTO_((BITSTRING *b, unsigned char *ch,
                                        int start, int len));

int          get_num_bits _PROTO_((BITSTRING *b));
int          insert_bit_string _PROTO_((BITSTRING *b, unsigned bit, int flag));
int          delete_bit_string _PROTO_((BITSTRING *b, unsigned bit));
int          copy_bits _PROTO_((BITSTRING *dest, BITSTRING *source));


/* structures used internally for input functions */

typedef struct {
  unsigned formflag:1;       /* tells if input is coming from a form */
  unsigned autoreturn:1;     /* tells if input is accepted if last character
                              * is typed in */
  unsigned autobackward:1;   /* tells if previous field is activated if the
                              * cursor goes before the first column (used
                              * in forms only) */
  unsigned password:1;       /* tells if input field is a password field */
  unsigned insert:1;         /* tells if in insert mode */
  unsigned uppercase:1;      /* tells if alpha characters are displayed in
                              * upper case */
  unsigned lowercase:1;      /* tells if alpha characters are displayed in
                              * lower case */
  unsigned checkspaces:1;    /* tells if input manager should check for
                              * blank spaces when checking input
                              * requirements */
  unsigned enhancedkey:1;    /* Tells if enhanced keys should be detected */
  unsigned checkregexp:1;    /* tells if each input position matches the
                              * regular expression desired */
  unsigned checkregexp_ign:1; /* tells if checking should be case insensitive */
  unsigned homecursor:1;      /* tells if input is shifted to first position
                               * after accepting */
	unsigned use_mouse:1;      /* use the mouse for this input field */
  unsigned clear_field:1;    /* clear field flag */
  unsigned use_virtual:1;    /* use virtual window input */
} IFLAG;

typedef struct tagISTRUCT{
  WPOINTER w;             /* window to get input from */
  char *savestring;       /* original default string */
  char *inputstring;      /* string currently being inputted */
  char *mask;             /* character mask to use */
  char *regexp;           /* regular expression to use */
  char *imask;            /* temporary input mask */
  unsigned row;           /* row to get input */
  unsigned col;           /* column to get input */
  int attr;               /* attribute to use */
  int maxwidth;           /* width of displayed input field */
  int retkey;             /* key when hit */
  char maskchar;          /* input mask character */
  char fc;                /* fill character */
  char pchar;             /* password character */
  int minchars;           /* minimum number of characters to accept */
  unsigned current_string_pos;  /* current input position */
  unsigned current_mask_pos;    /* current input position if using the
                                 * character mask */
  int left_mask_pos;      /* first character of mask that appears on the
                           * left of the displayed input field */
  int right_mask_pos;     /* last character of mask that appears on the
                           * right of the displayed input field */
  int first_input_pos;    /* first position in entered string that appears
                           * on the left of the displayed input field */
  int last_input_pos;     /* last position in entered string that appears
                             * on the right of the displayed input field */
  int abs_left_pos;       /* first position in mask that is an input position */
  int first_mask_pos;     /* first displayable mask position */
  int num_total_chars;    /* number of total characters that can be input */
  int nullpos;            /* position of null terminator in entered string */
  int string_nullpos;     /*   */
  IFLAG flags;            /* input flags */
  unsigned *editkey;     /* array of keys to use to edit this field */
	int startpos;          /* starting position in field */
}  INP_STRUCT;


CWL_VOID Iinsert_character _PROTO_((INP_STRUCT *, unsigned));
int  Ifind_next_pos  _PROTO_((INP_STRUCT *, int));
int  Ifind_prev_pos  _PROTO_((INP_STRUCT *, int));
CWL_VOID Ireset_mask _PROTO_((INP_STRUCT *,char *,int));
int  Iclean_up _PROTO_((INP_STRUCT *));
int  process_keystroke _PROTO_((INP_STRUCT *, unsigned, int, int, int));
int  default_key_process _PROTO_((INP_STRUCT *, int, int, int, int));
int  Icheck_regexp _PROTO_((INP_STRUCT *, int *));
int  window_get_input _PROTO_((INP_STRUCT *));


#ifdef POWERC
int count_events(int event);
int save_cap_(int seg, int off);
int TranslateMessage(int event);
int FindMessage(int message);
void ReplaceMessage(int message, int y, int x, int pos);
void SetVKbits(int message);
int SwapButtons(int message);
void AddMessage(int message, int y, int x, pos, WPOINTER w);
int GetQueueBack();
int GetWPtrOffset(int y, int x);
int CWLqueue_full();
int GetWPtrPos(int offset, int sseg, int soff);
void far *GetWPtr(int offset, int sseg, int ssof);
#endif



#define FORM_ON() (CWLformlib_exist && istruct->flags.formflag)

#endif
