/*********************************************************************
 * Global variables used in all libraries.  Please check here if you *
 * want to make sure that you are not inadvertantly using a library  *
 * variable.                                                         *
 *********************************************************************/

#define NUMALPHA         60
#define NUMCOLORSCHEME   10

#if defined (POWERC) || (MSC)
#define DEFDS near  /* make sure all variables are defined in the default
                       data segment */
#else
#define DEFDS
#endif

typedef WBUFFERTYPE SCREENIMAGE;

#define NUMCACHE   5

CWL_EXTERN int            CWLsys_initial;
CWL_EXTERN WPOINTER  *    CWLwindow_trans; /* array of transparent windows */
CWL_EXTERN int            CWLoverride_seethru;  /* Overrides seethru window in
                                                  *  screen_image */
CWL_EXTERN int            CWLmax_window_rank;    /* maximum rank number */
CWL_EXTERN int            CWLmin_window_rank;       /* lowest rank number */
CWL_EXTERN int            CWLnum_tshadows[MAXPAGES]; /* Number of shadows */
CWL_EXTERN int            CWLtotal_tshadows;          /* Number of transparent
                                                                   shadows */
CWL_EXTERN unsigned int   CWLDefaultPanKeys[NUMVPANKEYS];
CWL_EXTERN unsigned       CWLstack_size;
CWL_EXTERN int            CWLdoing_move;
CWL_EXTERN int            CWLdoing_resize;
CWL_EXTERN int            CWLdoing_scroll;
CWL_EXTERN int            CWLdoing_minmax;
CWL_EXTERN unsigned char  CWLalpha[NUMALPHA];

CWL_EXTERN SCREENIMAGE    *CWLscreen_image[MAXPAGES];

CWL_EXTERN WPOINTER       CWLcapture_window;
CWL_EXTERN int    DEFDS   CWLevents_on;
CWL_EXTERN char       *   CWLmouse_buffer;
CWL_EXTERN char           CWLmouse_effect;

CWL_EXTERN char           CWLmouse_seethru_on;
CWL_EXTERN char           CWLmouse_saved;

CWL_EXTERN WPOINTER       CWLmouse_wseethru;
CWL_EXTERN unsigned char  CWLmouse_char[MAXSCROLLSTRING];

CWL_EXTERN unsigned char  CWLscroll_up_char;
CWL_EXTERN unsigned char  CWLscroll_down_char;
CWL_EXTERN unsigned char  CWLscroll_region_char;

CWL_EXTERN int            CWLscroll_speed;
CWL_EXTERN int            CWLslide_row;
CWL_EXTERN int            CWLslide_col;
CWL_EXTERN int            CWLleft_button;
CWL_EXTERN int            CWLright_button;
CWL_EXTERN int            CWLcolor_nofocus;
CWL_EXTERN int            CWLcolor_focus;
CWL_EXTERN int            CWLqueue_on;
CWL_EXTERN int            CWLinbios;

CWL_EXTERN unsigned char   CWLasciicode[256];
CWL_EXTERN unsigned char   CWLvirtual_key[256];
CWL_EXTERN BITSTRING       CWLsync_key_state;
CWL_EXTERN BITSTRING       CWLasync_key_state;
CWL_EXTERN unsigned char   CWLtogglekey_state[NUMTOGGLEKEYS];
CWL_EXTERN BITSTRING       CWLasync_last_state;
CWL_EXTERN unsigned char   CWLnumpad_conv[10];
CWL_EXTERN unsigned char   CWLkeyshift_code[256];
CWL_EXTERN QUEUE    DEFDS  CWLevent_queue;

CWL_EXTERN CMLTIMER       CWLtimer_struct[NUMTIMERS];
CWL_EXTERN int            CWLnum_timers;
CWL_EXTERN CWL_VOID _FAR_ *CWLindos_ptr;
CWL_EXTERN int DEFDS      CWLindos_seg;
CWL_EXTERN int DEFDS      CWLindos_off;

CWL_EXTERN VIDEO_CONFIG   CWLinit_video;
CWL_EXTERN int            CWLdef_attr;   /* default screen attribute */
CWL_EXTERN unsigned       CWLscrnseg;
CWL_EXTERN unsigned char  CWLchksnow;
CWL_EXTERN SYS_FLAGS      CWLvideo_flags;
CWL_EXTERN unsigned       CWLcrt_port;
CWL_EXTERN int     DEFDS  CWLscreen_rows;     /* current # of rows displayed */
CWL_EXTERN int     DEFDS  CWLscreen_cols;     /* current # of columns displayed */
CWL_EXTERN int            CWLmax_pages;
CWL_EXTERN int     DEFDS  CWLactive_page;   /* current active display page */
CWL_EXTERN int            CWLvisible_page;  /* current visible display page */
CWL_EXTERN unsigned int   CWLpagesize;      /* size of video page in bytes */
CWL_EXTERN int            CWLvideo_mode;   /* current video mode */
CWL_EXTERN unsigned char  CWLwindow_buffer[MAXBUFSIZE]; /* global write buffer */
CWL_EXTERN unsigned char  CWLvirtual_buffer[MAXBUFSIZE];
CWL_EXTERN unsigned char  CWLscroll_buffer[MAXSCROLLWIDTH];
CWL_EXTERN unsigned int   CWLcaldelay;
CWL_EXTERN int            CWLtab_length;
CWL_EXTERN unsigned char  CWLcheck_char;
CWL_EXTERN int            CWLstart_bar_col;
CWL_EXTERN int            CWLbar_menu_spaces;

CWL_EXTERN int            CWLcursor_type[2];
CWL_EXTERN int            CWLcursor_mode;
CWL_EXTERN int            CWLfield_cursor_type[2];
CWL_EXTERN int            CWLfield_cursor_mode;
CWL_EXTERN int            CWLenhanced_keyboard;
CWL_EXTERN unsigned int   CWLlast_key;

CWL_EXTERN int            CWLfield_press;
CWL_EXTERN int            CWLform_action_key;
CWL_EXTERN int            CWLflush_kbd;
CWL_EXTERN int            CWLmouse_handler_on;

/*** Colors  ***/

CWL_EXTERN int            CWLblack;
CWL_EXTERN int            CWLblue;
CWL_EXTERN int            CWLgreen;
CWL_EXTERN int            CWLcyan;
CWL_EXTERN int            CWLred;
CWL_EXTERN int            CWLmagenta;
CWL_EXTERN int            CWLbrown;
CWL_EXTERN int            CWLwhite;
CWL_EXTERN int            CWLgray;
CWL_EXTERN int            CWLlightblue;
CWL_EXTERN int            CWLlightgreen;
CWL_EXTERN int            CWLlightcyan;
CWL_EXTERN int            CWLlightred;
CWL_EXTERN int            CWLlightmagenta;
CWL_EXTERN int            CWLyellow;
CWL_EXTERN int            CWLlightwhite;
CWL_EXTERN int            CWLuline;
CWL_EXTERN int            CWLbright;
CWL_EXTERN int            CWLblink;

CWL_EXTERN unsigned int   CWLedit_key[NUMEDITKEYS];
CWL_EXTERN int            CWLerror_code;
CWL_EXTERN int            CWLcheck_exist;
CWL_EXTERN char           CWLmask_char;
CWL_EXTERN unsigned       CWLeffect_speed[MAX_SPECIAL_EFFECT+1];
CWL_EXTERN int            CWLpassword_char;

/* define object pointers */
CWL_EXTERN CWLOBJECTPTR   CWLtrans_object;
CWL_EXTERN CWLOBJECTPTR   CWLwindow_object;
CWL_EXTERN CWLOBJECTPTR   CWLvwindow_object;
CWL_EXTERN CWLOBJECTPTR   CWLformptr_object;
CWL_EXTERN CWLOBJECTPTR   CWLpopup_object;
CWL_EXTERN CWLOBJECTPTR   CWLbar_object;
CWL_EXTERN CWLOBJECTPTR   CWLvideo_object;
CWL_EXTERN CWLOBJECTPTR   CWLbase_window;
CWL_EXTERN CWLOBJECTPTR   CWLpulldown_object;
CWL_EXTERN CWLOBJECTPTR   CWLaccelerator_object;
CWL_EXTERN CWLOBJECTPTR   CWLobjectclass_container;


CWL_EXTERN WPOINTER        CWLwindow_cache[NUMCACHE];
CWL_EXTERN WPOINTER        CWLorig_screen[MAXPAGES];
CWL_EXTERN char    _FAR_ * CWLpage_offset[MAXPAGES];
CWL_EXTERN int             CWLmouselib_exist;
CWL_EXTERN int             CWLmouselib2_exist;
CWL_EXTERN int             CWLformlib_exist;
CWL_EXTERN int             CWLmouse_installed;
CWL_EXTERN int             CWLmouse_active;
CWL_EXTERN int             CWLmouse_hidden;
CWL_EXTERN int             CWLnum_windows_init;

CWL_EXTERN int      DEFDS  CWLmouse_used;
CWL_EXTERN int             CWLmouse_last_press;
CWL_EXTERN int             CWLmouse_vert_pos;
CWL_EXTERN int             CWLmouse_horiz_pos;

CWL_EXTERN unsigned int    CWLpopup_press;
CWL_EXTERN unsigned int    CWLbar_press;
CWL_EXTERN unsigned char   CWLpopup_space;
CWL_EXTERN unsigned char   CWLpopup_char;


CWL_EXTERN FORMPTR         CWLcurrent_form;
CWL_EXTERN unsigned        CWLcurrent_field;
CWL_EXTERN char            CWLform_buffer[MAXFIELDSIZE];
CWL_EXTERN int             CWLfield_bad;
CWL_EXTERN unsigned        CWLform_help_key[NUMHELPKEYS];
CWL_EXTERN unsigned        CWLform_edit_key[NUMFORMKEYS];
CWL_EXTERN MINVALUES       CWLmouse_val;

CWL_EXTERN unsigned        CWLpopup_key_def[NUMPOPUPKEYS];
CWL_EXTERN unsigned        CWLbar_key_def[NUMBARKEYS];
CWL_EXTERN unsigned        CWLpopup_height;
CWL_EXTERN unsigned        CWLpopup_width;
CWL_EXTERN unsigned        CWLbar_width;
CWL_EXTERN unsigned        CWLbar_height;
CWL_EXTERN unsigned        CWLpopup_delay;

/* The following variables must be in the DGROUP segment
   The mouse library will not work if these variables are not
   in the DGROUP segment */
CWL_EXTERN  unsigned       * CWLstack;
CWL_EXTERN  unsigned        CWLstack_on;
CWL_EXTERN  unsigned DEFDS  CWLstack_seg;
CWL_EXTERN  unsigned DEFDS  CWLstack_bot;
CWL_EXTERN  unsigned DEFDS  CWLoldseg;
CWL_EXTERN  unsigned DEFDS  CWLoldtop;
CWL_EXTERN  unsigned        CWL13seg;
CWL_EXTERN  unsigned        CWL13ofs;
CWL_EXTERN  unsigned        CWLorig13seg;
CWL_EXTERN  unsigned        CWLorig13off;



/* Callback function pointers.  Safe to be modified. */

CWL_EXTERN POPUPUNDEFKEYPROC CWLpopup_undef_key_func;
CWL_EXTERN BARUNDEFKEYPROC   CWLbar_undef_key_func;
CWL_EXTERN CWLERRORPROC      CWLerror_func;
CWL_EXTERN UNDEFKEYPROC      CWLundef_fkey_func;
CWL_EXTERN UNDEFKEYPROC      CWLundef_akey_func;

CWL_EXTERN CHARSENTEREDPROC  CWLchars_entered_func;
CWL_EXTERN REGEXPERRORPROC   CWLreg_exp_error_func;
CWL_EXTERN FIELDERRORPROC    CWLfield_error_func;
CWL_EXTERN FORMUNDEFPROC     CWLundef_form_func;
CWL_EXTERN KEYIDLEPROC       CWLkey_idle_func;
CWL_EXTERN KEYINTERCEPTPROC  CWLkey_intercept_func;

CWL_EXTERN BARPREPROC        CWLglobal_bar_prefunc;
CWL_EXTERN POPUPPREPROC      CWLglobal_popup_prefunc;

CWL_EXTERN POPUPMOUSEPROC    CWLpopup_mouse_func;
CWL_EXTERN FORMLISTPROC      CWLform_picklist_func;
CWL_EXTERN EDITERRORPROC     CWLedit_error_func;

CWL_EXTERN FIELDPREPROC      CWLfield_prefunc;
CWL_EXTERN FIELDPOSTPROC     CWLfield_postfunc;
CWL_EXTERN FORMUNDEFKEYPROC  CWLform_undef_fkey_func;
CWL_EXTERN FORMUNDEFKEYPROC  CWLform_undef_akey_func;

CWL_EXTERN FIELDUNDEFKEYPROC CWLundef_toggle_func;
CWL_EXTERN FIELDUNDEFKEYPROC CWLundef_button_func;
CWL_EXTERN FIELDUNDEFKEYPROC CWLundef_radio_func;
CWL_EXTERN FIELDUNDEFKEYPROC CWLundef_checkbox_func;
CWL_EXTERN FIELDUNDEFKEYPROC CWLundef_list_func;

CWL_EXTERN HELPUNDEFKEYPROC  CWLundef_helpkey_func;
CWL_EXTERN HELPPREPROC       CWLform_help_prefunc;

CWL_EXTERN SPECFIELDPREPROC  CWLradio_field_prefunc;
CWL_EXTERN SPECFIELDPREPROC  CWLcheckbox_field_prefunc;
CWL_EXTERN SPECFIELDPREPROC  CWLtoggle_field_prefunc;


/* The following functions are pointing to 0000:0000 if there is no mouse
 * installed, or the mouse library is not included.  These functions are
   intended for internal use only. */

CWL_EXTERN CWL_VOID     (*CWLmouse_stat_pos_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN unsigned     (*CWLgetmousekey_func) _PROTO_((int, int *, int *, int *));
CWL_EXTERN int          (*CWLmouse_press_func) _PROTO_((int));
CWL_EXTERN CWL_VOID     (*CWLmouse_screen_func) _PROTO_((int,int,int *, int *));
CWL_EXTERN int          (*CWLcap_win_func) _PROTO_((WPOINTER,int,int,int *,int *));
CWL_EXTERN CWL_VOID     (*CWLmouse_hide_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN CWL_VOID     (*CWLmouse_show_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN CWL_VOID     (*CWLmouse_hmin_max_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN CWL_VOID     (*CWLmouse_vmin_max_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN CWL_VOID     (*CWLmouse_set_page_func) _PROTO_((UNKNOWNARGS));
CWL_EXTERN CWL_VOID     (*CWLdraw_hotspots_func)  _PROTO_((WPOINTER,int));
CWL_EXTERN CWL_VOID     (*CWLdraw_sb_func)       _PROTO_((WPOINTER,int));
CWL_EXTERN CWL_VOID     (*CWLfree_hotspots_func) _PROTO_((WPOINTER));
CWL_EXTERN unsigned     (*CWLsearch_form_func) _PROTO_((int,int));
CWL_EXTERN int          (*CWLform_help_func) _PROTO_((unsigned));
CWL_EXTERN CWL_VOID     (*CWLmouse_release_func) _PROTO_((CWL_VOID));
CWL_EXTERN CWL_VOID     (*CWLpending_off_func) _PROTO_((int));
CWL_EXTERN int          (*CWLfree_event_func) _PROTO_((WPOINTER));
CWL_EXTERN int          (*CWLform_free_func) _PROTO_((FORMPTR));
CWL_EXTERN int          (*CWLapprox_delay_func) _PROTO_((int,int));
CWL_EXTERN int          (*CWLmouse_restore_func) _PROTO_((int));
CWL_EXTERN CWL_VOID     (*CWLdraw_caption_func) _PROTO_((WPOINTER));
CWL_EXTERN CWL_VOID     (*CWLstring_double_func) _PROTO_((char *, VOIDPTR ,
                                                           int));
CWL_EXTERN CWL_VOID     (*CWLdouble_string_func) _PROTO_((FORMPTR, int,
                                                           char *, VOIDPTR ));
CWL_EXTERN int          (*CWLdouble_comp_func) _PROTO_((double, double,
                                                         double, int));
CWL_EXTERN int          (*CWLfloat_comp_func) _PROTO_((float, float, float,
                                                        int));
CWL_EXTERN int          (*CWLsearch_radio_func) _PROTO_((FORMPTR,int,int,
                                                          int,int,int));
CWL_EXTERN int          (*CWLnormal_field_func) _PROTO_((WPOINTER, int, int,
                                                          char *, char *,
                                                          int, int, int, int,
                                                          char *, int,
                                                          int, int, long,
                                                          char, int,
                                                          unsigned *, int *));
CWL_EXTERN int          (*CWLtoggle_field_func) _PROTO_((FORMPTR, int,
                                                          unsigned, unsigned,
                                                          int *));
CWL_EXTERN int          (*CWLsubform_func) _PROTO_((FORMPTR , int));
CWL_EXTERN int          (*CWLpicklist_func) _PROTO_((FORMPTR , int, int *));
CWL_EXTERN int          (*CWLbutton_field_func) _PROTO_((FORMPTR , int,
                                                          int *));
CWL_EXTERN int          (*CWLradio_field_func) _PROTO_((FORMPTR , int, int *));
CWL_EXTERN CWL_VOID     (*CWLradio_setup_func) _PROTO_((FORMPTR , int, int));
CWL_EXTERN CWL_VOID     (*CWLcheckbox_setup_func) _PROTO_((FORMPTR , int,
                                                            int));
CWL_EXTERN int          (*CWLcheckbox_func) _PROTO_((FORMPTR , int ,int *));
CWL_EXTERN int          (*CWLsearch_checkbox_func) _PROTO_((FORMPTR ,int,int,
                                                             int,int,int));
CWL_EXTERN int          (*CWLsearch_list_func) _PROTO_((FORMPTR ,int,int,int));
CWL_EXTERN CWL_VOID     (*CWLdisplay_list_func) _PROTO_((FORMPTR, int));
CWL_EXTERN int          (*CWLform_display_func) _PROTO_((FORMPTR, int, int));

CWL_EXTERN VOIDFARPROC CWLInt13;

#ifdef MSDOS

/* Interrupt functions */
#ifdef MSC
#define GETVECTFUNC   _dos_getvect
#define SETVECTFUNC   _dos_setvect
typedef void (interrupt far *INTERRUPTPROC) _PROTO_((UNKNOWNARGS));
#define INTFUNCDEF     void interrupt far
#endif

#ifdef __TURBOC__
#define GETVECTFUNC   getvect
#define SETVECTFUNC   setvect
typedef void interrupt (far *INTERRUPTPROC) _PROTO_((UNKNOWNARGS));

#define INTFUNCDEF     void interrupt far
#endif

#ifdef POWERC
#define GETVECTFUNC   getvect
#define SETVECTFUNC   setvect
typedef void interrupt far (*INTERRUPTPROC) _PROTO_((UNKNOWNARGS));

#define INTFUNCDEF     void interrupt far
#endif

#ifdef __ZTC__
#include <int.h>
#define GETVECTFUNC   _dos_getvect
#define SETVECTFUNC   _dos_setvect
#define INTFUNCDEF     int
typedef CWL_VOID (*INTERRUPTPROC) _PROTO_((UNKNOWNARGS));
#endif


#else
typedef CWL_VOID (*INTERRUPTPROC) _PROTO_((UNKNOWNARGS));
#endif

CWL_EXTERN INTERRUPTPROC CWLoldint9;
CWL_EXTERN INTERRUPTPROC CWLoldint1C;
CWL_EXTERN INTERRUPTPROC CWLoldint13;

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MSDOS
/* The int 1C functions */

#ifndef __ZTC__
INTFUNCDEF TimerHandler _PROTO_((UNKNOWNARGS));
INTFUNCDEF KbdHandler   _PROTO_((UNKNOWNARGS));
#else
INTFUNCDEF TimerHandler _PROTO_((struct INT_DATA *pd));
INTFUNCDEF KbdHandler   _PROTO_((struct INT_DATA *pd));
#endif /* Zortech/Symantec C++ */

#endif /* MSDOS */
#ifdef __cplusplus
}
#endif

