#include "cwlwin.h"
#include <time.h>
#include <stdio.h>
#include <string.h>

#define NORM  CREATE_VIDEO_ATTRIBUTE(BLACK_ ,WHITE_)
#define COLOR1 CREATE_VIDEO_ATTRIBUTE(WHITE_ ,BLACK_)

WPOINTER clock_win, wtop;
FILE *clockfile;

int do_clock(WPOINTER,int,int,long);

/*DoClock() {}*/


#ifdef MAINPROG
void main( )
#else
CWL_VOID DoClock( )
#endif
{
#ifndef SHWARE
  int b;
  clock_win = WindowInitialize(DESKTOP_WINDOW,BORDER,0,0,60,3,COLOR1,
                               COLOR1,SINGLEBOX);
  WindowCenter(clock_win,VERTCENTER | HORIZCENTER);
  WindowChangeCursor(clock_win,INVISIBLE);
  WindowDisplay(clock_win,1,NOEFFECT);

  WindowSetEventStyle(clock_win,CWL_CAPTION | CWL_RESIZE);
  WindowSetCaption(clock_win,"Real Time Clock Demo");
  WindowSetEventProc(clock_win,do_clock);
  SetWinTimer(clock_win,1,1000,(TIMERPROC)0);
  WindowSetFocus(clock_win); /* Set the focus for the clock window */
  WindowWriteCenterString(clock_win,"Press Space Bar to Quit",1);
  clockfile = fopen("CLOCK.OUT","w");
  /* Initialize Event System */
  ProcessAllEvents(M_EVENT | K_EVENT | T_EVENT);
  WindowClose(clock_win,NOEFFECT);
  fclose(clockfile);
#else
  NotAvailable( );
#endif
}



int do_clock(WPOINTER w, int message, int wParam, long lParam)
{
#ifndef SHWARE
  time_t t;
  static int timeon = FALSE;
  char buf[100];

  switch (message)
  {
    case CWL_TIMER:
    {
      if (!timeon)
      {
        timeon = TRUE;
        time(&t);
        sprintf(buf,"Current Date and Time is: %s",ctime(&t));
        WindowWriteCenterString(w,strtok(buf,"\n"),0);
        fprintf(clockfile,buf);
        timeon = FALSE;
      }
    }
    break;

    case CWL_SIZE:
    {
      WindowWriteCenterString(w,"Press Space Bar to Quit",1);
    }
    break;

    case CWL_CHAR:
     if (wParam == ' ')
     {
       CWLQuitMessage();
     }
    break;

  }
  return FALSE;
#else
  return 0;
#endif
}

