#define CWLDEMO_GLOBAL
#include "cwldemo.h"
#include <alloc.h>

/* opening lines */
char *openline[] = {
"This is a small demo of The C Window Library 3.0.  This demo shows some of",
"the various things that can be done with text windows, including menus,",
"dialog boxes, screen manipulation, and an example of an event driven clock.",
" ",
"The C Window Library has libraries for Turbo C Version 2.0 and higher,",
"Turbo C++, Borland C++, Microsoft C Version 5.1 and higher, Visual C++",
"and Symantec C++ version 6.0 and higher.  Watcom support will be available",
"in November 1994, with OS/2 and UNIX support thereafter.",
" ",
"The C Window Library order form is found in the file ORDER.FRM.  To order ",
"directly, contact Paul McKenzie at (718) 379-6777 for more information.",
" ",
"This demo is in itself an example of a pulldown menu system that was created",
"with CWL.  To end the pulldown menu, press Escape twice to exit the pulldown",
"menu.  If you have installed a mouse driver, you can use the mouse to access",
"the menu, clock, and dialog box demos."
};


main()
{
  /* Initialize CWL */
  InitCWL();

  /* Display Opening Screen */
  Intro( );

  /* Create Pulldown Menu */
  InitPulldown();

  /* Do the Demo */
  DoDemo();
  /* Uninitialize CWL */
  last_function( );
}


CWL_VOID InitCWL()
{
  int dummy;

  /* Initialize CWL System */
  WindowInitializeSystem( );

  /* Set error function */
  CWLerror_func = custom_error_func;

  /* Clear the screen */
  ClearScreen(0x7);

  /* Initialize the Desktop Window */
  WindowInitDesktop( 0 );

  /* Initialize Mouse */
  MouseInitializeSystem(MOUSE_FULL_INSTALL, &dummy, CWLscreen_rows / 2,
                        CWLscreen_cols / 2);

  /* Initialize Form System */
  FormInitializeSystem();

}

CWL_VOID Intro()
{
  int i;

  error_window = WindowInitialize(DESKTOP_WINDOW,BORDER,0,0,1,4,
                                  CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                  CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                  DOUBLEBOX);

  wOpeningScreen = WindowInitialize(DESKTOP_WINDOW,BORDER,0,0,78,NUMLINES + 2,
                                    CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                    CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                    SINGLEBOX);

  wNotAvailable = WindowInitialize(DESKTOP_WINDOW, BORDER, 0,0, 40, 2,
                                   CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                   CREATE_VIDEO_ATTRIBUTE(RED_, LIGHTWHITE_),
                                   DOUBLEBOX);

  WindowCenter(wNotAvailable, HORIZCENTER | VERTCENTER);
  WindowWriteCenterString(wNotAvailable,"Not Available in Shareware Version",0);
  WindowWriteCenterString(wNotAvailable,"Press a key to continue...",1);

  for (i = 0; i < NUMLINES; i++)
    WindowWriteString(wOpeningScreen, openline[i], i, 0);
  WindowTitleTop(wOpeningScreen,"[ CWL Demo ]",TITLECENTER);
  WindowCenter(wOpeningScreen, HORIZCENTER | VERTCENTER);

  WindowDisplay(wOpeningScreen,1,EXPLODE);

  delay(1000);
  WindowWriteCenterString(wOpeningScreen, "Press a key to start the demo...",
                          NUMLINES + 1);
  GET_KEY();

/*  WindowClose(wOpeningScreen, CONTRACT);*/
}




CWL_VOID DoDemo( )
{
  PulldownSelectMenu(pull,1,0,0);
}

CWL_VOID UninitCWL( )
{
  WindowUninitSystem( );
}

CWL_VOID NotAvailable( )
{
  WindowDisplay(wNotAvailable, 1, NOEFFECT);
  GET_KEY();
  WindowHide(wNotAvailable, NOEFFECT);
}

int Descript(POPUP_MENU_PTR p, int sel) { return POPUP_CONTINUE; }


