#include "cwldemo.h"

int ScreenDirect(POPUP_MENU_PTR p, int sel)
{
  CHECK_SNOW = FALSE;
  SCREEN_WRITE_METHOD = DMA;

  /* Check This menu entry */
  PopupCheckEntry(p,sel,TRUE);

  /* Uncheck other entries */
  PopupCheckEntry(p,sel+1,FALSE);
  PopupCheckEntry(p,sel+2,FALSE);
  return POPUP_CONTINUE;
}

int ScreenBIOS  (POPUP_MENU_PTR p, int sel)
{
  SCREEN_WRITE_METHOD = BIOS;

  /* Check This menu entry */
  PopupCheckEntry(p,sel,TRUE);

  /* Uncheck other entries */
  PopupCheckEntry(p,sel-1,FALSE);
  PopupCheckEntry(p,sel+1,FALSE);
  return POPUP_CONTINUE;
}

int ScreenSnow  (POPUP_MENU_PTR p, int sel)
{
  CHECK_SNOW = TRUE;
  SCREEN_WRITE_METHOD = DMA;

  /* Check This menu entry */
  PopupCheckEntry(p,sel,TRUE);

  /* Uncheck other entries */
  PopupCheckEntry(p,sel-1,FALSE);
  PopupCheckEntry(p,sel-2,FALSE);
  return POPUP_CONTINUE;
}


int Screen25 (POPUP_MENU_PTR p, int sel)
{
  int i;
  if (change_screen_size(ScreenSize[sel - 4]))
  {
    for (i = 4; i <= 6; i++)
    {
      if (i == sel)
        PopupCheckEntry(p,i,TRUE);
      else
        PopupCheckEntry(p,i,FALSE);
    }
  }
  return POPUP_CONTINUE;
}

int change_screen_size(int numrows)
{
  int b;
  int retval = 0;
  /* Check for VGA mode */
  if (numrows == 50 && CWLscreen_rows != 50)
  {
    if (VGA_MODE_ON)
    {
      SetVideoRows(numrows,1);
      retval = 1;
    }
  }
  else
  if (numrows == 43 && CWLscreen_rows != 43)
  {
    /* Check for EGA or MCGA mode */
    if (EGA_MODE_ON || MCGA_MODE_ON)
    {
      SetVideoRows(numrows,1);
      retval = 1;
    }
  }
  else
  {
    if (CWLscreen_rows != 25)
    {
      SetVideoRows(25,1);
      retval = 1;
    }
  }

  /* Adjust all global data in The C Window Library to reflect the new
   * number of rows */
  if (retval)
  {
    int mstatus = MouseOff();
    AdjustScreenInfo(0);
    MouseOn(mstatus);
  }
/*  MOUSESHOW();*/
  return retval;
}

int FormDialog (POPUP_MENU_PTR p, int sel)
{
  DialogDemo( );
  POPUP_CONTINUE;
}


int EventClock (POPUP_MENU_PTR p, int sel)
{
  static int clock_on = 0;
  if (!clock_on)
  {
    clock_on = 1;
    DoClock( );
    clock_on = 0;
    return POPUP_CONTINUE;
  }
  else
    return POPUP_CONTINUE;
}


int ListFunctions (BAR_MENU_PTR b, int sel)
{
  WindowCenter(POPUP_WINDOW(funclist), VERTCENTER | HORIZCENTER);
  PopupSelectMenu(funclist,1,0);
  return PULLDOWN_CONTINUE;
}
