#include "cwldemo.h"

/* Delay function that either exits when you press a key, or when time
 * runs out.  Demo is terminated if ESC key is pressed  */

int delay_approx(int mil)
{
  unsigned start = 5;
  int ch;

  /* quit if key is in keyboard buffer */
  while(!ISKEYREADY())
  {
    delay(10);
    start+=10;
  /* return because time ran out */
    if (start > mil)
      return 0;
  }
  /* read the key */
  ch = GET_KEY();

  /* quit demo if the Escape key was pressed */
  if (ch == ESC)
  {
    last_function();
  }
  return 0;
}


FILE *read_file (VWPOINTER vw, char *filename)
{
  char *buf;
  FILE *infile;
  int i = 0;
  unsigned row, col;

  buf = (char *)malloc((VIRTUAL_WIDTH(vw) + 1) * sizeof(char));
  if (!buf)
    return (FILE *)0;
  infile = fopen(filename,"r");
  if (!infile)
  {
    free(buf);
    return (FILE *)0;
  }

  fgets(buf, VIRTUAL_WIDTH(vw), infile);
  while (!feof(infile) && i < 80)
  {
    VirtualPrintf(vw, buf);
    i++;
    VirtualGetCursorPosition(vw, &row, &col);
    if (row >= 80)
      break;
    fgets(buf, VIRTUAL_WIDTH(vw), infile);
  }
  free(buf);
  return infile;
}


CWL_VOID last_function()
{
  int i,j,k;
  UninitCWL( );
  printf("Thanks for viewing the Demo of The C Window Library!\n");
  exit( 0 );
}


CWL_VOID custom_error_func(int error, char *fname, int line, char *func)
{
  char buf[100];
  int ch;
  MakeSound(500,100);
  if (error == NO_HEAP_MEM)
  {
    ClearScreen(0x7);
    VideoWriteString("Unable to allocate memory",0,0);
    GET_KEY();
    WindowUninitSystem( );
    exit(0);
  }
  else
  {
    WindowClear(error_window);

    sprintf(buf,"Error %d.  Line %d, Function %s",error,line,func);
    WindowResizeWidth(error_window, strlen(buf), ANCHORLEFT);
    WindowWriteString(error_window,buf,0,0);
    WindowWriteString(error_window,"Press 'q' to quit,",2,0);
    WindowWriteString(error_window,"any other key to continue...",3,0);

    WindowDisplay(error_window,1,NOEFFECT);
    ch = GET_KEY();
    if (ch == 'Q' || ch == 'q')
    {
/*      WindowUninitSystem();*/
      exit(0);
    }
    else
      WindowHide(error_window,NOEFFECT);
  }
}
