#include "cwldemo.h"

CWL_VOID InitPulldown( )
{
  WPOINTER wBar;
  FILE *infile;
  int len;
  int maxwidth;
  char buf[100];
  char *temp;
  int count = NUMWAIT;

  /* define colors */
  menu_colors[ENTRYCOLOR] =
  menu_colors[BORDERCOLOR] = BLACKONWHITE;
  menu_colors[UNAVAILCOLOR] = GRAYONWHITE;
  menu_colors[HOTKEYCOLOR] =
  menu_colors[HIGHLIGHTCOLOR] = WHITEONBLACK;

  /* Initialize pulldown Menu */
  pull = PulldownCreateMenu(DESKTOP_WINDOW, BARDEFOPTIONS,
                            menu_colors, 0, 0, 80);


  /* Make Bar borderless */
  wBar = BAR_WINDOW(BAR_MENU_PTR_FROM_PULLDOWN(pull));
  WindowRemoveBorder(wBar);
  WindowMove(wBar,0,0);

  /* Initialize popup entry 0 */
  popup[0] = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                             menu_colors, 0, 0);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Creating...", 0, WindowFunc[0]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Colors...", 0, WindowFunc[1]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " &Borders...", 0, WindowFunc[2]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Writing Text...", 0, WindowFunc[3]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Titles...", 0, WindowFunc[4]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Moving...", 0, WindowFunc[5]);

/*  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Hiding...", 0, WindowFunc[6]);        */

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Child...", 0, WindowFunc[6]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Virtual...", 0, WindowFunc[7]);

  PopupAppendEntry(popup[0],CWL_MSTRING ,
                   " Effects...", 0, WindowFunc[8]);

  PulldownInsertEntry(pull, CWL_MSTRING ,
                      0,"&Window",
                      0,(BARSELECTPROC)0,
                      popup[0]);


  /* Initialize popup entry 1 */
  popup[1] = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                             menu_colors, 0, 0);

  PopupAppendEntry(popup[1],CWL_MSTRING ,
                   " Dialog Box...", 0, FormFunc[0]);

  PulldownAppendEntry(pull, CWL_MSTRING ,
                      "&Data Entry",
                      0,(BARSELECTPROC)0,
                      popup[1]);


  /* Initialize popup entry 2 */

  popup[2] = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                             menu_colors, 0, 0);

  PopupAppendEntry(popup[2],CWL_MSTRING  | CWL_MCHECKED,
                   " Direct Screen", 0, ScreenFunc[0]);
  PopupAppendEntry(popup[2],CWL_MSTRING ,
                   " BIOS", 0, ScreenFunc[1]);

  PopupAppendEntry(popup[2],CWL_MSTRING ,
                   " Check Snow", 0, ScreenFunc[2]);

  PopupAppendEntry(popup[2],CWL_MSEPARATOR, SEPARATOR, 0, (POPUPSELECTPROC)0);

  PopupAppendEntry(popup[2],CWL_MSTRING ,
                   " 25 Rows", 0, ScreenFunc[3]);

  PopupAppendEntry(popup[2],CWL_MSTRING ,
                   " 43 Rows", 0, ScreenFunc[4]);

  PopupAppendEntry(popup[2],CWL_MSTRING ,
                   " 50 Rows", 0, ScreenFunc[5]);

  PulldownAppendEntry(pull, CWL_MSTRING ,
                      "&Screen Access",
                      0,(BARSELECTPROC)0,
                      popup[2]);

  /* Check proper screen mode */
  if (LINEMODE25)
    PopupCheckEntry(popup[2],4,TRUE);
  else
  if (LINEMODE43)
    PopupCheckEntry(popup[2],5,TRUE);
  else
  if (LINEMODE50)
    PopupCheckEntry(popup[2],6,TRUE);

  /* Initialize popup entry 3 */
  popup[3] = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                             menu_colors, 0, 0);

  PopupAppendEntry(popup[3],CWL_MSTRING ,
                   "Clock...", 0, EventFunc[0]);

  PulldownAppendEntry(pull, CWL_MSTRING ,
                      "&Event System",
                      0,(BARSELECTPROC)0,
                      popup[3]);

  /* Initialize popup entry 3 */
  PulldownAppendEntry(pull, CWL_MSTRING ,
                      "&Function List",
                      0,ListFunctions,
                      POPUP_NULL_PTR);

  /* Fill in popup menu structure */

  WindowWriteString(wOpeningScreen,"Loading Data...", NUMLINES, 0);

  funclist = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                                             menu_colors, 0, 0);
  infile = fopen("FUNCLIST.OUT","r");
  if (!infile)
    PopupMenuClose(funclist);
  PopupSetWinDimensions(funclist, 0, 12, POPUP_SETHEIGHT);
  fgets(buf,99,infile);
  maxwidth = 0;
  while(!feof(infile))
  {
    WindowWriteString(wOpeningScreen, waitchars[(count % NUMWAIT)], NUMLINES,
                      16);
    temp = strtok(buf,"\n");
    if (PopupAppendEntry(funclist,
        CWL_MSTRING , buf, 0, Descript) != NO_ERROR)
      break;
    if ((len = strlen(buf)) > maxwidth)
      maxwidth = len;
    fgets(buf,99,infile);
    count++;
    if (count > 100)
      break;
  }
  fclose(infile);


  WindowTitleTop(POPUP_WINDOW(funclist)," - CWL Functions - ",TITLETOP);
  PopupSetWinDimensions(funclist, maxwidth, 0, POPUP_SETWIDTH);

  /* Initialize popup entry 4 */
  popup[4] = PopupCreateMenu(DESKTOP_WINDOW, POPUPDEFOPTIONS | POPUPWRAP,
                             menu_colors, 0, 0);

  PopupAppendEntry(popup[4],CWL_MSTRING ,
                   " Popup Menu...", 0, MenuFunc[0]);

  PopupAppendEntry(popup[4],CWL_MSTRING ,
                   " Bar Menu...", 0, MenuFunc[1]);

  PulldownAppendEntry(pull, CWL_MSTRING ,
                      "&Menus",
                      0,(BARSELECTPROC)0,
                      popup[4]);


  PulldownCUA(pull);

  WindowClose(wOpeningScreen, NOEFFECT);
}
