#include "cwldemo.h"

int WinText (POPUP_MENU_PTR p, int sel)
{
  int i;
  WPOINTER cw,cw2;
  cw = WindowInitialize(DESKTOP_WINDOW,
                        BORDER,0,0,60,6,BLACKONCYAN,BLACKONCYAN,SINGLEBOX);

  /* Write text to sub window */
  WindowCenter(cw,VERTCENTER | HORIZCENTER);
  WindowDisplay(cw,1,NOEFFECT);

  WindowWriteCenterString(cw,"You can write text to a window...",0);
  delay_approx(1000);
  WindowWriteCenterString(cw,"Hello, world!",1);
  delay_approx(2000);

  /* Demonstrate writing text with different colors */
  WindowClearLine(cw,0);
  WindowWriteCenterString(cw,
          "You can write text with a different colors...",0);
  delay_approx(2000);
  WindowWriteCenterStringAttr(cw,"Hello, World!",1,BLACKONWHITE);
  WindowWriteCenterStringAttr(cw,"Hello, World!",2,YELLOWONRED);
  delay_approx(4000);

  /* Demonstrate WindowPrintf() */
  WindowClear(cw);
  WindowWriteCenterString(cw,"You can even use a printf() for windows!",0);
  delay_approx(2000);
  WindowWriteCenterString(cw,"To demonstrate, I will count to 20...",1);
  delay_approx(2000);
  WindowClear(cw);

  for (i=1;i<=20;i++)
  {
    WindowPrintf(cw,"Count is now %d\n",i);
    delay_approx(1000);
  }

  delay_approx(4000);
  WindowClear(cw);

  /* Demonstrate right justification of strings in a window */
  WindowWriteCenterString(cw,"You can write Right Justified strings...",0);
  delay_approx(2000);
  WindowWriteStringRJ(cw,"These strings",2,18);
  WindowWriteStringRJ(cw,"are printed Right",3,18);
  WindowWriteStringRJ(cw,"justified!",4,18);
  delay_approx(4000);

  /* Demonstrate centering strings around a column in a window */
  WindowClear(cw);
  WindowWriteCenterString(cw,
      "You can write strings Centered on a certain column...",0);
  delay_approx(2000);
  WindowWriteStringCC(cw,"These strings",2,9);
  WindowWriteStringCC(cw,"are centered on",3,9);
  WindowWriteStringCC(cw,"column 9",4,9);
  delay_approx(3000);
  WindowClear(cw);
  WindowWriteStringCC(cw,"These strings",2,18);
  WindowWriteStringCC(cw,"are centered on",3,18);
  WindowWriteStringCC(cw,"column 18",4,18);
  delay_approx(3000);
  WindowClear(cw);
  WindowWriteStringCC(cw,"These strings",2,28);
  WindowWriteStringCC(cw,"are centered on",3,28);
  WindowWriteStringCC(cw,"column 28",4,28);
  delay_approx(3000);

  cw2 = WindowInitialize(DESKTOP_WINDOW,
                         BORDER,WINDOW_ROW(cw) - 3, WINDOW_COLUMN(cw) - 4,
                         40,5,0x7,0x7,DOUBLEBOX);

  WindowClear(cw);
  WindowWriteCenterString(cw,"You can write strings to background windows...",0);
  delay_approx(5000);
  WindowDisplay(cw2,2,NOEFFECT);
  WindowWriteCenterString(cw,"Watch...",2);
  delay_approx(2000);
  WindowWriteString(cw2,"Surprise!! Surprise!!",0,0);
  WindowWriteString(cw2,"Surprise!! Surprise!!",1,0);
  WindowWriteString(cw2,"Surprise!! Surprise!!",2,0);
  WindowWriteString(cw2,"Surprise!! Surprise!!",3,0);
  delay_approx(5000);
  WindowClose(cw2,NOEFFECT);
  WindowClose(cw,NOEFFECT);
  return POPUP_CONTINUE;

}
