#define DLG_GLOBAL
/* The following program displays and gets input in a dialog box in
   conjunction with the mouse functions found in the C Mouse Lib Version 2.0.
   The dialog box is created using CWL_RADIO, CWL_BUTTONS, and normal text
   field.  You can use this source code as a guide in creating your
   own dialog boxes using CWL_RADIO, CWL_RADIO and CWL_BUTTON fields.
   */
#if 0
[]Display optionsͻ
  Display swapping          Integer format  Files          
   ( ) None                  ( ) Hex        Ŀ 
   () Smart                 ( ) Decimal    FILE1.C      
   ( ) Always                () Both       FILE2.C      
                                            FILE3000.C   
  Screen lines              Tab size        NEWFILE.CPP  
   () 25    ( ) 43/50       8              OLDFILE.CPP  
                                            CURFILE.C    
   OK      Cancel      Help               
                                         
ͼ
#endif

#include "cwlwin.h"
#include <string.h>
#ifdef MSDOS
#include <direct.h>
#include <dos.h>
#endif

#ifdef __TURBOC__
#define FILENAME(f)   (f.ff_name)
#endif

#ifdef MSC
#define FILENAME(f)   (f.name)
#endif

#ifdef COHERENT
#include <stddef.h>
#include <sys/types.h>
#include <dirent.h>
#endif

#ifdef MSDOS
#define BLACKONWHITE CREATE_VIDEO_ATTRIBUTE(WHITE_, BLACK_)
#define LIGHTONWHITE CREATE_VIDEO_ATTRIBUTE(WHITE_, LIGHTWHITE_)
#define BLACKONCYAN  CREATE_VIDEO_ATTRIBUTE(CYAN_, BLACK_)
#define WHITEONCYAN  CREATE_VIDEO_ATTRIBUTE(CYAN_, LIGHTWHITE_)
#define YELLOWONCYAN CREATE_VIDEO_ATTRIBUTE(CYAN_, YELLOW_)
#define WHITEONBLUE  CREATE_VIDEO_ATTRIBUTE(BLUE_, LIGHTWHITE_)
#define BLACKONGREEN CREATE_VIDEO_ATTRIBUTE(GREEN_, BLACK_)
#define WHITEONGREEN CREATE_VIDEO_ATTRIBUTE(GREEN_, LIGHTWHITE_)
#define GRAYONCYAN   CREATE_VIDEO_ATTRIBUTE(CYAN_, GRAY_)
#endif

#ifdef COHERENT
#define BLACKONWHITE CREATE_VIDEO_ATTRIBUTE(WHITE_, BLACK_)
#define LIGHTONWHITE CREATE_VIDEO_ATTRIBUTE(WHITE_, BLACK_)
#define BLACKONCYAN  CREATE_VIDEO_ATTRIBUTE(WHITE_, BLACK_)
#define WHITEONCYAN  BLACKONWHITE  /*CREATE_VIDEO_ATTRIBUTE(CYAN_, LIGHTWHITE_)
*/
#define YELLOWONCYAN BLACKONWHITE /*CREATE_VIDEO_ATTRIBUTE(CYAN_, YELLOW_)*/
#define WHITEONBLUE  BLACKONWHITE /*CREATE_VIDEO_ATTRIBUTE(BLUE_, LIGHTWHITE_)*/
#define BLACKONGREEN BLACKONWHITE /*CREATE_VIDEO_ATTRIBUTE(GREEN_, BLACK_)*/
#define WHITEONGREEN BLACKONWHITE /*CREATE_VIDEO_ATTRIBUTE(GREEN_, LIGHTWHITE_)*/
#define GRAYONCYAN   BLACKONWHITE /*CREATE_VIDEO_ATTRIBUTE(CYAN_, GRAY_)*/
#endif

#define IBMASCII(c)  ((c) > 32 && (c) < 255)

#include "dialog.h"


CWL_VOID DialogDemo( )
{
#ifndef SHWARE
  int attr[4];
  int attr2[4];
  int b;
  int i;
  unsigned formkeys[NUMFORMKEYS];
  attr[NORMATTR] = BLACKONCYAN;
  attr[HIATTR] = WHITEONCYAN;
  attr[HOTATTR] = YELLOWONCYAN;
  attr[UNAVAILATTR] = BLACKONWHITE;
  attr2[NORMATTR] = BLACKONGREEN;
  attr2[HIATTR] = WHITEONGREEN;

  /* initialize the list box colors */
  menu_colors2[ENTRYCOLOR] =
  menu_colors2[UNAVAILCOLOR] =
  menu_colors2[BORDERCOLOR] = CREATE_VIDEO_ATTRIBUTE(CWLwhite,CWLblack);

  menu_colors2[HOTKEYCOLOR] =
  menu_colors2[HIGHLIGHTCOLOR] = CREATE_VIDEO_ATTRIBUTE(CWLblack,CWLwhite);


  /* Initialize opening screen */
  opening_window = WindowInitialize(DESKTOP_WINDOW,BORDER,
    8, 0,
    77, 8,
    CREATE_VIDEO_ATTRIBUTE(CWLblack, CWLwhite),
    CREATE_VIDEO_ATTRIBUTE(CWLblack, CWLwhite),
    "Ŀ");
  WindowPrintf(opening_window,opening_text);
  WindowPrintf(opening_window,opening_text2);

  WindowWriteCenterStringAttr(opening_window,
                         "Press a key to start the demo...", 7,
                          CREATE_VIDEO_ATTRIBUTE(WHITE_ ,
                                                 BLACK_));
  WindowCenter(opening_window,VERTCENTER | HORIZCENTER);
  WindowDisplay(opening_window,1,EXPLODE);
  GET_KEY();
  WindowClose(opening_window,CONTRACT);


  /* Start the mouse event handler */
  ProcessAllEvents(M_EVENT);


  /* Initialize dialog window */
  diagw = WindowInitialize(DESKTOP_WINDOW,BORDER, 0, 0, 70, 11, BLACKONWHITE, LIGHTONWHITE,
    DOUBLEBOX);
  WindowCenter(diagw, VERTCENTER | HORIZCENTER);
  WindowMove(diagw, WINDOW_ROW(diagw) - 2, 0);

  /* Set the caption */
  WindowSetEventStyle(diagw, CWL_CAPTION);
  WindowSetCaption(diagw, "Dialog Box Demo");

  /* Initialize stats window */
  statw = WindowInitialize(DESKTOP_WINDOW,BORDER, 17, 0, 50, 6, BLACKONWHITE, LIGHTONWHITE,
    SINGLEBOX);

  /* define help window */
  helpw = WindowInitialize(DESKTOP_WINDOW,BORDER, 0, 52, 25, 15, BLACKONWHITE, LIGHTONWHITE,
    SINGLEBOX);
  WindowChangeCursor(statw, INVISIBLE);
  WindowDisplay(diagw,1,NOEFFECT);

  /* write the help info */
  write_help();

  /* write title */
  WindowTitleTop(diagw, "Display options", TITLECENTER);
  WindowTitleTop(statw, "Current Stats", TITLECENTER);

  /* write other stuff to the dialog window */
  WindowWriteString(diagw, "Display swapping", 0, 2);
  WindowWriteString(diagw, "Integer format", 0, 28);
  WindowWriteString(diagw, "Screen Size", 5, 2);
  WindowWriteString(diagw, "Tab Size", 5, 28);
  WindowWriteString(diagw, "Files",0,49);
  CWLform_edit_key[FIELD_NEXTFIELD_KEY] = CWLKEY_TAB;
  CWLform_edit_key[FIELD_PREVFIELD_KEY] = CWLKEY_BACKTAB;
  CWLform_edit_key[FORM_EXIT_ACCEPT_KEY] = CWLKEY_RETURN;
  CWLform_edit_key[BUTTON_NEXTFIELD_KEY] = CWLKEY_TAB;
  CWLform_edit_key[BUTTON_PREVFIELD_KEY] = CWLKEY_BACKTAB;

  /* setup pop up menu */
  pop = popup_init();

  /* Initialize form */
  dbox = FormInitialize(diagw, fentry, FORM_WRAP | FORM_STATIC);

  /* Set the dialog help system */
  vhelp_window = WindowInitialize(DESKTOP_WINDOW, BORDER, 0, 0, 78, 4,
                                  0x7, 0x7, SINGLEBOX);
  FormInitializeFieldHelp(dbox, vhelp_window, "dialog.txt", DISK_HELP,
                          ONLINE_HELP);

  /* let field point to tabwidth variable */
  FormSetFieldVariable(dbox, 4, &tabwidth, TRUE);

  /* change cursor mode */
  FIELD_CURSORMODE(dbox, 4) = INSERTMODE;

  FormSetListField(dbox, 2, 1, 0, pop);

  /* let form know about CWL_RADIO fields */
  FormSetRadioField(dbox, 0, r1, '*', 0, attr);
  FormSetRadioField(dbox, 1, r2, '*', 2, attr);
  FormSetRadioField(dbox, 3, r3, '*', 0, attr);

  /* let form know about CWL_BUTTON fields */
  FormSetButtonField(dbox, 5, FORM_ACCEPT, " OK ", attr2,
    NO_BUTTON_FUNC);
  FormSetButtonField(dbox, 6, FORM_CANCEL, " Cancel ", attr2,
    NO_BUTTON_FUNC);
  FormSetButtonField(dbox, 7, FIELD_CONTINUE, " Help ", attr2,
    show_help);

  /* write a shadow around buttons (nice effect) */
  write_button_shadow(9, 3, 4);
  write_button_shadow(9, 12, 8);
  write_button_shadow(9, 25, 6);

  /* update stats when a field is exited */
  for (i = 0;i < 8;i++)
    FormSetFieldPostFunction(dbox, i, do_stats);

  FormSetFieldPreFunction(dbox, 2, focus_it);
  FormSetFieldPostFunction(dbox, 2, unfocus_it);

  /* make form 'mouseable' */
  FormSetMouse(dbox, TRUE);

  /* make cursor invisible */
  WindowChangeCursor(statw, INVISIBLE);
  do_stats(dbox, &i);

  /* display stats window */
  WindowMove(statw, WINDOW_ROW(diagw) + WINDOW_HEIGHT(diagw) + 1, 0);
  WindowDisplay(statw, 4, NOEFFECT);

  /* set radio field prefunc */
  CWLradio_field_prefunc = change_stats;

  /* get the input in the form */
  FormGetInput(dbox, 1, 0);

  /* print out the final stats */
  WindowMoveCursor(statw, 0, 0);
  WindowWriteCenterString(statw, "Press any key to continue...", 5);
  GET_KEY();

  /* free the dialog and the array for the file list */
  FormClose(dbox);
  WindowClose(diagw,NOEFFECT);
  WindowClose(statw,NOEFFECT);
  WindowClose(helpw,NOEFFECT);
  CWLQuitMessage( );
#else
  NotAvailable( );
#endif
}



/* place a 'focus' border on the list field */
int focus_it(FORMPTR form, int *entry)
{
  WindowChangeBorderAttribute(POPUP_WINDOW(pop),LIGHTONWHITE);
  return FIELD_CONTINUE_PROCESS;
}


/* place a 'focus' border on the list field */
int unfocus_it(FORMPTR form, int *entry)
{
  WindowChangeBorderAttribute(POPUP_WINDOW(pop),menu_colors2[BORDERCOLOR]);
  return FIELD_CONTINUE_PROCESS;
}


/* initialize the list field's contents */
POPUP_MENU_PTR popup_init()
{
#ifndef SHWARE
  POPUP_MENU_PTR p;

#ifdef MSC
  struct find_t filedata;
#else
  struct ffblk filedata;
#endif

  int i = 1,j;
  int done;
  char buf[100];

  p = PopupCreateMenu(DESKTOP_WINDOW,POPUPDEFOPTIONS,
                      menu_colors2,0,0);
  PopupSetDimensions(p,15,101,POPUP_SETALL);
  PopupSetWinDimensions(p,13,7,POPUP_SETALL);

  buf[0] = ' ';
/*  WindowDisplay(POPUP_WINDOW(p),1,NOEFFECT);*/
#ifdef MSDOS
#ifdef __TURBOC__
  done = findfirst("*.c",&filedata,0);
#endif
#ifdef MSC
  done = _dos_findfirst("*.c",0,&filedata);
#endif
  if (!done)
  {
    strncpy(buf,FILENAME(filedata),sizeof(FILENAME(filedata)));
    buf[sizeof(FILENAME(filedata))] = '\0';
    PopupAppendEntry(p,CWL_MSTRING,buf,0,
                     (POPUPSELECTPROC)0);

    while (_dos_findnext(&filedata) == 0)
    {
      strncpy(buf,FILENAME(filedata),sizeof(FILENAME(filedata)));
      buf[sizeof(FILENAME(filedata))] = '\0';
      PopupAppendEntry(p,CWL_MSTRING ,buf,0,
      (POPUPSELECTPROC)0);
      i++;
      if (i > 100)
        break;
    }
  }
#endif

#ifdef COHERENT
  {
    DIR *dirp;
    struct dirent *dp;

    dirp = opendir(".");
    while ((dp = readdir(dirp)) != NULL)
    {
      strcpy(buf,dp->d_name);
      PopupAppendEntry(p,CWL_MSTRING ,buf,0,
                       (POPUPSELECTPROC)0);
    }
    closedir(dirp);



  }
#endif
  /* Define pre function for list field menu */
  CWLglobal_popup_prefunc = display_choice;
  return p;
#else
  return (POPUP_MENU_PTR)0;
#endif
}




