#include "cwlwin.h"
#include "dialog.h"

int display_choice(POPUP_MENU_PTR p, unsigned sel)
{
  int entry = 2;
  if (p == pop)
  {
    do_stats(dbox,&entry);
  }
  return POPUP_CONTINUE;
}


void write_button_shadow(int row, int col, int len)
{
  WindowWriteRepeatCharacter(diagw, shadow_under, row, col, len);
  WindowWriteRepeatCharacter(diagw, shadow_up, row - 1, col + len - 1, 1);
}


/* display the current choices in another window */
int do_stats(FORMPTR form, int *entry)
{
  int tw = -1;
  static int oldtw=-1;
  static int choices[3]={0,0,0};
  FormGetFieldData(dbox, 4, &tw);
  if (oldtw != tw ||
      FormGetRadioChoice(dbox,0) != choices[0] ||
      FormGetRadioChoice(dbox,1) != choices[1] ||
      FormGetRadioChoice(dbox,3) != choices[2] ||
      *entry == 2)
  {
    oldtw = tw;
    choices[0] = FormGetRadioChoice(dbox,0);
    choices[1] = FormGetRadioChoice(dbox,1);
    choices[2] = FormGetRadioChoice(dbox,3);

    WindowMoveCursor(statw, 0, 0);

    WindowPrintf(statw,
      "Display Swapping      : %s     \n"
      "Integer Format        : %s     \n"
      "Screen Lines          : %s     \n"
      "Tab Width             : %d     \n"
      "Current List Choice   : %s       ",

      rstr1[FormGetRadioChoice(dbox, 0)],
      rstr2[FormGetRadioChoice(dbox, 1)],
      rstr3[FormGetRadioChoice(dbox, 3)],
      tw,
      ((FormGetListChoice(dbox,2) >= 0)?POPUP_ENTRY_STRING(pop,FormGetListChoice(dbox,2)):"No Selection"));
    prev_field = *entry;
  }
  if (*entry != 2)  /* Popup window */
    WindowChangeBorderAttribute(POPUP_WINDOW(pop),menu_colors2[BORDERCOLOR]);
  return FIELD_CONTINUE_PROCESS;
}



void change_stats(FORMPTR form, int entry, int current)
{
  do_stats(form, &entry);
}


/* write the help information when 'Help' is selected */
write_help()
{
  WindowWriteCenterString(helpw, "General Help", 0);
  WindowWriteCenterString(helpw, "", 1);
  WindowWriteString(helpw, "Next  Field - TAB", 3, 0);
  WindowWriteString(helpw, "Prev. Field - SHIFTTAB", 4, 0);
  WindowWriteString(helpw, "Accept      - ENTER", 5, 0);

  WindowWriteCenterString(helpw, "Radio Field Help", 7);
  WindowWriteCenterString(helpw, "", 8);
  WindowWriteString(helpw, "Next  Entry - ", 10, 0);
  WindowWriteString(helpw, "Prev  Entry - ", 11, 0);
  WindowWriteCenterString(helpw, "Press any key...", 13);
}


int show_help(FORMPTR form, int entry, int *newent)
{
  int which;
  WindowDisplay(helpw, 1, EXPLODE);
  GET_MPRESS_KEY(&which);
  WindowHide(helpw, CONTRACT);
  if (entry != 7)
    *newent = prev_field;
  else
    *newent = entry;
  return FIELD_NEWFIELD;
}
